/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.framework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidDirlistFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.DirListWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class ImageListFileBuffer
extends Thread {
    private static final int \u00d500000 = 30000;
    private final Map<String, PoolList> String = new ConcurrentHashMap<String, PoolList>();
    private final FSIServerSettings \u00d300000;
    private final StorageManager \u00d200000;
    private final ReentrantLock o00000 = new ReentrantLock();
    private boolean \u00d600000 = true;

    public ImageListFileBuffer(FSIServerSettings fSIServerSettings, StorageManager storageManager) {
        this.setName("ListBuffer");
        this.\u00d300000 = fSIServerSettings;
        this.\u00d200000 = storageManager;
        this.start();
    }

    @Override
    public void run() {
        while (this.\u00d600000) {
            try {
                this.o00000.lock();
                try {
                    this.syncBufferedLists();
                }
                finally {
                    this.o00000.unlock();
                }
                ImageListFileBuffer.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                this.o00000.lock();
                try {
                    this.syncBufferedLists();
                }
                finally {
                    this.o00000.unlock();
                }
            }
            catch (Exception exception) {
                this.\u00d300000.getLogger().logException(exception, 3151, "unknown", exception.getLocalizedMessage());
            }
        }
    }

    private void syncBufferedLists() {
        String[] stringArray;
        for (String string : stringArray = this.String.keySet().toArray(new String[0])) {
            PoolList poolList = this.String.get(string);
            if (poolList == null) continue;
            Path path = poolList.getStorageDirlist();
            if (!poolList.isSyncRequired()) continue;
            this.writeListFile(path, poolList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolList getList(Path path, String string) throws IOException {
        PoolList poolList;
        if (this.String.containsKey(string)) {
            poolList = this.String.get(string);
        } else {
            this.o00000.lock();
            try {
                poolList = this.getListFileContents(path, string);
                if (poolList != null) {
                    this.String.put(string, poolList);
                }
            }
            finally {
                this.o00000.unlock();
            }
        }
        return poolList;
    }

    public void invalidateAllBuffers() {
        this.o00000.lock();
        try {
            this.syncBufferedLists();
            this.String.clear();
        }
        finally {
            this.o00000.unlock();
        }
    }

    public void invalidateBuffer(String string) {
        this.o00000.lock();
        try {
            this.syncBufferedLists();
            this.String.remove(string);
        }
        finally {
            this.o00000.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeList(Path path, PoolList poolList) {
        if (!this.\u00d600000 || poolList == null) {
            return;
        }
        this.o00000.lock();
        try {
            boolean bl = false;
            String string = poolList.getAssetURLPath();
            poolList.setSyncRequired(true);
            this.String.put(string, poolList);
        }
        finally {
            this.o00000.unlock();
        }
    }

    private void readAndCheckMagicNumber(byte[] byArray, Path path) throws IOException {
        for (int i = 0; i < 8; ++i) {
            if (byArray[i] == EISEnvironment.\u00d200000[i]) continue;
            throw new NotAValidDirlistFileException(path);
        }
    }

    private short checkContainerMinorVersion(ByteArrayWalker byteArrayWalker) throws IOException {
        short s = byteArrayWalker.getShort();
        if (s != 2) {
            throw new IOException("Wrong container version " + s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolList getListFileContents(Path path, String string) throws IOException {
        String string2 = string.length() > 1 && string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        long l = this.\u00d300000.getLogger().isTraceEnabled() ? System.nanoTime() : 0L;
        boolean bl = false;
        PoolList poolList = new PoolList(path, string2);
        long l2 = -1L;
        long l3 = -1L;
        try {
            Object object;
            byte[] byArray;
            LockerReadWrite.Value<String> value = this.\u00d300000.getStorageLockHandler().readLock(path);
            try {
                byArray = FileOperations.readFile(path);
                this.readAndCheckMagicNumber(byArray, path);
            }
            catch (NotAValidDirlistFileException notAValidDirlistFileException) {
                int n = EISChainReader.findChainEntryNumber(path, string2);
                if (n == -1) {
                    throw new NoSuchFileException(path + " chain for " + string2);
                }
                object = StorageManager.getChainedDestination(path, n);
                byArray = FileOperations.readFile((Path)object);
                this.readAndCheckMagicNumber(byArray, (Path)object);
                poolList.thisclass = n;
                poolList.setStorageDirlist((Path)object);
            }
            finally {
                this.\u00d300000.getStorageLockHandler().unlockRead(value);
            }
            byte by = byArray[8];
            ByteOrder byteOrder = by == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            object = ByteArrayWalker.wrap(byArray, byteOrder);
            ((ByteArrayWalker)object).position(9);
            int n = ((ByteArrayWalker)object).capacity();
            this.checkContainerMinorVersion((ByteArrayWalker)object);
            boolean bl2 = false;
            while (!bl2 && !bl) {
                int n2;
                try {
                    n2 = ((ByteArrayWalker)object).getShort();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    n2 = -1;
                    bl2 = true;
                }
                if (n2 != 3854 && n2 != -1) {
                    int n3;
                    try {
                        n3 = ((ByteArrayWalker)object).getInt();
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        n3 = 0;
                        bl2 = true;
                    }
                    switch (n2) {
                        case 101: {
                            PoolEntry poolEntry;
                            if (((ByteArrayWalker)object).position() + 1 < n) {
                                poolEntry = this.readImageTag((ByteArrayWalker)object, n3);
                                poolList.addImageInitial((PoolFileEntry)poolEntry);
                                break;
                            }
                            bl2 = true;
                            bl = true;
                            break;
                        }
                        case 102: {
                            PoolEntry poolEntry;
                            if (((ByteArrayWalker)object).position() + 1 < n) {
                                poolEntry = this.readDirectoryTag((ByteArrayWalker)object, n3);
                                poolList.addDirectoryInitial((PoolDirectoryEntry)poolEntry);
                                break;
                            }
                            bl2 = true;
                            bl = true;
                            break;
                        }
                        case 100: {
                            poolList.\u00d4\u00d60000 = ((ByteArrayWalker)object).getLong();
                            break;
                        }
                        case 10: {
                            l2 = ((ByteArrayWalker)object).getLong();
                            break;
                        }
                        case 11: {
                            l3 = ((ByteArrayWalker)object).getLong();
                            break;
                        }
                        default: {
                            ((ByteArrayWalker)object).position(((ByteArrayWalker)object).position() + n3);
                            break;
                        }
                    }
                    continue;
                }
                bl2 = true;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.\u00d600000) {
                this.\u00d300000.getLogger().logError(outOfMemoryError, 3157, path);
            }
            bl = true;
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException | NullPointerException runtimeException) {
            if (this.\u00d600000) {
                this.\u00d300000.getLogger().logException(runtimeException, 3156, path);
            }
            bl = true;
        }
        catch (NoSuchFileException noSuchFileException) {
            throw noSuchFileException;
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException iOException) {
            if (this.\u00d600000) {
                this.\u00d300000.getLogger().logException(iOException, 3196, path, iOException.getLocalizedMessage());
            }
            throw iOException;
        }
        if (this.\u00d300000.getLogger().isTraceEnabled() && !bl) {
            float f = (float)(System.nanoTime() - l) / 1000000.0f;
            this.\u00d300000.getLogger().log(3516, path, Float.valueOf(f));
        }
        if ((l2 != (long)poolList.getFileCount() || l3 != (long)poolList.getDirectoryCount()) && this.\u00d600000) {
            this.\u00d300000.getLogger().log(3156, "Data mismatch in " + path + " for " + string2);
        }
        poolList.setSyncRequired(false);
        if (bl) {
            poolList = null;
        }
        return poolList;
    }

    private PoolDirectoryEntry readDirectoryTag(ByteArrayWalker byteArrayWalker, int n) throws IndexOutOfBoundsException {
        PoolDirectoryEntry poolDirectoryEntry = new PoolDirectoryEntry();
        int n2 = 0;
        do {
            byte by = byteArrayWalker.get();
            switch (by) {
                case 0: {
                    short s = byteArrayWalker.getShort();
                    byte[] byArray = new byte[s];
                    byteArrayWalker.get(byArray);
                    poolDirectoryEntry.o00000 = new String(byArray, FileOperations.new);
                    n2 += s + 1 + 2;
                    break;
                }
                case 1: {
                    poolDirectoryEntry.\u00d200000 = byteArrayWalker.getLong();
                    n2 += 9;
                    break;
                }
                case 2: {
                    poolDirectoryEntry.\u00f500000 = byteArrayWalker.getInt();
                    n2 += 5;
                    ++n2;
                    break;
                }
                case 3: {
                    poolDirectoryEntry.null = byteArrayWalker.getInt();
                    n2 += 5;
                    ++n2;
                }
            }
        } while (n2 < n);
        return poolDirectoryEntry;
    }

    private PoolFileEntry readImageTag(ByteArrayWalker byteArrayWalker, int n) throws IndexOutOfBoundsException {
        PoolFileEntry poolFileEntry = new PoolFileEntry();
        int n2 = 0;
        do {
            short s = byteArrayWalker.get();
            switch (s) {
                case 1: {
                    short s2 = byteArrayWalker.getShort();
                    byte[] byArray = new byte[s2];
                    byteArrayWalker.get(byArray);
                    poolFileEntry.o00000 = new String(byArray, FileOperations.new);
                    n2 += s2 + 1 + 2;
                    break;
                }
                case 2: {
                    poolFileEntry.\u00d500000 = byteArrayWalker.getLong();
                    n2 += 9;
                    break;
                }
                case 3: {
                    poolFileEntry.\u00d200000 = byteArrayWalker.getLong();
                    n2 += 9;
                    break;
                }
                case 4: {
                    poolFileEntry.\u00d600000 = byteArrayWalker.getInt();
                    n2 += 5;
                    break;
                }
                case 5: {
                    poolFileEntry.String = byteArrayWalker.getInt();
                    n2 += 5;
                    break;
                }
                case 0: {
                    poolFileEntry.\u00d800000 = byteArrayWalker.get();
                    n2 += 2;
                }
            }
        } while (n2 != n);
        return poolFileEntry;
    }

    private void writeListFile(Path path, PoolList poolList) {
        poolList.setSyncRequired(false);
        PoolList poolList2 = (PoolList)poolList.copy();
        DirListWriter dirListWriter = new DirListWriter(this.\u00d300000.getLogger(), poolList2, this.\u00d200000.getStorageLogger());
        Path path2 = StorageManager.getDestinationWithoutChainIndex(path);
        this.\u00d200000.executeStorageDataProvider(path2, dirListWriter);
    }

    void halt() {
        this.\u00d600000 = false;
        this.interrupt();
        this.syncBufferedLists();
    }
}

