/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.XMLOperations;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public class LDAPAuthentication
extends UserAuthenticationInterface {
    private final SearchControls \u00d3o0000;
    private final String \u00f4o0000;
    private final String \u00d8o0000;
    private final String \u00d2o0000;
    private final String floatsuper;
    private int \u00d6o0000 = -1;
    private int \u00d4o0000 = -1;

    public LDAPAuthentication(SourceManagerSettings sourceManagerSettings) {
        super(sourceManagerSettings);
        Path path = sourceManagerSettings.getConfigHome();
        this.\u00d3o0000 = new SearchControls();
        this.\u00d3o0000.setSearchScope(2);
        String string = sourceManagerSettings.getPrefsString("application", "ldapuri");
        this.\u00f4o0000 = string.endsWith("/") ? string : string + "/";
        this.\u00d8o0000 = sourceManagerSettings.getPrefsString("application", "ldapuser");
        this.\u00d2o0000 = sourceManagerSettings.getPrefsString("application", "ldappassword");
        this.floatsuper = sourceManagerSettings.getPrefsString("application", "ldapbasedn");
        this.\u00d600000 = path.resolve("permissionsets");
        this.do = path.resolve("propertysets");
        this.\u00f6O0000 = path.resolve("publishingsets");
        this.readPermissionConfig();
        this.readPropertyConfig();
        Path[] pathArray = new Path[]{this.\u00d600000};
        this.setupMonitoring("updateSourceConnectorAccessRules", null, pathArray);
        Path[] pathArray2 = new Path[]{this.do, this.\u00f6O0000};
        this.setupMonitoring("updateSourceConnectorAccessRules", null, pathArray2);
    }

    @Override
    public boolean isPasswordChangePossible() {
        return false;
    }

    private Hashtable<String, String> getLDAPEnvironment() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", this.\u00f4o0000 + this.floatsuper);
        if (this.\u00d8o0000 != null && this.\u00d8o0000.length() > 0) {
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", this.\u00d8o0000);
            hashtable.put("java.naming.security.credentials", this.\u00d2o0000);
        }
        return hashtable;
    }

    @Override
    public boolean addGroup(String string, Set<String> set, String string2, String string3) {
        return false;
    }

    @Override
    protected void readPermissionSets() {
        this.\u00f400000.clear();
        this.voidsuper = null;
        this.setupDefaultPermissionSets();
        try {
            List<PathCached> list = FileOperations.listFiles(this.\u00d600000, "*.xml");
            for (PathCached pathCached : list) {
                String string = pathCached.getFileName().substring(0, pathCached.getFileName().length() - 4);
                try {
                    Document document = FileOperations.getXMLFileContent(this.\u00f4O0000.getLogger(), pathCached.getPath());
                    String string2 = XMLOperations.elementNamesToLowerCase(this.\u00f4O0000.getLogger(), document);
                    PermissionSet permissionSet = XMLOperations.unmarshalJAXB(string2, PermissionSet.class);
                    permissionSet.setName(string);
                    this.\u00d300000.put(string, permissionSet);
                    PermissionSet permissionSet2 = permissionSet.clone();
                    permissionSet2.applyDefaults();
                    this.\u00f400000.put(string, permissionSet2);
                }
                catch (DataBindingException dataBindingException) {
                    this.\u00f4O0000.getLogger().log(2061, pathCached);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            this.\u00f4O0000.getLogger().logException(exception, 2072, this.do.toString());
        }
    }

    public boolean checkLDAPConfig() {
        boolean bl = false;
        int n = this.\u00d4o0000;
        Map<String, Group> map = this.getGroupsFromLDAP();
        if (n != this.\u00d4o0000) {
            this.Objectsuper.clear();
            this.setupDefaultGroups();
            this.Objectsuper.putAll(map);
            bl = true;
        }
        int n2 = this.\u00d6o0000;
        Set<Users.User> set = this.getUsersFromLDAP();
        if (n2 != this.\u00d6o0000) {
            this.\u00f600000.clear();
            this.\u00f600000.addAll(set);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Group> getGroupsFromLDAP() {
        HashMap<String, Group> hashMap = new HashMap<String, Group>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            InitialDirContext initialDirContext = new InitialDirContext(this.getLDAPEnvironment());
            namingEnumeration = initialDirContext.search("", "(objectclass=groupOfNames)", this.\u00d3o0000);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attribute = attributes.get("cn");
                String string = (String)attribute.get();
                Group group = new Group(string);
                HashSet<String> hashSet = new HashSet<String>();
                Attribute attribute2 = attributes.get("member");
                NamingEnumeration<?> namingEnumeration2 = attribute2.getAll();
                while (namingEnumeration2.hasMore()) {
                    LdapName ldapName = new LdapName((String)namingEnumeration2.next());
                    List<Rdn> list = ldapName.getRdns();
                    hashSet.add((String)list.get(list.size() - 1).getValue());
                }
                group.setUsers(hashSet);
                hashMap.put(group.getName(), group);
            }
        }
        catch (NamingException namingException) {
            this.\u00f4O0000.getLogger().log(2062, namingException.getLocalizedMessage());
        }
        finally {
            LDAPAuthentication.closeResult(namingEnumeration);
        }
        this.\u00d4o0000 = hashMap.hashCode();
        return hashMap;
    }

    @Override
    protected void readGroups() {
        this.Objectsuper.clear();
        this.setupDefaultGroups();
        this.Objectsuper.putAll(this.getGroupsFromLDAP());
    }

    @Override
    protected void readUsers() {
        this.\u00f600000.clear();
        this.\u00f600000.addAll(this.getUsersFromLDAP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Users.User> getUsersFromLDAP() {
        HashSet<Users.User> hashSet = new HashSet<Users.User>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            Object object;
            InitialDirContext initialDirContext = new InitialDirContext(this.getLDAPEnvironment());
            namingEnumeration = initialDirContext.search("", "(objectclass=account)", this.\u00d3o0000);
            HashSet<String> hashSet2 = new HashSet<String>();
            while (namingEnumeration.hasMore()) {
                object = namingEnumeration.next();
                Users.User user = new Users.User();
                Attributes attributes = ((SearchResult)object).getAttributes();
                Attribute attribute = attributes.get("uid");
                user.name = (String)attribute.get();
                Attribute attribute2 = attributes.get("userPassword");
                if (attribute2 != null && attribute2.get() instanceof byte[]) {
                    user.hash = new String((byte[])attribute2.get(), FileOperations.new);
                }
                hashSet.add(user);
                hashSet2.add(user.name);
            }
            object = (Group)this.Objectsuper.get("authenticated");
            if (object != null) {
                ((Group)object).setUsers(hashSet2);
            }
        }
        catch (NamingException namingException) {
            this.\u00f4O0000.getLogger().log(2062, namingException.getLocalizedMessage());
        }
        finally {
            LDAPAuthentication.closeResult(namingEnumeration);
        }
        this.\u00d6o0000 = hashSet.hashCode();
        return hashSet;
    }

    private static void closeResult(NamingEnumeration<?> namingEnumeration) {
        if (namingEnumeration != null) {
            try {
                namingEnumeration.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected synchronized boolean savePermissionSets() {
        \u00d200000.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = true;
        for (Map.Entry entry : this.\u00d300000.entrySet()) {
            Path path = this.\u00d600000.resolve((String)entry.getKey() + ".xml");
            try {
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    JAXB.marshal(entry.getValue(), (OutputStream)outputStream);
                }
                bl &= true;
            }
            catch (IOException | DataBindingException throwable) {
                this.\u00f4O0000.getLogger().log(2048, path, throwable.getLocalizedMessage());
            }
        }
        this.setFileMonitorTasksSuspended(false);
        \u00d200000.unlock();
        return bl;
    }

    @Override
    protected synchronized boolean saveGroups() {
        throw new UnsupportedOperationException("Saving to LDAP Server not permitted");
    }

    @Override
    protected synchronized boolean saveUsers() {
        throw new UnsupportedOperationException("Saving to LDAP Server not permitted");
    }

    @Override
    public boolean duplicateGroup(String string, String string2) {
        throw new UnsupportedOperationException("Saving to LDAP Server not permitted");
    }

    public Path getPermissionSetsDirectory() {
        return this.\u00d600000;
    }

    @Override
    public boolean isUserModificationPossible() {
        return false;
    }
}

