/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.framework.cache.CacheableData;
import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.io.DirectOutputStream;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PoolList
implements CacheableData<PoolList> {
    private Path \u00d5\u00d60000;
    private final String \u00f5\u00d60000;
    private short \u00d3\u00d60000 = (short)-1;
    public long \u00d4\u00d60000 = -1L;
    public int thisclass = 0;
    private final Map<String, PoolFileEntry> whileString;
    private final Map<String, PoolDirectoryEntry> \u00f4\u00d60000;
    private AtomicBoolean \u00d8\u00d60000 = new AtomicBoolean(true);

    public PoolList(Path path, String string) {
        this.\u00d5\u00d60000 = path;
        this.\u00f5\u00d60000 = string;
        this.whileString = new ConcurrentHashMap<String, PoolFileEntry>(16, 0.75f, 2);
        this.\u00f4\u00d60000 = new ConcurrentHashMap<String, PoolDirectoryEntry>(16, 0.75f, 2);
    }

    private PoolList(Path path, String string, int n, int n2) {
        this.\u00d5\u00d60000 = path;
        this.\u00f5\u00d60000 = string;
        this.whileString = new ConcurrentHashMap<String, PoolFileEntry>(n + 16, 0.75f, 2);
        this.\u00f4\u00d60000 = new ConcurrentHashMap<String, PoolDirectoryEntry>(n2 + 16, 0.75f, 2);
    }

    public boolean isSyncRequired() {
        return this.\u00d8\u00d60000.get();
    }

    public void setSyncRequired(boolean bl) {
        this.\u00d8\u00d60000.set(bl);
    }

    public Path getStorageDirlist() {
        return this.\u00d5\u00d60000;
    }

    public void setStorageDirlist(Path path) {
        this.\u00d5\u00d60000 = path;
    }

    public String getAssetURLPath() {
        return this.\u00f5\u00d60000;
    }

    public int addImage(PoolFileEntry poolFileEntry) {
        PoolFileEntry poolFileEntry2 = this.whileString.put(poolFileEntry.o00000, poolFileEntry);
        int n = poolFileEntry2 != null ? 0 : 1;
        this.\u00d8\u00d60000.set(true);
        return n;
    }

    public void addImageInitial(PoolFileEntry poolFileEntry) {
        this.whileString.put(poolFileEntry.o00000, poolFileEntry);
    }

    public int addDirectory(PoolDirectoryEntry poolDirectoryEntry) {
        PoolDirectoryEntry poolDirectoryEntry2 = this.\u00f4\u00d60000.put(poolDirectoryEntry.o00000, poolDirectoryEntry);
        int n = poolDirectoryEntry2 != null ? 0 : 1;
        this.\u00d8\u00d60000.set(true);
        return n;
    }

    public void addDirectoryInitial(PoolDirectoryEntry poolDirectoryEntry) {
        this.\u00f4\u00d60000.put(poolDirectoryEntry.o00000, poolDirectoryEntry);
    }

    public Collection<PoolFileEntry> getFilesAsCollection() {
        return this.whileString.values();
    }

    public List<PoolFileEntry> getFilesAsList() {
        return new ArrayList<PoolFileEntry>(this.whileString.values());
    }

    public Set<Map.Entry<String, PoolFileEntry>> getImageSet() {
        return this.whileString.entrySet();
    }

    public Set<String> getImageNameSet() {
        return new HashSet<String>(this.whileString.keySet());
    }

    public PoolDirectoryEntry getDirectory(String string) {
        return this.\u00f4\u00d60000.get(string);
    }

    public Map<String, PoolDirectoryEntry> getDirectories() {
        return this.\u00f4\u00d60000;
    }

    public List<String> getDirectoryNamesAsList() {
        return new ArrayList<String>(this.\u00f4\u00d60000.keySet());
    }

    public List<PoolDirectoryEntry> getDirectoriesAsList() {
        return new ArrayList<PoolDirectoryEntry>(this.\u00f4\u00d60000.values());
    }

    public Collection<PoolDirectoryEntry> getDirectoriesAsCollection() {
        return this.\u00f4\u00d60000.values();
    }

    public Set<String> getDirectoryNameSet() {
        return new HashSet<String>(this.\u00f4\u00d60000.keySet());
    }

    public boolean containsImageFilename(String string) {
        return this.whileString.containsKey(string);
    }

    public boolean containsDirectory(String string) {
        return this.\u00f4\u00d60000.containsKey(string);
    }

    public synchronized boolean removeImageFilename(String string) {
        if (this.whileString.remove(string) != null) {
            this.\u00d8\u00d60000.set(true);
            return true;
        }
        return false;
    }

    public synchronized boolean removeDirectory(String string) {
        if (this.\u00f4\u00d60000.remove(string) != null) {
            this.\u00d8\u00d60000.set(true);
            return true;
        }
        return false;
    }

    public synchronized PoolFileEntry getImage(String string) {
        return this.whileString.get(string);
    }

    @Override
    public CacheableData<PoolList> copy() {
        PoolList poolList = new PoolList(this.\u00d5\u00d60000, this.\u00f5\u00d60000, this.whileString.size(), this.\u00f4\u00d60000.size());
        poolList.\u00d3\u00d60000 = this.\u00d3\u00d60000;
        poolList.\u00d4\u00d60000 = this.\u00d4\u00d60000;
        for (PoolFileEntry poolEntry : this.whileString.values()) {
            poolList.addImage(poolEntry);
        }
        for (PoolDirectoryEntry poolDirectoryEntry : this.\u00f4\u00d60000.values()) {
            poolList.addDirectory(poolDirectoryEntry);
        }
        return poolList;
    }

    public int getFileCount() {
        return this.whileString.size();
    }

    public int getDirectoryCount() {
        return this.\u00f4\u00d60000.size();
    }

    public PoolListSummary getSummary() {
        return new PoolListSummary(this.\u00d4\u00d60000, this.getFileCount(), this.getDirectoryCount());
    }

    @Override
    public byte[] pack() {
        byte[] byArray;
        try (ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast((this.whileString.size() + this.\u00f4\u00d60000.size()) * 32);
             DirectOutputStream directOutputStream = new DirectOutputStream(byteArrayOutputStreamFast);){
            byte[] byArray2;
            PoolEntry poolEntry;
            Iterator<Map.Entry<String, PoolEntry>> iterator;
            directOutputStream.setByteOrder(ByteOrder.nativeOrder());
            if (this.\u00d5\u00d60000 != null) {
                iterator = this.\u00d5\u00d60000.toAbsolutePath().toString();
                byte[] object = ((String)((Object)iterator)).getBytes(FileOperations.new);
                directOutputStream.writeInt(object.length);
                directOutputStream.write(object);
            } else {
                directOutputStream.writeInt(0);
            }
            if (this.\u00f5\u00d60000 != null) {
                iterator = (Iterator<Map.Entry<String, PoolEntry>>)this.\u00f5\u00d60000.getBytes(FileOperations.new);
                directOutputStream.writeInt(((Object)iterator).length);
                directOutputStream.write((byte[])iterator);
            } else {
                directOutputStream.writeInt(0);
            }
            directOutputStream.writeShort(this.\u00d3\u00d60000);
            directOutputStream.writeLong(this.\u00d4\u00d60000);
            directOutputStream.writeInt(this.thisclass);
            directOutputStream.writeBoolean(this.isSyncRequired());
            if (this.whileString != null && this.whileString.size() > 0) {
                directOutputStream.writeInt(this.whileString.size());
                for (Map.Entry<String, PoolFileEntry> entry : this.whileString.entrySet()) {
                    poolEntry = entry.getValue();
                    byArray2 = poolEntry.o00000.getBytes(FileOperations.new);
                    directOutputStream.writeInt(byArray2.length);
                    directOutputStream.write(byArray2);
                    directOutputStream.writeLong(poolEntry.\u00d200000);
                    directOutputStream.writeLong(poolEntry.\u00d500000);
                    directOutputStream.writeInt(poolEntry.\u00d600000);
                    directOutputStream.writeInt(poolEntry.String);
                    directOutputStream.writeByte(poolEntry.\u00d800000);
                }
            } else {
                directOutputStream.writeInt(0);
            }
            if (this.\u00f4\u00d60000 != null && this.\u00f4\u00d60000.size() > 0) {
                directOutputStream.writeInt(this.\u00f4\u00d60000.size());
                for (Map.Entry<String, PoolEntry> entry : this.\u00f4\u00d60000.entrySet()) {
                    poolEntry = (PoolDirectoryEntry)entry.getValue();
                    byArray2 = ((PoolDirectoryEntry)poolEntry).o00000.getBytes(FileOperations.new);
                    directOutputStream.writeInt(byArray2.length);
                    directOutputStream.write(byArray2);
                    directOutputStream.writeLong(((PoolDirectoryEntry)poolEntry).\u00d200000);
                    directOutputStream.writeInt((int)((PoolDirectoryEntry)poolEntry).\u00f500000);
                    directOutputStream.writeInt((int)((PoolDirectoryEntry)poolEntry).null);
                }
            } else {
                directOutputStream.writeInt(0);
            }
            directOutputStream.close();
            byArray = byteArrayOutputStreamFast.toByteArray();
        }
        catch (IOException iOException) {
            byArray = null;
        }
        return byArray;
    }

    public static PoolList unpack(byte[] byArray) {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.nativeOrder());
        try {
            byte[] byArray2;
            int n;
            PoolEntry poolEntry;
            int n2;
            Object object;
            String string = null;
            String string2 = null;
            int n3 = byteArrayWalker.getInt();
            if (n3 > 0) {
                object = new byte[n3];
                byteArrayWalker.get((byte[])object);
                string = new String((byte[])object, FileOperations.new);
            }
            if ((n3 = byteArrayWalker.getInt()) > 0) {
                object = new byte[n3];
                byteArrayWalker.get((byte[])object);
                string2 = new String((byte[])object, FileOperations.new);
            }
            object = new PoolList(Paths.get(string, new String[0]), string2);
            ((PoolList)object).\u00d3\u00d60000 = byteArrayWalker.getShort();
            ((PoolList)object).\u00d4\u00d60000 = byteArrayWalker.getLong();
            ((PoolList)object).thisclass = byteArrayWalker.getInt();
            ((PoolList)object).setSyncRequired(byteArrayWalker.get() == 1);
            n3 = byteArrayWalker.getInt();
            if (n3 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    poolEntry = new PoolFileEntry();
                    n = byteArrayWalker.getInt();
                    if (n > 0) {
                        byArray2 = new byte[n];
                        byteArrayWalker.get(byArray2);
                        poolEntry.o00000 = new String(byArray2, FileOperations.new);
                    }
                    poolEntry.\u00d200000 = byteArrayWalker.getLong();
                    poolEntry.\u00d500000 = byteArrayWalker.getLong();
                    poolEntry.\u00d600000 = byteArrayWalker.getInt();
                    poolEntry.String = byteArrayWalker.getInt();
                    poolEntry.\u00d800000 = byteArrayWalker.get();
                    ((PoolList)object).addImageInitial((PoolFileEntry)poolEntry);
                }
            }
            if ((n3 = byteArrayWalker.getInt()) > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    poolEntry = new PoolDirectoryEntry();
                    n = byteArrayWalker.getInt();
                    if (n > 0) {
                        byArray2 = new byte[n];
                        byteArrayWalker.get(byArray2);
                        ((PoolDirectoryEntry)poolEntry).o00000 = new String(byArray2, FileOperations.new);
                    }
                    ((PoolDirectoryEntry)poolEntry).\u00d200000 = byteArrayWalker.getLong();
                    ((PoolDirectoryEntry)poolEntry).\u00f500000 = byteArrayWalker.getInt();
                    ((PoolDirectoryEntry)poolEntry).null = byteArrayWalker.getInt();
                    ((PoolList)object).addDirectoryInitial((PoolDirectoryEntry)poolEntry);
                }
            }
            return object;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.\u00d300000;
    }

    public String toString() {
        return "PoolList: " + this.\u00f5\u00d60000 + " - Images: " + this.whileString.size() + this.whileString.keySet() + " - Dirs: " + this.\u00f4\u00d60000.size() + " - Source: " + this.\u00d5\u00d60000;
    }
}

