/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;

public class TIFFCIELabColorConverter
extends TIFFColorConverter {
    private static final float Xn = 95.047f;
    private static final float Yn = 100.0f;
    private static final float Zn = 108.883f;
    private static final float THRESHOLD = (float)Math.pow(0.008856, 0.3333333333333333);

    private float clamp(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 100.0f) {
            return 255.0f;
        }
        return f * 255.0f / 100.0f;
    }

    private float clamp2(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 255.0f) {
            return 255.0f;
        }
        return f;
    }

    @Override
    public void fromRGB(float f, float f2, float f3, float[] fArray) {
        float f4 = 0.412453f * f + 0.35758f * f2 + 0.180423f * f3;
        float f5 = 0.212671f * f + 0.71516f * f2 + 0.072169f * f3;
        float f6 = 0.019334f * f + 0.119193f * f2 + 0.950227f * f3;
        float f7 = f5 / 100.0f;
        float f8 = f4 / 95.047f;
        float f9 = f6 / 108.883f;
        f7 = f7 < 0.008856f ? 7.787f * f7 + 0.13793103f : (float)Math.pow(f7, 0.3333333333333333);
        f8 = f8 < 0.008856f ? 7.787f * f8 + 0.13793103f : (float)Math.pow(f8, 0.3333333333333333);
        f9 = f9 < 0.008856f ? 7.787f * f9 + 0.13793103f : (float)Math.pow(f9, 0.3333333333333333);
        float f10 = 116.0f * f7 - 16.0f;
        float f11 = 500.0f * (f8 - f7);
        float f12 = 200.0f * (f7 - f9);
        f10 *= 2.55f;
        if (f11 < 0.0f) {
            f11 += 256.0f;
        }
        if (f12 < 0.0f) {
            f12 += 256.0f;
        }
        fArray[0] = this.clamp2(f10);
        fArray[1] = this.clamp2(f11);
        fArray[2] = this.clamp2(f12);
    }

    @Override
    public void toRGB(float f, float f2, float f3, float[] fArray) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8 = f * 100.0f / 255.0f;
        float f9 = f2 > 128.0f ? f2 - 256.0f : f2;
        float f10 = f7 = f3 > 128.0f ? f3 - 256.0f : f3;
        if (f8 < 8.0f) {
            f6 = f8 / 903.3f;
            f5 = 7.787f * f6 + 0.13793103f;
        } else {
            f4 = (f8 + 16.0f) / 116.0f;
            f6 = f4 * f4 * f4;
            f5 = (float)Math.pow(f6, 0.3333333333333333);
        }
        f4 = f6 * 100.0f;
        float f11 = f5 + f9 / 500.0f;
        float f12 = f11 <= THRESHOLD ? 95.047f * (f11 - 0.13793103f) / 7.787f : 95.047f * f11 * f11 * f11;
        float f13 = f5 - f7 / 200.0f;
        float f14 = f13 <= THRESHOLD ? 108.883f * (f13 - 0.13793103f) / 7.787f : 108.883f * f13 * f13 * f13;
        float f15 = 3.240479f * f12 - 1.53715f * f4 - 0.498535f * f14;
        float f16 = -0.969256f * f12 + 1.875992f * f4 + 0.041556f * f14;
        float f17 = 0.055648f * f12 - 0.204043f * f4 + 1.057311f * f14;
        fArray[0] = this.clamp(f15);
        fArray[1] = this.clamp(f16);
        fArray[2] = this.clamp(f17);
    }
}

