/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;

final class PixelReplacementImage
extends PlanarImage
implements PropertyChangeListener {
    private ImageWriteParam param;
    private ImageWriter writer;
    private int imageIndex;
    private ImageOutputStream streamToClose;

    private static Vector createVector(Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.add(object);
        return vector;
    }

    PixelReplacementImage(RenderedImage renderedImage, Map map, ImageWriteParam imageWriteParam, ImageWriter imageWriter, int n, ImageOutputStream imageOutputStream) throws IOException {
        super(new ImageLayout(renderedImage), PixelReplacementImage.createVector(renderedImage), map);
        if (!imageWriter.canReplacePixels(n)) {
            throw new IllegalArgumentException("!writer.canReplacePixels(imageIndex)");
        }
        this.param = imageWriteParam;
        this.writer = imageWriter;
        this.imageIndex = n;
        this.streamToClose = imageOutputStream;
    }

    public synchronized void dispose() {
        if (this.streamToClose != null) {
            try {
                this.streamToClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public Raster getTile(int n, int n2) {
        return this.getSourceImage(0).getTile(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PlanarImage planarImage = this.getSourceImage(0);
        Object object = propertyChangeEvent.getSource();
        if (propertyChangeEvent instanceof PropertyChangeEventJAI && propertyChangeEvent.getPropertyName().equalsIgnoreCase("invalidregion") && object.equals(planarImage) || propertyChangeEvent instanceof RenderingChangeEvent && propertyChangeEvent.getOldValue().equals(planarImage) && object instanceof RenderedOp && propertyChangeEvent.getNewValue().equals(((RenderedOp)object).getRendering())) {
            Point[] pointArray;
            Shape shape = null;
            if (propertyChangeEvent instanceof RenderingChangeEvent) {
                RenderingChangeEvent object2 = (RenderingChangeEvent)propertyChangeEvent;
                shape = object2.getInvalidRegion();
                planarImage = (PlanarImage)propertyChangeEvent.getNewValue();
                this.setSource(planarImage, 0);
                if (shape == null) {
                    shape = ((PlanarImage)object2.getOldValue()).getBounds();
                }
            } else {
                Shape shape2 = (Shape)propertyChangeEvent.getNewValue();
                if (shape2 instanceof Shape) {
                    shape = shape2;
                }
            }
            if (shape == null) {
                return;
            }
            if (this.param != null) {
                Rectangle rectangle = this.param.getSourceRegion();
                if (rectangle != null && !shape.intersects(rectangle)) {
                    return;
                }
            } else {
                this.param = this.writer.getDefaultWriteParam();
            }
            if ((pointArray = planarImage.getTileIndices(shape.getBounds())) == null) {
                return;
            }
            int n = this.minX + this.param.getSubsamplingXOffset();
            int n2 = this.minY + this.param.getSubsamplingYOffset();
            int n3 = this.param.getSourceXSubsampling();
            int n4 = this.param.getSourceYSubsampling();
            boolean bl = n3 != 1 || n4 != 1 || n != this.minX || n2 != this.minY;
            for (Point point : pointArray) {
                Rectangle rectangle;
                Rectangle rectangle2 = planarImage.getTileRect(point.x, point.y);
                if (!shape.intersects(rectangle2)) continue;
                Raster raster = planarImage.getTile(point.x, point.y);
                if (bl) {
                    int n5 = (rectangle2.x - n + n3 - 1) / n3;
                    int n6 = (rectangle2.y - n2 + n4 - 1) / n4;
                    int n7 = (rectangle2.x + rectangle2.width - n + n3 - 1) / n3;
                    int n8 = (rectangle2.y + rectangle2.height - n2 + n4 - 1) / n4;
                    rectangle = new Rectangle(n5, n6, n7 - n5, n8 - n6);
                } else {
                    rectangle = rectangle2;
                }
                try {
                    ImageWriter imageWriter = this.writer;
                    synchronized (imageWriter) {
                        this.writer.prepareReplacePixels(this.imageIndex, rectangle);
                        this.param.setDestinationOffset(rectangle.getLocation());
                        this.writer.replacePixels(raster, this.param);
                        this.writer.endReplacePixels();
                    }
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }
}

