/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.MathJAI;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.media.jai.operator.DFTDescriptor;

public class FFT {
    public static final int SCALING_NONE = DFTDescriptor.SCALING_NONE.getValue();
    public static final int SCALING_UNITARY = DFTDescriptor.SCALING_UNITARY.getValue();
    public static final int SCALING_DIMENSIONS = DFTDescriptor.SCALING_DIMENSIONS.getValue();
    protected boolean lengthIsSet = false;
    protected int exponentSign;
    protected int scaleType;
    protected int length;
    private int nbits;
    private int[] index;
    private double scaleFactor;
    private double[] wr;
    private double[] wi;
    private double[] wrFCT;
    private double[] wiFCT;
    protected double[] real;
    protected double[] imag;

    public FFT(boolean bl, Integer n, int n2) {
        this.exponentSign = bl ? -1 : 1;
        this.scaleType = n;
        this.setLength(n2);
    }

    public void setLength(int n) {
        if (this.lengthIsSet && n == this.length) {
            return;
        }
        if (!MathJAI.isPositivePowerOf2(n)) {
            throw new RuntimeException(JaiI18N.getString("FFT0"));
        }
        this.length = n;
        if (this.scaleType == SCALING_NONE) {
            this.scaleFactor = 1.0;
        } else if (this.scaleType == SCALING_UNITARY) {
            this.scaleFactor = 1.0 / Math.sqrt(n);
        } else if (this.scaleType == SCALING_DIMENSIONS) {
            this.scaleFactor = 1.0 / (double)n;
        } else {
            throw new RuntimeException(JaiI18N.getString("FFT1"));
        }
        this.nbits = 0;
        for (int i = 1; i < n; i <<= 1) {
            ++this.nbits;
        }
        this.initBitReversalLUT();
        this.calculateCoefficientLUTs();
        if (!this.lengthIsSet || n > this.real.length) {
            this.real = new double[n];
            this.imag = new double[n];
        }
        this.lengthIsSet = true;
    }

    private void initBitReversalLUT() {
        this.index = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            int n = i;
            int n2 = this.length >> 1;
            int n3 = 0;
            for (int j = 0; j < this.nbits; ++j) {
                int n4 = n & 1;
                if (n4 != 0) {
                    n3 += n2;
                }
                n >>= 1;
                n2 >>= 1;
                this.index[i] = n3;
            }
        }
    }

    private void calculateCoefficientLUTs() {
        this.wr = new double[this.nbits];
        this.wi = new double[this.nbits];
        int n = 1;
        double d = (double)this.exponentSign * Math.PI;
        for (int i = 0; i < this.nbits; ++i) {
            this.wr[i] = Math.cos(d / (double)n);
            this.wi[i] = Math.sin(d / (double)n);
            n *= 2;
        }
    }

    private void calculateFCTLUTs() {
        this.wrFCT = new double[this.length];
        this.wiFCT = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            double d = i == 0 ? Math.sqrt(1.0 / (double)this.length) : Math.sqrt(2.0 / (double)this.length);
            double d2 = Math.PI * (double)i / (2.0 * (double)this.length);
            this.wrFCT[i] = d * Math.cos(d2);
            this.wiFCT[i] = d * Math.sin(d2);
        }
    }

    public void setData(int n, Object object, int n2, int n3, Object object2, int n4, int n5, int n6) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n2 == n4 && n3 == n5) {
                        for (int i = 0; i < n6; ++i) {
                            this.real[i] = fArray[n2];
                            this.imag[i] = fArray2[n2];
                            n2 += n3;
                        }
                    } else {
                        for (int i = 0; i < n6; ++i) {
                            this.real[i] = fArray[n2];
                            this.imag[i] = fArray2[n4];
                            n2 += n3;
                            n4 += n5;
                        }
                    }
                } else {
                    for (int i = 0; i < n6; ++i) {
                        this.real[i] = fArray[n2];
                        n2 += n3;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (n3 == 1 && n5 == 1) {
                    System.arraycopy(dArray, n2, this.real, 0, n6);
                    if (object2 == null) break;
                    System.arraycopy((double[])object2, n4, this.imag, 0, n6);
                    break;
                }
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n2 == n4 && n3 == n5) {
                        for (int i = 0; i < n6; ++i) {
                            this.real[i] = dArray[n2];
                            this.imag[i] = dArray2[n2];
                            n2 += n3;
                        }
                    } else {
                        for (int i = 0; i < n6; ++i) {
                            this.real[i] = dArray[n2];
                            this.imag[i] = dArray2[n4];
                            n2 += n3;
                            n4 += n5;
                        }
                    }
                } else {
                    for (int i = 0; i < n6; ++i) {
                        this.real[i] = dArray[n2];
                        n2 += n3;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFT2"));
            }
        }
        if (n6 < this.length) {
            Arrays.fill(this.real, n6, this.length, 0.0);
            if (object2 != null) {
                Arrays.fill(this.imag, n6, this.length, 0.0);
            }
        }
        if (object2 == null) {
            Arrays.fill(this.imag, 0, this.length, 0.0);
        }
    }

    public void getData(int n, Object object, int n2, int n3, Object object2, int n4, int n5) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                if (object2 != null) {
                    float[] fArray2 = (float[])object2;
                    if (n2 == n4 && n3 == n5) {
                        for (int i = 0; i < this.length; ++i) {
                            int n6 = this.index[i];
                            fArray[n2] = (float)this.real[n6];
                            fArray2[n2] = (float)this.imag[n6];
                            n2 += n3;
                        }
                    } else {
                        for (int i = 0; i < this.length; ++i) {
                            int n7 = this.index[i];
                            fArray[n2] = (float)this.real[n7];
                            fArray2[n4] = (float)this.imag[n7];
                            n2 += n3;
                            n4 += n5;
                        }
                    }
                } else {
                    for (int i = 0; i < this.length; ++i) {
                        fArray[n2] = (float)this.real[this.index[i]];
                        n2 += n3;
                    }
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                if (object2 != null) {
                    double[] dArray2 = (double[])object2;
                    if (n2 == n4 && n3 == n5) {
                        for (int i = 0; i < this.length; ++i) {
                            int n8 = this.index[i];
                            dArray[n2] = this.real[n8];
                            dArray2[n2] = this.imag[n8];
                            n2 += n3;
                        }
                    } else {
                        for (int i = 0; i < this.length; ++i) {
                            int n9 = this.index[i];
                            dArray[n2] = this.real[n9];
                            dArray2[n4] = this.imag[n9];
                            n2 += n3;
                            n4 += n5;
                        }
                    }
                } else {
                    for (int i = 0; i < this.length; ++i) {
                        dArray[n2] = this.real[this.index[i]];
                        n2 += n3;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFT2"));
            }
        }
    }

    public void setFCTData(int n, Object object, int n2, int n3, int n4) {
        switch (n) {
            case 4: {
                int n5;
                float[] fArray = (float[])object;
                for (n5 = 0; n5 < n4; ++n5) {
                    this.imag[n5] = fArray[n2];
                    n2 += n3;
                }
                for (n5 = n4; n5 < this.length; ++n5) {
                    this.imag[n5] = 0.0;
                }
                n5 = this.length - 1;
                int n6 = 0;
                for (int i = 0; i < n5; ++i) {
                    this.real[i] = this.imag[n6++];
                    this.real[n5--] = this.imag[n6++];
                }
                break;
            }
            case 5: {
                int n7;
                double[] dArray = (double[])object;
                for (n7 = 0; n7 < n4; ++n7) {
                    this.imag[n7] = dArray[n2];
                    n2 += n3;
                }
                for (n7 = n4; n7 < this.length; ++n7) {
                    this.imag[n7] = 0.0;
                }
                n7 = this.length - 1;
                int n8 = 0;
                for (int i = 0; i < n7; ++i) {
                    this.real[i] = this.imag[n8++];
                    this.real[n7--] = this.imag[n8++];
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFT2"));
            }
        }
        Arrays.fill(this.imag, 0, this.length, 0.0);
    }

    public void getFCTData(int n, Object object, int n2, int n3) {
        if (this.wrFCT == null || this.wrFCT.length != this.length) {
            this.calculateFCTLUTs();
        }
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < this.length; ++i) {
                    int n4 = this.index[i];
                    fArray[n2] = (float)(this.wrFCT[i] * this.real[n4] + this.wiFCT[i] * this.imag[n4]);
                    n2 += n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < this.length; ++i) {
                    int n5 = this.index[i];
                    dArray[n2] = this.wrFCT[i] * this.real[n5] + this.wiFCT[i] * this.imag[n5];
                    n2 += n3;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFT2"));
            }
        }
    }

    public void setIFCTData(int n, Object object, int n2, int n3, int n4) {
        if (this.wrFCT == null || this.wrFCT.length != this.length) {
            this.calculateFCTLUTs();
        }
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < n4; ++i) {
                    float f = fArray[n2];
                    this.real[i] = (double)f * this.wrFCT[i];
                    this.imag[i] = (double)f * this.wiFCT[i];
                    n2 += n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < n4; ++i) {
                    double d = dArray[n2];
                    this.real[i] = d * this.wrFCT[i];
                    this.imag[i] = d * this.wiFCT[i];
                    n2 += n3;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFT2"));
            }
        }
        if (n4 < this.length) {
            Arrays.fill(this.real, n4, this.length, 0.0);
            Arrays.fill(this.imag, n4, this.length, 0.0);
        }
    }

    public void getIFCTData(int n, Object object, int n2, int n3) {
        switch (n) {
            case 4: {
                float[] fArray = (float[])object;
                int n4 = this.length - 1;
                for (int i = 0; i < n4; ++i) {
                    fArray[n2] = (float)this.real[this.index[i]];
                    fArray[n2 += n3] = (float)this.real[this.index[n4--]];
                    n2 += n3;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n5 = this.length - 1;
                for (int i = 0; i < n5; ++i) {
                    dArray[n2] = (float)this.real[this.index[i]];
                    dArray[n2 += n3] = (float)this.real[this.index[n5--]];
                    n2 += n3;
                }
                break;
            }
            default: {
                throw new RuntimeException(n + JaiI18N.getString("FFT2"));
            }
        }
    }

    public void transform() {
        int n;
        Integer n2 = new Integer(this.length);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        if (this.real.length < this.length || this.imag.length < this.length) {
            throw new RuntimeException(numberFormat.format(n2) + JaiI18N.getString("FFT3"));
        }
        int n3 = 1;
        for (int i = 0; i < this.nbits; ++i) {
            double d = 1.0;
            double d2 = 0.0;
            int n4 = 2 * n3;
            for (int j = 0; j < n3; ++j) {
                for (n = j; n < this.length; n += n4) {
                    int n5 = n + n3;
                    int n6 = this.index[n];
                    int n7 = this.index[n5];
                    double d3 = this.real[n7] * d - this.imag[n7] * d2;
                    double d4 = this.imag[n7] * d + this.real[n7] * d2;
                    this.real[n7] = this.real[n6] - d3;
                    this.imag[n7] = this.imag[n6] - d4;
                    this.real[n6] = this.real[n6] + d3;
                    this.imag[n6] = this.imag[n6] + d4;
                }
                double d5 = d;
                d = d * this.wr[i] - d2 * this.wi[i];
                d2 = d5 * this.wi[i] + d2 * this.wr[i];
            }
            n3 *= 2;
        }
        if (this.scaleFactor != 1.0) {
            for (n = 0; n < this.length; ++n) {
                this.real[n] = this.real[n] * this.scaleFactor;
                this.imag[n] = this.imag[n] * this.scaleFactor;
            }
        }
    }
}

