/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import javax.media.jai.CRIFImpl;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;

final class FilterCRIF
extends CRIFImpl {
    private static final int STEPSIZE = 5;

    private static final KernelJAI createKernel(double d) {
        float[] fArray;
        int n;
        int n2 = 5;
        if (d == 0.0) {
            return null;
        }
        double d2 = Math.abs(d);
        int n3 = (int)d2 / n2;
        double d3 = (double)(10.0f / (float)n2) * (d2 - (double)(n3 * n2));
        double d4 = 0.010101010101010102 * (Math.pow(10.0, 0.2 * d3) - 1.0);
        if ((double)(n3 * n2) == d2) {
            n = 2 * n3 + 1;
            fArray = new float[n * n];
            float f = 1.0f / (float)(n * n);
            Arrays.fill(fArray, f);
        } else {
            int n4;
            int n5 = 2 * n3 + 1;
            n = n5 + 2;
            fArray = new float[n * n];
            float f = 1.0f / (float)(n5 * n5) * (1.0f - (float)d4);
            int n6 = n;
            for (int i = 1; i < n - 1; ++i) {
                for (n4 = 1; n4 < n - 1; ++n4) {
                    fArray[n6 + n4] = f;
                }
                n6 += n;
            }
            float f2 = 1.0f / (float)(n * n) * (float)d4;
            n4 = 0;
            while (n4 < fArray.length) {
                int n7 = n4++;
                fArray[n7] = fArray[n7] + f2;
            }
        }
        if (d > 0.0) {
            int n8 = 0;
            while (n8 < fArray.length) {
                int n9 = n8++;
                fArray[n9] = (float)((double)fArray[n9] * -1.0);
            }
            int n10 = fArray.length / 2;
            fArray[n10] = fArray[n10] + 2.0f;
        }
        return new KernelJAI(n, n, fArray);
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        KernelJAI kernelJAI = FilterCRIF.createKernel(parameterBlock.getFloatParameter(0));
        return kernelJAI == null ? parameterBlock.getRenderedSource(0) : JAI.create("convolve", parameterBlock.getRenderedSource(0), (Object)kernelJAI);
    }
}

