/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class NeuQuantOpImage
extends ColorQuantizerOpImage {
    protected static final int prime1 = 499;
    protected static final int prime2 = 491;
    protected static final int prime3 = 487;
    protected static final int prime4 = 503;
    protected static final int minpicturebytes = 1509;
    private int ncycles;
    private final int maxnetpos;
    private final int netbiasshift = 4;
    private final int intbiasshift = 16;
    private final int intbias = 65536;
    private final int gammashift = 10;
    private final int gamma = 1024;
    private final int betashift = 10;
    private final int beta = 64;
    private final int betagamma = 65536;
    private final int initrad;
    private final int radiusbiasshift = 6;
    private final int radiusbias = 64;
    private final int initradius;
    private final int radiusdec = 30;
    private final int alphabiasshift = 10;
    private final int initalpha = 1024;
    private int alphadec;
    private final int radbiasshift = 8;
    private final int radbias = 256;
    private final int alpharadbshift = 18;
    private final int alpharadbias = 262144;
    private int[][] network;
    private int[] netindex;
    private int[] bias;
    private int[] freq;
    private int[] radpower;

    public NeuQuantOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n, int n2, ROI rOI, int n3, int n4) {
        super(renderedImage, map, imageLayout, n, rOI, n3, n4);
        this.maxnetpos = this.maxColorNum - 1;
        this.netbiasshift = 4;
        this.intbiasshift = 16;
        this.intbias = 65536;
        this.gammashift = 10;
        this.gamma = 1024;
        this.betashift = 10;
        this.beta = 64;
        this.betagamma = 65536;
        this.initrad = this.maxColorNum >> 3;
        this.radiusbiasshift = 6;
        this.radiusbias = 64;
        this.initradius = this.initrad * 64;
        this.radiusdec = 30;
        this.alphabiasshift = 10;
        this.initalpha = 1024;
        this.radbiasshift = 8;
        this.radbias = 256;
        this.alpharadbshift = 18;
        this.alpharadbias = 262144;
        this.netindex = new int[256];
        this.bias = new int[this.maxColorNum];
        this.freq = new int[this.maxColorNum];
        this.radpower = new int[this.initrad];
        this.colorMap = null;
        this.ncycles = n2;
    }

    protected synchronized void train() {
        int n;
        Object object;
        this.network = new int[this.maxColorNum][];
        for (int i = 0; i < this.maxColorNum; ++i) {
            this.network[i] = new int[4];
            object = this.network[i];
            int n2 = (i << 12) / this.maxColorNum;
            object[2] = n2;
            object[1] = n2;
            object[0] = n2;
            this.freq[i] = 65536 / this.maxColorNum;
            this.bias[i] = 0;
        }
        PlanarImage planarImage = this.getSourceImage(0);
        object = planarImage.getBounds();
        if (this.roi != null) {
            object = this.roi.getBounds();
        }
        RandomIter randomIter = RandomIterFactory.create(planarImage, (Rectangle)object);
        int n3 = this.xPeriod * this.yPeriod;
        int n4 = ((Rectangle)object).x / this.xPeriod;
        int n5 = ((Rectangle)object).y / this.yPeriod;
        int n6 = ((Rectangle)object).x % this.xPeriod;
        int n7 = ((Rectangle)object).y % this.yPeriod;
        int n8 = (((Rectangle)object).width - 1) / this.xPeriod + 1;
        int n9 = n8 * ((((Rectangle)object).height - 1) / this.yPeriod + 1);
        if (n9 < 1509) {
            n3 = 1;
        }
        this.alphadec = 30 + (n3 - 1) / 3;
        int n10 = 0;
        int n11 = n9 / this.ncycles;
        int n12 = 1024;
        int n13 = this.initradius;
        int n14 = n13 >> 6;
        if (n14 <= 1) {
            n14 = 0;
        }
        for (n = 0; n < n14; ++n) {
            this.radpower[n] = n12 * ((n14 * n14 - n * n) * 256 / (n14 * n14));
        }
        n = n9 < 1509 ? 3 : (n9 % 499 != 0 ? 1497 : (n9 % 491 != 0 ? 1473 : (n9 % 487 != 0 ? 1461 : 1509)));
        int[] nArray = new int[3];
        int n15 = 0;
        while (n15 < n9) {
            int n16 = (n10 / n8 + n5) * this.yPeriod + n7;
            int n17 = (n10 % n8 + n4) * this.xPeriod + n6;
            try {
                randomIter.getPixel(n17, n16, nArray);
            }
            catch (Exception exception) {
                continue;
            }
            int n18 = nArray[2] << 4;
            int n19 = nArray[1] << 4;
            int n20 = nArray[0] << 4;
            int n21 = this.contest(n18, n19, n20);
            this.altersingle(n12, n21, n18, n19, n20);
            if (n14 != 0) {
                this.alterneigh(n14, n21, n18, n19, n20);
            }
            if ((n10 += n) >= n9) {
                n10 -= n9;
            }
            if (++n15 % n11 != 0) continue;
            n12 -= n12 / this.alphadec;
            if ((n14 = (n13 -= n13 / 30) >> 6) <= 1) {
                n14 = 0;
            }
            for (n21 = 0; n21 < n14; ++n21) {
                this.radpower[n21] = n12 * ((n14 * n14 - n21 * n21) * 256 / (n14 * n14));
            }
        }
        this.unbiasnet();
        this.inxbuild();
        this.createLUT();
        this.setProperty("LUT", this.colorMap);
        this.setProperty("JAI.LookupTable", this.colorMap);
    }

    private void createLUT() {
        int n;
        this.colorMap = new LookupTableJAI(new byte[3][this.maxColorNum]);
        byte[][] byArray = this.colorMap.getByteData();
        int[] nArray = new int[this.maxColorNum];
        for (n = 0; n < this.maxColorNum; ++n) {
            nArray[this.network[n][3]] = n;
        }
        for (n = 0; n < this.maxColorNum; ++n) {
            int n2 = nArray[n];
            byArray[2][n] = (byte)this.network[n2][0];
            byArray[1][n] = (byte)this.network[n2][1];
            byArray[0][n] = (byte)this.network[n2][2];
        }
    }

    private void inxbuild() {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.maxColorNum; ++n) {
            int[] nArray;
            int n4;
            int[] nArray2 = this.network[n];
            int n5 = n;
            int n6 = nArray2[1];
            for (n4 = n + 1; n4 < this.maxColorNum; ++n4) {
                nArray = this.network[n4];
                if (nArray[1] >= n6) continue;
                n5 = n4;
                n6 = nArray[1];
            }
            nArray = this.network[n5];
            if (n != n5) {
                n4 = nArray[0];
                nArray[0] = nArray2[0];
                nArray2[0] = n4;
                n4 = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = n4;
                n4 = nArray[2];
                nArray[2] = nArray2[2];
                nArray2[2] = n4;
                n4 = nArray[3];
                nArray[3] = nArray2[3];
                nArray2[3] = n4;
            }
            if (n6 == n2) continue;
            this.netindex[n2] = n3 + n >> 1;
            for (n4 = n2 + 1; n4 < n6; ++n4) {
                this.netindex[n4] = n;
            }
            n2 = n6;
            n3 = n;
        }
        this.netindex[n2] = n3 + this.maxnetpos >> 1;
        for (n = n2 + 1; n < 256; ++n) {
            this.netindex[n] = this.maxnetpos;
        }
    }

    protected byte findNearestEntry(int n, int n2, int n3) {
        int n4 = 1000;
        int n5 = -1;
        int n6 = this.netindex[n2];
        int n7 = n6 - 1;
        while (n6 < this.maxColorNum || n7 >= 0) {
            int n8;
            int n9;
            int[] nArray;
            if (n6 < this.maxColorNum) {
                nArray = this.network[n6];
                n9 = nArray[1] - n2;
                if (n9 >= n4) {
                    n6 = this.maxColorNum;
                } else {
                    ++n6;
                    if (n9 < 0) {
                        n9 = -n9;
                    }
                    if ((n8 = nArray[0] - n3) < 0) {
                        n8 = -n8;
                    }
                    if ((n9 += n8) < n4) {
                        n8 = nArray[2] - n;
                        if (n8 < 0) {
                            n8 = -n8;
                        }
                        if ((n9 += n8) < n4) {
                            n4 = n9;
                            n5 = nArray[3];
                        }
                    }
                }
            }
            if (n7 < 0) continue;
            nArray = this.network[n7];
            n9 = n2 - nArray[1];
            if (n9 >= n4) {
                n7 = -1;
                continue;
            }
            --n7;
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n8 = nArray[0] - n3) < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) >= n4) continue;
            n8 = nArray[2] - n;
            if (n8 < 0) {
                n8 = -n8;
            }
            if ((n9 += n8) >= n4) continue;
            n4 = n9;
            n5 = nArray[3];
        }
        return (byte)n5;
    }

    private void unbiasnet() {
        for (int i = 0; i < this.maxColorNum; ++i) {
            int[] nArray = this.network[i];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[i];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[i];
            nArray3[2] = nArray3[2] >> 4;
            this.network[i][3] = i;
        }
    }

    private void alterneigh(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n;
        if (n7 < -1) {
            n7 = -1;
        }
        if ((n6 = n2 + n) > this.maxColorNum) {
            n6 = this.maxColorNum;
        }
        int n8 = n2 + 1;
        int n9 = n2 - 1;
        int n10 = 1;
        while (n8 < n6 || n9 > n7) {
            int[] nArray;
            int n11 = this.radpower[n10++];
            if (n8 < n6) {
                nArray = this.network[n8++];
                nArray[0] = nArray[0] - n11 * (nArray[0] - n3) / 262144;
                nArray[1] = nArray[1] - n11 * (nArray[1] - n4) / 262144;
                nArray[2] = nArray[2] - n11 * (nArray[2] - n5) / 262144;
            }
            if (n9 <= n7) continue;
            nArray = this.network[n9--];
            nArray[0] = nArray[0] - n11 * (nArray[0] - n3) / 262144;
            nArray[1] = nArray[1] - n11 * (nArray[1] - n4) / 262144;
            nArray[2] = nArray[2] - n11 * (nArray[2] - n5) / 262144;
        }
    }

    private void altersingle(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.network[n2];
        nArray[0] = nArray[0] - n * (nArray[0] - n3) / 1024;
        nArray[1] = nArray[1] - n * (nArray[1] - n4) / 1024;
        nArray[2] = nArray[2] - n * (nArray[2] - n5) / 1024;
    }

    private int contest(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n5 = Integer.MAX_VALUE;
        int n7 = n4 = -1;
        int n8 = 0;
        while (n8 < this.maxColorNum) {
            int n9;
            int n10;
            int[] nArray = this.network[n8];
            int n11 = nArray[0] - n;
            if (n11 < 0) {
                n11 = -n11;
            }
            if ((n10 = nArray[1] - n2) < 0) {
                n10 = -n10;
            }
            n11 += n10;
            n10 = nArray[2] - n3;
            if (n10 < 0) {
                n10 = -n10;
            }
            if ((n11 += n10) < n5) {
                n5 = n11;
                n4 = n8;
            }
            if ((n9 = n11 - (this.bias[n8] >> 12)) < n6) {
                n6 = n9;
                n7 = n8;
            }
            int n12 = this.freq[n8] >> 10;
            int n13 = n8;
            this.freq[n13] = this.freq[n13] - n12;
            int n14 = n8++;
            this.bias[n14] = this.bias[n14] + (n12 << 10);
        }
        int n15 = n4;
        this.freq[n15] = this.freq[n15] + 64;
        int n16 = n4;
        this.bias[n16] = this.bias[n16] - 65536;
        return n7;
    }
}

