/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.ScaleOpImage;

public final class ScaleBilinearBinaryOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleBilinearBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n7];
        long l = n4;
        long l2 = 1L;
        long l3 = n5;
        long l4 = 1L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l3 = l3 * this.transYRationalDenom - this.transYRationalNum * l4;
        l = 2L * l + (l2 *= this.transXRationalDenom);
        l2 *= 2L;
        l3 = 2L * l3 + (l4 *= this.transYRationalDenom);
        l4 *= 2L;
        l *= this.invScaleXRationalNum;
        l3 *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleXRationalDenom);
        l3 = 2L * l3 - (l4 *= this.invScaleYRationalDenom);
        l4 *= 2L;
        int n8 = Rational.floor(l, l2 *= 2L);
        long l5 = l % l2;
        if (n8 < 0) {
            l5 = l2 + l5;
        }
        int n9 = Rational.floor(l3, l4);
        long l6 = l3 % l4;
        if (n9 < 0) {
            l6 = l4 + l6;
        }
        long l7 = l2 * this.invScaleXRationalDenom;
        l5 *= this.invScaleXRationalDenom;
        long l8 = this.invScaleXFrac * l2;
        long l9 = l4 * this.invScaleYRationalDenom;
        l6 *= this.invScaleYRationalDenom;
        long l10 = this.invScaleYFrac * l4;
        for (n = 0; n < n6; ++n) {
            nArray[n] = n8;
            nArray3[n] = (int)((float)l5 / (float)l7 * (float)this.one);
            n8 = (int)((long)n8 + this.invScaleXInt);
            if ((l5 += l8) < l7) continue;
            ++n8;
            l5 -= l7;
        }
        for (n = 0; n < n7; ++n) {
            nArray2[n] = n9;
            nArray4[n] = (int)((float)l6 / (float)l9 * (float)this.one);
            n9 = (int)((long)n9 + this.invScaleYInt);
            if ((l6 += l10) < l9) continue;
            ++n9;
            l6 -= l9;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, n4, n5, n6, n7, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, n4, n5, n6, n7, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, n4, n5, n6, n7, nArray, nArray2, nArray3, nArray4);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        int n7;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n18 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n19 = dataBufferByte2.getOffset();
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        for (n7 = 0; n7 < n3; ++n7) {
            n6 = nArray[n7];
            n5 = n10 + (n6 - n8);
            nArray5[n7] = n5 >> 3;
            nArray6[n7] = 7 - (n5 & 7);
        }
        int n20 = 0;
        int n21 = 0;
        int n22 = (n2 - n15) * n17 + n19;
        int n23 = n16 + (n - n14);
        int n24 = 0;
        int n25 = 0;
        for (n25 = 0; n25 < n4; ++n25) {
            n21 = nArray2[n25];
            int n26 = nArray4[n25];
            n7 = (n21 - n9) * n11 + n18;
            n23 = n16 + (n - n14);
            for (n24 = 0; n24 < n3; ++n24) {
                int n27 = nArray3[n24];
                n20 = nArray[n24];
                int n28 = n10 + (n20 + 1 - n8);
                int n29 = n28 >> 3;
                int n30 = 7 - (n28 & 7);
                n6 = byArray[n7 + nArray5[n24]] >> nArray6[n24] & 1;
                n5 = byArray[n7 + n29] >> n30 & 1;
                int n31 = byArray[n7 + n11 + nArray5[n24]] >> nArray6[n24] & 1;
                int n32 = byArray[n7 + n11 + n29] >> n30 & 1;
                int n33 = (n5 - n6) * n27 + (n6 << this.subsampleBits);
                int n34 = (n32 - n31) * n27 + (n31 << this.subsampleBits);
                int n35 = (n34 - n33) * n26 + ((n33 << this.subsampleBits) + this.round2) >> this.shift2;
                int n36 = n23 >> 3;
                int n37 = 7 - (n23 & 7);
                if (n35 == 1) {
                    int n38 = n22 + n36;
                    byArray2[n38] = (byte)(byArray2[n38] | 1 << n37);
                } else {
                    int n39 = n22 + n36;
                    byArray2[n39] = (byte)(byArray2[n39] & 255 - (1 << n37));
                }
                ++n23;
            }
            n22 += n17;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        int n7;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n18 = dataBufferUShort.getOffset();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray2 = dataBufferUShort2.getData();
        int n19 = dataBufferUShort2.getOffset();
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        for (n7 = 0; n7 < n3; ++n7) {
            n6 = nArray[n7];
            n5 = n10 + (n6 - n8);
            nArray5[n7] = n5 >> 4;
            nArray6[n7] = 15 - (n5 & 0xF);
        }
        int n20 = (n2 - n15) * n17 + n19;
        int n21 = n16 + (n - n14);
        for (int i = 0; i < n4; ++i) {
            int n22 = nArray2[i];
            int n23 = nArray4[i];
            n7 = (n22 - n9) * n11 + n18;
            n21 = n16 + (n - n14);
            for (int j = 0; j < n3; ++j) {
                int n24 = nArray3[j];
                int n25 = nArray[j];
                int n26 = n10 + (n25 + 1 - n8);
                int n27 = n26 >> 4;
                int n28 = 15 - (n26 & 0xF);
                n6 = sArray[n7 + nArray5[j]] >> nArray6[j] & 1;
                n5 = sArray[n7 + n27] >> n28 & 1;
                int n29 = sArray[n7 + n11 + nArray5[j]] >> nArray6[j] & 1;
                int n30 = sArray[n7 + n11 + n27] >> n28 & 1;
                int n31 = (n5 - n6) * n24 + (n6 << this.subsampleBits);
                int n32 = (n30 - n29) * n24 + (n29 << this.subsampleBits);
                int n33 = (n32 - n31) * n23 + (n31 << this.subsampleBits) + this.round2 >> this.shift2;
                int n34 = n21 >> 4;
                int n35 = 15 - (n21 & 0xF);
                if (n33 == 1) {
                    int n36 = n20 + n34;
                    sArray2[n36] = (short)(sArray2[n36] | 1 << n35);
                } else {
                    int n37 = n20 + n34;
                    sArray2[n37] = (short)(sArray2[n37] & 65535 - (1 << n35));
                }
                ++n21;
            }
            n20 += n17;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        int n7;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        int n10 = multiPixelPackedSampleModel.getDataBitOffset();
        int n11 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n12 = writableRaster.getMinX();
        int n13 = writableRaster.getMinY();
        int n14 = writableRaster.getSampleModelTranslateX();
        int n15 = writableRaster.getSampleModelTranslateY();
        int n16 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n17 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray5 = dataBufferInt.getData();
        int n18 = dataBufferInt.getOffset();
        int[] nArray6 = dataBufferInt2.getData();
        int n19 = dataBufferInt2.getOffset();
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        for (n7 = 0; n7 < n3; ++n7) {
            n6 = nArray[n7];
            n5 = n10 + (n6 - n8);
            nArray7[n7] = n5 >> 5;
            nArray8[n7] = 31 - (n5 & 0x1F);
        }
        int n20 = (n2 - n15) * n17 + n19;
        int n21 = n16 + (n - n14);
        for (int i = 0; i < n4; ++i) {
            int n22 = nArray2[i];
            int n23 = nArray4[i];
            n7 = (n22 - n9) * n11 + n18;
            n21 = n16 + (n - n14);
            for (int j = 0; j < n3; ++j) {
                int n24 = nArray3[j];
                int n25 = nArray[j];
                int n26 = n10 + (n25 + 1 - n8);
                int n27 = n26 >> 5;
                int n28 = 31 - (n26 & 0x1F);
                n6 = nArray5[n7 + nArray7[j]] >> nArray8[j] & 1;
                n5 = nArray5[n7 + n27] >> n28 & 1;
                int n29 = nArray5[n7 + n11 + nArray7[j]] >> nArray8[j] & 1;
                int n30 = nArray5[n7 + n11 + n27] >> n28 & 1;
                int n31 = (n5 - n6) * n24 + (n6 << this.subsampleBits);
                int n32 = (n30 - n29) * n24 + (n29 << this.subsampleBits);
                int n33 = (n32 - n31) * n23 + (n31 << this.subsampleBits) + this.round2 >> this.shift2;
                int n34 = n21 >> 5;
                int n35 = 31 - (n21 & 0x1F);
                if (n33 == 1) {
                    int n36 = n20 + n34;
                    nArray6[n36] = nArray6[n36] | 1 << n35;
                } else {
                    int n37 = n20 + n34;
                    nArray6[n37] = nArray6[n37] & 255 - (1 << n35);
                }
                ++n21;
            }
            n20 += n17;
        }
    }
}

