/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleNearestOpImage
extends ScaleOpImage {
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleNearestOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int[] nArray = new int[n7];
        long l = n5;
        long l2 = 1L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l = 2L * l + (l2 *= this.transXRationalDenom);
        l2 *= 2L;
        int n9 = Rational.floor(l *= this.invScaleXRationalNum, l2 *= this.invScaleXRationalDenom);
        long l3 = l % l2;
        if (n9 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleXRationalDenom;
        l3 *= this.invScaleXRationalDenom;
        long l5 = this.invScaleXFrac * l2;
        for (int i = 0; i < n7; ++i) {
            nArray[i] = (n9 - n) * n4;
            n9 = (int)((long)n9 + this.invScaleXInt);
            if ((l3 += l5) < l4) continue;
            ++n9;
            l3 -= l4;
        }
        int[] nArray2 = new int[n8];
        long l6 = n6;
        long l7 = 1L;
        l6 = l6 * this.transYRationalDenom - this.transYRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transYRationalDenom);
        l7 *= 2L;
        int n10 = Rational.floor(l6 *= this.invScaleYRationalNum, l7 *= this.invScaleYRationalDenom);
        long l8 = l6 % l7;
        if (n10 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleYRationalDenom;
        l8 *= this.invScaleYRationalDenom;
        long l10 = this.invScaleYFrac * l7;
        for (int i = 0; i < n8; ++i) {
            nArray2[i] = (n10 - n2) * n3;
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l8 += l10) < l9) continue;
            ++n10;
            l8 -= l9;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getNumBands();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n6 = nArray4[i];
            int n7 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n8 = n7;
                int n9 = nArray2[j] + n6;
                for (int k = 0; k < n; ++k) {
                    int n10 = nArray[k];
                    int n11 = n10 + n9;
                    byArray3[n8] = byArray4[n11];
                    n8 += n3;
                }
                n7 += n4;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getNumBands();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n6 = nArray4[i];
            int n7 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n8 = n7;
                int n9 = nArray2[j] + n6;
                for (int k = 0; k < n; ++k) {
                    int n10 = nArray[k];
                    int n11 = n10 + n9;
                    sArray3[n8] = sArray4[n11];
                    n8 += n3;
                }
                n7 += n4;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int[] nArray4 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray5 = rasterAccessor.getBandOffsets();
        int[][] nArray6 = rasterAccessor.getIntDataArrays();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            int[] nArray7 = nArray3[i];
            int[] nArray8 = nArray6[i];
            int n6 = nArray5[i];
            int n7 = nArray4[i];
            for (int j = 0; j < n2; ++j) {
                int n8 = n7;
                int n9 = nArray2[j] + n6;
                for (int k = 0; k < n; ++k) {
                    int n10 = nArray[k];
                    int n11 = n10 + n9;
                    nArray7[n8] = nArray8[n11];
                    n8 += n4;
                }
                n7 += n5;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n6 = nArray4[i];
            int n7 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n8 = n7;
                int n9 = nArray2[j] + n6;
                for (int k = 0; k < n; ++k) {
                    int n10 = nArray[k];
                    int n11 = n10 + n9;
                    fArray3[n8] = fArray4[n11];
                    n8 += n4;
                }
                n7 += n5;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n6 = nArray4[i];
            int n7 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n8 = n7;
                int n9 = nArray2[j] + n6;
                for (int k = 0; k < n; ++k) {
                    int n10 = nArray[k];
                    int n11 = n10 + n9;
                    dArray3[n8] = dArray4[n11];
                    n8 += n4;
                }
                n7 += n5;
            }
        }
    }
}

