/*!
 * FSI Viewer (tm)
 * Build: 19.05.6483
 * 
 * Copyright (c) 2019 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2019",strBuild:"19.05.6483",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CORSLoader!==b){return}a.CORSLoader=function(){var h=this;var d=0;var c={};var g=false;var i;var f=null;if(a.isInternetExplorer&&a.versionInternetExplorer<10){i=function(k){var e;if(!a.utils.isCrossDomain(k)){g=false;e=new XMLHttpRequest()}else{g=true;e=new XDomainRequest()}return e}}else{if(typeof XMLHttpRequest!="undefined"){i=function(){return new XMLHttpRequest()}}}if(!i){try{f=new ActiveXObject("Msxml2.XMLHTTP");i=function(){return new ActiveXObject("Msxml2.XMLHTTP")}}catch(j){try{f=new ActiveXObject("Microsoft.XMLHTTP");i=function(){return new ActiveXObject("Microsoft.XMLHTTP")}}catch(j){f=null;i=function(){return null}}}}this.getSupported=function(){return(i()!=null)};this.load=function(l,m,o,q){var k=i(l);if(!k){return}if(o&&k.overrideMimeType){k.overrideMimeType(o)}k._url=l;var n=d;c[d]=k;d++;if(g){k.onerror=function(){delete c[n];if(m===b||this.FSIaborted){return}m(this,this.responseText,q,400)};k.onload=function(){delete c[n];if(m===b||this.FSIaborted){return}var r=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var s=new ActiveXObject("Microsoft.XMLDOM");s.async=false;s.loadXML(r);r=this.responseXML=s}catch(t){}break}m(this,r,q,200)}}else{k.onreadystatechange=function(){if(k.readyState!==4){return}delete c[n];if(m===b||this.FSIaborted){return}var e=(this.responseXML!=null&&this.responseXML.firstChild)?this.responseXML:this.responseText;m(this,e,q,k.status)}}try{k.open("GET",l,true);k.send(null)}catch(p){m(this,"",q,500)}return k};this.stopPendingRequests=function(){for(var k in c){if(c.hasOwnProperty(k)){var e=c[k];if(e){e.FSIaborted=true;if(e.abort){e.abort()}}}}};this.destroy=function(){h.reset()};this.reset=function(){this.stopPendingRequests();c={}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CanvasProgressBar!==b){return}a.CanvasProgressBar=function(s,m,j,d,q,e){var r=this;if(!e){e={}}if(typeof(e.border)!="string"){e.frame="#58a8ff"}if(typeof(e.color)!="string"){e.color="#58a8ff"}if(typeof(e.background)!="string"){e.background="rgba(255,255,255,0.5)"}if(typeof(e.text)!="string"){e.text="#FFFFFF"}var p=m;var o=j;var g=q;var l=d;var h=0;var k=(q>10&&d>40);this.draw=function(t){var u=l/100*t;i(p,o,l,g,h);c(p,o,u,g,h,l);if(k){f(p,o,u,g,h,l)}};this.setCtx=function(t){s=t};this.setPos=function(t,u){p=t;o=u};var i=function(v,z,w,u,t){s.save();s.fillStyle=e.border;n(v-1,z-1,w+2,1,t);n(v-1,z+u,w+2,1,t);n(v-1,z-1,1,u+2,t);n(v+w,z-1,1,u+2,t);s.fillStyle=e.background;n(v,z,w,u,t);s.restore()};var c=function(v,z,w,u,t){s.fillStyle=e.color;n(v,z,w,u,t)};var n=function(u,w,v,t){s.fillRect(u,w,v,t)};var f=function(B,z,t,D,w,A){s.save();s.font="10px Arial";s.textAlign="start";s.textBaseline="alphabetic";s.fillStyle=e.text;var C=Math.floor(t/A*100)+"%";var u=s.measureText(C).width;var v=B+t-u-w/2-4;if(t<=w+u){v=B+w/2}s.fillText(C,v,z+D/2+3.25);s.restore()}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}if(ar.renderer===b){ar.renderer="jpeg"}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim]}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=a.utils.urlDecode(ay[0]).toLowerCase();if(ax.length>0){ar=a.utils.urlDecode(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=a.utils.urlDecode(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=a.utils.urlDecode(n.getAttributeValue(aO,"src"))}if(!aK){aK=a.utils.urlDecode(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(au){var aA,ay,av;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var az=n.cfg.fpxsources;if(typeof(az)==="string"||(typeof(az)==="object")&&typeof(az.push)==="function"){aA={};aA.oXML=null;if(typeof(az)==="string"){if(ae===false){aA.arImages=az.split(",");for(ay=0;ay<aA.arImages.length;ay++){aA.arImages[ay]=a.utils.urlDecode(aA.arImages[ay])}}else{var ax=az.split(",");aA.arImages=[];for(ay=0;ay<ax.length;ay++){av=a.utils.urlDecode(ax[ay]);if(ae(av)){aA.arImages.push(av)}}}}else{aA.arImages=az}}}if(!aA&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aB=n.arUnrecognizedConfigNodes;for(ay=0;ay<aB.length;ay++){var aw=aB[ay];if(typeof(aw.nodeName)==="string"){var at=aw.nodeName.toLowerCase();if(at==="images"||at==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aA=S(aw,au);aA.oXML=aw;break}}}}}if(!aA&&n.cfg&&n.cfg.fpxsrc!==b){aA={};aA.oXML=null;if(ae===false){aA.arImages=[a.utils.urlDecode(n.cfg.fpxsrc)]}else{av=a.utils.urlDecode(n.cfg.fpxsrc);if(ae()){aA.arImages=[av]}}}return aA};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=n.XMLChildNodesToString(aF)}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(a.getViewerLocation()+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=a.getViewerLocation()+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!==b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.setFromArray=function(h){e.left=h[0];e.top=h[1];e.right=h[2];e.bottom=h[3]};this.scaleRect=function(h){if(h===1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h===1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.getPartialRect=function(j){var i=e.duplicateRect();if(!j.isDefaultImageRect()){var h=i.width();var k=i.height();i.offsetRect(j.left*h,j.top*k);i.right=i.left+h*j.width();i.bottom=i.top+k*j.height()}return i};this.isDefaultImageRect=function(){return(e.left===0&&e.top===0&&e.right===1&&e.bottom===1)};this.limitToImageRect=function(){e.left=Math.max(0,Math.min(1,e.left));e.right=Math.max(0,Math.min(1,e.right));e.top=Math.max(0,Math.min(1,e.top));e.bottom=Math.max(0,Math.min(1,e.bottom))};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left===h.left&&e.top===h.top&&e.right===h.right&&e.bottom===h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.setFromString=function(j){if(typeof(j)!=="string"){return}j=decodeURIComponent(j);j=j.replace(/[^0-9,.]/g,"");j=j.split(",");if(j.length>3){for(var h=0;h<j.length;h++){j[h]=parseFloat(j[h])}e.setFromArray(j)}};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!==b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!==b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!==b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!==0||u!==0||v!==0||q!==0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!==-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!==-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!==b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!==b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r===b&&u===b){r=i.width();u=i.height();A=1}else{if(r!==b){A=i.width()/r;if(u===b){u=i.height()/A}}else{A=i.height()/u;if(r===b){r=i.width()/A}}}if(z===b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left===0&&v.top===0&&v.width()===v._refWidth&&v.height()===v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left===0&&r.top===0&&r.width()===r._refWidth&&r.height()===r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,B){var C=new a.CroppedImage();var D,v;if(typeof(y)!=="string"||y.length!==2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var A;var z=p.isCropped();var q,E;var x,F;if(z){x=(1-h.left-h.right);F=(1-h.top-h.bottom);q=Math.round(x*c.width);E=Math.round(F*c.height)}else{q=c.width;E=c.height}u=Math.min(u,q);s=Math.min(s,E);if(u/q<s/E){v=s;D=Math.round(q/E*s);t=D-u;switch(y.charAt(1)){case"l":r.setRect(0,0,D-t,v);break;case"r":r.setRect(t,0,D,v);break;case"v":A=Math.random()*t;r.setRect(A,0,A+u,v);break;default:r.setRect(t/2,0,D-t/2,v)}}else{D=u;v=Math.round(E/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,D,v-t);break;case"b":r.setRect(0,t,D,v);break;case"v":A=Math.random()*t;r.setRect(0,A,D,A+s);break;default:r.setRect(0,t/2,D,v-t/2)}}r.scaleRectXY(1/D,1/v);if(p.isCropped()){D/=x;v/=F;if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v);r.scaleRectXY(x,F);r.offsetRect(h.left,h.top)}else{if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v)}C.widthUncropped=D;C.heightUncropped=v;C.setCropRect(r.left,r.top,r.right,r.bottom);return C}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomSkinClass!==b){return}a.CustomSkinClass=function(i,m,f,j){var q=this;var l;var o;var g;var k;var n=f.getCallbacks();var d=this.paramCustomSkinClass=m;var c;var p=function(){l=f.getRootContainer();o=f.getParentElement();q.destroy();c=a.getViewerLocation()+"/skins/";if(typeof(m)==="string"){if(m.match(/\.js$/)){var r=a.getViewerLocation()+"/"+m;c=r;c=c.replace(/\/[^/]*$/,"/");a.loadJavascript(r,f.getInstanceID(),q,e)}else{if(typeof(window[m])==="function"){k=new window[m](i,o,h,q)}}}else{if(typeof(m)==="function"){k=new m(i,o,h,q)}}};this.getSkinPath=function(){return c};this.replacePaths=function(r){r=r.replace(/\[fsi-skin-path]/g,c);r=r.replace(/\[fsi-viewer-path]/g,a.getViewerLocation()+"/");return r};this.loadHTMLFragment=function(s,v,t,r){s=q.replacePaths(s);var u=function(x,w){w=q.replacePaths(w);if(v&&typeof(v)==="object"&&v.tagName){while(v.firstChild){v.removeChild(v.firstChild)}v.innerHTML=w}t(w,r)};i.loadFile(s,u,"text/plain; charset=utf-8")};var h=function(s){g=s;if(s&&typeof(s)==="object"&&s.tagName){s.appendChild(l)}if(n.isset("onResize")){var r=f.getElementSpace();n.run("onResize",[r.width,r.height,true,f.getIsFullScreen()])}if(i.onResize){i.onResize({FSI_after_treshold:true})}j.apply(i)};var e=function(){d=d.replace(/\.js$/,"");var r=d.lastIndexOf("/");if(r!==1){d=d.substr(r+1)}if(d.length>0&&typeof(window[d])==="function"){k=new window[d](i,o,h,q)}else{h()}};this.getCustomSkinInstance=function(){return k};this.destroy=function(){if(k&&typeof(k.destroy)==="function"){k.destroy(q);k=b}if(g!==b){g=b;while(o.firstChild){o.removeChild(o.firstChild)}o.appendChild(l)}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Sprite!==b){return}a.Sprite=function(k,i,t,o,s,m,f){var n=this;var c=0.075;var d;var e=true;var u;var j;var v=1;var l=n.margin={left:0,top:0,right:0,bottom:0};var r={};r.width=i;r.height=t;var p=(s)?"canvas":"div";d=n.element=document.createElement(p);d.setAttribute("draggable","false");if(f){d.className=f}var g="";switch(m){case"inline":break;default:g+="position:absolute;z-index:"+o}a.utils.setStyleAttr(d,g);if(s){n.canvas=n.element;n.canvas.setAttribute("crossorigin","anonymous");n.canvas.setAttribute("width",r.width);n.canvas.setAttribute("height",r.height);n.ctx=n.canvas.getContext("2d")}if(k){k.appendChild(d)}this.remove=function(){if(k){a.removeChild(k,d)}};this.setPos=function(h,w){n.x=h;n.y=w;d.style.marginLeft=h+"px";d.style.marginTop=w+"px"};this.isVisible=function(){return(v>0)};this.show=function(h,w){if(e===h){return}e=h;if(j!==b){cancelAnimationFrame(j);j=b}if(!w){v=d.style.opacity=(h)?1:0;d.style.display=(h)?"block":"none"}else{u=(h)?c:-c;if(h){d.style.display="block"}q()}};this.updateMargins=function(){l=n.margin=a.utils.getElementMargins(d)};this.getClientDim=function(){return a.getElementClientDim(n.element)};this.updateDimension=function(){r=a.getElementClientDim(d)};this.width=function(){return r.width};this.height=function(){return r.height};var q=function(){v+=u;if(u>0){if(v>=1){v=1;j=b}else{j=requestAnimationFrame(q)}}else{if(v<=0){v=0;j=b;d.style.display="none"}else{j=requestAnimationFrame(q)}}d.style.opacity=v};if(!s){this.setSize=function(x,y){r.width=x;r.height=y;if(typeof(x)!=="string"){x+="px"}if(typeof(y)!=="string"){y+="px"}n.element.style.width=x;n.element.style.height=y};this.clear=function(){}}else{this.setSize=function(x,y){r.width=x;r.height=y;n.canvas.width=x;n.canvas.height=y};this.clear=function(){n.ctx.clearRect(0,0,r.width,r.height)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ToolTip!==b){return}a.ToolTip=function(c){var q=this;var n;var h;var d;var m,l;var j;var k=false;var e={};var g=false;var i;var p=function(){n=document.createElement("div");a.addClass(n,"fsi-ui-tool-tip-container fsi-ui-tool-tip-container-hidden");h=document.createElement("div");a.addClass(h,"fsi-ui-tool-tip");n.appendChild(h);d=document.createElement("div");a.addClass(d,"fsi-ui-tool-tip-arrow");n.appendChild(d)};this.destroy=function(){q.hide();clearTimeout(j)};this.setContent=function(r){i=r};this.show=function(t,s,r,z,v,u,w){if(!i){return}e.strTip=t;e.elSrc=s;e.x=r;e.y=z;e.bNoAutoBold=w;e.fnGetToolTipText=v;if(l!==b){clearTimeout(l);l=b}if(m!==b){clearTimeout(m)}if(u===b){u=(k)?100:1000}m=setTimeout(f,u)};this.setParentContainer=function(r){q.hide();c=r};var f=function(){if(m!==b){clearTimeout(m);m=b}var w=e.strTip;var C,D;if(e.fnGetToolTipText!==b){D=e.fnGetToolTipText(w,i);if(D===b){D=i[w]}}else{D=i[w]}if(D!==b){w=D}else{if(!e.bNoAutoBold){w="<b>"+w+"</b>"}}h.innerHTML=w;c.appendChild(n);d.style.left="0px";n.style.display="inline-block";n.style.width=c.offsetWidth+"px";C=a.getElementClientPos(h);n.style.display="block";n.style.width=C.width+"px";var G=e.x;if(G===b){G=0}var F=e.y;if(F===b){F=0}var v;var u=a.getElementClientPos(c);if(e.elSrc){v=a.getElementClientPos(e.elSrc);G+=v.left-u.left+(v.right-v.left)/2;F+=v.top-u.top}C=a.getElementClientPos(n);G-=C.width/2;F-=C.height+2;var t=document.body;var z=4;var E=G;var s=t.clientWidth;if(a.isMobileDevice){s=Math.max(t.clientWidth,u.width+u.left)}G=Math.min(s-u.left-C.width-z,Math.max(-u.left+z,G));var B=E-G;var r=d.offsetWidth/2;if(B!==0){var A=Math.min(n.offsetWidth/2-r,Math.abs(B));if(B<0){B=-A}else{B=A}}d.style.left=(n.offsetWidth/2-r+B)+"px";n.style.left=G+"px";n.style.top=F+"px";g=true;k=true;clearTimeout(j);j=setTimeout(o,1000);a.removeClass(n,"fsi-ui-tool-tip-container-hidden");a.addClass(n,"fsi-ui-tool-tip-container-visible")};var o=function(){k=false};this.hideAfter=function(r){if(r===b||isNaN(r)||r<1){r=2500}if(l!==b){clearTimeout(l);l=b}l=setTimeout(q.hide,r)};this.hide=function(){if(m!==b){clearTimeout(m);m=b}if(l!==b){clearTimeout(l);l=b}if(g){a.removeClass(n,"fsi-ui-tool-tip-container-visible");a.addClass(n,"fsi-ui-tool-tip-container-hidden");a.removeChild(c,n);g=false}};p()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.FullScreen!==b){return}a.FullScreen={};a.FullScreen.__initDone=false;a.FullScreen._nIDChangeEvent=0;a.FullScreen._nIDErrorEvent=0;a.FullScreen._eventHandlers={};a.FullScreen.__init=function(){var d=a.FullScreen;if(d.__initDone){return}d.__initDone=true;var c=0;if(document.webkitExitFullscreen){c=3}else{if(document.msExitFullscreen){c=1}else{if(document.mozCancelFullScreen){c=2}else{if(document.exitFullscreen){c=0}}}}switch(c){case 1:d.requestFullscreen="msRequestFullscreen";d.exitFullscreen="msExitFullscreen";d.fullscreenPseudoClass=":-ms-fullscreen";d.fullscreenChange="MSFullscreenChange";d.fullscreenError="MSFullscreenError";d.fullScreen="msFullscreenElement";d.fullscreenElement="msFullscreenElement";break;case 2:d.requestFullscreen="mozRequestFullScreen";d.exitFullscreen="mozCancelFullScreen";d.fullscreenPseudoClass=":-moz-full-screen";d.fullscreenChange="mozfullscreenchange";d.fullscreenError="mozfullscreenerror";d.fullScreen="mozFullScreen";d.fullscreenElement="mozFullScreenElement";break;case 3:d.requestFullscreen="webkitRequestFullscreen";d.exitFullscreen="webkitExitFullscreen";d.fullscreenPseudoClass=":-webkit-full-screen";d.fullscreenChange="webkitfullscreenchange";d.fullscreenError="webkitfullscreenerror";d.fullScreen="webkitIsFullScreen";d.fullscreenElement="webkitFullscreenElement";break;default:d.requestFullscreen="requestFullscreen";d.exitFullscreen="exitFullscreen";d.fullscreenPseudoClass=":fullscreen";d.fullscreenChange="fullscreenChange";d.fullscreenError="fullscreenError";d.fullScreen="fullScreen";d.fullscreenElement="fullscreenElement"}if(typeof(document[d.exitFullscreen])!=="function"){a.FullScreen.bUseFakeFullScreen=true}d.nMode=c};a.FullScreen.start=function(c){a.FullScreen.__init();a.FullScreen.quit();if(!a.FullScreen.bUseFakeFullScreen){c[a.FullScreen.requestFullscreen]()}else{a.FullScreen._enterFakeFullScreen(c)}};a.FullScreen.quit=function(){a.FullScreen.__init();if(!a.FullScreen._exitFakeFullScreen()&&!a.FullScreen.bUseFakeFullScreen){document[a.FullScreen.exitFullscreen]()}};a.FullScreen._enterFakeFullScreen=function(c){if(!c){return}var f=a.FullScreen.oFake={};f.elParentOriginal=c.parentNode;f.elNextSibling=c.nextSibling;f.el=c;var e,d;e=document.documentElement;f.docScrollLeft=e.scrollLeft;f.docScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;e=document.body;f.bodyScrollLeft=e.scrollLeft;f.bodyScrollTop=e.scrollTop;e.scrollTop=e.scrollLeft=0;d=f.bodyStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box";if(document.documentElement){e=document.documentElement;d=f.documentStyle={};d.overflow=e.style.overflow;e.style.overflow="hidden";d.boxSizing=e.style.boxSizing;e.style.boxSizing="border-box"}a.FullScreen.bChanging=true;document.body.appendChild(c);a.FullScreen.bChanging=false;a.addEvent(window,"keydown",a.FullScreen._keyDown);a.FullScreen.callHandlers()};a.FullScreen._keyDown=function(c){if(c&&c.key==="Escape"||c.which===27){a.FullScreen.quit()}};a.FullScreen._exitFakeFullScreen=function(){if(!a.FullScreen.oFake){return false}var f=a.FullScreen.oFake;a.FullScreen.bChanging=true;if(f.elParentOriginal){if(f.elNextSibling){f.elParentOriginal.insertBefore(f.el,f.elNextSibling)}else{f.elParentOriginal.appendChild(f.el)}}var e=document.body;var d=f.bodyStyle;var c;for(c in d){if(d.hasOwnProperty(c)){e.style[c]=d[c]}}e.scrollLeft=f.bodyScrollLeft;e.scrollTop=f.bodyScrollTop;if(document.documentElement){e=document.documentElement;d=f.documentStyle;for(c in d){if(d.hasOwnProperty(c)){e.style[c]=d[c]}}e.scrollLeft=f.docScrollLeft;e.scrollTop=f.docScrollTop}a.FullScreen.bChanging=false;a.FullScreen.oFake=b;a.FullScreen.callHandlers();a.removeEvent(window,"keydown",a.FullScreen._keyDown);return true};a.FullScreen.toggle=function(c){if(a.FullScreen.getEnabled()){a.FullScreen.quit()}else{a.FullScreen.start(c)}};a.FullScreen.getFullscreenPseudoClass=function(){a.FullScreen.__init();return a.FullScreen.fullscreenPseudoClass};a.FullScreen.addChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();a.FullScreen._nIDChangeEvent++;if(typeof(e)==="function"){if(!e._FSIFullScreenEventID){a.FullScreen._eventHandlers[a.FullScreen._nIDChangeEvent]=e;e._FSIFullScreenEventID=a.FullScreen._nIDChangeEvent}a.addEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.addEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.callHandlers=function(){var c={type:"fullscreenchange",FSI_fake:true};for(var e in a.FullScreen._eventHandlers){if(a.FullScreen._eventHandlers.hasOwnProperty(e)){var d=a.FullScreen._eventHandlers[e];d(c)}}};a.FullScreen.removeChangeEvents=function(d,e,c){if(!d){return}a.FullScreen.__init();if(typeof(e)==="function"){if(e._FSIFullScreenEventID&&a.FullScreen._eventHandlers[e._FSIFullScreenEventID]){delete a.FullScreen._eventHandlers[e._FSIFullScreenEventID]}a.removeEvent(window,a.FullScreen.fullscreenChange,e)}if(typeof(c)==="function"){a.removeEvent(window,a.FullScreen.fullscreenError,c)}};a.FullScreen.getAvailable=function(d){a.FullScreen.__init();var c=d[a.FullScreen.requestFullscreen];return(c)};a.FullScreen.getEnabled=function(){a.FullScreen.__init();var c=a.FullScreen.getElement();return(c!==b&&c!==null)};a.FullScreen.getElement=function(){a.FullScreen.__init();var c;if(a.FullScreen.bUseFakeFullScreen){if(a.FullScreen.oFake){c=a.FullScreen.oFake.el}}else{c=document[a.FullScreen.fullscreenElement]}return c}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!==b){return}a.Easing={easeLinear:function(f,g,e,h){return h*(f/g)+e},easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f===0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f===g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f===0){return e}if(f===g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j/2)===2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.IMGLoadingEngine!==b){return}a.IMGLoadingEngine=function(q,h){var p=this;var n=0;var w=0;var l=(typeof(h)==="function")?h:a.fnDoNothing;var j={};var c=1;var s;var g,d;var v;this.destroy=function(){e();p.abortAll();c=1;u()};this.getCountLoading=function(){return n};this.load=function(x,z,B,y,C){var A=(!v||v[B]===b);if(typeof(C)!=="object"){C={}}if(typeof(x)!=="object"){return C}if(typeof(B)!=="string"||B.length<1){B="default"}if(j[B]===b){j[B]={__count:0}}j[B][c]=x;j[B].__count++;n++;if(A){if(w===0){m(1)}w++}a.addEvent(x,"load",r);a.addEvent(x,"error",f);x.FSIIMGLoadingEngineData=C;C.uid=c;C.url=z;C.strPurpose=B;C.bLoading=true;C.bVisual=A;if(typeof(y)==="function"){C.fnLoad=y}a.utils.loadImageCors(x,z);c++};this.setNotVisualPurposes=function(x){if(typeof(x)&&x!==null&&typeof(x.concat)==="function"){if(x.length>0){v={};for(var y=0;y<x.length;y++){v[x[y]]=true}}else{v=b}}};var m=function(x){if(!l||x===g){return}g=x;e();s=setTimeout(i,50)};var i=function(){if(g===d){return}d=g;e();l.call(q,d)};var e=function(){if(s!==b){clearTimeout(s);s=b}};var u=this.reset=function(){if(n>0){for(var z in j){if(j.hasOwnProperty(z)){var y=z[j];for(var x in y){if(y.hasOwnProperty(x)){t(y[x])}}}}}n=w=0;j={}};var k=function(x){return(typeof(x)==="object"&&typeof(x.FSIIMGLoadingEngineData)==="object")};var t=function(x){if(!k(x)){return false}var y=x.FSIIMGLoadingEngineData;if(!y.bLoaded){y.bAborted=true}n--;if(x.FSIIMGLoadingEngineData.bVisual){w--;if(w===0){m(0)}}if(j[y.strPurpose]!==b){if(j[y.strPurpose][y.uid]===b){a.console.error("IMGLoadingEngine: failed to remove item with purpose '"+y.strPurpose+" and uid "+y.uid)}else{j[y.strPurpose][y.uid]=b;delete j[y.strPurpose][y.uid];delete x.FSIIMGLoadingEngineData}j[y.strPurpose].__count--;if(j[y.strPurpose].__count===0){delete j[y.strPurpose]}}return true};this.abortAll=function(){if(n>0){for(var z in j){if(j.hasOwnProperty(z)){var y=j[z];for(var x in y){if(y.hasOwnProperty(x)){o(y[x]);if(!y[x]){break}}}}}}};var o=this.abortItem=function(x){if(!k(x)){return false}if(x.FSIIMGLoadingEngineData.bAborted){return true}x.FSIIMGLoadingEngineData.bAborted=true;if(x.FSIIMGLoadingEngineData.bLoaded){t(x)}return true};this.abortPurpose=function(y){if(n<1){return false}if(typeof(j[y])!=="object"||j[y].__count<1){return false}for(var x in j[y]){if(j[y].hasOwnProperty(x)){o(j[y][x]);if(!j[y]){break}}}return true};var f=function(x){var y=this.FSIIMGLoadingEngineData;y.bError=true;r.apply(this,[x])};var r=function(x){var y=this;a.removeEvent(y,"load",r);a.removeEvent(y,"error",f);var z=y.FSIIMGLoadingEngineData;z.bLoading=false;z.bLoaded=true;if(!z.bError&&!z.bAborted){z.bSuccess=true}t(y);if(!z.bAborted&&z.fnLoad){z.fnLoad.apply(y,[x,z])}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderCSSSkin!==b){return}a.LoaderCSSSkin=function(){var e=this;var i=0;var g={};var c=0;var d=new a.CORSLoader();var h=function(m,l,u,k,s){var r=this;var t;var A=[];var n;var x=0;var q=false;var p=false;this.uniqueID=c++;this.bReleased=false;this.getSkinName=function(){return l.getSkinName()};this.callReady=function(C,D,F,E){if(this.bReleased){return}if(E){p=true}n=arguments;q=true;o()};var o=function(){if(!q||x>0){return}if(p){t=setTimeout(y,1)}else{y()}};var y=function(){j();u.apply(k,n)};var j=function(){if(t!==b){clearTimeout(t);t=b}};this.remove=function(){j();if(r.bReleased){return}l.removeWaiter(r.uniqueID);for(var C=0;C<A.length;C++){A[C].remove()}this.bReleased=true};var B=function(C,D,F,E){if(E){p=true}x--;o()};if(s&&typeof(s)=="object"&&s.length>0){for(var v=0;v<s.length;v++){var w=s[v];x++;var z=a.utils.loadSkinCSS(w.file,r,B,w.nPriority);A.push(z)}}};var f=function(j,v){var s=false;var k=0;var u={};var p=false;var q=false;var r;var o;var l;var n;l=j.match(/(.*)\/[^/]*$/);l=l[1]+"/";l=l.replace(/\/resources\/$/,"/");o=j.replace(/\.[^/]*$/,"");o=o.match(/([^/]*)$/);o=o[1].toLowerCase();this.removeWaiter=function(w){if(u[w]===b){return}delete u[w];k--};this.addWaiter=function(w){if(w.uniqueID===b||w.bReleased){return}if(p){w.callReady(q,n,"ALREADY LOADED",false)}else{if(u[w.uniqueID]===b){u[w.uniqueID]=w;k++;if(!s){t()}}}};this.getSkinName=function(){return o};var m=function(G,z,H,B){var E=false;if(B>299||typeof(z)!="string"){a.console.error("Failed to load Skin CSS (HTTP "+B+"): "+j)}else{E=true;z=z.replace(/\[fsi-skin-path]/g,l);r=document.createElement("style");r.setAttribute("type","text/css");r.setAttribute("data-generated-by","FSI");r.setAttribute("data-fsi-skin",o);r.setAttribute("data-fsi-priority",v);r.appendChild(document.createTextNode(z));var D=document.head;if(!D){D=document.getElementsByTagName("head");if(D&&D.length>0){D=D[0]}}if(D&&D.firstChild){try{var y;var I=D.getElementsByTagName("style");for(var A=0;A<I.length;A++){var F=I[A];var x=parseInt(F.getAttribute("data-fsi-priority"));if(isNaN(x)||x>v){y=F;break}}if(y){D.insertBefore(r,y)}else{D.appendChild(r)}}catch(C){D.appendChild(r)}}else{D.appendChild(r)}n=r.sheet;q=E}p=true;for(var w in u){if(u.hasOwnProperty(w)){u[w].callReady(q,n,"onLoaded",true)}}u={};k=0};var t=function(){s=true;if(typeof(j)!="string"||j.length<0){return false}d.load(j,m,"text/css");return true}};this.load=function(o,p,l,q,k){if(q===b){q=100}var n=false;if(a.versionInternetExplorer<9){n=true}if(n){a.console.error("Unable to load skin: unsupported browser version.");if(l){l.call(p,false)}return false}if(!a.getViewerLocation()||typeof(o)!="string"||o.length<1){a.console.error("Unable to load skin:");if(!a.getViewerLocation()){a.console.error("FSI Viewer path not known")}else{a.console.error("Invalid skin URL "+o)}if(l){l.call(p,false)}return false}var j=o;if(j.indexOf("http")!==0){j=a.getViewerLocation()+"/skins/"+j}if(!j.match(/\.css$/)){j+=".css"}var r;if(g[j]===b){i++;r=g[j]=new f(j,q)}else{r=g[j]}var m=new h(j,r,l,p,k);r.addWaiter(m);return m}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.LoaderJavascript!==b){return}a.LoaderJavascript=function(){var e={};this.load=function(h,l,n,j,m){var k=e[h];if(n===b){n=window}if(typeof(j)!="function"){return false}if(k===b){k=e[h]={};k.path=h;k.loaded=false;k.failed=false;f(k);if(!g(k)){k.failed=true;k.loaded=true;k.addNodeFailed=true}}else{if(k.oListeners[l]!==b){d(h,l)}}k.nListeners++;var i=k.oListeners[l]={};i.argScope=n;i.argFunction=j;i.oPassThrough=m;if(k.loaded===true){c(k)}return true};var d=this.release=function(h,j){var i=e[h];if(i===b){return}if(i.oListeners[j]!==b){delete i.oListeners[j];i.nListeners--}};var g=function(l){var h=false;try{var i=document.getElementsByTagName("head");if(i&&i.length>0){i=i[0];var j=l.node=document.createElement("script");var k=l.onLoad=function(n){if(n.type==="error"){l.failed=true;c(l)}else{l.failed=false;c(l)}l.loaded=true};a.addEvent(j,"load",k);l.onError=function(){l.failed=true;c(l);l.loaded=true};a.addEvent(j,"error",k);i.appendChild(j);j.src=l.path;h=true}}catch(m){}return h};var c=function(j){var h=!j.failed;a.removeEvent(j.node,j.onLoad);a.removeEvent(j.node,j.onError);for(var k in j.oListeners){if(j.oListeners.hasOwnProperty(k)){var i=j.oListeners[k];i.argFunction.call(i.argScope,h,j.path,i.oPassThrough)}}f(j)};var f=function(h){h.oListeners={};h.nListeners=0}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.AboutWindow!==b){return}a.AboutWindow=function(d,k){var m=this;var e;var g;var h;var f;var i;var l=function(){e=document.createElement("div");a.utils.setStyleAttr(e,"position: absolute;z-index:1000;width:12em;");e.className="fsi-ui-info-window";h=document.createElement("div");h.className="fsi-ui-title";f=document.createElement("div");f.style.display="inline-block";f.innerHTML=k.title;h.appendChild(f);i=document.createElement("div");i.style.display="inline-block";i.style["float"]="right";i.style.cursor="pointer";i.innerHTML="X";h.appendChild(i);e.appendChild(h);g=document.createElement("div");g.className="fsi-ui-content";var o=k.strLongVersion;o="<h3>"+o.replace(/ build/,'</h3><span class="small">build')+"</span>";var n;if(k.strCopyright===b){n="<br/><br/>&copy; 2019 NeptuneLabs GmbH<br/>";n+='<hr/><a style="color:inherit;text-decoration:none" href="//www.neptunelabs.com/" target="_blank">www.neptunelabs.com</a><br/><br/><span class="small">FSI Viewer &reg; is a registered trademark of NeptuneLabs GmbH, Germany<br/></span>'}else{k.strCopy=k.strCopyright}o+="<br/>"+n;g.innerHTML=o;e.appendChild(g);d.appendChild(e);a.addEvent(e,"click",j);c()};var c=function(){var o=a.getElementPosition(d);o.width=(o.right-o.left);o.height=(o.bottom-o.top);var n=a.getElementPosition(e);n.width=(n.right-n.left);n.height=(n.bottom-n.top);e.style.left=Math.round((o.width-n.width)/2)+"px";e.style.top=Math.round((o.height-n.height)/2)+"px"};var j=this.destroy=function(){if(typeof(k.fnOnDestroy)=="function"){if(!k.fnOnDestroy.call(this)){return}}a.removeEvent(e,"click",j);a.removeChild(e.parentNode,e)};l()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!==c){if(q){j()}else{i()}}};var m=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){g=q;k(q);p=true}else{p=false}return p};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){if(!f){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l===20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l===40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l===50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!==b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!==b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!==b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!==d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!==b){return}w=setTimeout(K,N);K()};var K=function(){if(w!==b){clearTimeout(w);w=b}var e=false;var U=L();if(C!==U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!==b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!==b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u===b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!==b){if(U===b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length===0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIMouseWheel")){return}a.utils.registerCustomEvent("FSIMouseWheel",function(){var c=this;var f=100000;var g;a.utils.CustomEventListener.prototype.constructor.call(c,"FSIMouseWheel");c._strClassName="$FSI.CustomEventListenerMouseWheel";this._onListenerAdd=function(h){h.callback=function(i){d(h,i)};a.addEvent(h.element,"mousewheel",h.callback);a.addEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerRemove=function(h){a.removeEvent(h.element,"mousewheel",h.callback);a.removeEvent(h.element,"DOMMouseScroll",h.callback)};this._onListenerCountChange=function(h){if(h<1){if(g!==b){clearInterval(g);g=b}}};this.setListenerProps=function(k,i,j){if(typeof(i)!=="string"){return false}var h=c.getListenerObjectByID(k);if(!h){return false}switch(i){case"acceleration":if(j){h.bAccelerate=true;h.acceleration=j;h._accelerate=1;if(h._accelerateMax===b){h._accelerateMax=10}}break;case"accelerationMax":h._accelerateMax=j;break}};var e=function(){var j=c.getListenersArray();var k=true;for(var l=0;l<j.length;l++){var h=j[l];if(h.bAccelerate&&h._accelerate>1){h._accelerate/=1.5*h.acceleration;if(h._accelerate>1.5){k=false}else{k=true;h._accelerate=1}}}if(k){clearInterval(g);g=b}};var d=function(h,i){var k=0;if(i.detail){k=i.detail}else{if(i.wheelDelta){k=-i.wheelDelta}}if(k!==0){i.FSI_normalized_delta=(k>0)?-1:1;f=Math.min(f,Math.abs(k))}else{i.FSI_normalized_delta=0}if(h.bAccelerate){if(g===b){g=setInterval(e,200)}h._accelerate*=h.acceleration;h._accelerate=Math.min(h._accelerateMax,h._accelerate);k=Math.round(h._accelerate*k)}else{h._accelerate=1}i.FSI_delta=-k;i.FSI_weighted_delta=i.FSI_delta/f;i.FSI_normalized_accelerated_delta=(k>0)?-h._accelerate:h._accelerate;var j=c.fireEvent(h,i);if(j===false){h._accelerate=1}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.NavigatorWindow!==b){return}a.NavigatorWindow=function(q,A,w,I){var i=this;var ah=q.iViewer;var t;var ac=0;var m;var p,C;var g;var E,r;var h,f;var u=false;var x=false;var L=q.getElementSpace();var M=q.getinPlaceZoom();var V=q.getDrawRatio();var s=ah.getSrcDim();var af=q.getdrawRatioUnZoomed();var F=q.getdrawRatioUnResized();var X=q.viewport;var H;var W;var c={x:2,y:2};var d;var ag;var N=false;var Z;var P;var ae={};var G;var B=false;var z;var J;var v=true;var e=true;var o;var S;var aa;var ab=function(){S=a.utils.getNumberSeperators(q.iConfig);u=A.result.autoHideNav;m=[];ac=4;g=16;o=A.makeBool(A.cfg.autohidenaviftoosmall,true);var al=l(A.result.navWidth,X.width,120);var ar=l(A.result.navHeight,X.height,120);var ao=Math.min(L.width-2*ac,al);var ap=Math.min(L.height-2*ac-20,ar);ao=Math.max(60,ao);ap=Math.max(40,ap);var an,aj;an=ao;aj=an/af.imageWidth*af.imageHeight;if(aj>ap){aj=ap;an=aj/af.imageHeight*af.imageWidth}p=Math.max(10,Math.round(an));C=Math.max(10,Math.round(aj));var aq=p+2*ac;var am=C+2*ac+g;E=aq;r=am;i.sprite=new a.Sprite(I,aq,am,500);a.addClass(i.sprite.element,"fsi-ui-nav-window");i.sprite.element.style.width=i.sprite.element.style.height="auto";if(w){d=w.navFrameBorderColor;ag=w.navFrameBackgroundColor}else{d="red";ag="rgba(255,255,255,0.5)"}i.canvasSprite=new a.Sprite(i.sprite.element,p,C,2,true,"inline");i.canvasSprite.element.style.clear="both";a.addClass(i.canvasSprite.element,"fsi-ui-nav-window-image");if(A.hasPlugin("zoommeter")){H=document.createElement("div");a.addClass(H,"fsi-ui-nav-window-zoom-text");i.sprite.element.appendChild(H);W=document.createTextNode("100 %");H.appendChild(W);var ak=A.getPluginParameter("zoommeter","color");if(ak){H.style.color="#"+ak}aa=parseInt(A.getPluginParameter("zoommeter","decimals"));if(isNaN(aa)||aa<0){aa=1}N=A.getPluginParameter("zoommeter","srcrelative",false,true)}i.sprite.updateMargins();i.sprite.updateDimension();var ai={};ai.smoothing={enabled:true,factor:7,fEndDiff:0.03};z=new a.TouchHandler(i.canvasSprite.canvas,ai,R,Y,U);P=i.canvasSprite.ctx;K();n();if(u){Q(false,false)}};this.destroy=function(){if(j!==b){j=clearTimeout(j)}if(z){z.destroy();z=b}a.removeChild(I,i.sprite.element)};this.enable=function(ai,aj){z.enable(ai);if(i.sprite&&i.sprite.element){if(aj){i.sprite.element.style.visibility="hidden"}else{i.sprite.element.style.visibility=""}}};var l=function(al,aj,ak){var ai=parseInt(al);if(typeof(al)=="string"&&al.indexOf("%")!==-1){ai=Math.max(0,Math.min(100,ai));ai=Math.round(ai*aj/100)}else{ai=parseInt(al)}if(isNaN(ai)){ai=ak}return ai};this.isDragging=function(){return x};var R=function(aj,am){q.onUserAction();q.stopAutoSpin();var ak=a.getElementPosition(i.canvasSprite.element);h=-ak.left;f=-ak.top;var ai=am.x+h;var al=am.y+f;if(ai<0||al<0||ai>p||al>C){return false}x=true;q.stopDesktopAnimation();q.stopAfterTouch();y(am,true);q.autoShowHideHotSpots(false);q.iCallbacks.run("onStartDragging",[true]);return true};var Y=function(ai,aj){y(aj,true)};var U=function(ai,aj){q.onUserAction();x=false;y(aj,false);q.onAfterinPlaceZoomChanged();q.autoShowHideHotSpots(true);q.iCallbacks.run("onStopDragging",[true])};var y=function(al,aj){var ai=al.x+h-p/2;var ak=al.y+f-C/2;M.panPos.left=J*-ai;M.panPos.top=J*-ak;q.updateInPlaceZoom(aj)};var O=function(aq,az,ar,ax,at){var ao,am,al,ak,ap,ay,aw;ay=az;aw=ar;az=Math.max(1,Math.round(az/2));if(az<ax){az=ax}ar=Math.max(1,Math.round(ar/2));if(ar<at){ar=at}am=ak=document.createElement("canvas");ak.setAttribute("crossorigin","anonymous");ak.width=az;ak.height=ar;ap=ak.getContext("2d");ap.drawImage(aq,0,0,ay,aw,0,0,az,ar);var aj=document.createElement("canvas");aj.setAttribute("crossorigin","anonymous");var an=aj.getContext("2d");var ai=false;while(az>ax||ar>at){ao=am;ay=az;aw=ar;if(ai){am=ak;al=ap;ai=false}else{am=aj;al=an;ai=true}az=Math.round(az/2);if(az<ax){az=ax}ar=Math.round(ar/2);if(ar<at){ar=at}am.width=az;am.height=ar;al.drawImage(ao,0,0,ay,aw,0,0,az,ar)}var av;try{av=al.getImageData(0,0,az,ar);Z=D}catch(au){av=am;Z=k}return av};var D=function(aj,ai,ak){P.putImageData(aj,ai,ak)};var k=function(aj,ai,ak){P.drawImage(aj,ai,ak)};var K=function(){switch(c.x){case 2:i.sprite.element.style.left="auto";i.sprite.element.style.right=i.sprite.margin.right+"px";break;default:i.sprite.element.style.right="auto";i.sprite.element.style.left=i.sprite.margin.left+"px";break}switch(c.y){case 2:i.sprite.element.style.top="auto";i.sprite.element.style.bottom=i.sprite.margin.bottom+ah.getMenuHeight("navWindow")+"px";break;default:i.sprite.element.style.bottom="auto";i.sprite.element.style.top=i.sprite.margin.top+"px";break}};this.setContainerSize=function(ai,al,ak){var aj=i.sprite.element.style.display;i.sprite.element.style.display="block";i.sprite.updateDimension();V=al;af=ak;L=ai;i.sprite.element.style.display=aj;n()};var Q=function(ai,aj){if(ai===b){ai=(!B&&v)}if(e===ai){return}e=ai;i.sprite.show(ai,aj)};var n=function(){if(!o){return}B=(L.width<4*i.sprite.width()||L.height<4*i.sprite.height());Q(b,false)};var ad=this.autoShowHide=function(ai){if(!u){return}if(v!==(M.scale>1.05)){v=!v;Q(b,ai)}};this.setPreviewImageSize=function(ai,aj){if(ai===b){G=b}else{ae.width=ai;ae.height=aj;G=ae}};var j;var T=function(){j=b;var ai;if(N){ai=t*F.imageWidth/s.width}else{ai=V.imageWidth/af.imageWidth}W.nodeValue=a.utils.makeNiceNumber(100*ai,aa,S)+" %"};this.update=function(aA,am){ad(true);if(!i.sprite.isVisible()){return}J=V.imageWidth/p;var ar=P;if(m[aA]===b){var av=q.getPreviewImage(aA);var aw=(G)?G:av;m[aA]=O(av,aw.width,aw.height,p,C)}ar.lineWidth=0;var ao=0;var an=0;if(H&&t!==am){t=am;if(j===b){j=setTimeout(T,50)}}Z(m[aA],ao,an);var az=M.scale;if(az>1.05){var aq=p/F.imageWidth/az;var ak=aq*X.width;var at=aq*X.height;var ax=p/V.imageWidth;var ap=(p-ak)/2-M.panPos.left*ax;var ay=(C-at)/2-M.panPos.top*ax;var aj=ao+ap;var ai=an+ay;var al=ao;var au=an;if(ak<4||at<4){aj+=ak/2;ai+=at/2;ar.strokeStyle=d;ar.strokeRect(aj,ai-3,1,7);ar.strokeRect(aj-3,ai,7,1)}else{ar.save();ar.fillStyle=ag;ar.beginPath();ar.rect(al,au,p,ai-au);ar.rect(al,ai,aj-al,at);ar.rect(aj+ak,ai,p-ap-ak,at);ar.rect(al,ai+at,p,C-ay-at);ar.closePath();ar.clip();ar.fillRect(ao,an,p,C);ar.restore();ar.save();ar.strokeStyle=d;ar.beginPath();ar.rect(ao,an,p,C);ar.clip();ar.strokeRect(aj,ai,ak,at);ar.restore()}}};this.reverseImageSequence=function(){m.reverse();m.unshift(m.pop())};ab()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MenuBar!==b){return}a.MenuBar=function(k,s,A,J,r){var i=this;var M=this.myViewer=k.iViewer;var B=k.getElementSpace();var h;var x;var u=0;var D=[];var m=b;if(r===b){r={}}this.bEnabled=b;var C={};var n={};var L={};var g=0;var j=0;var z="fsi-ui-button-icon";var q;var E;var o=1;var y=[];var d;var v,K;var p=this.setInterface=function(){v=k.getDebug();K=k.getToolTip()};var G=function(){i.oInterface=k;var N=k.iConfig;E=N.makeBool(N.cfg.menubuttontooltips,true,true);p(k);i.btnID=0;i.sprite=new a.Sprite(A,B.width,g,450,b,b,"fsi-ui-menu-bar");i.sprite.element.style.width="100%";i.sprite.element.style.top="auto";i.sprite.element.style.left="0px";i.sprite.element.style.right="auto";i.sprite.element.style.lineHeight="100%";i.sprite.element.style.bottom="0px";i.sprite.element.style.visibility="hidden";i.iconClassNamesNormal=z;m=setTimeout(f,0)};this.getContainer=function(){return A};this.getSprite=function(){return i.sprite.element};this.groupButtons=function(N){var Q;var O=[];for(Q=0;Q<N.length;Q++){var P=i.getButtonByCMD(N[Q]);if(P&&P.elButton){O.push(P.elButton)}}if(O.length>0){var S=document.createElement("span");S.className="fsi-ui-button-group-container";var R=O[0].parentNode;R.replaceChild(S,O[0]);for(Q=0;Q<N.length;Q++){S.appendChild(O[Q])}y.push(S)}};var f=function(){if(i.sprite.element.offsetHeight!==0||u++>200){m=b;l()}else{m=setTimeout(f,25)}};this.getButtonContainerWidth=function(){return x.element.offsetWidth};this.addButtonCSSClass=function(N,O){F(N,O,true)};this.removeButtonCSSClass=function(N,O){F(N,O,false)};var F=function(P,Q,O){var N=n[P];if(N===b){return}if(O){a.addClass(N.elButton,Q)}else{a.removeClass(N.elButton,Q)}i.setExternalButtonState(P,N.getState(),N.elButton.className)};this.getExternalButtonID=function(){return o++};var l=function(){var O=i.sprite.getClientDim();g=Math.round(O.height);i.sprite.setSize("100%",g);i.setEnabled(false);if(typeof(s.urlLogo)==="string"&&s.urlLogo.length>0&&s.urlLogo!=="none"){h=document.createElement("div");a.addClass(h,"fsi-ui-logo");a.utils.setStyleAttr(h,"position:absolute;display:none");var N=document.createElement("img");N.className="fsi-ui-logo-image";N.style.backgroundImage="none";N.src=s.urlLogo;h.appendChild(N);a.addEvent(N,"load",w);i.sprite.element.appendChild(h);a.addEvent(h,"click",M.showAboutWindow)}a.addEvent(i.sprite.element,"mouseup",e);a.addEvent(i.sprite.element,"contextmenu",H);i.sprite.element.style.visibility="";J()};this.show=function(N){if(d===N){return}d=N;i.sprite.show(N,false)};this.getVisible=function(){return d};this.destroy=function(){t("onMenuDestroy");if(m!==b){clearTimeout(m);m=b}if(h){a.removeEvent(h,"click",M.showAboutWindow)}a.removeEvent(i.sprite.element,"mouseup",e);a.removeEvent(i.sprite.element,"contextmenu",H);i.removeButtons();i.removeDomElement()};this.removeDomElement=function(){if(i.sprite.element.parentNode){a.removeChild(i.sprite.element.parentNode,i.sprite.element);g=0}};var e=function(N){if(N.which&&N.which===3){j=new Date().getTime()}};var H=function(O){if(j){var N=new Date().getTime()-j;if(N<300){return}}O.preventDefault&&O.preventDefault()};this.getHeight=function(){return g};this.pressButton=function(O){var N=n[O];if(N!==b){N.onMouseDown()}};this.releaseButton=function(O){var N=n[O];if(N!==b){N.onMouseUp()}};var c=function(N,P){var Q=b;if(!N||!P){return Q}if(N.indexOf("_")!==-1){var O=N.split("_");switch(O[0]){case"MouseMode":Q="";if(P.Mode){Q+="<b>"+P.Mode+"</b>"}if(P["Mode"+O[1]]){Q+=" "+P["Mode"+O[1]]}break}}return Q};this.showButtonToolTip=function(O,P){var N;if(P){N=P.getAttribute("fsi-tool-tip");if(k.iConfig.makeBool(N,true)===false){return}}if(!N){N=O.getCMD()}if(typeof(r[N])==="string"){N=r[N]}i.showToolTip(N,P)};this.getButtonDomElement=function(O){var N=n[O];if(N){return N.elButton}};this.showToolTip=function(P,O,N,Q){if(!K||!E){return}K.show(P,O,N,Q,c)};this.hideToolTip=function(){if(!K||!E){return}K.hide()};this.setEnabled=function(N,O){if(i.bEnabled===N){return}i.bEnabled=N;if(O){return}if(N){a.removeClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}else{a.addClass(i.sprite.element,"fsi-ui-menu-bar-disabled")}t("onMenuEnabled",[N])};this.getButtonEnabled=function(O){var N=n[O];if(N===b){return}return N.bEnabled};this.showButton=function(P,N){var O=n[P];if(O===b){return false}return O.show(N)};this.enableButton=function(P,N){var O=n[P];if(O===b){return false}return O.setEnabled(N)};this.getButtonPressed=function(O){var N=n[O];if(N===b){return false}return N.getPressed()};this.setButtonPressed=function(P,N){var O=n[P];if(O===b){return false}O.setPressed(N);return true};var I=function(O,P){var N;if(C[P]===b){N=C[P]={};N.arButtons=[]}else{N=C[P]}N.arButtons.push(O);O.oGroup=N;O.makeRadioButton()};this.removeButtons=function(){var N;i.unregisterExternalButtons();for(N=0;N<D.length;N++){D[N].destroy()}for(N=0;N<y.length;N++){if(y[N]&&y[N].parentNode){y[N].parentNode.removeChild(y[N])}}D=[];C={};n={}};this.unregisterExternalButtons=function(){for(var P in L){if(L.hasOwnProperty(P)){var N=L[P];for(var O=0;O<N.length;O++){N[O].destroy(true)}}}L={}};this.addButtons=function(Y,ac){i.removeButtons();var Q;var Z=g-6;var S,ad;var R,aa,T;var O="";if(typeof(ac)==="string"&&ac.length>0){O=" (sorted by parameter MenuButtonOrder)";var N=ac.split(",");var W={};for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){W[Y[aa].cmd.toLowerCase()]=aa}}var V=[];var ab={};for(aa=0;aa<N.length;aa++){T=a.trim(N[aa].toLowerCase());if(W[T]!==b){if(ab[T]===b){ab[T]=true;V.push(Y[W[T]])}}}for(aa=0;aa<Y.length;aa++){if(typeof(Y[aa].cmd)==="string"){T=Y[aa].cmd.toLowerCase();if(!ab[T]){V.push(Y[aa])}}}Y=V}else{O=" (default)"}if(!x){x=new a.Sprite(i.sprite.element,B.width,g,2);a.utils.setStyleAttr(x.element,"position:relative");a.addClass(x.element,"fsi-ui-button-container")}var ae;if(v.on){ae=[]}for(aa=0;aa<Y.length;aa++){Q=Y[aa];if(Q.cmd){if(v.on){ae.push(Q.cmd)}if(Q.width===b){S=Z}else{S=Q.width}if(Q.height===b){ad=Z}else{ad=Q.height}R=new a.MenuBarButton(i,x.element,Q,Q.bCheckButton);n[Q.cmd]=R;D.push(R);if(Q.groupID!==b){I(R,Q.groupID)}}if(typeof(Q.fnCreate)==="function"){Q.fnCreate.apply(Q.fnCreateInstance,[R,Q])}if(Q.enabled===false){i.enableButton(Q.cmd,false)}}if(v.on){v.log("Button sequence"+O+": "+ae.join(","))}w();var P=q.run("onRegisterExternalMenuButtons");if(P){i.registerExternalButtonsFromContainer(P)}var U=k.iConfig;if(typeof(U.cfg.externalbuttoncontainer)!=="undefined"){i.registerExternalButtonsFromContainer(U.cfg.externalbuttoncontainer)}t("onMenuReady",[i]);for(var X in C){if(C.hasOwnProperty(X)){C[X].arButtons[0].setPressed(true)}}};this.createHiddenButton=function(O,Q){if(n[O]!==b){return n[O]}var N={cmd:O,bCheckButton:Q};var P=new a.MenuBarButton(i,b,N,N.bCheckButton);P.bUserButton=true;n[N.cmd]=P;D.push(P);return P};this.setCallbacks=function(N){q=N};var t=this.callListeners=function(O,N){if(q){q.run(O,N)}};this.setContainerSize=function(N){var O=i.sprite.element.style.display;i.sprite.element.style.display="block";var P=a.getElementClientDim(i.sprite.element);g=P.height;if(P.width===0&&P.height===0){return}i.sprite.updateDimension();B=N;i.sprite.setSize("100%",g);i.sprite.element.style.display=O;w();if(d){i.sprite.show(true)}};var w=function(){if(!h){return}h.style.display="";if(h.firstChild!==b&&h.firstChild.offsetWidth>0&&x!==b){var N=(i.sprite.element.offsetWidth-x.element.offsetWidth)/2;if(N-8<h.firstChild.offsetWidth){h.style.display="none"}}};this.setPressedExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setPressed(O)}}};this.enableExternalButtons=function(Q,O){if(L[Q]!==b){var N=L[Q];for(var P=0;P<N.length;P++){N[P].setEnabled(O)}}};this.setExternalButtonState=function(Q,P,R){if(L[Q]!==b){var N=L[Q];for(var O=0;O<N.length;O++){N[O].setState(P,R)}}};this.removeExternalButton=function(P,Q){var N=L[P];if(N!==b){for(var O=0;O<N.length;O++){if(N[O].nExternalButtonID===Q){N.splice(O,1)}}}};M.getMenuButtonPresent=function(O){var N=i.getButtonByCMD(O);return(N!==b&&N.bUserButton!==true)};M.registerExternalMenuButtonsFromContainer=this.registerExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Registering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.registerExternalButton(Q[O],R)}}}v.groupEnd()};M.unregisterExternalMenuButtonsFromContainer=this.unregisterExternalButtonsFromContainer=function(S){if(typeof(S)==="string"){S=document.getElementById(S)}v.groupCollapsed("Unregistering external buttons from container: ");v.log(S);if(S&&typeof(S.querySelectorAll)==="function"){var Q=S.querySelectorAll("[fsi-cmd],[fsi-tool-tip]");for(var O=0;O<Q.length;O++){var P=Q[O];var R=P.getAttribute("fsi-cmd");var N=P.getAttribute("fsi-tool-tip");if((R&&R.length>0)||N&&N.length>0){i.unregisterExternalButton(Q[O],R)}}}v.groupEnd()};M.registerExternalMenuButton=this.registerExternalButton=function(N,Q){var O=Q;if(typeof(O)!=="string"||O.length<1){O="user_tool_tip_only"}if(typeof(N)==="string"){N=document.getElementById(N)}if(!N||N.style===b){return false}if(N.FSIExternalButton!==b){if(v.on){v.error("The dom element has already been registered as external button for command '"+N.FSIExternalButton.getCMD()+"'.")}return false}var P=new a.MenuBarExternalButton(i,k,N,O);if(!P.init()){v.error("The dom element could not be registered as external button for command '"+O+"'.",N);P.destroy();return false}if(P.bUserButton){v.log("Registering external button for user command: "+O,N)}else{v.log("Registering external button for command: "+O,N)}N.FSIExternalButton=P;if(L[O]===b){L[O]=[]}L[O].push(P);if(q.isset("onAfterRegisterExternalButton")){q.run("onAfterRegisterExternalButton",[N,Q,(P.bUserButton!==true)])}};M.unregisterExternalMenuButton=this.unregisterExternalButton=function(O){if(typeof(O)==="string"){O=document.getElementById(O)}if(!O||O.style===b||typeof(O.FSIExternalButton)!=="object"||typeof(O.FSIExternalButton.destroy)!=="function"){return false}var N=O.FSIExternalButton;if(v.on){v.log("Unregistering external button for command: "+N.getCMD(),O)}O.FSIExternalButton.destroy();O.FSIExternalButton=b;return true};this.getButtonByCMD=function(N){return n[N]};G()};a.MenuBarExternalButton=function(i,e,c,g){var k=this;var h=i;var f="";var j;var d;this.init=function(){if(c.style===b){return false}k.nExternalButtonID=i.getExternalButtonID();d=i.getButtonByCMD(g);if(d===b){d=h.createHiddenButton(g,e.iConfig.makeBool(c.getAttribute("fsi-check-button")))}if(d===b){return false}k.bUserButton=d.bUserButton;f=a.trim(c.className);if(f.length>0){f+=" "}d.addEvents(c);k.setState(d.getState(),d.getCSSClass());k.setEnabled(d.getEnabled());k.setPressed(d.getIsPressed());c.setAttribute("data-fsi-registered","true");return true};this.getCMD=function(){return g};this.setPressed=function(l){if(l){c.setAttribute("checked","checked")}else{c.removeAttribute("checked")}};this.setEnabled=function(l){if(l){c.removeAttribute("disabled");a.removeClass(c,"fsi-ui-button-disabled")}else{c.setAttribute("disabled","disabled");a.addClass(c,"fsi-ui-button-disabled")}};this.setState=function(l,m){j=l;c.className=f+m};this.destroy=function(l){if(c.FSIExternalButton){d.removeEvents(c);c.FSIExternalButton=b;c.removeAttribute("data-fsi-registered");if(d){c.className=a.trim(f)}if(!l){h.removeExternalButton(g,k.nExternalButtonID)}}}};a.MenuBarButton=function(u,f,i,h){var q=this;var v=i.cmd;var k=u;var C;this.bEnabled=true;this.id=k.btnID++;var m=false;var B;var c;var l="";var e=true;var d;var y;var x="";var A,r;var g;var j={passive:false,capture:false};var w=function(){B=q.elButton=document.createElement("div");a.addClass(B,"fsi-ui-button");c=document.createElement("div");a.addClass(c,k.iconClassNamesNormal);B.appendChild(c);if(f){f.appendChild(B)}if(v.length>0){l=v.replace(/#.*$/,"")}else{l=""}if(i.cssClass){if(l.length>0){l+=" "}l+=i.cssClass}B.className="fsi-ui-button "+l;if(!i.bNoMouseEvents){q.addEvents(B)}s(1)};var t=function(D){D.cancelBubble=true;if(D.stopPropagation){D.stopPropagation()}if(D.preventDefault){D.preventDefault()}return false};this.addEvents=function(D){a.addEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.addEvent(D,"mousedown",q.onMouseDown,j);a.addEvent(D,"mouseleave",q.onMouseOut,j);a.addEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.addEvent(D,"touchstart",q.onTouchDown,j);a.addEvent(D,"touchcancel",q.onTouchUp,j);a.addEvent(D,"touchend",q.onTouchUp,j)}};this.removeEvents=function(D){a.removeEvent(D,"contextmenu",t,j);if(!a.isMobileDevice){a.removeEvent(D,"mousedown",q.onMouseDown,j);a.removeEvent(D,"mouseleave",q.onMouseOut,j);a.removeEvent(D,"mouseenter",q.onMouseOver,j)}if(a.isTouch){a.removeEvent(D,"touchstart",q.onTouchDown,j);a.removeEvent(D,"touchcancel",q.onTouchUp,j);a.removeEvent(D,"touchend",q.onTouchUp,j)}};this.destroy=function(){if(!i.bNoMouseEvents){q.removeEvents(B)}if(B&&B.parentNode){a.removeChild(B.parentNode,B)}};this.getCMD=function(){return v};this.makeCheckButton=function(){h=true};this.makeRadioButton=function(){h=true;m=true};this.getState=function(){return C};this.getCSSClass=function(){return B.className};var s=this.setState=function(E){if(C===E){return}if(h){var D=(E>2);if(D!==y){y=D;z("onMenuButtonSetPressed",null,D)}}o(E)};var o=this.setState=function(F){if(F===C){return}C=F;var G="";if(!q.bEnabled){G="fsi-ui-button-disabled "}switch(C){case 2:G+="fsi-ui-button-hover";break;case 3:G+="fsi-ui-button-active";break;case 4:G+="fsi-ui-button-active";if(q.oGroup!==b){for(var E=0;E<q.oGroup.arButtons.length;E++){var D=q.oGroup.arButtons[E];if(D.id!==q.id){D.setPressed(false)}}}break;default:break}if(G!==x){if(x.length>0){a.removeClass(B,x)}if(G.length>0){a.addClass(B,G)}x=G}k.setExternalButtonState(v,C,B.className)};this.onMouseOver=function(D){A=true;var E=D.target;if(a.hasClass(E,"fsi-ui-button-icon")&&E.parentNode){E=E.parentNode}k.showButtonToolTip(q,E);if(!q.bEnabled||!k.bEnabled){return}if(C===1){s(2)}};this.onMouseOut=function(){A=false;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}if(r){return}if(C!==1&&C!==4){s(1)}};this.onMouseDown=function(D){z("onMenuButtonMouseDown",D);if(D&&D.type==="mousedown"){if(D.preventDefault){D.preventDefault()}if(D.which!==1){return true}}r=true;k.hideToolTip();if(!q.bEnabled||!k.bEnabled){return}a.addEvent(window,"mouseup",q.onMouseUp);g=true;if(h){if(C===4){if(!m){s(3)}}else{s(4)}}else{s(3)}p(D)};this.show=function(D){if(e===D){return}e=D;q.elButton.style.display=(D)?"":"none"};this.onTouchDown=function(D){if(A){q.onMouseOut(D)}if(r){q.onMouseUp(D)}q.onMouseDown(D)};this.onTouchUp=function(D){if(A){k.hideToolTip();A=false}q.onMouseUp(D);if(D.preventDefault){D.preventDefault()}};this.onMouseUp=function(E){if(g){a.removeEvent(window,"mouseup",q.onMouseUp);g=false}var F=(E&&E.type==="touchend");if(!F&&!r){return}r=false;if(!q.bEnabled||!k.bEnabled){return}if(!F&&!A&&h&&!m){if(C===4){s(1)}else{s(4)}}var D=(!A)?1:2;if(h){if(C===3){s(D)}}else{s(D)}n(E);if(F||A){u.oInterface.clickMenuButton(v,E);z("onMenuButtonClicked",E)}};this.getEnabled=function(){return q.bEnabled};this.setEnabled=function(D){if(q.bEnabled===D){return}if(!D&&d){n()}if(!D&&(C===1||!h)){q.setState(1)}if(D){a.removeClass(B,"fsi-ui-button-disabled")}else{a.addClass(B,"fsi-ui-button-disabled")}q.bEnabled=D;k.enableExternalButtons(v,D);z("onMenuButtonEnabled",null,D);return true};this.getPressed=function(){return(C>2)};this.getIsPressed=function(){return(h&&q.getPressed())};this.setPressed=function(D){if(!h){return}if(D){s(4)}else{s(1)}k.setPressedExternalButtons(v,D)};var p=function(D){d=true;z("onMenuButtonPressed",D);u.oInterface.pressMenuButton(v,D)};var n=function(D){d=false;z("onMenuButtonReleased",D);u.oInterface.releaseMenuButton(v,D)};var z=function(F,D){var E=[v,D];if(arguments.length>2){E=E.concat(Array.prototype.slice.call(arguments,2))}k.callListeners(F,E)};w()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.PluginMeasure!==b){return}a.PluginMeasure=function(y,q){var p=this;this.name="measure";var J;var h;var l,aa,v;var k,Z,u;var m,x,i;var D;var ad=1;var W;var ae;var ac=0;var t;var O;var V=1;var G;var E=0;var L,K;var e=true;var P,C,Y,j;var w=q.getCallbacks();var I=a.utils.makeNiceNumber;var N;var d={};var T;var R=a.utils.getSVGNameSpaceURL();var ab=function(){var ai=function(al){var am=g(al);if(am){am=a.utils.getCSSColor(am)}return am};N=a.utils.getNumberSeperators(q.iConfig);T=g("showInAllMouseModes",false,true);O=g("showAngle",false,true);j=g("showText",true,true);W=parseFloat(g("imageWidth","100"));if(isNaN(W)){W=100}C=g("prefix","");P=g("suffix","mm");P=" "+P;Y=parseInt(g("decimals","1"));if(isNaN(Y)||Y<0){Y=1}t=q.getRootContainer();J=document.createElement("div");J.setAttribute("style","position:absolute;width:100%;height:100%;overflow:hidden;z-index:101;");J.className="fsi-plugin-measure";h=document.createElementNS(R,"svg");h.setAttribute("style","width:100%;height:100%");h.className.baseVal="fsi-plugin-measure";m=document.createElementNS(R,"g");i=m.cloneNode(false);l=document.createElementNS(R,"line");l.setAttribute("x1",0);l.setAttribute("x2",0);l.setAttribute("y1",-8);l.setAttribute("y2",8);l.setAttribute("class","stroke:rgb(255,0,0);stroke-width:2");l.className.baseVal="fsi-plugin-measure-start-line";i.appendChild(l);aa=l.cloneNode(false);aa.className.baseVal="fsi-plugin-measure-end-line";aa.setAttribute("x1","100");aa.setAttribute("x2","100");i.appendChild(aa);v=l.cloneNode(false);v.className.baseVal="fsi-plugin-measure-main-line";v.setAttribute("x1","0");v.setAttribute("x2","100");v.setAttribute("y1","0");v.setAttribute("y2","0");i.appendChild(v);i.className.baseVal="fsi-plugin-measure-group-back";m.appendChild(i);x=i.cloneNode(true);x.className.baseVal="fsi-plugin-measure-group-front";m.appendChild(x);k=x.childNodes[0];Z=x.childNodes[1];u=x.childNodes[2];h.appendChild(m);J.appendChild(h);if(j){var ag=g("textSize","");var ak=ai("BGColor");var ah=ai("TextColor");var af=ai("TextBorder");var aj=ai("lineColor");D=document.createElement("span");D.className="fsi-plugin-measure-label";J.appendChild(D);if(ag){D.style.fontSize=ag+"px"}if(ak){D.style.background=ak}if(ah){D.style.color=ah}if(af){D.style.borderColor=af}if(aj){k.style.stroke=Z.style.stroke=u.style.stroke=aj}}t.appendChild(J);q.addDrawListener("FSI.PluginMeasure",z);q.registerPointerHandlers(100,F,Q,c);y.addListener("onMouseModeChanged",r);y.addListener("onResize",U);y.addListener("onAfterReady",X);M(false);A()};var g=function(ag,ah,af){return q.iConfig.getPluginParameter("measure",ag,ah,af)};var A=function(af){var ag=q.getdrawRatioUnZoomed();if(!ag||!ag.imageWidth){return}d.imageWidth=ag.imageWidth;d.imageHeight=ag.imageHeight;d.imageX=ag.imageX;d.imageY=ag.imageY;ad=W/ag.imageWidth;if(!af){f(0)}w.run("onMeasureUpdateRatio",[ad,W,ag.imageWidth])};var X=function(){A();var af=g("initial");if(af&&af.length>0){af=a.trim(af);af=af.split(",");if(af.length===4){var ag={};ag.x=parseFloat(af[0])*d.imageWidth+d.imageX;ag.y=parseFloat(af[1])*d.imageHeight+d.imageY;H(ag);ag.x=parseFloat(af[2])*d.imageWidth+d.imageX;ag.y=parseFloat(af[3])*d.imageHeight+d.imageY;s(ag,false);M((T||y.getMouseMode()===100),true)}}};var U=function(af,ah,ai){if(!ai||ac===0){return}var ag=e;var ak=a.utils.cloneObject(d);A(true);var aj=d.imageWidth/ak.imageWidth;d.x1=(ak.x1-ak.imageX)*aj+d.imageX;d.y1=(ak.y1-ak.imageY)*aj+d.imageY;d.x2=(ak.x2-ak.imageX)*aj+d.imageX;d.y2=(ak.y2-ak.imageY)*aj+d.imageY;H({x:d.x1,y:d.y1});s({x:d.x2,y:d.y2},d.bShift);n();if(!ag){M(false)}};var r=function(ag){var af=T;if(ag===100){if(ac!==0){af=true}q.setCursor("crosshair")}M(af,true)};var M=function(af,ag){if(af===e){return}e=af;if(e){J.style.display=""}else{J.style.display="none"}w.run("onMeasureShow",[e]);if(ag&&e){B();n()}};var f=function(af){if(af===ac){return}aa.setAttribute("x1",af);aa.setAttribute("x2",af);Z.setAttribute("x1",af);Z.setAttribute("x2",af);v.setAttribute("x2",af);u.setAttribute("x2",af);if(ac!==af){M(af!==0);ac=af}B()};var B=function(){if(!e){return}var ah=ad*ac/V;var ag=C+I(ah,Y,N)+P;if(O){ag+=", "+I(E,Y,N)+"°"}var af=w.run("onMeasureChange",[ah,E,ag]);if(typeof(af)==="string"){ag=af}d.label=ag;if(j){D.innerText=ag;if(G){n()}}G=b};var H=function(af){d.x1=L=af.x;d.y1=K=af.y};var n=function(){if(!e){return}m.setAttribute("transform","translate("+L+" "+K+") rotate("+E+")");if(!j){return}var am=L;var al=K;var af=E%360;var ao=Math.floor(af/90);var an=D.offsetWidth;var ai=D.offsetHeight;var ak=16;switch(ao){case 0:case 1:am+=ak;al-=ak+ai;break;case 2:case 3:am+=ak;al+=ak;break}var aj=y.getMenuHeight();var ah=t.offsetWidth-an;var ag=t.offsetHeight-aj-ai;if(al>ag){al=ag;if(ao===3){am=L-an-ak}}else{if(al<0){al=0;if(ao===0){am=L-an-ak}}}if(am>ah){am=ah;if(al===0||al===ag){am=Math.max(0,am-an)}}if(am<0){am=0;if(al===0||al===ag){am=Math.min(ah,am+an)}}D.style.left=am+"px";D.style.top=al+"px"};var S=function(af){return{x:af.x-ae.left,y:af.y-ae.top}};var o=function(ah,aj,ag,ai){var af=ag-ah;var ak=ai-aj;if(ak===0){ak=1e-8}if(af===0){af=1e-8}return Math.atan(ak/af)+(-0.5*(ak/Math.abs(ak))-0.5*(ak/Math.abs(ak))*(af/Math.abs(af))+1)*Math.PI};var F=function(af,ah){ae=a.getElementPosition(t);H(S(ah));f(0);n();var ag=ad*ac/V;w.run("onMeasureStart",[ag,E,d.label])};var Q=function(af,ag){s(S(ag),af.shiftKey)};var c=function(){if(w.isset("onMeasureEnd")){var af=[];af.push((d.x1-d.imageX)/d.imageWidth);af.push((d.y1-d.imageY)/d.imageHeight);af.push((d.x2-d.imageX)/d.imageWidth);af.push((d.y2-d.imageY)/d.imageHeight);var ag=ad*ac/V;w.run("onMeasureEnd",[ag,E,d.label,af])}};var s=function(ak,aj){d.x2=ak.x;d.y2=ak.y;d.bShift=aj;var ag=o(L,K,ak.x,ak.y);E=ag*180/Math.PI;if(aj){E=45*Math.round(E/45)}var ai=ak.x-L;var ah=ak.y-K;var af=Math.sqrt(ai*ai+ah*ah);f(af);n()};this.destroy=function(){y.removeListener("onMouseModeChanged",r);y.removeListener("onResize",U);y.removeListener("onAfterReady",X);if(G){clearTimeout(G);G=b}q.unregisterPointerHandlers(100);q.removeDrawListener("FSI.PluginMeasure");t.removeChild(J)};var z=function(ah,ag,af){if(e){if(G===b&&V!==af.scale){G=setTimeout(B,25)}V=af.scale}};ab()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.Viewer!==b){return}a.utils.API.Viewer=function(d,e){var c=this;c.scriptMainFile="FSI.Viewer.js";c.getActiveMenuButtons=function(){if(e.arMenuButtons===b){return b}var f={};for(var g=0;g<e.arMenuButtons.length;g++){var h=e.arMenuButtons[g].cmd;if(h!==b){f[h]=true}}return f};c.oMenuCommands={Reset:1,ZoomOut:1,ZoomIn:1,MouseMode_0:1,MouseMode_1:1,MouseMode_2:1,MouseMode_100:1,MaxZoom:1,HotSpots:"Hotspots",ToggleAutoSpin:"autospin-button-toggle",ToggleFullScreen:"FullScreen"};c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeImage:{a:"oParameters, strViewString",r:"bSuccess"},clickMenuButton:{a:"strButtonID"},debugEnabled:{r:"bEnabled"},debugError:{a:"mixed"},debugLog:{a:"mixed"},debugWarn:{a:"mixed"},destroy:{},dumpListeners:{},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getHotspotViewString:{a:"nHotspotID",r:"strViewString"},getImageIsTransparent:{r:"bTransparent"},getInFullScreenMode:{r:"bFullScreen"},getInitDone:{r:"bInitDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getMenuButtonPresent:{a:"strButtonID",r:"bPresent"},getMenuHeight:{a:"strPurpose",r:"nHeight"},getMouseMode:{r:"nMouseMode"},getParameters:{r:"oParameters"},getPluginParameter:{a:"strPluginName, strParameterName, defaultValue, bMakeBoolean",r:"mixed"},getSkinClassName:{r:"strClassName"},getSpinFrames:{r:"nFrames"},getSrcDim:{r:"oDimension"},getVersion:{r:"strVersion"},getViewString:{r:"strViewString"},getVisibleImageRect:{r:"rcVisibleRect"},getVisibleImageRectParameter:{r:"strImageRectParameter"},getVisibleImageURL:{a:"width, height, strEffects, bMakeImageFitInto",r:"strURL"},getZoom:{r:"fZoomInPercent"},getZoomFloat:{r:"fZoomAsFloat"},gotoHotspot:{a:"FSIHotspotID, bAnimate, bZoom",r:"bSuccess"},gotoViewString:{a:"strView, bAnimated",r:"bSuccess"},hideMenuToolTip:{},init:{a:"elementID, oParameters, bDebug"},makeBoolean:{a:"value, bDefaultValue",r:"bResult"},pressMenuButton:{a:"strButtonID"},printAPI:{},registerExternalMenuButton:{a:"elButton, strButtonID, strTip"},registerExternalMenuButtonsFromContainer:{a:"elContainer"},releaseMenuButton:{a:"strButtonID"},removeListener:{a:"strListenerName, fn",r:"bSuccess"},resetView:{},setFullScreenElement:{a:"elFullScreenContainer",r:"bSuccess"},setMouseMode:{a:"nMode"},setZoom:{a:"fZoomPercent, bPreliminary, bAnimate"},showAboutWindow:{},showMenuButton:{a:"strButtonID, bShow"},showMenuToolTip:{a:"strTip, elSrc, x, y"},spinToDegree:{a:"fDegree"},spinToTarget:{a:"nTargetFrame, nStopSceneSet, nFrames"},start:{},startAutoSpin:{r:"bSuccess"},stopAutoSpin:{r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unregisterExternalMenuButton:{a:"elButton"},unregisterExternalMenuButtonsFromContainer:{a:"elContainer"},updateSize:{}};c.oProperties={};c.oCallbacks={on3DWorldChanged:{a:"o3DData"},onAfterReady:{},onAfterRegisterExternalButton:{a:"elButton, strButtonID, bButtonPresentInViewer"},onAnimationComplete:{},onAnimationStart:{},onChangeConfig:{a:"strCfgFileName, oParameters"},onChangeImage:{a:"oParameters, strView"},onClickDemoMode:{a:"url, targetFrame"},onConfigsReady:{a:"oConfigValues"},onDataComplete:{},onDestroy:{},onEnterDemoMode:{},onExitDemoMode:{},onFullScreen:{a:"bSet"},onHotspotEvent:{a:"strAction, nHotspotID, strHotspotAttributeID, strContent, event"},onInit:{a:"oParameters)"},onInit3D:{a:"oProjection)"},onInitFailed:{a:"strReason"},onInitMenu:{},onLanguageData:{a:"oLanguageItems"},onMeasureChange:{a:"fLength, fRotation, strLabel",r:"strModifiedLabel"},onMeasureEnd:{a:"fLength, fRotation, strLabel, arCoords"},onMeasureShow:{a:"bShow"},onMeasureStart:{a:"fLength, fRotation, strLabel"},onMeasureUpdateRatio:{a:"fLengthFactor, fImageRealWidth, fImageWidth"},onMenuButtonEnabled:{a:"strButtonID, null, bEnable"},onMenuButtonMouseDown:{a:"strButtonID, evt"},onMenuButtonPressed:{a:"strButtonID, evt"},onMenuButtonReleased:{a:"strButtonID, evt"},onMenuButtonClicked:{a:"strButtonID, evt"},onMenuButtonSetPressed:{a:"bPressed"},onMenuDestroy:{},onMenuEnabled:{a:"bEnabled"},onMenuReady:{},onMouseModeChanged:{a:"nMouseMode"},onProgress:{a:"fPercent"},onReady:{},onRegisterExternalMenuButtons:{},onReset:{},onResize:{a:"nWidth, nHeight, bResizeDone, bFullscreen"},onSkinChanged:{a:"strCurrentSkinClass, strCurrentSkinClassBefore"},onStartDragging:{a:"bInNavWindow"},onStopDragging:{a:"bInNavWindow"},onViewChanged:{a:"strViewString"},onZoomChanged:{a:"fScale, fScaleMax, fPercent"},onZoomChanging:{a:"fScale, fScaleMax, fPercent, bPreliminary"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Viewer!==b){return}a.Viewer=function(gy,er){var g3={};var aG={strVersion:"2019",strBuild:"19.05.6483",strConfigSection:"Viewer",oTraceConfigParameters:er,bHasListeners:true};var cP=new a.utils.ClassDef(this,"FSI Viewer",aG);cP.oAPI=new a.utils.API.Viewer(this,g3);var bj=cP.instance;a.utils.guessFSIViewerLocation("fsiviewer.js",3);var dZ=a.utils.getViewerInstanceID();this.getInstanceID=g3.getInstanceID=function(){return dZ};this.getInstanceName=function(){return cP.strClassName+" ["+S+"]"};this.debugLog=function(){dE.log.apply(dE,arguments)};this.debugWarn=function(){dE.warn.apply(dE,arguments)};this.debugError=function(){dE.error.apply(dE,arguments)};this.debugEnabled=function(){return dE.on};var g5;var gj,di,ce;var aw;var m;var df;var ez;var h;var gH={};var Z;var dH;var D;var e6;var bG;var ds=false;var J;var dL=0;var fJ=0;var aJ={};var dK,d0;var eL;var bV;var cg;var cL;var bP,bb;var dM=false;var hi;var M;var a2;var bx={};var fQ={};var T,eW;var g0={};var aM;var gS;var aT;var aR;var eY=8;var hC=1;var aj;var d=false;var hk=false;var gf;var ck;var bB;var db;var fe;var hr,c2;var fd;var bH=true;var gO=100;var cf=true;var eO;var b4;var aH;var c9;var hj;var dD;var eU;var s;var bw;var dW=false;var fz=new a.CroppedImage();var fy=new a.Rect();var eM=a.Easing.easeOutCubic;var I=a.Easing.easeOutCubic;var dU=a.Easing.easeOutCubic;var e1;var e2={width:0,height:0};var bS;var aa;var aC;var g4;var bE;var aY={};var cO=10000;var hx=cO;var fc;var bz;var X;var dp;var a6={x:0,y:0,z:0};var g7;var gX;var ai;var ba=new a.Rect(0,0,-1,-1);var dS=new a.Rect(0,0,-1,-1);var fE=new a.Rect(0,0,-1,-1);var fX=new a.Rect(0,0,-1,-1);var gb=new a.Rect(0,0,-1,-1);var aS=new a.Rect(0,0,0,0);var gT=new a.Rect(0,0,0,0);var aF=false;var Y=true;var ht=!(a.isChrome);var ec=false;var bR=false;var bU=false;var da=true;var C;var fp=false;var hn;var dl=false;var gQ=true;var hg=false;var f7=false;var fA;var cb=new a.Rect(0,0,0,0);var eG=0;var du;var cV=0;var bI=0;var ak=0;var a0;var ev=0;var el=0;var cD=0;var dJ={x:0,y:0};var ad={};var bm={};var x={};var eI="auto";var eN;var fB=1;var aA;var bu;var gI=true;var a3={};var cT,cN,u;var fI=b;var f;var de;var hA=false;var eQ=false;var d5=true;var dr=true;var gA=false;var cu=false;var fh=false;var fO;var cj;var g9;var bA=false;var gU;var eJ;var bo;var fm={};var cA;var dt;var gp;var cB;var gh;var d7;var ef,dX;var af;var ej;var et;var dA;var hw;var e=[];var he=[];var dN;var dT={};var cG={};var gt;var eh=false;var hv;var bK,dx;var dY;var fg={};var S;var dO;var ac;var hl={};var ao;var bl=g3.viewport={};var dI=a.utils.getSVGNameSpaceURL();var f1="1.1";var bD;var hf;var ay;var co=1;var bk=1;var aN;var cq;var ff;var fD=0;var fb=1;var ax=2;var gi=fD;var gx;var i=false;var a8;var b3;var f5;var ho;var aP=false;var fV=false;var gz;var cc={};var H=false;var P;var gl;var gK;var n;var fH;var c1={width:0,height:0};var cd=false;var aO=false;var eg;var cr="&limit=0,360";var e7;var g6=false;var gZ;var z;var ge={};var fC=false;var b7;var cw="&effects=Matte(FFFFFF)";var c;var av;var aD;var c7={};var bv=true;var gn;var cZ;var fZ;var dR;var bM=0;var cF=0;var bO={};var cW=false;var e5=true;var K;var fu={};var au=0;var a5={};var cX={};var gu;var ek={};var dE=new a.EmptyDebugger();var hq=function(hD,o){if(o&&!dE.on&&hD.on){gt.stopPendingRequests();bj.destroy(true);bj.init(gu,ek,true);bj.start();return true}dE=hD;if(cL){cL.setDebug(dE)}if(dE.on){dE.setPrefix(bj.getInstanceName())}};var go=g3;go.iViewer=bj;go.getDebug=function(){return dE};go.getToolTip=function(){return fZ};go.getElementSpace=function(){return ao};go.getDrawRatio=function(){return ad};go.getdrawRatioUnZoomed=function(){return bm};go.getdrawRatioUnResized=function(){return x};go.getinPlaceZoom=function(){return cc};go.getRootContainer=function(){return g5};go.getParentElement=function(){return aw};go.getCallbacks=function(){return cL};go.getIsFullScreen=function(){return eh};go.getImageArray=function(){return he};go.getCurrentSkin=function(){return a3};this.init=function(hD,hG,o){if(gA){bj.destroy()}gu=hD;if(typeof(hD)==="object"){if(typeof(hD.id)==="string"){S=hD.id}}else{if(typeof(hD)==="string"){S=hD}}if(!S){S="fsi.viewer #"+dZ}if(bj._fsi_parameters){hG=bj._fsi_parameters;delete bj._fsi_parameters;bj._fsi_parameters=b}if(a.isMobileDevice){gx=5000000}else{gx=8000000}aT=new a.IMGLoadingEngine(bj,e9);var hE;if(typeof(hD)=="object"&&hD.tagName!==b){hE=hD}else{hE=document.getElementById(hD)}if(typeof(hG)=="object"&&typeof(window[hG.oninit])=="function"){window[hG.oninit](bj,S,hG)}gh=ek=(hG&&typeof(hG)=="object")?a.utils.cloneParameters(hG):{};gF();var hF=ek;if(o){hF=a.utils.cloneObject(ek);hF.debug=true}gt.init(hF);if(dE.on){dE.log(bj.getVersion())}B();if(!hE){dE.error("A DOM element with the id '"+hD+"' could not be found. Aborting.");return}bD="1.5px";if(a.isSmallMobileDevice){dE.log("Small mobile Device detected.");cd="fsi-ui-hotspot-mobile fsi-ui-hotspot-mobile-small";bD="4px"}else{if(a.isMobileDevice){dE.log("Mobile Device detected.");cd="fsi-ui-hotspot-mobile"}}if(hE.firstChild){hE.innerHTML=""}aw=hE;if(aw.tagName.toLowerCase()!=="fsi-viewer"){a.addClass(aw,"fsi-viewer")}aw.setAttribute("data-fsi-id",S);ff=(a.isMobileDevice)?0.2:0.15;if(!g5){g5=document.createElement("div");g5.className="fsi-root fsi-viewer-root";a.utils.setStyleAttr(g5,"position:relative;left:0px;top:0px;padding:0px;margin:0px;border:0px none;z-index:0;width:100%;height:100%;text-align:left;vertical-align:top;");hE.appendChild(g5)}am();dC(true);if(dE.on){dE.log("Container element: "+ao.width+" x "+ao.height+" ("+hE.nodeName+")")}gA=true;bw=a.utils.getCSSTransformStyleName();eO=false};var gF=function(){var o={};o.onConfigsReady=d9;o.onDebuggerChange=hq;gt=g3.iConfig=new a.Config(null,o,{strSection:cP.strConfigSection});gt.setEffectsFilterArea();bj.loadFile=gt.loadFile;if(a2){gt.setAccessToken(a2)}if(!cL){cL=g3.iCallbacks=new a.Callbacks(bj,gt,b,ar);cL.watchListeners(cE,ew)}else{cL.setConfig(gt)}};var cE={onZoomChanged:true,onZoomChanging:true,onProgress:true};var ew=function(hD){var o=function(hG,hF){var hE;if(hD[hG]===b){hE=hF}else{hE=hD[hG]}return hE};cN=o("onZoomChanging",cN);u=o("onZoomChanged",u);cT=o("onProgress",cT)};var ar=function(hF,o,hD){var hE=true;if(hF==="onViewChanged"){hE=(bb!==b)}return hE};this.getInitDone=function(){return gA};g3.getViewportSize=function(){return bl};var am=function(){var o=a.getBoundingClientRect(g5);ao={width:o.width,height:o.height};var hD=(gH&&gH.minInstanceSize>1)?gH.minInstanceSize:60;if(ao.width<hD||ao.height-cF<hD){ao.visible=false;ao.width=hD;ao.height=hD+cF}else{ao.visible=true}bl.width=ao.width;bl.height=ao.height-cF};var b6=g3.setCursor=function(o){if(b7===o){return}if(ho){if(b7){a.removeClass(ho,"fsi-ui-cursor-"+b7)}if(o){a.addClass(ho,"fsi-ui-cursor-"+o)}}b7=o};var fP=function(hJ,hI,hL,hH,o){var hF=bl.width*aC.scale;var hD=bl.height*aC.scale;if(hJ===b){hJ=hF/2}if(hI===b){hI=hD/2}var hE;if(hL!==b){hE=Math.max(1,Math.min(cc.maxScale,cc.scale+hL))}else{hE=cc.defaultZoom}var hK=hE/cc.scale;hJ=hK*(cc.panPos.left-(hJ-hF/2));hI=hK*(cc.panPos.top-(hI-hD/2));var hG=(hH)?0:o;eX(hJ,hI,hE,hG)};var gB=function(o,hG,hE,hD){if(!cc.enabled){return}if(cc.panPos.left===0&&cc.panPos.top===0&&(hf<=1||(X&&cc.targetZoom===1))){return}var hF=(hE)?0:hD;eX(0,0,1,hF)};var eR=function(o){if(aC.scale>1){o.scaleRect(1/aC.scale)}var hM=o.width();var hH=o.height();if(hM<1||hH<1){return}var hI=hM/hH;var hG=bl.width/bl.height;if(hI>hG){hH=hM*bl.height/bl.width;o.inflateRect(0,hH-o.height())}else{if(hI<hG){hM=hH*bl.width/bl.height;o.inflateRect(hM-o.width(),0)}}var hD=hf*bl.width/hM;hD=Math.max(1,Math.min(cc.maxScale,hD));var hL=hD/hf;var hF=o.left+o.width()/2;var hE=o.top+o.height()/2;var hK=(cc.panPos.left-hF+bl.width/2)*hL;var hJ=(cc.panPos.top-hE+bl.height/2)*hL;eX(hK*aC.scale,hJ*aC.scale,hD)};var eX=function(o,hG,hF,hD){hF=Math.max(1,Math.min(cc.maxScale,hF));eE();cc.pos=0;cc.frames=(hD!==b)?hD:28;if(cc.frames<1){cc.frames=1}cc.sourceZoom=cc.scale;cc.sourceX=cc.panPos.left;cc.sourceY=cc.panPos.top;if(o===b){o=cc.sourceX}if(hG===b){hG=cc.sourceY}var hE=hd(o,hG,hF);cc.targetX=hE.x;cc.targetY=hE.y;cc.targetZoom=hF;cc.dX=hE.x-cc.sourceX;cc.dY=hE.y-cc.sourceY;cc.dZoom=hF-cc.sourceZoom;bp()};var A=g3.stopAfterTouch=function(){if(K){K.cancelAfterTouch()}};var aV=g3.autoShowHideHotSpots=function(o){if(dr===o){return}dr=o;if(!eQ||!a.isMobileDevice){return}d5=o;gc(o);dQ();if(o){hm()}};var bp=function(){if(X){return}dx=false;cc.lockPanAnimation=false;H=true;aV(false);X=true;cL.run("onAnimationStart");hm()};var eE=g3.stopDesktopAnimation=function(){if(X){aV(true);H=false;X=false;cc.pos=cc.frames=0;cc.targetZoom=b;ca();d2();f0();c4()}};var cn=function(){if(X||hA){return}cL.run("onAnimationComplete");I=eM};var fF=function(){cc.pos++;gd(I(cc.pos,cc.frames,cc.sourceZoom,cc.dZoom));if(!cc.lockPanAnimation){cc.panPos.left=I(cc.pos,cc.frames,cc.sourceX,cc.dX);cc.panPos.top=I(cc.pos,cc.frames,cc.sourceY,cc.dY)}ca();if(cc.pos===cc.frames){eE();cn();if(dx){fN()}return false}return true};var e0=g3.onAfterinPlaceZoomChanged=function(){ca();d2();f0()};this.getMouseMode=function(){return eN};var fk=this.setMouseMode=function(o){if(K){K.cancel()}eI=o;switch(o){case"auto":if(z){o=(cc.bZoomedIn)?1:0}else{o=(cc.bAutoMouseModePan)?1:2}break;case 0:case 1:break;case 2:if(z){o=(cc.bZoomedIn)?1:0}else{o=2}break}cU(o)};var cU=function(o){eN=o;switch(eN){case 0:b6("zoom");break;case 1:b6("pan");break;case 2:if(a5.nSceneSets>1){b6("rotate3d")}else{b6("rotate")}break}cL.runPersistent("onMouseModeChanged",[eN]);if(cZ){cZ.setButtonPressed("MouseMode_"+eN,true)}};var f0=function(){if(!cc.enabled||eI!=="auto"){return}var o=(cc.scale>1);if(cc.bZoomedIn===o){return}cc.bZoomedIn=o;if(o){cc.bAutoMouseModePan=true;cU(1)}else{cc.bAutoMouseModePan=false;if(z){cU(0)}else{cU(2)}}};var hd=function(o,hJ,hI){var hG={x:o,y:hJ};var hH=Math.round(bm.imageWidth*hI);var hE=Math.round(bm.imageHeight*hI);var hF=Math.max(0,(hH-ad.maxPanReferenceWidth)/2);var hD=Math.max(0,(hE-ad.maxPanReferenceHeight)/2);hG.x=Math.max(-hF,Math.min(hF,o));hG.y=Math.max(-hD,Math.min(hD,hJ));return hG};this.getZoom=function(){if(cc.maxScale<=1){return 0}return(cc.scale-1)/(cc.maxScale-1)*100};this.getZoomFloat=function(){return cc.scale};this.setZoom=function(hF,o,hD){if(isNaN(hF)){return false}hF=Math.max(0,Math.min(100,hF));var hE=1+hF*(cc.maxScale-1)/100;return eK(hE,o,hD)};var eK=function(hE,o,hD){if(!cu||!cc.enabled){return false}if(isNaN(hE)){return false}aI(true);eE();if(hD){eX(b,b,hE);return}else{gd(hE)}ca(o);if(!o){d2();f0()}return true};this.gotoHotspot=function(hF,hD,hE){if(!cu){return false}aI();if(hD!==false){hD=true}var o=bj.getHotspotViewString(hF,hE);if(hE===false){o=o.split(",");o=o.splice(0,2);o=o.concat([0,0,1,1]);o=o.join(",")}if(o===false){return false}ha(o,hD);return true};this.getHotspotViewString=function(hE,o,hD){if(!cu||eL[hE]===b){return false}return fq(eL[hE],hD,o)};var fq=function(hL,hU,hK){if(typeof(hL)!="object"){return false}if(hK===b){hK=hL.rotateOnFocus}if(hU===b){hU=hL.zoomOnFocus}var h3;var hM;var o=(a5.nCurrent===b)?0:a5.nCurrent;var hR=o+1;var hW=Math.round(eG/(ev/bI));var h1=1+hW;var hP=false;var hV=false;var h4=false;var hI=el;var hQ;var hJ=false;if(hK){if(hL._focusSceneSet!==b){hJ=true;if(hL._focusSceneSet!==false){hR=hL._focusSceneSet}}else{if(a5.nSceneSets===b||a5.nSceneSets<2||hL.perimeterAngleX===b){hL._focusSceneSet=false}else{var h2=cQ();var hX=h2.angle;var hH=Math.abs(h2.stepAngle);hQ=(hL.focusAngleX!==b)?hL.focusAngleX:hL.perimeterAngleX;if(typeof(hQ)=="number"){var h5=hQ-hX;if(!isNaN(h5)){h5=h5%360;if(h5<0){h5+=360}var hG=Math.round(h5/hH);hG=Math.max(0,Math.min(a5.nSceneSets,hG))+1;if(hG!==hR){hR=hG;if(hU){hV=eG;h4=hP=true;fY(hR-1)}}}hL._focusSceneSet=false}else{hL._focusSceneSet=false}hL._focusSceneSet=hR}}if(hL._focusScene!==b){hJ=true;if(hL._focusScene!==false){h1=hL._focusScene}}else{hQ=(hL.focusAngleY!==b)?hL.focusAngleY:hL.perimeterAngleY;if(typeof(hQ)=="number"){var hS=hv(Math.round(hQ/360*bI))+1;hV=hv(Math.round(hQ/360*ev));if(!isNaN(hS)){if(hU){if(hV!==eG){hP=true}}hL._focusScene=h1=hS;hL._focusSpinPos=hV}else{hL._focusScene=false}}else{hL._focusScene=false}}}var hO=(hK&&typeof(hL._focusScene)=="number"&&typeof(hL._focusSceneSet)=="number");if(hU&&hK&&hJ&&!hO){if(hL._focusSceneSet!==false&&hL._focusSceneSet!==hR){hV=eG;h4=hP=true;fY(hL._focusSceneSet-1)}if(hL._focusScene!==false&&hL._focusScene!==hW){hV=hL._focusSpinPos;hP=true}}if(hP){cl(hV);eB()}if(hU){if(hO&&hL._focusZoom!==b){hM=hL._focusZoom}else{var hN=new THREE.Vector3();dT.camera.setViewOffset(bl.width,bl.height,0,0,bl.width,bl.height);if(hP){bn()}hN.setFromMatrixPosition(hL.object.matrixWorld);hN.project(dT.camera);var h0=0.5;var hD=0.5;var hZ=bm.imageWidth/bl.width;var hY=bm.imageHeight/bl.height;var hF=hN.x/hZ*h0+h0;var hE=hD-hN.y/hY*hD;hg=true;var hT=new a.Rect(hF,hE,hF,hE);if(typeof(hL.focusRadius)=="number"&&hL.focusRadius>0){hT.inflateRect(hL.focusRadius,hL.focusRadius)}hM=hT.toString();if(hO){hL._focusZoom=hM}}}if(h4){fY(o)}if(hP){cl(hI);eB();hm()}h3=hR+","+h1;if(hM!==b){h3+=","+hM}return h3};var cC=this.getViewString=function(){if(!aD){return b}var o=[];var hF=a5.nCurrent+1;var hE=1+Math.round(eG/(ev/bI));if(isNaN(hE)){hE=1}var hD=fM();hD.round();o.push(hF);o.push(hE);o.push(hD.toString());o.push(0);return o.join(",")};var fM=function(){var hH=fz.getImageRect();var o=hH.width()*cc.scale/cc.scaleToSourceImage;var hF=hH.height()*cc.scale/cc.scaleToSourceImage;o=Math.max(o,bl.width);hF=Math.max(hF,bl.height);var hD=-cc.panPos.left+(o-bl.width)/2;var hE=-cc.panPos.top+(hF-bl.height)/2;var hG=new a.Rect(hD,hE,hD+bl.width,hE+bl.height);hG.scaleRectXY(1/o,1/hF);hG.limitToImageRect();return hG};this.getVisibleImageRect=function(){var hD=fM();if(fz.isCropped()){var o=fz.getFloatRect();hD=o.getPartialRect(hD)}hD.round();return hD};this.getVisibleImageRectParameter=function(){return gt.getImageRectParamFromRect(bj.getVisibleImageRect())};this.getVisibleImageURL=function(hK,hG,hI,hL){if(isNaN(hK)&&isNaN(hG)){hK=Math.round(Math.min(bl.width,ad.imageWidth))}var hE={};if(!isNaN(hK)){hE.width=Math.ceil(hK)}if(!isNaN(hG)){hE.height=Math.ceil(hG)}if(typeof(hI)==="string"&&hI.length>0){var hH=gt.getImageQueryParameters();hE.effects=hH.effects;gt.appendImageEffect(hE,"effects",hI)}var hD=bj.getVisibleImageRect();if(hL===true&&!isNaN(hK)&&!isNaN(hG)){var hF=a.utils.fitImageIntoSpace(aD.width*hD.width(),aD.height*hD.height(),hK,hG,true);hE.width=hF.width;delete hE.height;a.utils.extendRectToFill(hD,aD.width,aD.height,hK,hG,false,true);hD.round()}if(!hD.isDefaultImageRect()){hE.rect=gt.getImageRectParamFromRect(hD)}var hJ=aK(hJ);var o=he[hJ];return gt.getImageURL(o,hE)};var eA=function(hH){var hG={SceneSet:0,scene:0,frame:0};if(hH===b||typeof(hH)!=="string"||hH.length<3){return hG}var hK=gt.viewStringToArray(hH);if(hK.length<2){return hG}if(a5.nSceneSets<2){hG.SceneSet=0}else{hG.SceneSet=hK[0]-1;if(isNaN(hG.SceneSet)){hG.SceneSet=b}}hG.scene=hK[1];if(isNaN(hG.scene)){hG.scene=1}hG.scene=hG.scene%bI-1;if(hG.scene<0){hG.scene+=bI}hG.frame=hG.scene*ev/bI;if(hK.length>5){var hO=hK[2];var hE=hK[3];var hM=hK[4];var hF=hK[5];var hD=hG.rc=new a.Rect(hO,hE,hM,hF);hD.normalizeRect();var hL=fz.getImageRect();var hS=cc.maxScale/cc.scaleToSourceImage;var hR=hS*hL.width()*hD.width();var hQ=hS*hL.height()*hD.height();var hP=a.utils.fitImageIntoSpace(hR,hQ,bl.width,bl.height,true,true);var hN=hP.width/hR;hG.zoom=cc.maxScale*hN;var hJ=bm.imageWidth*hG.zoom;var hT=bm.imageHeight*hG.zoom;hD.scaleRectXY(hJ,hT);hG.x=-(hD.left+hD.width()/2-hJ/2);hG.y=-(hD.top+hD.height()/2-hT/2);var hI=hd(hG.x,hG.y,hG.zoom);hG.x=hI.x;hG.y=hI.y}return hG};var ha=this.gotoViewString=function(hE,hF){if(!cu){return false}aI();var o=(hF)?30:0;var hD=eA(hE);if(hD.scene===b){return false}var hG=eA(cC());if(hD.SceneSet===hG.SceneSet&&hD.scene===hG.scene&&Math.abs(hD.x-hG.x)<1&&Math.abs(hD.y-hG.y)<1&&Math.abs(hD.zoom-hG.zoom)<0.000001){if(dx){fN()}return true}if(hD.SceneSet!==hG.SceneSet||hD.scene!==hG.scene){bj.spinToTarget(hD.frame,hD.SceneSet,o)}if(cc.enabled&&hD.rc!==b){eX(hD.x,hD.y,hD.zoom,o)}return true};this.changeImage=function(hF,hG){cL.run("onChangeImage",[hF,hG]);gt.makeObjectPropertiesLowerCase(hF);if(!fh){fO=arguments;return false}av=cC();if(dE.on){a.console.log("")}dE.log("--- changeImage() called ---");gt.stopPendingRequests();var hI=false;if(hF&&typeof(hF)==="object"){if(hF.fpxsrc!==b||hF.imagepath!==b){hI=true}if(hF.dir!==b){hI=true}}if(!hI){return bj.gotoViewString(hG,true)}if(hF.imagepath!==b){hF.fpxsrc=hF.imagepath;hF.imagepath=b;hF.imagepath=b}hF.fpxsrc=encodeURIComponent(hF.fpxsrc);var o=["imagesrc","imagepath","imagesources","imagewidth","imageheight","imagetilesx","imagetilesy","imagetransparency","images3durl"];var hE=gt.cfgAliasNames;var hD=gt.cfg;for(var hH=0;hH<o.length;hH++){var hJ=o[hH];delete hD[hJ];if(hE[hJ]){delete hD[hE[hJ]]}}gt.setCfgValues(hF);B();c=hG;by();gt.dumpConfig();fT();return true};var gm=function(){var o=bS;if(hf<=1){fe=1;o=aN}else{var hE=hf*x.imageWidth;var hG=Math.round(aD.width/e2.width*hE);var hF;for(var hD=0;hD<bB.length;hD++){if(bB[hD]>=hG){hF=aa=bB[hD];break}}if(!hF){if(bB.length>0){hF=bB[bB.length-1]}if(hF<=1.1*x.imageWidth){hF=b}}if(hF){o=Math.round(hF*fz.getImageRect().width()/aD.width)}fe=o/aN}return o};var gd=function(o){o=Math.max(1,Math.min(cc.maxScale,o));cc.scale=o;hf=cc.scale*aC.scale;ay=Math.min(cc.maxScaleInitial,co*cc.scale);db=cc.scale*co};var fW=function(){var o=Math.min(cc.maxScaleInitial,co);if(o*cc.scale>cc.maxScaleInitial){cc.scale=cc.maxScaleInitial/o}ay=Math.min(cc.maxScaleInitial,co*cc.scale);return o};var ag=function(o){aC.scale=o;hf=aC.scale*cc.scale;ay=Math.min(cc.maxScaleInitial,co*cc.scale);cc.scale=Math.max(1,ay/co);db=co*cc.scale};var ca=g3.updateInPlaceZoom=function(hD){if(X){hD=true}var hE=false;if(hD){if(cc.nLastScalePreliminary!==hf){cc.nLastScalePreliminary=hf;hE=true}}else{if(cc.nLastScaleFinal!==hf){cc.nLastScaleFinal=hf;hE=true}}if(hE){if(!hD&&u){cL.runPersistent("onZoomChanged",[hf,cc.maxScaleInitial,bj.getZoom()])}if(cN){cL.runPersistent("onZoomChanging",[hf,cc.maxScaleInitial,bj.getZoom(),hD])}if(hD&&dt&&hf-dt.renderScale<-1){fx()}ad.imageWidth=hl.testWidth=Math.round(x.imageWidth*hf);ad.imageHeight=Math.round(x.imageHeight*hf);ad.imageX=Math.round(bm.imageX-(ad.imageWidth-bm.imageWidth)/2);ad.imageY=Math.round(bm.imageY-(ad.imageHeight-bm.imageHeight)/2);ad.maxImageOffsetX=Math.floor(Math.max(0,(ad.imageWidth-ad.maxPanReferenceWidth)/2-0.01));ad.maxImageOffsetY=Math.floor(Math.max(0,(ad.imageHeight-ad.maxPanReferenceHeight)/2-0.01));if(g9){ad.videoWidth=Math.round(x.videoWidth*hf);ad.videoHeight=Math.round(x.videoHeight*hf);ad.videoX=bm.videoX-(ad.videoWidth-bm.videoWidth)/2;ad.videoY=bm.videoY-(ad.videoHeight-bm.videoHeight)/2}if(!hD){var o;o=(cc.scale>1);cH("ZoomOut",o);if(gi<ax){cH("MouseMode_1",o)}o=(cc.scale<cc.maxScale);cH("ZoomIn",o);cH("MaxZoom",e2.width!==ad.imageWidth);bS=gm();cL.run("onAnimationComplete")}}if(!X){cc.panPos.left=Math.max(-ad.maxImageOffsetX,Math.min(ad.maxImageOffsetX,cc.panPos.left));cc.panPos.top=Math.max(-ad.maxImageOffsetY,Math.min(ad.maxImageOffsetY,cc.panPos.top))}if(!hD){cc.panPos.left=Math.floor(cc.panPos.left);cc.panPos.top=Math.floor(cc.panPos.top)}hg=true;dQ();C=true;hm();if(!hD){an()}};var an=function(){if(!cL.isset("onViewChanged")){return}if(bP!==b){clearTimeout(bP)}bP=setTimeout(bN,250)};var bN=function(){bP=b;var o=cC();if(o===bb){return}bb=o;cL.runPersistent("onViewChanged",[o])};var d2=function(){if(!de&&!hA){fr()}};var cp=function(){var o=a.getElementClientPos(fd);ba.copyRect(cb);gb.copyRect(o);ba.interSectRectValidate(gb);ba.offsetRect(-gb.left,-gb.top);var hD=(ba.width()>0&&ba.height()>0);var hE=(hD!==aC.visible);aC.visible=hD;return hE};var ct=function(o){fX.copyRect(o);fX.offsetRect(-x.imageX,-x.imageY);if(bH&&fX.width()>0&&fX.height()>0){fX.inflateRect(gO/hf,gO/hf)}fX.scaleRect(fe)};var k=function(){var hD;var o;hD=(ba.left+ba.width()/2)-aC.widthUnScaled/2;if(aC.leftLast!==hD){aC.leftLast=hD;if(hD<0){hD=0}if(hD>aC.maxLeft){hD=aC.maxLeft}aC.left=hD}aC.drawOffsetX=aC.scale*-aC.left;o=(ba.top+ba.height()/2)-aC.heightUnScaled/2;if(aC.topLast!==o){aC.topLast=o;if(o<0){o=0}if(o>aC.maxTop){o=aC.maxTop}aC.top=o}aC.drawOffsetY=aC.scale*-aC.top;if(ec){dP(aC.totalWidth,aC.totalHeight);hg=true;dQ()}};var dP=function(hE,hG){var o=gp.style.width;var hF=gp.style.height;var hH=gp.width;var hD=gp.height;dT.renderer.setSize(hE,hG);gp.style.width=o;gp.style.height=hF;gp.width=hH;gp.height=hD};var t=function(hD,hF){if(fc){return}var hM=co;if(!i){l(ad.widthForRatio,ad.heightForRatio,true);hm();return}var hH=false;var hE=fW();db=cc.scale*co;var hJ=cp();if(hJ){hD=true}else{if(!aC.visible){return}}if(!hD&&dt){if((hJ&&!aC.visible)||(aC.widthUnScaled<ba.width()||aC.heightUnScaled<ba.height()-cF)||(Math.abs(hE-aC.scale)>1)){if(hM>1){hM=1;hD=true}}}if(!hD){var hG=aC.left;var hQ=aC.top;k();dp=(hG!==aC.left||hQ!==aC.top);C=true;hm();return}var hK=a.getViewportSize();if(aC.bSizeAtMax&&(hK.width!==aC.dimViewport.width||hK.height!==aC.dimViewport.height)){hF=true}if(hF||aC.lastScale!==hE){aC.dimViewport=hK;aC.lastScale=hE;ag(hE);var hI=Math.ceil(bl.width*hE);var o=Math.ceil(bl.height*hE);var hP,hO;var hN=0;if(bH){hN=gO}aC.maxWidth=Math.round((hK.width*co+hN)*hE/hM);aC.maxHeight=Math.round((hK.height*co+hN)*hE/hM);aC.bSizeAtMax=false;if(hI>aC.maxWidth){aC.bSizeAtMax=true;hP=aC.maxWidth}else{hP=hI}if(o>aC.maxHeight){aC.bSizeAtMax=true;hO=aC.maxHeight}else{hO=o}aC.width=hP;aC.height=hO;aC.widthUnScaled=Math.ceil(hP/hE);aC.heightUnScaled=Math.ceil(hO/hE);aC.totalWidth=hI;aC.totalHeight=o;hH=(hF||gp.width!==hP||gp.height!==hO)}aC.maxLeft=(aC.totalWidth-aC.width)/aC.scale;aC.maxTop=(aC.totalHeight-aC.height)/aC.scale;if(eO){if(aC.scale!==1){var hL=1/aC.scale;if(cf){aC.strTransformScale=" scale3d("+hL+","+hL+","+hL+")"}else{aC.strTransformScale=" scale("+hL+","+hL+")"}}else{aC.strTransformScale=""}}else{aC.strTransformScale=""}k();if(hH){if(cf){g(gp,"translate3d("+aC.left+"px,"+aC.top+"px,0px)"+aC.strTransformScale)}else{g(gp,"translate("+aC.left+"px,"+aC.top+"px)"+aC.strTransformScale)}if(!eO){gp.style.width=hP/hE+"px";gp.style.height=hO/hE+"px"}gp.width=hP;gp.height=hO;cB=gp.getContext("2d");hr=hI;c2=o;l(ad.widthForRatio,ad.heightForRatio,true);bS=gm();if(cc.enabled){c8();ca()}}else{if(cf){g(gp,"translate3d("+aC.left+"px,"+aC.top+"px,0px)"+aC.strTransformScale)}else{g(gp,"translate("+aC.left+"px,"+aC.top+"px)"+aC.strTransformScale)}if(!eO){gp.style.width=gp.width/hE+"px";gp.style.height=gp.height/hE+"px"}}if(!cj){fr();C=true;hm()}else{cS()}};var g=function(o,hD){o.style[bw]=hD};this.showAboutWindow=function(){if(m){m.destroy();m=b;return}var o={};o.title="About FSI Viewer";o.fnOnDestroy=hz;o.strLongVersion=bj.getVersion();m=new a.AboutWindow(g5,o)};var hz=function(){m=b;return true};this.getParameters=function(){return a.utils.cloneParameters(ek)};this.getConfigValue=function(hE){if(!gt){return}if(typeof(hE)!=="string"){return"error: type of argument must be string"}hE=a.trim(hE);if(hE.indexOf("_")!==-1){var o=hE.split("_");var hD=o.shift().toLowerCase();hE=o.join("_");return gt.getPluginParameter(hD,hE)}if(gt&&typeof(hE)==="string"){return gt.cfg[a.trim(hE.toLowerCase())]}};this.makeBoolean=function(hD,o){if(gt){return gt.makeBool(hD,o)}};this.getPluginParameter=function(hF,hE,hD,o){if(gt){return gt.getPluginParameter(hF,hE,hD,o)}};this.changeConfig=function(hD,hE,o){cL.run("onChangeConfig",[hD,hE]);if(dE.on){a.console.log("")}av=cC();cu=false;gw();if(o){ek=gh={}}if(hE!=null&&typeof(hE)==="object"){ek=a.utils.cloneParameters(gh);a.utils.mergeObjects(ek,hE)}if(typeof(hD)==="string"){ek.cfg=hD}gF();dM=true;gw();bj.start()};var fn=function(o,hD){if(!o){return}if(!hD){if(o.FSI_prevDisplayState===b){o.FSI_prevDisplayState=o.style.display}o.style.display="none"}else{if(o.FSI_prevDisplayState!==b){o.style.display=o.FSI_prevDisplayState}o.FSI_prevDisplayState=b}};var gc=function(o){if(!ds){o=false}fn(ac,o)};var bd=this.onResize=function(o){if(eT()){return}if(!fc){fc=true;hs();bz=cC();if(K){K.cancel()}fn(ho,false);gc(false);if(fZ){fZ.hide()}}if(o.FSI_after_treshold!==b){b5()}dC(o.FSI_after_treshold)};var dC=function(o){var hD=a.getElementDimension(g5);cL.runPersistent("onResize",[hD.width,hD.height,(o!==b),eh])};this.updatePosition=function(){cp();C=true;hm()};this.updateSize=function(){dG();g7=setTimeout(hu,0)};var dG=function(){if(g7===b){return}clearTimeout(g7);g7=b};var hu=function(){dG();bj.updatePosition();b5()};var b5=function(hD){var hF={};hF.width=bl.width;hF.height=bl.height;var o;if(gH.keepViewOnResize){if(!bz){bz=cC()}o=bz}bz=false;fc=false;am();fn(ho,true);gc(true);if(!hD&&hF.width===bl.width&&hF.height===bl.height){return}hs();eC();if(!gp||bl.width<1||bl.height<1){return}var hE=c9;hr=bl.width;c2=bl.height;l(ad.widthForRatio,ad.heightForRatio);l(ad.widthForRatio,ad.heightForRatio,true);fL();C=true;if(ec){dP(bl.width,bl.height);cm();dQ();hg=true}eU=c9=b;fx();aQ();if(gn){gn.setContainerSize(ao,ad,bm)}if(cZ){cZ.setContainerSize(ao)}fi();ca();eZ(hE);if(o&&!fQ.bEnabled){ha(o)}t(true)};var gw=function(){c9=eU=b;if(n){n.destroy();n=b}if(fg.nInterval!==b){clearInterval(fg.nInterval);fg.nInterval=b}dG();a.FullScreen.removeChangeEvents(window,cY,a4);cL.run("onReset");if(cZ){cZ.unregisterExternalButtons()}if(bP){clearTimeout(bP);bP=b}bb=b;cL.removeConfigListeners();hh();if(gU){gU.remove();gU=b}hs();aJ={};d8();aY={};dE=new a.EmptyDebugger();B();if(gt){gt.reset();gt.init(ek)}gH={}};g3.getConfigObject=function(){return gH};var gW=function(){if(e1&&b3){e1.lockImageSourceDimension(b3,false);e1.lockImage(b3,false);e1.removeImages(b3,false)}};var c8=function(){cc.nLastScalePreliminary=b;cc.nLastScaleFinal=b};var aQ=function(){c8();bS=aa=b;fA=b};var gP=function(){hl={}};var eC=function(){aC=g3.oDynamicCanvas={};aC.lastScale=b;ag(1);var o,hD;if(gp){o=gp.width;hD=gp.height}aC.leftLast=aC.topLast=b;aC.width=aC.widthUnScaled=aC.totalWidth=o;aC.height=aC.heightUnScaled=aC.totalHeight=hD;aC.left=aC.top=0;aC.drawOffsetX=aC.drawOffsetY=0};var B=function(){bb=b;dG();hs();aT.abortAll();dL=0;gQ=true;bL();if(K){K.cancel()}aI();bZ();eE();fx();aq();es();cc.panPos={left:0,top:0};cc.maxScale=cc.maxScaleInitial=1;cc.scaleToSourceImage=1;cc.scale=1;cc.pos=cc.frames=0;cc.sourceX=cc.sourceY=0;cc.targetX=cc.targetY=0;cc.sourceZoom=cc.targetZoom=1;cc.dX=cc.dY=cc.dZoom=0;cc.lockPanAnimation=false;eC();gd(1);co=1;gP();bE=b;e2={width:0,height:0};au++;aQ();d5=true;gc(false);aH=b;c9=b;eU=b;hA=false;da=true;bU=false;if(cZ){cZ.setEnabled(false,true)}bA=false;c=b;cu=false;if(!i&&b3){a.removeEvent(b3,"load",dy)}c1={width:0,height:0};gW();hx=cO;f0();if(gl){clearTimeout(gl);gl=b}if(eg){clearTimeout(eg);eg=b}eu("image",true);gJ();e=[];if(eQ){if(bV){a.removeChild(ac,bV);bV=b}for(var o=0;o<gH.hotspots.points.length;o++){var hD=gH.hotspots.points[o];if(hD&&hD.tooltip){if(hD.interactive){if(!hD.tooltip.FSIEmpty){a.removeEvent(hD.tooltip,"mouseenter",fs);a.removeEvent(hD.tooltip,"mouseleave",fs)}if(hD.oSvg){a.addEvent(hD.oSvg.svg,"mouseenter",fs);a.addEvent(hD.oSvg.svg,"mouseleave",fs)}}a.removeChild(hD.tooltip.parentNode,hD.tooltip);a.removeChild(hD.marker.parentNode,hD.marker)}}}cj=false;eQ=false;ev=b;bo="";dN=0;a8=b;he=[];es();if(cA){cA=b}fm={};ej=b};var es=function(){if(dY){fK(dY);if(dY.parentNode){a.removeChild(dY.parentNode,dY)}dY=b}};var fK=function(hE){try{if(hE&&hE.FSIEvents){for(var hG in hE.FSIEvents){if(hE.FSIEvents.hasOwnProperty(hG)){var hD=hE.FSIEvents[hG];a.removeEvent(hE,hG,hD.fn,hD.phase)}}}}catch(hF){}};this.addListener=function(hF,hD,hE){var o=false;if(cL){o=cL.addListener(hF,hD,hE)}return o};this.removeListener=function(hE,hD){var o=false;if(cL){o=cL.removeListener(hE,hD)}return o};g3.registerPointerHandlers=function(o,hE,hF,hD){if(g0[o]){return}g0[o]={fnDown:hE,fnMove:hF,fnUp:hD}};g3.unregisterPointerHandlers=function(o){if(g0[o]===b){return}delete g0[o]};var ey=function(o,hF){g3.onUserAction();if(!cu||eN<0){return false}dk("mousedown",o);cg=(ge.interval!==b);aI();bZ();if(cc.enabled){var hE=false;if(c7&&c7.timeStamp!==b&&(o.timeStamp-c7.timeStamp)<300){if(Math.abs(c7._posx-hF.x)<50&&Math.abs(c7._posy-hF.y)<50){hE=true}}if(!hE){var hD=(X)?cc.targetZoom:cc.scale;e5=(hD<=1)}c7=o;c7._posx=hF.x;c7._posy=hF.y;eE()}de=true;cL.run("onStartDragging",[false]);if(e1&&eN===2&&!z){e1.lockImageSourceDimension(b3,true);e1.lockImage(b3,true)}gp.lastOffsetX=hF.x;gp.lastOffsetY=hF.y;cD=el;dJ.x=hF.x;dJ.y=hF.y;switch(eN){case 0:if(cc.enabled){aS.clientOffset=a.getElementPosition(ho);aS.setRect(hF.x,hF.y,hF.x,hF.y);f7=true;hm()}break;case 2:fg.bEnabled=(hf>1);fg.bEnabled=true;fg.bSuspended=false;if(fg.bEnabled){fg.nTimeLastMove=fg.nTime=a.now();fg.nInterval=setInterval(fw,200)}dJ.SceneSetStart=dJ.SceneSetLast=a5.nCurrent;aS.clientOffset=a.getElementPosition(ho);b8("mouseDown");break}if(g0[eN]&&g0[eN].fnDown){g0[eN].fnDown.apply(bj,[o,hF])}return true};var y=function(hJ,hI){if(bk>1.2){hJ.FSI_allowEventDefault=true;return}var hD=gp.lastOffsetX-hI.x;var o=gp.lastOffsetY-hI.y;switch(eN){case 0:if(cc.enabled){aS.setRect(aS.left,aS.top,hI.x,hI.y);hm()}break;case 2:if(fg.bSuspended){fg.nTimeLastMove=fg.nTime=a.now();fg.nInterval=setInterval(fw,200);b8("mouseDown");fg.bSuspended=false}if(a5.nSceneSets<2){if(Math.abs(o)>3*Math.abs(hD)){hJ.FSI_allowEventDefault=true}}else{var hK=hI.y-dJ.y;var hH=dJ.SceneSetStart-Math.round(hK*a5.nSceneSets/bl.height);hH=ae(hH);if(hH!==dJ.SceneSetLast){fY(hH);dJ.SceneSetLast=hH}}hc(cD-(hI.x-hJ.FSI_start_x)/fB);dN=(hD<0)?-1:1;fg.nTimeLastMove=fg.nTime;break;default:if(eN<100){var hE=false;if(cc.enabled){var hG=cc.panPos.left;var hF=cc.panPos.top;cc.panPos.left-=hD*aC.scale;cc.panPos.top-=o*aC.scale;ca();hE=(hG!==cc.panPos.left||hF!==cc.panPos.top);if(!hE){aV(true);hJ.FSI_allowEventDefault=true}else{aV(false);hm()}}else{hJ.FSI_allowEventDefault=true}}}gp.lastOffsetX=hI.x;gp.lastOffsetY=hI.y;if(g0[eN]&&g0[eN].fnMove){g0[eN].fnMove.apply(bj,[hJ,hI])}};var ab=y;g3.enableAfterTouch=function(){if(K){K.enableAfterTouch.apply(this,arguments)}};g3.getCurrentPointerPos=function(){return K.getCurrentPos()};g3.blockMouseMove=function(hD,o){if(hD){ab=(o||a.fnDoNothing)}else{ab=y}K.setFnMove(ab)};var fw=function(){fg.nTime+=200;if(fg.nTime-fg.nTimeLastMove>400){cR()}};var cR=function(){if(fg.nInterval!==b){clearInterval(fg.nInterval);fg.nInterval=b}fg.bSuspended=true;gv()};var fU=function(hD,hH,hG){g3.onUserAction();if(!fu.bActive){aV(true)}var o=hD._FSI_Canceled;var hE=hD._FSI_Click;if(hE&&h){if(h.onClick(hD,hH)){hE=false}}cL.run("onStopDragging",[false]);de=false;f7=false;dk("mouseup",hD);if(o){if(eN===2){gv("pointer up - canceled")}return}switch(eN){case 0:if(cc.enabled){gD();if(!hE&&cc.maxScale>1){eR(gT)}hm()}break;case 1:if(gi===ax&&hf<=1){gB(0,0)}break;case 2:if(fg.nInterval){clearInterval(fg.nInterval);fg.nInterval=b}if(!hD._FSI_fromAfterTouch){eS(b,false)}else{var hF=dq(el,false);eo(hF,hF,1,1);gv("pointer up")}break}f0();if(hE){b2(hD,hH,hG)}if(g0[eN]&&g0[eN].fnUp){g0[eN].fnUp.apply(bj,[hD,hH])}};var bq=function(){return(eN===2||(eN===1&&hf>1))};var U=function(hH){if(eN===2){var hE=ev/bI;var hD=hH.x-dJ.x;var o=-hD/fB+cD;var hG=Math.round(o/hE)*hE;var hF=-(hG-cD)*fB;hH.x=hF+dJ.x}return hH};var b2=function(hD,hG){if(cg&&gt.getPluginParameter("autospin","preventClickZoomWhileSpinning",false,true)){return}if(dk("click",hD)===true){return}if(eN===0||(gH.clickZoomInAllMouseModes&&eN<100)){if(!e5){gB(0,0)}else{if(cc.maxScale>1){var hE=a.getElementPosition(ho);var o=hG.x-hE.left;var hF=hG.y-hE.top;fP(o*aC.scale,hF*aC.scale)}}}};var dk=function(hE,o){var hF=K.getInitialDownEvent();if(!hF||!hF.target||hF.target===ho){return false}var hD=hF.target;while(hD!==b&&hD!==g5&&hD.FSIHotspot===b){hD=hD.parentNode}if(hD&&hD.FSIHotspot){return f2(hE,hD,o)}return false};var gq=function(hE,hD,hH,hF){for(var hG in hH){if(hH.hasOwnProperty(hG)){hD[hG]=hE.getFloatParameter(hF+hG,hH[hG])}}};var eq=function(hE,hD,hH,hF){for(var hG in hH){if(hH.hasOwnProperty(hG)){hD[hG]=hE.getIntParameter(hF+hG,hH[hG])}}};var dv=function(hF,hE,hD,hG){for(var hH in hD){if(hD.hasOwnProperty(hH)){hE[hH]=hF.getStringParameter(hG+hH,hD[hH])}}};var w=function(hE,hD,hG,hF){for(var hH in hG){if(hG.hasOwnProperty(hH)){hD[hH]=hE.makeBool(hE.getStringParameter(hF+hH),hG[hH])}}};var dh=function(hD,o,hF,hE){var hG;if(hF&&hF.length>0){if(typeof(o[hF])!=="object"){o[hF]={}}hE=hE[hF];hG=o[hF]}else{hG=o}if(hE.strings){dv(hD,hG,hE.strings,hF)}if(hE.booleans){w(hD,hG,hE.booleans,hF)}if(hE.floats){gq(hD,hG,hE.floats,hF)}if(hE.integers){eq(hD,hG,hE.integers,hF)}};var L=function(){var o=function(hE){var hF=gH[hE];hE=hE.toLowerCase();for(var hG in hF){if(hF.hasOwnProperty(hG)){var hD=hE+hG.toLowerCase();if(gt.cfg[hD]===b){gt.cfg[hD]=hF[hG]}}}};o("camera");o("virtualSpace")};var bJ={strings:{dir:"",easingZoom:"easeOutCubic",easingSpin:"easeOutCubic",skin:"black",language:"english",backgroundColor:"#FFF",hotspotLineColor1:"#000000",hotspotLineColor2:"#FFFFFF",hotspotDotColor1:"#58a8ff",hotspotDotColor2:"#FFFFFF",hotspotCallbackFunction:b,fpxservertemplate:b,imagemattecolor:"FFFFFF",initialview:"",initialMouseMode:"auto",navWidth:"120",navHeight:"120",panLimits:"strict",inPlaceZoom:"true",documentZoom:"auto",hideUI:"false",spinDirectionImage:"right",progressBarVAlign:"bottom",progressBarHAlign:"center",MenuButtonOrder:b,urlLoadingAnimation:"/skins/resources/loading.svg"},booleans:{menubar:true,keepViewOnResize:true,useDevicePixelRatio:true,adaptiveUISize:true,drawCube:false,forceDraw3D:false,forceHotSpots:false,drawTable:false,drawGroundPlate:false,pellets:true,enableHotspots:true,decodeHTMLEntitiesInHotSpotTexts:false,enableZoom:true,noCanvas:false,useMaskedJPEGs:true,noNav:false,autoHideNav:true,autoDisablePointerActions:true,loadExactPreviewImagesAfterResize:false,preventImageTransparency:false,noSetLoop:false,noSceneLoop:false,initialViewPersistent:false,showPreviewWhileLoading:true,spinPreviewWhileLoading:true,showProgressbar:true,reverseSceneSets:false,autoDestroy:true,clickZoomInAllMouseModes:true},floats:{pelletsOpacity:0.15,fMouseSensitivity:1,desktopClickZoomScale:3,autoSpinSpeed:0,autoSpinInterval:0,tableDiameter:950,maxZoom:100,progressBarWidth:35,progressBarHeight:14},integers:{hotspotDotRadius:4,zoomPrecision:1,minInstanceSize:60,quality:-1},video:{strings:{skin:"black",base:"videos/",source:"",spinDirection:"right",sceneSet:0},integers:{captureFrames:120,frameOffset:0},floats:{captureOffsetStart:0,captureOffsetEnd:0,widthCorrectionFactor:1,heightCorrectionFactor:1,xCorrectionFactor:0,yCorrectionFactor:0}},camera:{strings:{position:"",targetPosition:"",armJointPosition:""},floats:{digitalCropFactor:1,focalLength:50,distanceToTableCenter:1500,heightAboveTable:b,heightTable:b,heightCamera:1000,targetHeightOffset:0,targetWidthOffset:0,shiftX:0,armLength:0,armAngleMeasureSetup:0,armAngleStart:0,armAngleEnd:0}},virtualSpace:{integers:{cubeSegments:4},strings:{position:""},floats:{cubeSizeX:100,cubeSizeY:100,cubeSizeZ:100,cubeLineWidth:1,baseRotationX:0,rotationXRange:180,rotationXSets:0,baseRotationY:0,rotationYRange:360,rotationYScenes:0,baseRotationZ:0,shiftX:0,shiftZ:0,shiftY:0}}};var cx=function(hD){if(!hD||typeof(hD)!=="object"){hD={}}hD.serverBase=gt.serverBase;dh(gt,hD,"",bJ);dh(gt,hD,"camera",bJ);dh(gt,hD,"virtualSpace",bJ);dh(gt,hD,"video",bJ);if(gH.enableHotspots){var o=gt.getUnrecognizedConfigNode("hotspots3d");dg(o)}cw="&effects=Matte("+encodeURIComponent(gH.imagemattecolor)+")"};g3.getHotSpots=function(){return gH.hotspots};g3.setHotspotCode=function(o){hl.arSpotsAtFrame=b;hl.hotSpotsAtThisFrame=b;hl.spinFrame=b;a5.bSetCameraPosition=false;ac.innerHTML="";dh(gt,gH,"camera",bJ);dh(gt,gH,"virtualSpace",bJ);Q();dg(o);hy();hg=true;dQ();hm()};var dg=function(hF){var hN={strings:{id:"",normalClass:"",hoverClass:"",activeClass:"",text:"",actionParameter:b,url:b,urlTarget:"_self",cssStyle:"",cssClass:"",icon:""},booleans:{interactive:false,rotateOnFocus:true,zoomOnFocus:true,focusOnClick:true},floats:{iconScaleX:1,iconScaleY:1,perimeterZoom:1,perimeterImageWidth:0,perimeterAngle:b,perimeterAngleRange:30,perimeterAngleFadeOut:10,perimeterAngleX:b,perimeterAngleXRange:30,perimeterAngleXFadeOut:10,perimeterAngleY:b,perimeterAngleYRange:30,perimeterAngleYFadeOut:10,verticalMarkerSize:100,horizontalMarkerSize:30,markerAngle:45,horizontalMarkerPosition:0,verticalMarkerPosition:0.5,perimeterDistance:b,perimeterTerminator:b,x:0,y:0,z:0,focusRadius:0.25,focusAngleX:b,focusAngleY:b}};ap={};var hH=[];var hG;var hL=new a.Config();var hE,hK,hM;var hJ,hD,hO;if(typeof(gt.cfg.hotspots)==="object"&&gt.cfg.hotspots.length>0&&typeof(gt.cfg.hotspots.join)==="function"){dE.log("Using HotSpots from JS parameters");gH.hotspots={};gH.hotspots.defaults={};gH.hotspots.points=new Array(gt.cfg.hotspots.length);hE=gt.cfg.hotspotsdefaults;if(hE===b){hE=gt.cfg.hotspotdefaults}if(hE!==b){hL.makeObjectPropertiesLowerCase(hE);hL.cfg=hE;hG={};dh(hL,hG,"",hN);for(hD in hN){if(hN.hasOwnProperty(hD)){hK=hN[hD];for(hO in hK){if(hK.hasOwnProperty(hO)){if(hG[hO]!==b){hK[hO]=hG[hO]}}}}}hE=hG;hG={};for(hD in hE){if(hE.hasOwnProperty(hD)){if(hE[hD]!==b){hG[hD]=hE[hD]}}}gH.hotspots.defaults=hG}for(hJ=0;hJ<gt.cfg.hotspots.length;hJ++){hM=gt.cfg.hotspots[hJ];hL.makeObjectPropertiesLowerCase(hM);hL.cfg=hM;hM={};dh(hL,hM,"",hN);gH.hotspots.points[hJ]=hM}}else{if(hF){hF=hF.firstChild;while(hF){if(hF.nodeType!==1){hF=hF.nextSibling;continue}var hI=hF.nodeName.toLowerCase();switch(hI){case"hotspot":hH.push(hF);break;case"defaults":hG=eH(hL,hF,hN);break}hF=hF.nextSibling}}if(hG!==b){for(hD in hN){if(hN.hasOwnProperty(hD)){hK=hN[hD];for(hO in hK){if(hK.hasOwnProperty(hO)){if(hG[hO]!==b){hK[hO]=hG[hO]}}}}}hE=hG;hG={};for(hD in hE){if(hE.hasOwnProperty(hD)){if(hE[hD]!==b){hG[hD]=hE[hD]}}}}for(hJ=0;hJ<hH.length;hJ++){hH[hJ]=eH(hL,hH[hJ],hN)}gH.hotspots={};gH.hotspots.points=hH;gH.hotspots.defaults=hG}if(gH.hotspots&&gH.hotspots.points){dE.log("HotSpots parsed: "+gH.hotspots.points.length);eQ=(gH.hotspots.points.length>0)}else{eQ=false}if(gH.forceHotSpots&&!eQ){eQ=true;gH.hotspots={};gH.hotspots.defaults={};gH.hotspots.points=[]}};var eH=function(hD,hH,hG){var o=a.utils.attributes2parameters(hH);hD.makeObjectPropertiesLowerCase(o);hH=hH.firstChild;while(hH){if(hH.nodeType!==1){hH=hH.nextSibling;continue}var hF=hD.getValueFromXMLNode(hH,"");o[hF.name]=hF.value;hH=hH.nextSibling}hD.cfg=o;var hE={};dh(hD,hE,"",hG);if(gS&&hD.cfg.hse_id!==b){ap[hD.cfg.hse_id]=hE}return hE};var eb=function(){cx(gH);if(gt.cfg.hotspoteditor===true){gS=true}gt.result=gH;Q()};var gR=function(o,hM){dE.log("Video Dimension: "+o+" x "+hM+"px");var hI=fz.isCropped();var hJ=false;var hD=fz.getCropMargins();var hG=aD.width;var hL=hG/o;var hK=hM*hL;var hH=Math.round((aD.height-hK)/2);if(hH>hD.top){hJ=true;hD.top=hH}if(hH>hD.bottom){hJ=true;hD.bottom=hH}if(hJ){dE.log("Cropping images to match video dimension ("+hH+"px)");fz.setCropValues(hD.left+"px",hD.top+"px",hD.right+"px",hD.bottom+"px");q()}if(hI){hD=fz.getCropMargins();hD.scaleRectInt(1/hL);hH=Math.round(hH/hL);fy.left=hD.left;fy.right=hD.right;fy.top=hD.top-hH;fy.bottom=hD.bottom-hH}else{fy.setRect(0,0,0,0)}bE=b;bW();var hE=o-fy.left-fy.right;var hF=hM-fy.top-fy.bottom;c1={width:o,height:hM,croppedWidth:hE,croppedHeight:hF};l(hE,hF);d3();if(cB&&gH.pellets&&gH.pelletsOpacity>0){cz()}};var l=function(hM,h1,hP){if(!gH||!gH.video||aD===b||!gH.video.widthCorrectionFactor){return}var hT,hW;var hN;var hL;var hO,hY,hV,hG;if(!i){hV=bl.width;hG=bl.height}else{hV=hr;hG=c2}var h2=hM/h1;var hK=hV/hG;var hJ,o;if(h2>hK){hJ=hV}else{o=hG}bW();hT=fz.getFloatRect();var hQ=hT.getRange();var hS=a.getFSIServerImageDim(aD.width,aD.height,hJ,o,hQ,true);hO=hS.width;hY=hS.height;if(hO>e2.width||hY>e2.height){hO=e2.width;hY=e2.height}bS=Math.min(hx,Math.round(hO));hN=Math.round((hV-hO)/2);hL=Math.round((hG-hY)/2);ad.widthForRatio=hM;ad.heightForRatio=h1;ad.imageWidth=hO;ad.imageHeight=hY;ad.imageX=hN;ad.imageY=hL;if(aC.scale===1){ad.imageWidthAbsolute=ad.imageWidth;ad.imageHeightAbsolute=ad.imageHeight;ad.imageXAbsolute=(aC.drawOffsetX+ad.imageX-(ad.imageWidth*aC.scale-ad.imageWidth)/2)/aC.scale;ad.imageYAbsolute=(aC.drawOffsetY+ad.imageY-(ad.imageHeight*aC.scale-ad.imageHeight)/2)/aC.scale}ad.videoWidth=hO*gH.video.widthCorrectionFactor;ad.videoHeight=hY*gH.video.heightCorrectionFactor;ad.videoX=hN+hO*gH.video.xCorrectionFactor-(hO*gH.video.widthCorrectionFactor-hO)/2;ad.videoY=hL+hY*gH.video.yCorrectionFactor-(hY*gH.video.heightCorrectionFactor-hY)/2;if(!hP){aN=bS;eF(x)}eF(bm);if(!hP){hT=fz.getImageRect();var hU;if(hT.width()>0){hU=aD.width/hT.width()}else{hU=0}var hH=Math.ceil(hU*x.imageWidth);if(aD.__levelsCalculatedFor!==hH){aD.__levelsCalculatedFor=hH;dE.log("Calculating image levels for image base width: "+hH+" px");dE.log("Source image dimension: "+aD.width+" x "+aD.height);var hR=Math.ceil(1.1*hH);bB=[];if(hH>0){if(aD.levels&&aD.levels.length>0){var h0=[];for(hW=0;hW<aD.levels.length;hW++){var hF=parseInt(aD.levels[hW].width);if(!isNaN(hF)){if(hF>hR){h0.push(hF)}else{break}}}if(dE.on){dE.log("Matching server side image levels: "+h0.join(", "))}if(h0.length>0){h0.push(hH);var hE=h0[0];bB.push(hE);for(hW=1;hW<h0.length;hW++){var hX=h0[hW];var hI=hE/hX;while(hI>2.5){hE/=2;hI=hE/hX;if(hE>hR){bB.push(Math.round(hE))}}bB.push(hX);hE=hX}bB.pop();h0.pop();bB.reverse()}if(dE.on){var hZ=(bB.length-h0.length);if(hZ===0){dE.log("Using server side image levels only.")}else{dE.log("Using "+hZ+" additional virtual image levels.")}}}else{dE.log("No image level information from server. Using virtual image levels.");var hD=aD.width;var h3=aD.height;if(hR>0){while(hD>hR&&h3>0){bB.push(hD);hD=Math.round(hD/2);h3=Math.round(h3/2)}}bB.reverse()}}if(dE.on){dE.log("Using image levels: "+bB.join(", "))}}br()}switch(gi){case fD:ad.maxPanReferenceWidth=bl.width*aC.scale;ad.maxPanReferenceHeight=bl.height*aC.scale;break;case ax:ad.maxPanReferenceWidth=0;ad.maxPanReferenceHeight=0;break;default:ad.maxPanReferenceWidth=bm.imageWidth;ad.maxPanReferenceHeight=bm.imageHeight;break}};var eF=function(hD){for(var hE in ad){if(ad.hasOwnProperty(hE)){hD[hE]=ad[hE]}}};var az=function(){var o=gH.video.source;if(o&&o.indexOf("[static]")===0&&gH.serverBase!==b){var hD=gH.serverBase;hD=hD.split("/");hD.pop();hD=hD.join("/");o=o.replace(/\[static]\/*/,hD+"/static/")}return o};this.start=function(){df=a.now();fJ=0;ep();if(cZ&&!dM){cZ.destroy();cZ=b}if(!gA){return}eD()};var eD=function(){gH={};gt.loadConfigs()};var d9=function(){eb();am();if(cL.isset("onConfigsReady")){cL.runPersistent("onConfigsReady",[a.utils.cloneObject(gt.cfg)])}var hD=[];if(typeof(gt.cfg.invisibleloadingpurposes)==="string"){hD=gt.cfg.invisibleloadingpurposes.split(",")}aT.setNotVisualPurposes(hD);if(gt.hasPlugin("autospin")){var hH=gt.getPluginParameter("autospin","speed",4);if(hH!==b){hH=parseFloat(hH);if(!isNaN(hH)){gH.autoSpinSpeed=hH}}var o=gt.getPluginParameter("autospin","interval");if(o!==b){o=parseInt(o);if(!isNaN(o)){gH.autoSpinInterval=o}}}if(gt.hasPlugin("fullscreen")&&!gt.hasPlugin("resize")){gt.addPluginFromString("resize")}var hJ=gH.enableZoom;i=(a.BrowserSupports.canvas());cc.enabled=false;s=false;if(hJ&&a.BrowserSupports.canvas()){var hF=""+gH.inPlaceZoom;switch(hF.toLowerCase()){case"auto":cc.enabled=(!a.isMobileDevice);break;default:cc.enabled=gt.makeBool(hF,true);break}hF=""+gH.documentZoom;switch(hF.toLowerCase()){case"auto":s=(a.isTouch);break;default:s=gt.makeBool(hF,true);break}}d=false;hF=""+gH.hideUI;hF=hF.toLowerCase();if((a.isMobileDevice&&hF==="onmobiledevices")||(!cc.enabled&&hF==="ifnoinplacezoom")||gt.makeBool(gH.hideUI)===true){d=true}bv=(!gH.noNav&&!d&&cc.enabled);hk=!gt.makeBool(gH.menubar,true);if(i){e1=b}else{e1=a._FSITouchZoomInstance}if(i&&gt.hasPlugin("resize")){if(!g6){var hE=gZ=a.addCustomEvent(g5,"FSIElementDimension",bd);a.setCustomEventListenerProperty(hE,"treshold",100);g6=true}}else{if(g6){a.removeCustomEvent(g5,"FSIElementDimension",bd);g6=false}}if(gH.noCanvas){i=false}var hI=a9;var hG=gt.cfg.customskinclass;if(M&&M.paramCustomSkinClass!==hG){M.destroy()}if(hG!==b){if(!M||M.paramCustomSkinClass!==hG){M=new a.CustomSkinClass(bj,hG,g3,hI)}}else{hI()}};var a9=function(hD){if(gt.makeBool(gH.urlLoadingAnimation,true)&&ce!==gH.urlLoadingAnimation){ce=gH.urlLoadingAnimation;var o=gt.getReloadPath(gt.locationFSIViewer,gH.urlLoadingAnimation);gt.loadFile(o,gs,"text/html; charset=utf-8")}else{v()}};var gs=function(o){var hD=o.responseText;if(gj){gj=b}if(typeof(hD)==="string"&&hD.length>0){a.utils.addViewerClassCSSRule(".fsi-viewer-loading-animation","position:absolute;padding:15px;z-index:10;left:100%;top:0%;transform:translate(-100%,0%);pointer-events:none;");gj=document.createElement("div");a.addClass(gj,"fsi-viewer-loading-animation");gj.innerHTML=hD}v()};var e3=function(){if(!gj||aR){return}di=gj;if(di){aR=true;g5.appendChild(di)}};var hh=function(){if(aR&&di&&di.parentNode){a.removeChild(di.parentNode,di);di=b}aR=false};var ee=function(){var o="/linkeditor/js/fsilinkeditor.js";var hD="fsiviewer.js";var hE=a.utils.getScriptPath(hD,2);dE.log("Loading LLoading language fileinkEditor: "+hE+o);a.loadJavascript(hE+o,dZ,bj,gE,hE)};var gE=function(o,hE,hD){h=new a.LinkEditor(bj,g3,g5,{});h.init(dZ,hD,v)};var v=function(){if(gt.hasPlugin("linkeditor")&&!h){ee();return}e3();var hD=gH.skin;if(hi!==hD){dM=false;hi=hD}dE.log("Loading skin: "+hD+".css");if(gU){gU.remove();gU=b}if(!dM){var hE=a3.className;a3.name=hD;a3.className="fsi-skin-"+a3.name;g5.className="fsi-root fsi-viewer-root "+a3.className;var o=[{file:"resources/fsi-core.css",nPriority:1},{file:"resources/fsi-viewer-core.css",nPriority:5}];gU=a.utils.loadSkinCSS(hD,bj,dd,10,o);if(hE!==a3.className){cL.runPersistent("onSkinChanged",[a3.className,hE])}}else{dd(dM)}};this.getSkinClassName=function(){return a3.className};var gg=function(){if(fQ.bEnabled){return}fQ.bEnabled=true;bz=b;if(typeof(gH.initialview)==="string"&&gH.initialview.length>0){var hD=gH.initialViewPersistent;gH.initialViewPersistent=true;bj.resetView(false);gH.initialViewPersistent=hD}else{bj.resetView(false)}fQ.hideUI=gt.makeBool(gt.cfg.hideuiindemomode,true);a.addClass(g5,"fsi-demo-mode");a.addEvent(aw,"click",bh,true);if(fQ.hideUI){if(cZ){cZ.show(false);cF=0}if(gn){gn.enable(false,true)}}var o=gt.cfg.demotooltip;if(!a.isMobileDevice&&typeof(o)==="string"&&o.length>0){fQ.bToolTip=true;fQ.strTip=o;a.addEvent(aw,"mousemove",hp);a.addEvent(aw,"mouseout",fS)}else{fQ.strTip="";fQ.bToolTip=false}cL.runPersistent("onEnterDemoMode")};var hp=function(o){if(!fQ.oToolTip){if(g3.getToolTip()){fQ.oToolTip=g3.getToolTip();fQ.bDestroyToolTip=false}else{fQ.oToolTip=new a.ToolTip(g5);fQ.oToolTip.setContent({});fQ.bDestroyToolTip=true}}var hD=a.getElementClientPos(g5);fQ.oToolTip.show(fQ.strTip,null,o.clientX-hD.left,o.clientY-hD.top,b,100,true)};var fS=function(){if(fQ.oToolTip){fQ.oToolTip.hide()}};var cK=function(){if(!fQ.bEnabled){return}a.removeClass(g5,"fsi-demo-mode");a.removeEvent(aw,"click",bh);if(fQ.hideUI){if(cZ){cZ.show(true);cF=bM}if(gn){gn.enable(true,false)}}if(fQ.bToolTip){a.removeEvent(aw,"mousemove",hp);a.removeEvent(aw,"mouseout",fS);fQ.oToolTip.hide();if(fQ.bDestroyToolTip){fQ.oToolTip.destroy();fQ.oToolTip=b}}fQ.bEnabled=false;fQ.hideUI=false;cL.runPersistent("onExitDemoMode")};var bh=function(){if(!fQ.bEnabled){return}var hD=gt.cfg.demourl;var hE=gt.cfg.demourltarget;if(!hE){hE="_self"}var o=cL.run("onClickDemoMode",[hD,hE]);if(o===false){return}if(hD==="no action"){return}if(hD==="enter fullscreen"){fQ.bRestore=true;if(gt.hasPlugin("fullscreen")){g3.clickMenuButton("ToggleFullScreen",b,true)}}else{window.open(hD,hE)}};var dd=function(o){if(gt.cfg.demourl){gg()}else{cK()}gU=b;if(o){dE.log("Skin loaded successfully. ");c0()}else{dE.error("Failed to load skin.");eJ={hMenuBar:0};a3._nameParsedLast=b}em()};this.showMenuButton=function(hD,o){if(cZ){cZ.showButton(hD,o)}};this.getMenuHeight=function(hD){var o=bM;if(hD!==b){switch(hD){case"navWindow":if(eJ.bFloatingNavWindow){o=0}break}}return o};var c0=function(){if(a3._nameParsedLast!==a3.name){a3._nameParsedLast=a3.name;var hI=document.createElement("div");hI.style.position="absolute";hI.style.top="0px";hI.style.left="0px";hI.style.width="1px";hI.style.height="1px";hI.style.overflow="hidden";hI.style.visibility="hidden";var hD=document.createElement("div");hI.appendChild(hD);g5.appendChild(hI);var hK={};var hF=function(hS,hP,hN,hM,hO){var hL,hR;if(hK[hS]===b){hD.className=hS;hR=hK[hS]=getComputedStyle(hD,hO)}else{hR=hK[hS]}hL=hR.getPropertyValue(hP);if(hM){hL=hL.replace(/^[^{]*/g,"");hL=hL.replace(/[^}]*$/g,"");hL=hL.replace(/\\"/g,'"');if(hL.length>0){try{hL=JSON.parse(hL)}catch(hQ){a.console.error("ERROR parsing JSON from CSS selector '"+hS+"' property '"+hP+"'.");a.console.error(hQ.message)}}else{hL={}}}if(hL===b){hL=hN}return hL};eJ=hF("fsi-ui-info","content",b,true,":before");eJ.bFloatingMenuBar=gt.makeBool(eJ.floatingMenuBar);eJ.bFloatingNavWindow=gt.makeBool(eJ.floatingNavWindow);eJ.hMenuBar=hF("fsi-ui-menu-bar","height");a3.urlLogo=hF("fsi-ui-logo-image","background-image");if(typeof(a3.urlLogo)=="string"){var hH=/url\(\s*["']?([^"')]*)["']?\s*\)/;var o=hH.exec(a3.urlLogo);if(o&&o.length>0){a3.urlLogo=o[1]}}a3.navFrameBorderColor=hF("fsi-ui-nav-frame","border-left-color","red");a3.navFrameBackgroundColor=hF("fsi-ui-nav-frame","background-color","rgba(255,255,255,0.5)");aA=hF("fsi-ui-select-frame","border-left-color","red");bu=hF("fsi-ui-select-frame","background-color","rgba(255,255,255,0.25)");a3.oProgressBarStyle={};a3.oProgressBarStyle.color=hF("fsi-ui-progressbar","color","#CCC");a3.oProgressBarStyle.background=hF("fsi-ui-progressbar","background-color","#FFF");a3.oProgressBarStyle.border=hF("fsi-ui-progressbar","border-left-color","#CCC");a3.oProgressBarStyle.text=hF("fsi-ui-progressbar-text","color","#555");var hJ=16;var hE=8;if(eJ){if(!isNaN(eJ.baseSize)&&eJ.baseSize>0){hJ=eJ.baseSize}if(!isNaN(eJ.baseEnlargement)&&eJ.baseEnlargement>0){hE=eJ.baseEnlargement}}else{eJ={}}var hG=1;if(a.isMobileDevice&&gH.adaptiveUISize===true){hG=a.getDevicePixelRatio()}ai=Math.round(hJ+hE*hG);eJ._baseSkinSize=ai;g5.removeChild(hI)}g5.style.fontSize=ai+"px"};var em=function(){if(typeof(eJ.hMenuBar)!="string"||eJ.hMenuBar.length<1||isNaN(parseFloat(eJ.hMenuBar))){cW=false}else{cW=(d!==true&&!hk)}j()};var ea=function(){if(!cW){cZ.removeDomElement()}bM=cZ.getHeight();if(eJ&&eJ.bFloatingMenuBar){cF=0}else{cF=bM}if(fQ.bEnabled&&fQ.hideUI){cZ.show(false);cF=0}am();by()};this.showMenuToolTip=function(hE,hD,o,hF){if(cZ){cZ.showToolTip(hE,hD,o,hF)}};this.hideMenuToolTip=function(){if(cZ){cZ.hideToolTip()}};var j=function(){if(fZ===b){if(a.getViewerLocation()!==b){fZ=new a.ToolTip(g5)}}fT();if(cZ===b||!dM){if(cZ){cZ.destroy()}cZ=new a.MenuBar(g3,a3,g5,ea,cP.oAPI.oMenuCommands);cZ.setCallbacks(cL)}else{if(dM&&cZ){cZ.setInterface(g3)}ea()}};var fT=function(){if(fZ!==b&&gH){gt.loadLanguageFile(bx,gH.language,gk,dE)}};var gk=function(hD,o){dR=hD;cL.runPersistent("onLanguageData",[dR]);fZ.setContent(dR)};var eV=function(){if(!cZ){return}var hI;var hF=g3.arMenuButtons=[];hF.push({cmd:"Reset"});if(cc.enabled){hF.push({cmd:"ZoomOut",enabled:false});hF.push({cmd:"ZoomIn"})}if(gt.hasPlugin("mousemodes")||gt.hasPlugin("mousemodeselect")){var hD=[0,1];if(he.length>1){hD.push(2)}if(gt.hasPlugin("measure")){hD.push(100)}var hK={};for(hI=0;hI<hD.length;hI++){hK[hD[hI]]=true}hD=hD.join(",");var hG=gt.getPluginParameter("mousemodes","sequence",hD);var hH=(hG!==hD);hG=hG.split(",");if(hH){var hM={};for(hI=0;hI<hG.length;hI++){hM[hG[hI]]=true}for(var hL in hK){if(hK.hasOwnProperty(hL)){if(!hM[hL]){hG.push(hL)}}}}var hJ={};for(hI=0;hI<hG.length;hI++){hJ[hG[hI]]=gt.getPluginParameter("mousemodes","mode"+hG[hI],true,true)}if(!cc.enabled){hJ[0]=hJ[1]=false}var hE=function(hN){if(!hK[hN]||!hJ[hN]){return}var hO=true;if(hN===1){hO=(gi>fb)}hF.push({cmd:"MouseMode_"+hN,groupID:"MouseMode",enabled:hO})};for(hI=0;hI<hG.length;hI++){hE(parseInt(hG[hI]))}}if(gt.hasPlugin("maxzoom")&&cc.enabled){hF.push({cmd:"MaxZoom"})}if(eQ){if(!gt.hasPlugin("hotspots")){gt.addPluginFromString("hotspots")}if(gt.getPluginParameter("hotspots","button","true",true)){hF.push({cmd:"HotSpots",bCheckButton:true})}ds=gt.getPluginParameter("hotspots","visible","true",true)}if(gH.autoSpinSpeed!==0&&gt.hasPlugin("autospin")&&gt.getPluginParameter("autospin","button",true,true)){hF.push({cmd:"ToggleAutoSpin",bCheckButton:true})}var o=false;if(gt.hasPlugin("fullscreen")){o=true;a.FullScreen.addChangeEvents(window,cY,a4);hF.push({cmd:"ToggleFullScreen",bCheckButton:1})}cZ.addButtons(hF,gH.MenuButtonOrder);cL.run("onInitMenu");if(o&&eh){cZ.setButtonPressed("ToggleFullScreen",true)}if(eQ&&ds){cZ.setButtonPressed("HotSpots",true)}};var fL=function(){var o;if(!s){o=Math.round(Math.max(1,hC)*Math.max(bl.width,bl.height))}else{o=Math.round(Math.max(1,hC)*Math.max(screen.width,screen.height))}fH=Math.min(1024,Math.max(2,Math.ceil(o/3/128))*128)};var by=function(){if(typeof(gH.virtualSpace)!="object"){return}var hF=gt.parsePositionParameter(gH.virtualSpace.position);if(hF!==b){gH.virtualSpace.shiftX=hF.x;gH.virtualSpace.shiftY=hF.y;gH.virtualSpace.shiftZ=hF.z}if(gt.cfg.cameraarmanglestart!==b){if(gt.cfg.cameraarmangleend!==b){gH.virtualSpace.rotationXRange=gH.camera.armAngleEnd-gH.camera.armAngleStart}}if(gH.useDevicePixelRatio){hC=a.getDevicePixelRatio()}else{hC=1}g3.devicePixelRatio=hC;fL();fz=new a.CroppedImage();fz.setCropFromConfig(gt.cfg);switch(gH.panLimits){case"loose":gi=ax;break;case"medium":gi=fb;break;default:gi=fD;break}p();fh=true;if(gH.noSceneLoop){hv=a7}else{hv=e8}J=gH.virtualSpace.rotationYRange*-Math.PI/180;a5.rotXRange=gH.virtualSpace.rotationXRange;a5.rotXGradPerSet=(a5.rotXRange/(a5.nSceneSets-1))*Math.PI/180;if(fO!==b){var hE=fO;fO=b;bj.changeImage.apply(bj,hE);return}var hD=gH.dir;if(hD===b||hD.length===0){hD=gt.cfg.images3durl}if(!hD||hD.length===0||gt.makeBool(gt.cfg.ignoreimagelists)){var o=gt.getImageList();if(o){bX(o.arImages,o.oXML,o)}else{return dj("failed to load image list")}}else{o=gt.loadImageList(hD,bX,cr);if(dE.on&&typeof(o._url)=="string"){dE.log("Loading image list: "+o._url)}}};var bX=function(hD,hE){if(!hD||hD.length<1){dE.error("Failed to load image list.");return dj("image list is empty")}d8();he=hD;bI=ak=hD.length;a5=gt.parseSceneSets(he.length,false);dE.log("Image list ready ("+he.length+" images)");if(he.length>0){if(gt.cfg.fpxwidth!==b&&gt.cfg.fpxheight!==b){var o={};o.width=parseInt(gt.cfg.fpxwidth);o.height=parseInt(gt.cfg.fpxheight);b1(null,o)}else{gt.loadImageInfo(he[0],b1)}}else{bC()}};var cQ=function(){var o={};o.angle=gH.camera.armAngleStart;o.stepAngle=gH.virtualSpace.rotationXRange/(a5.nSceneSets-1);return o};var e4=function(){if(!ec||a5.nSceneSets<1){return}if(a5.bSetCameraPosition){return}a5.bSetCameraPosition=true;var hJ=new THREE.Vector3();var hD=new THREE.Vector3();var hO=new THREE.Vector3();var hM=new THREE.Group();var hE=new THREE.Group();hM.add(hE);var hP=new THREE.Object3D();hE.add(hP);var hI=180/Math.PI;var hT;var hU=dT.targetObj.position;hE.rotation.set(0,0,0);hO.set(0,hU.y,hU.z);if(gt.cfg.cameraarmlength===b){hT=dT.camera.position.distanceTo(hU);gt.cfg.cameraarmlength=hT}else{hT=gH.camera.armLength}var hL=gt.parsePositionParameter(gH.camera.armJointPosition);if(hL===b){hE.position.set(hU.x,hU.y,hU.z);gt.cfg.cameraarmjointposition=hU.x+","+hU.y+","+hU.z}else{hE.position.set(hL.x,hL.y,hL.z)}hE.rotation.x=gH.camera.armAngleMeasureSetup/hI;hM.rotation.set(0,0,0);hP.rotation.set(0,0,0);hP.position.set(0,0,hT);hM.updateMatrixWorld();hD.setFromMatrixPosition(hP.matrixWorld);var hS=cQ();var hR=hS.angle;var hK=hS.stepAngle;if(gH.reverseSceneSets){hR+=gH.virtualSpace.rotationXRange;hK=-hK}dE.log("Calculated Camera Positions:");dE.log("----------------------------");var o=180/Math.PI;for(var hN=0;hN<a5.nSceneSets;hN++){var hF=a5.arSets[hN];hF.cameraArmAngle=hR;hE.rotation.x=hR/hI;hM.updateMatrixWorld();hJ.setFromMatrixPosition(hP.matrixWorld);hF.posCamera=new THREE.Vector3(dT.camera.position.x+hJ.x-hD.x,dT.camera.position.y+hJ.y-hD.y,dT.camera.position.z+hJ.z-hD.z);hJ.x=0;hF.xAngleToTarget=hO.angleTo(hJ)-Math.PI/2;hF.xAngleToTargetDeg=hF.xAngleToTarget*o;if(dE.on){dE.log("SceneSet "+(hN+1)+", arm angle "+hR+"°, angle to target: "+hF.xAngleToTargetDeg+"°, position (x,y,z): "+hF.posCamera.x+", "+hF.posCamera.y+", "+hF.posCamera.z)}if(eQ){hF.visibleHotSpots={};for(var hQ=0;hQ<gH.hotspots.points.length;hQ++){var hG=gH.hotspots.points[hQ];var hH=1;if(hG.perimeterAngleX!==b){var hV=Math.abs(hG.perimeterAngleX-hF.xAngleToTargetDeg);if(hV>180){hV=Math.abs(360-hV)}if(hV<hG.perimeterAngleXRange){if(hV>hG.perimeterAngleXRange-hG.perimeterAngleXFadeOut){hH=(hG.perimeterAngleXRange-hV)/hG.perimeterAngleXFadeOut}}else{hH=0}hF.visibleHotSpots[hG.FSIHotspotID]=hH}else{hF.visibleHotSpots[hG.FSIHotspotID]=1}}}hR+=hK}};var dV=function(){if(a5.bDefault){return}var hG=100000000;var hL=0;var hH,hF,hK;var hN;if(dE.on){hN=a.utils.cloneObject(a5.arSets)}var hM={};for(hH=0;hH<a5.arSets.length;hH++){hK=a5.arSets[hH].arScenes;for(hF=0;hF<hK.length;hF++){var hI=hK[hF]=hK[hF]-1;hM[hI]=he[hI]}}var hJ=[];var hE=e.length;for(var hD in hM){if(hM.hasOwnProperty(hD)){hJ.push(hM[hD]);hM[hD]=hE;hE++}}for(hH=0;hH<a5.arSets.length;hH++){hK=a5.arSets[hH].arScenes;for(hF=0;hF<hK.length;hF++){hK[hF]=hM[hK[hF]]}hG=Math.min(hG,hK.length);hL=Math.max(hL,hK.length)}if(a5.arSets[0].arScenes.length>0){a5.bDefault=false;a5.quantizeMin=hG;a5.quantizeMax=a5.quantizeMaxImages=hL;if(dE.on){dE.log('Using SceneSets Parameter: "'+gt.cfg.scenesets+'"');dE.log("Parsed SceneSets:");for(hH=0;hH<hN.length;hH++){dE.log("Scene "+(hH+1)+": "+hN[hH].arScenes.join(", "))}}he=hJ;if(a5.arSets.length>1){if(hG!==hL){a5.bQuantize=true}if(dL!==b&&dL>0){a5.quantizeMax=Math.max(a5.quantizeMax,dL);if(hL!==a5.quantizeMax){a5.bQuantize=true}}}}else{a5.bDefault=true;a5.bHasMultipleSets=false;dE.error('Invalid SecenSet definition: "'+gt.cfg.scenesets+'"')}};var bg=function(){var hF=100000000;var o=0;for(var hE=0;hE<a5.arSets.length;hE++){var hD=a5.arSets[hE].arScenes;hF=Math.min(hF,hD.length);o=Math.max(o,hD.length)}return{min:hF,max:o}};var f8=function(){var hG,hJ;var hD=a5.quantizeMax;for(var hI=0;hI<a5.arSets.length;hI++){if(hI===a5.nVideoSet){continue}var hH=a5.arSets[hI].arScenes;if(hH.length<hD){var o=hH.length;a5.arSets[hI].fQuantizeFactor=hD/o;var hE=o-1;var hF=new Array(hD);for(hG=0;hG<hD;hG++){hJ=(hG*hE/(hD-1));hF[hG]=hH[Math.round(hJ)]}a5.arSets[hI].arScenes=hF}else{a5.arSets[hI].oSpinPositions=false}}};var bc=function(){var hG,hF,hH,hE,hL;if(a5.bDefault){return}for(hG=0;hG<a5.arSets.length;hG++){if(hG===a5.nVideoSet){continue}var hM=a5.arSets[hG];var hJ=hM.arScenes;var hK=hJ.length;hL=hE=b;for(hF=0;hF<hK;hF++){hH=hJ[hF];if(hE===b||hE>hH){hE=hH}if(hL===b||hL<hH){hL=hH}}hM.minScene=hE;hM.maxScene=hL;hM.sceneRange=hL-hE;var hD=hM.sceneRange+1;var o=hM.oSpinPositions={};var hI=o.arPositions={};for(hF=0;hF<hK;hF++){hH=hJ[hF];hI[hH]=(hH-hE)/hD}}};var dj=function(o){hh();b6("default");if(cZ){cZ.setEnabled(false)}cL.run("onInitFailed",[o])};var b1=function(hD,o){if(!o||!o.width||isNaN(o.width)){return dj("Failed to load image info")}aD=o;aD.transparency=gt.makeBool(aD.alpha);aD.width=parseInt(aD.width);aD.height=parseInt(aD.height);if(gH.fpxservertemplate!==b){fm.renderer=gH.fpxservertemplate}if(gH.headers!==b){fm.headers=gH.headers}dW=(aD.transparency&&!gH.preventImageTransparency);if(dW){if(i){bA=gH.useMaskedJPEGs;if(gt&&(gt.cfg.fpxservertemplate==="png"||gt.cfg.imageformat==="png")){bA=false}}else{}}hn=(!dW||!bA);if(typeof(aD.levels)=="object"&&typeof(aD.levels.sort)=="function"){aD.levels.sort(aU)}else{aD.levels=b}fz.setSourceDimension(aD.width,aD.height);q();l(e2.width,e2.height);d3();bC()};var aU=function(hD,o){return o.width-hD.width};var d3=function(){if(fz.isCropped()){var hD=fz.getImageRect();var o=hD.width()/ad.imageWidth;aY.cropScaleX=aD.width/hD.width();aY.cropScaleY=aD.height/hD.height();aY.x=(hD.left+hD.width()/2-aD.width/2)/o;aY.y=(hD.top+hD.height()/2-aD.height/2)/o}else{aY.cropScaleX=1;aY.cropScaleY=1;aY.x=0;aY.y=0}};var q=function(){var o;if(fz.isCropped()){o=fz.getPixelRangeRect();e2.width=o.right;e2.height=o.bottom}else{e2.width=aD.width;e2.height=aD.height}};var bC=function(){if(typeof(a.Easing[gH.easingZoom])==="function"){eM=a.Easing[gH.easingZoom]}else{eM=a.Easing.easeOutCubic}if(typeof(a.Easing[gH.easingSpin])==="function"){dU=a.Easing[gH.easingSpin]}else{dU=a.Easing.easeOutCubic}if(typeof(gt.cfg.fullscreenelement)!="undefined"){dK=gt.cfg.fullscreenelement}else{dK=aw}gP();ec=false;bR=false;var o=true;if(a.BrowserSupports.canvas()){if(gH.forceDraw3D||gH.drawCube||gH.drawGroundPlate||gH.drawTable){bR=ec=true}if(!ec&&gH.enableHotspots){if(gH.hotspots&&gH.hotspots.points&&gH.hotspots.points.length>0){ec=true}}if(ec&&cL.isset("on3DWorldChanged")){aM=f6}else{aM=false}var hD="js/three_custom_min.js";if(a.getViewerLocation()!==b){hD=a.getViewerLocation()+"/applications/viewer/"+hD}o=false;if(ec){if(typeof(window.THREE)=="object"){o=true}else{if(!a.loadJavascript(hD,dZ,bj,fa)){o=true;ec=false}}}else{a.releaseLoadJavascript(hD,dZ);o=true}}if(!ec){bR=false}if(o){dF()}};var fa=function(){if(typeof(window.THREE)!="object"){ec=false}if(!ec){bR=false}dF()};var dF=function(){if(gH.video.spinDirection&&gH.video.spinDirection.toLowerCase()==="left"){gH._reverseVideoDirection=true}if(gH.spinDirectionImage!==b){if(gH.spinDirectionImage.toLowerCase()==="left"){gH._reverseImageDirection=true}}else{gH._reverseImageDirection=gH._reverseVideoDirection}if(!a5.bDefault){if(gH._reverseImageDirection){for(var o=0;o<a5.arSets.length;o++){a5.arSets[o].arScenes.reverse()}gH._reverseImageDirection=false}if(gH.reverseSceneSets){a5.arSets.reverse()}}if(gH._reverseImageDirection){he.reverse();he.unshift(he.pop())}f=az();c3();eV();if(eQ){gc(true)}else{gc(false)}if(gp){hy();f3()}cL.run("onDataComplete")};var cI=function(){if(eN!==b&&cZ){cZ.setButtonPressed("MouseMode_"+eN,true)}if(bv){c5()}};var c3=function(){if(e2.width){hx=Math.min(cO,e2.width)}else{hx=cO}br()};var br=function(){cc.scaleToSourceImage=Math.max(1,e2.width/bm.imageWidth);cc.maxScale=cc.maxScaleInitial=gH.maxZoom/100*cc.scaleToSourceImage;cc.defaultZoom=Math.min(gH.desktopClickZoomScale,cc.maxScale)};this.destroyOnDetach=function(){if(gH&&gH.autoDestroy!==false){ga()}};var ga=this.destroy=function(o){cK();if(h){h=h.destroy()}if(M){M.destroy()}aT.destroy();hs();if(gt){gt.destroy()}if(aw){aw.removeAttribute("data-fsi-id");a.removeClass(aw,"fsi-viewer")}if(m){m.destroy()}if(gU){gU.remove();gU=b}if(bG!==b){a.removeCustomEvent(g5,"FSIMouseWheel",fR);bG=b}if(D!==b){a.removeCustomEvent(ho,"FSIDocumentZoomChange",d6);D=b}if(e6!==b){a.removeCustomEvent(fd,"FSIViewport",bi);e6=b}if(g6){a.removeCustomEvent(g5,"FSIElementDimension",bd);g6=false}if(eg){clearTimeout(eg);eg=b}V();if(fZ){fZ.destroy();fZ=b}ep();if(K){K.destroy();K=b}gA=false;gw();if(cZ){cZ.destroy();cZ=b}if(g5){if(gp){a.removeChild(fd,gp);a.removeChild(g5,fd);gp=b}if(g5.parentNode===aw){a.removeChild(aw,g5)}g5=b}if(ac){a.removeChild(ac.parentNode,ac);ac=b}if(ho){if(!a.isMobileDevice){a.removeEvent(ho,"keydown",c6);a.removeEvent(ho,"keyup",cs)}a.removeChild(ho.parentNode,ho);ho=b}if(!o&&cL){cL.run("onDestroy");cL.destroy()}};var p=function(){if(!bl||bl.width<10||bl.height<10){return false}if(ho===b){g3.eventOverlay=ho=document.createElement("div");ho.className="fsi-event-overlay";var hD="position:absolute;z-index:300;width:100%;height:100%;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;";if(a.isInternetExplorer){a.utils.setStyleAttr(ho,hD+";background-color:rgba(0,0,0,0)")}else{a.utils.setStyleAttr(ho,hD)}b6("wait");if(!a.isMobileDevice){ho.setAttribute("tabIndex","0")}g5.appendChild(ho);if(!K){var hE={};hE.detectGestures=true;hE.afterTouch={enabled:true};hE.afterTouch.modifyTarget=U;hE.afterTouch.fnGetAfterTouchEnabled=bq;hE.afterTouch.fnStartStopAfterTouch=N;if(cc.enabled){hE.detectClick=true;hE.onPinchStart=r;hE.onPinchChange=d4;hE.onPinchEnd=g2}K=new a.TouchHandler(ho,hE,ey,ab,fU)}if(!a.isMobileDevice){a.addEvent(ho,"keydown",c6);a.addEvent(ho,"keyup",cs)}if(cc.enabled){bG=a.addCustomEvent(g5,"FSIMouseWheel",fR);a.setCustomEventListenerProperty(bG,"acceleration",1.7);a.setCustomEventListenerProperty(bG,"accelerationMax",30)}else{if(bG!==b){a.removeCustomEvent(g5,"FSIMouseWheel",fR);bG=b}}if(cc.enabled){if(D===b){D=a.addCustomEvent(ho,"FSIDocumentZoomChange",d6);a.triggerCustomEvent(D)}}else{if(D){a.removeCustomEvent(ho,"FSIDocumentZoomChange",d6);D=b}if(K){K.enable(true)}}}if(ac===b&&eQ){ac=document.createElement("div");a.addClass(ac,"fsi-ui-hotspot-container");a.utils.setStyleAttr(ac,"position:absolute;z-index:4;");ho.appendChild(ac)}if(ac){fn(ac,false)}if(gp===b||gp.FSIisCanvas!==i){if(gp!==b&&gp.FSIisCanvas!==i){a.removeChild(g5,gp);f5=gp=b3=b}fd=document.createElement("div");fd.setAttribute("draggable","false");a.utils.setStyleAttr(fd,"position:absolute;overflow:hidden;width:100%;height:100%;");if(i){gp=document.createElement("canvas")}else{gp=document.createElement("div")}fd.appendChild(gp);g5.appendChild(fd);var o="z-index:1;position:absolute;transform-origin:0px 0px;	-webkit-transform-origin:0px 0px;	-ms-transform-origin:0px 0px;";o+="backface-visibility: hidden;-webkit-backface-visibility: hidden;";a.utils.setStyleAttr(gp,o);if(i){cB=gp.getContext("2d");dH=cB.webkitBackingStorePixelRatio||cB.mozBackingStorePixelRatio||cB.msBackingStorePixelRatio||cB.oBackingStorePixelRatio||cB.backingStorePixelRatio||1;if(!eO){gp.style.width=gp.style.height=""}}else{gp.style.textAlign="left"}gp.FSIisCanvas=i}if(typeof(gH.backgroundColor)=="string"&&gH.backgroundColor.toLowerCase()==="none"){gH.backgroundColor="transparent"}g5.style.backgroundColor=gH.backgroundColor;if(!i){if(f5===b){f5=b3;b3=b}if(b3!==b){a.removeChild(b3.parentNode,b3)}b3=document.createElement("img");if(f5!==b){b3.style.display="none"}gp.appendChild(b3)}if(i){if(e6===b){e6=a.addCustomEvent(fd,"FSIViewport",bi);a.setCustomEventListenerProperty(e6,"treshold",250)}}else{if(e6!==b){a.removeCustomEvent(fd,"FSIViewport",bi);e6=b}ba.setRect(0,0,bl.width,bl.height)}hr=gp.width=Math.ceil(bl.width*aC.scale);c2=gp.height=Math.ceil(bl.height*aC.scale);gp.lastOffsetX=gp.lastOffsetY=0;if((a.BrowserSupports.documentZoom()&&!a.isMobileDevice)||(a.isMobileDevice&&!i)){fV=true}eC();return true};var r=function(o,hE){if(cc.maxScale<=1){fu.bActive=false;return}fu.bActive=true;fu.lastX=hE.x;fu.lastY=hE.y;fu.distanceStart=o._FSI_PinchDistance;var hD=a.getElementPosition(ho);fu.offsetX=-hD.left-bl.width/2;fu.offsetY=-hD.top-bl.height/2;fu.startZoom=cc.scale;aV(false)};var d4=function(hF,hJ){if(!fu.bActive){return}if(bk>1.2){hF.FSI_allowEventDefault=true;return}var hH=hJ.x-fu.lastX;var hG=hJ.y-fu.lastY;fu.lastX=hJ.x;fu.lastY=hJ.y;var hE=fu.startZoom*hF._FSI_PinchScale;hE=Math.max(1,Math.min(cc.maxScale,hE));var o=hJ.x+fu.offsetX;var hI=hJ.y+fu.offsetY;var hD=hE/cc.scale;cc.panPos.left-=o;cc.panPos.top-=hI;cc.panPos.left*=hD;cc.panPos.top*=hD;cc.panPos.left+=o;cc.panPos.top+=hI;cc.panPos.left+=hH;cc.panPos.top+=hG;eK(hE,true,false)};var g2=function(){if(!fu.bActive){return}fu.bActive=false;aV(true);var o=cc.scale;eK(o,false,false)};var O=function(hD){bk=hD;var o=hC;if(o<1||gH.useDevicePixelRatio){hD=o*hD}if(fA!==hD){fA=hD;cc.maxScale=Math.max(1,cc.maxScaleInitial/hD);dQ();co=hD}};var eT=function(){var o=false;if(a.FullScreen){o=a.FullScreen.getElement()}return(o&&o!==d0)};var bi=function(o){if(eT()){return}cb=o.FSI_viewport_rect;O(o.FSI_scale);if(!cu){return}t(o.FSI_after_treshold)};var d6=function(){fi()};var fi=function(){if(gH.autoDisablePointerActions){var hD=a.getViewportSize();var o=(bj.getInFullScreenMode()||(ao.width<=hD.width&&ao.height<=hD.height));if(o!==gI){gI=o;K.enable(o);if(gn){gn.enable(o)}}}};var aX=function(){return(de&&(!K||!K.isAfterTouchRunning()))};var fR=function(hK){g3.onUserAction();if(fQ.bEnabled||!hK.FSI_delta){return}aI(false);if(hK.preventDefault){hK.preventDefault()}A();bY();var hL=aX();if(cj||hL){return}if(cc.maxScale<=1){return}var hJ=0.45*hK.FSI_normalized_accelerated_delta;cG=K.getMousePositionClient(hK);var hI=a.getElementPosition(ho);var hE=1+Math.abs(hJ)/6;if(hJ<0){hE=1/hE}var hM=Math.max(1,Math.min(cc.maxScale,cc.scale*hE));var hH=cG.x*aC.scale-hI.left-bl.width*aC.scale/2;var hG=cG.y*aC.scale-hI.top-bl.height*aC.scale/2;var o=hM/cc.scale;var hF=cc.panPos.left-hH;var hD=cc.panPos.top-hG;hF*=o;hD*=o;hF+=hH;hD+=hG;I=a.Easing.easeOutQuart;eX(hF,hD,hM,13);if(gn&&gn.isDragging()){cc.lockPanAnimation=true}hK.cancelBubble=true};var N=function(o){gX=o;if(o){hm()}};var gJ=function(){if(!d7){return}aF=false;if(d7._timeOutDraw){clearTimeout(d7._timeOutDraw)}d7=b};var eP=function(){if(!gH.showProgressbar){return}if(he.length<2){gJ();return}if(!i){return}var o=0;switch(gH.progressBarHAlign){case"left":case"right":o=8;break}ef=Math.max(10,(bl.width*(Math.max(0,Math.min(100,gH.progressBarWidth/100)))-2*o))*aC.scale;dX=Math.max(1,Math.min(bl.height,gH.progressBarHeight))*aC.scale;d7=new a.CanvasProgressBar(cB,0,0,ef,dX,a3.oProgressBarStyle);cS();d7._timeOutDraw=setTimeout(bF,100)};var bF=function(){if(d7){aF=true}};var cS=function(){if(!d7){return}var o,hD;switch(gH.progressBarHAlign){case"left":o=aC.scale*8;break;case"right":o=aC.scale*(bl.width-ef-8);break;default:o=aC.scale*((bl.width-ef)/2)}switch(gH.progressBarVAlign){case"middle":case"center":hD=aC.scale*(bl.height/2-dX/2);break;case"top":hD=aC.scale*4;break;default:hD=aC.scale*(bl.height-4-dX)}d7.setPos(o,hD)};var f3=function(){var hP;cJ(0);var hH=false;aO=(!a.isMobileDevice&&(a.isOpera||a.isInternetExplorer));eP();b6("wait");var hJ="";if(f.indexOf("//")===-1){hJ=gH.video.base}if(!i||a.isMobileDevice||!f){dE.log("Using image sequence w/o video.");return dn()}var hN=gH.video.captureOffsetStart;if(hN===b||isNaN(hN)){hN=0}var hF=gH.video.captureOffsetEnd;if(hF===b||isNaN(hF)){hF=0}var hI;hP=gH.video.captureFrames;if(hP===b||isNaN(hP)){gH.video.captureFrames=120}if(a5.nSceneSets>1){var hK=bg();gH.video.captureFrames=Math.max(gH.video.captureFrames,hK.max)}else{gH.video.captureFrames-=gH.video.captureFrames%he.length;gH.video.captureFrames=Math.max(gH.video.captureFrames,he.length)}var hO=document.createElement("canvas");hO.setAttribute("webkit-playsinline","");var hL=hO.getContext("2d");if(!dA){dA=document.createElement("canvas");hw=dA.getContext("2d")}hP=hJ+f;if(a.isInternetExplorer&&a.versionInternetExplorer<10&&a.utils.isCrossDomain(hP)){dE.error("CROSS DOMAIN VIDEO ACCESS not possible with this browser.");dE.log("Falling back to using image sequence.");return dn()}dE.log("Capture "+gH.video.captureFrames+" video frames");dY=document.createElement("video");dY.setAttribute("muted","muted");dY.setAttribute("preload","auto");dY.setAttribute("webkit-playsinline","");dY.setAttribute("crossorigin","anonymous");a.utils.setStyleAttr(dY,"position:absolute;z-index:10000;width:1px;height:1px");if(a.isSafari){dY.style.display="none"}dY.style.marginLeft=bl.width/2+"px";dY.style.marginTop=bl.height/2+"px";if(!a.isSafari&&!a.isInternetExplorer){var hE=document.createElement("source");hE.setAttribute("src",hJ+f+".webm");dY.appendChild(hE)}var hD=document.createElement("source");hD.setAttribute("src",hJ+f+".mp4");dY.appendChild(hD);if(!a.isSafari&&!a.isInternetExplorer){var o=document.createElement("source");o.setAttribute("src",hJ+f+".ogv");dY.appendChild(hD)}g5.appendChild(dY);dY.FSIEvents={};var hM=function(hR,hS,hQ){dY.FSIEvents[hR]={fn:hS,phase:hQ};a.addEvent(dY,hR,hS,hQ)};hM("error",function(){if(dY.networkState===dY.NETWORK_NO_SOURCE){dE.error('Failed loading the video: "'+f+'"');dE.log("Falling back to using image sequence w/o video.");dn()}},true);hM("loadedmetadata",function(){cj=true;eu("video");var hR=dY.videoWidth;var hQ=dY.videoHeight;dY.setAttribute("width",hR);dY.setAttribute("height",hQ);hI=(dY.duration-hN-hF)/gH.video.captureFrames;gR(hR,hQ);hO.setAttribute("width",c1.croppedWidth);hO.setAttribute("height",c1.croppedHeight);dA.setAttribute("width",c1.croppedWidth);dA.setAttribute("height",c1.croppedHeight);cI();hb()},true);hM("canplaythrough",function(){if(!hH){if(a.isSafari){dY.style.display=""}hH=true;this.currentTime=Math.max(0,hN)}},true);var hG=0;hM("seeked",function(hQ){if(!cj){return}var hR=dY.duration;if(a.isInternetExplorer){hR-=0.3}if(e.length<gH.video.captureFrames){try{hL.drawImage(hQ.target,0,0,c1.width,c1.height,-fy.left,-fy.top,c1.width,c1.height);var hT=hL.getImageData(0,0,hO.width,hO.height);e.push(hT)}catch(hS){dE.error('Failed capturing the video: "'+f+'"');dE.log("REASON: "+hS.message);dE.log("Falling back to using image sequence w/o video.");cj=false;dn();return}cJ(100*e.length/gH.video.captureFrames);cl(e.length-1);hm();hG=Math.min(hR,hI*e.length+hN);if(aO){eg=setTimeout(function(){dY.currentTime=hG},1)}else{dY.currentTime=hG}}else{dc()}},true)};var fN=this.startAutoSpin=function(){if(!cu||!ge.bEnabledByConfig){return false}if(ge.interval){return true}if(cZ){cZ.setButtonPressed("ToggleAutoSpin",true)}A();bZ();b8("autoSpin");ge.enabled=true;eE();ge.interval=setInterval(f4,ge.nIntervalTime);return true};var gN=function(){if(!cu||!ge.bEnabledByConfig){return false}if(!ge.enabled){fN()}else{aI(true)}};this.stopAutoSpin=function(){return aI()};var aI=g3.stopAutoSpin=function(o){if(!cu||!ge.bEnabledByConfig){return false}if(!ge.interval){return true}if(cZ){cZ.setButtonPressed("ToggleAutoSpin",false)}ge.enabled=false;gv("autoSpin");clearInterval(ge.interval);ge.interval=b;if(o){eS()}return true};var f4=function(){if(!hA){b8("autoSpin")}var o=eG+ge.nDirection;if(o>=ev){o-=ev}else{if(o<0){o+=ev}}hc(o);hm()};var aZ=function(hD){ev=hD;var o=1;if(typeof(gH.fMouseSensitivity)!="undefined"){o=parseFloat(gH.fMouseSensitivity);if(isNaN(o)||o===0){o=1}}fB=160/ev*4/o;dO=ev/120};var gC=function(){var o;if(!a5.bDefault&&a5.nSceneSets>1){o=Math.max(1,Math.min(a5.nSceneSets,gH.video.sceneSet))-1;if(gH.reverseSceneSets){o=(-(o+1)+a5.nSceneSets)%a5.nSceneSets}}return o};var dc=function(){if(gH._reverseVideoDirection){e.reverse();e.unshift(e.pop())}bB.unshift(x.imageWidth);fJ=e.length;if(e.length>0){a5.nVideoSet=gC()}else{a5.nVideoSet=b}if(a5.nVideoSet!==b){var o=g9;dn();g9=o}else{dV();b9()}};var fl=function(){if(n){n.destroy()}if(gt.hasPlugin("measure")){n=new a.PluginMeasure(bj,g3)}};var b9=function(){var hD;cJ(100);hh();if(ck!==b){gf=ck}fl();bc();if(a5.bQuantize){f8()}cl(0);aF=false;bU=ec;cA=b;if(gH._reverseImageDirection&&gn){gn.reverseImageSequence()}if(e1){hm()}es();gJ();bs();bK=false;ge.bEnabledByConfig=false;if(ev>1||a5.nSceneSets>1){z=false;if(a.isIETouch){if(a5.nSceneSets>1){ho.style.msTouchAction="pinch-zoom double-tap-zoom"}else{ho.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}}if(gH.autoSpinSpeed||gH.autoSpinInterval){if(gH.autoSpinInterval){hD=gH.autoSpinInterval;ge.nDirection=(hD>0)?1:-1;hD=Math.abs(hD)}else{if(gH.autoSpinSpeed<0){gH.autoSpinSpeed=-gH.autoSpinSpeed;ge.nDirection=-1}else{ge.nDirection=1}hD=gH.autoSpinSpeed*1000/ev;if(!hD){hD=1}while(hD<20&&Math.abs(ge.nDirection)<ev/2){hD*=2;ge.nDirection*=2}hD=Math.max(20,Math.ceil(hD))}ge.nIntervalTime=hD;ge.bEnabledByConfig=true;if(!gt.hasPlugin("autospin")||gt.getPluginParameter("autospin","enabled",true,true)){bK=gt.getPluginParameter("autospin","restartonreset",false,true);cu=true;fN();cu=false}}}else{z=true;if(a.isIETouch){ho.style.msTouchAction=b}if(!cc.enabled){b6("default")}}hD=gH.initialMouseMode;if(hD!=="auto"){hD=parseInt(hD)}fk(hD);cj=false;var o=b;if(gH.video.frameOffset&&g9){o=eG+gH.video.frameOffset;o=hv(ev+o);cl(o)}ci();cu=true;if(cZ){cZ.setEnabled(true)}if(c!==b){ha(c,(he.length>1));c=b}else{if(av!==b&&gt.makeBool(gt.cfg.keepcurrentviewafterconfigchange,false)){gH.initialview=av}if(gH){if(typeof(gH.initialview)==="string"&&gH.initialview.length>0){if(!ha(gH.initialview,false)){gH.initialview=b}else{gH.initialview=gt.fillViewString(gH.initialview)}}else{gH.initialview=b}}}av=b;if(dE.on){dE.log("Startup time: "+(a.now()-df)+"ms")}cL.run("onReady");cn();if(cc.enabled){ca()}if(!cc.enabled){if(z){K.setCapture(false,false)}else{K.setCapture(true,false)}}if(e6){a.triggerCustomEvent(e6);t(true)}cL.runPersistent("onAfterReady");an()};var dn=function(){hs();dL=e.length;eu("image");hb();dV();es();l(e2.width,e2.height);cI();fv()};var dy=function(){a.removeEvent(b3,"load",dy);if(f5!==b&&f5.parentNode){a.removeChild(f5.parentNode,f5);f5=b}b3.style.display="inline";gp.style.paddingLeft=ad.imageX+"px";gp.style.paddingTop=ad.imageY+"px"};var fv=function(){cj=true;if(!i){b3.width=ad.imageWidth;b3.height=ad.imageHeight;a.addEvent(b3,"load",dy,true);if(f5===b){try{gp.style.paddingLeft=gp.style.paddingRight="auto";gp.style.paddingTop=gp.style.paddingRight="auto"}catch(o){}}}if(dA){dA.setAttribute("width",ad.imageWidth);dA.setAttribute("height",ad.imageHeight)}fj()};var e9=function(o){if(o){e3()}else{hh()}};var f9=function(o,hE,hF,hD){var hG;o.FSI_image_context=o;if(bA){hG={};hG.argsJPEG=Array.prototype.slice.call(arguments);hD=dz;hE=a.utils.changeRendererInURL(hE,"png.alpha");hE=a.utils.removeFormatInURL(hE);o=hG.argsJPEG[0].FSI_alpha_channel=new Image()}aT.load(o,hE,hF,hD,hG)};var dz=function(o,hD){aT.load.apply(this,hD.argsJPEG)};var cy=function(hE){if(!hE){return}if(hE.FSI_alpha_channel){var hD=hE.width;var hG=hE.height;var hF=hE.FSI_image_context=document.createElement("canvas");hF.setAttribute("width",hD);hF.setAttribute("height",hG);hF.setAttribute("crossorigin","anonymous");var o=hF.getContext("2d");o.drawImage(hE.FSI_alpha_channel,0,0,hD,hG);o.globalCompositeOperation="xor";o.drawImage(hE,0,0,hD,hG);hE.FSI_alpha_channel=b}};var cJ=function(o){af=o;if(cT){cL.runPersistent("onProgress",[o])}};var fj=function(){ez={};ez.oImages={};ez.nPendingImages=0;ez.nNext=0;ez.nCurrentIndex=-1;ez.nLoaded=0;ez.nAddedPreview=0;if(!i){ez.img=new Image()}var hD=Math.min(6,he.length);for(var o=0;o<hD;o++){F()}};var gM=function(){ez.nLoaded++;cJ(100*ez.nLoaded/he.length);if(ez.nNext!==this.FSI_nImage){ez.oImages[this.FSI_nImage]=this;ez.nPendingImages++}else{b0(this);d1()}F()};var d1=function(){if(ez&&ez.nPendingImages>0){while(ez&&ez.oImages[ez.nNext]){var hD=ez.nNext;var o=ez.oImages[hD];ez.oImages[hD]=b;ez.nPendingImages--;b0(o)}}};var b0=function(o){ez.nAddedPreview++;ez.nNext++;cy(o);if(i){e.push(o)}else{e.push(o.src)}cl(e.length-1);hm();if(ez.nAddedPreview>=he.length){d1();aq();if(e1){e1.addImage(b3)}b9()}};var F=function(){if(!ez||++ez.nCurrentIndex>=he.length){return}var o;if(i){o=e7=new Image();o.FSI_nImage=ez.nCurrentIndex}else{o=ez.img}f9(o,g1(ez.nCurrentIndex).fullURL,"sequence",gM)};var aq=function(){if(ez===b){return}aT.abortPurpose("sequence");ez=b};var hc=function(o){var hD=hv(Math.round(o));if(hD!==hv(eG)){dQ();cl(hD);hm();if(cu&&fI===b&&ge.interval===b){an()}}el=o};var b8=function(){if(hA){return}Y=true;hA=true;V();da=false;C=false};var gv=function(){if(!hA){return}cl(hv(eG));hA=false;da=true;C=true;if(!dt||eG!==dt.spinPos){if(dt){fx()}fr()}else{c4(50)}};var cl=function(o){eG=el=o;if(!a0){du=eG}else{du=a0[eG]}};var cz=function(){var o,hI,hE;ej=document.createElement("canvas");ej.setAttribute("width",c1.croppedWidth);ej.setAttribute("height",c1.croppedHeight);et=ej.getContext("2d");var hG=ej.width;var hD=ej.height;var hF=et.createImageData(hG,hD);var hH=hF.data;for(hI=0;hI<hD;hI++){if(hI%4===0){for(o=0;o<hG;o++){if(o%4!==0){hE=hI*hG*4+o*4;hH[hE]=0;hH[hE+1]=0;hH[hE+2]=0;hH[hE+3]=255}}}else{if(hI%4===1||hI%4===2){for(o=1;o<hG;o+=4){hE=hI*hG*4+o*4;hH[hE]=0;hH[hE+1]=0;hH[hE+2]=0;hH[hE+3]=255}}}}et.putImageData(hF,0,0)};var hm=g3.drawScene=function(){if(P!==b||fc){return}P=requestAnimationFrame(aB)};var hs=function(){if(P===b){return}cancelAnimationFrame(P);P=b};var bn=g3.render3D=function(){dT.renderer.render(dT.scene,dT.camera)};var aB=g3.doDrawScene=function(){P=b;var hD=false;if(gX&&K.runAfterTouch()){hD=true}if(!i){if(a8!==du){b3.src=e[du];a8=du}}else{if(X&&fF()){hD=true}cB.globalAlpha=1;cB.clearRect(0,0,hr,c2);gf();if(da&&dt){if(hB()){hD=true}}}if(bU){if(hg){var hI=hf*bl.width;var hF=hf*bl.height;hg=false;var hG=-aC.drawOffsetX+(hI-bl.width*aC.scale)/2-cc.panPos.left+aY.x*cc.scale;var hE=-aC.drawOffsetY+(hF-bl.height*aC.scale)/2-cc.panPos.top+aY.y*cc.scale;dT.camera.setViewOffset(hI,hF,hG,hE,aC.totalWidth,aC.totalHeight)}if(dl){eB()}if(bR){bn()}if(dl){dl=false;if(eQ&&d5){if(!bR){bn()}bT()}}}if(gQ){gQ=false;if(gn){gn.update(du,ay)}}if(f7){gD();cB.fillStyle=bu;cB.fillRect(gT.left+1,gT.top+1,gT.width()-1,gT.height()-1);cB.fillStyle=aA;cB.fillRect(gT.left,gT.top,gT.width(),1);cB.fillRect(gT.left,gT.bottom,gT.width(),1);cB.fillRect(gT.left,gT.top,1,gT.height());cB.fillRect(gT.right,gT.top,1,gT.height())}if(aF){d7.draw(af)}if(dp){if(cf){g(gp,"translate3d("+aC.left+"px,"+aC.top+"px,0px)"+aC.strTransformScale)}else{g(gp,"translate("+aC.left+"px,"+aC.top+"px)"+aC.strTransformScale)}}if(hD){hm()}if(eW){var hH=[aC,hf,cc];for(var hJ in T){if(T.hasOwnProperty(hJ)){T[hJ].apply(bj,hH)}}}};g3.addDrawListener=function(hD,o){if(!hD||typeof(o)!=="function"){return false}if(T&&T[hD]){return false}if(!T){T={}}T[hD]=o;eW=true;return true};g3.removeDrawListener=function(hD){if(!hD){return false}if(!T||!T[hD]){return false}delete T[hD];var hF=0;for(var hE in T){hF++}if(hF===0){T=b;eW=false}return true};var eB=function(){var o;if(cX.oSpinPositions){o=cX.oSpinPositions.arPositions[du]}else{o=eG/ev}ft(0,o*J,0)};var gD=function(){gT.copyRect(aS);gT.offsetRect(-aS.clientOffset.left,-aS.clientOffset.top);gT.normalizeRect();if(aC.scale!==1){gT.scaleRect(aC.scale)}};var dQ=function(){dl=gQ=true};var ex=function(){return false};var R=function(o){cB.drawImage(o.img.FSI_image_context,o.x,o.y,o.width,o.height);return false};g3.getAccessToken=function(){return a2};this.setAccessToken=function(o){a2=o;if(gt){gt.setAccessToken(a2)}};var gY=function(hD){var o;hD.alpha+=ff;if(hD.alpha>=1){hD.fnDraw=R;hD.alpha=1;o=false}else{o=true}cB.globalAlpha=hD.alpha;R(hD);cB.globalAlpha=1;return o};var hB=function(){var o=false;if(C){g8()}if(dt.nVisibleTiles>0){var hH=aC.drawOffsetX+ad.imageX+cc.panPos.left;var hG=aC.drawOffsetY+ad.imageY+cc.panPos.top;var hF=ad.imageWidth/dt.width;cB.save();cB.translate(hH,hG);cB.scale(hF,hF);var hD=dt.arVisibleTiles;for(var hE=0;hE<dt.nVisibleTiles;hE++){if(hD[hE].fnDraw(hD[hE])){o=true}}cB.restore()}dt.bTilesFading=o;if(!ht&&Y&&!o&&dt.bFilesArePreparedForLoading){if(!cA||(cA.nTilesLoading===0&&dt.arTilesToLoad.length===0)){Y=false}}return o};var eu=function(o,hD){fp=(o==="video");if(fp){eU=b;dD=dA;b4=g3.getPreviewImage=aL;gf=cv}else{b4=g3.getPreviewImage=cM;gf=gG}if(!hD){g9=fp;if(gH){if(he.length>1){if(!gH.showPreviewWhileLoading){ck=gf;gf=a.fnDoNothing}else{if(!gH.spinPreviewWhileLoading){ck=gf;if(!aJ.bSetup){aJ.bStillPreview=true;gf=a.fnDoNothing}else{if(aJ.imgDraw){gf=gr}else{gf=a.fnDoNothing}}}else{ck=b}}}aJ.bSetup=true}}};var hb=function(){if(!aJ.bStillPreview||aJ.bStillPreviewDone){return}gL()};var gL=function(){aJ.bStillPreviewDone=true;var hE=cu;cu=true;var hF;var hG=eA(gH.initialview);if(a5.bDefault){hF=hG.scene}else{var hD=a5.arSets[hG.SceneSet];hF=hD.arScenes[hG.scene]-1}bW();var o=g1(hF).fullURL;aJ.img=new Image();f9(aJ.img,o,"stillPreview",E);cu=hE;bE=b};var E=function(){cy(this);aJ.imgDraw=this.FSI_image_context;gf=gr};var gr=function(){aE(aJ.imgDraw,ad.imageX,ad.imageY,hf)};var aL=function(o){if(eU===o){return dD}eU=o;hw.putImageData(e[o],0,0);dD=dA;return dD};var cM=function(o){if(eU===o){return dD}if(!c9){c9=x.imageWidth;if(hn){aH=document.createElement("canvas");aH.setAttribute("width",x.imageWidth);aH.setAttribute("height",x.imageHeight);hj=aH.getContext("2d")}}if(!e[o]){eU=b}else{if(!hn){dD=e[o].FSI_image_context}else{hj.drawImage(e[o].FSI_image_context,0,0,x.imageWidth,x.imageHeight);dD=aH}eU=o}return dD};var cv=function(){cB.globalAlpha=1;var o=hf*x.videoWidth/c1.croppedWidth;aE(aL(du),ad.videoX,ad.videoY,o);if(Y&&gH.pellets&&!H){cB.globalAlpha=gH.pelletsOpacity;cB.globalCompositeOperation="xor";aE(ej,ad.videoX,ad.videoY,o);cB.globalAlpha=1;cB.globalCompositeOperation="source-over"}};var gG=function(){aE(cM(du),ad.imageX,ad.imageY,hf)};var aE=function(hF,hM,hJ,hD){if(!hF){return}var hL=0;var hK=0;var hG=aC.drawOffsetX+hM+cc.panPos.left;var hE=aC.drawOffsetY+hJ+cc.panPos.top;if(hG<0){hL=-hG/hD;hG=0}if(hE<0){hK=-hE/hD;hE=0}var hN=hF.width-hL;var hI=hF.height-hK;var hH=hN*hD;var o=hI*hD;cB.drawImage(hF,hL,hK,hN,hI,hG,hE,hH,o)};g3.getImagePos=function(hF){var hE,o,hD,hG;if(hF){hE=bm.imageXAbsolute;o=bm.imageYAbsolute;hD=bm.imageWidthAbsolute;hG=bm.imageHeightAbsolute}else{hE=aC.drawOffsetX+(ad.imageX+cc.panPos.left)/aC.scale;o=aC.drawOffsetY+(ad.imageY+cc.panPos.top)/aC.scale;hD=ad.imageWidth/aC.scale;hG=ad.imageHeight/aC.scale}return{x:hE,y:o,width:hD,height:hG}};var c5=function(){if(gn){ep()}if(cc.enabled&&i){gn=new a.NavigatorWindow(g3,gt,a3,g5,dR);if(fQ.hideUI){gn.enable(false,true)}}};var ep=function(){if(!gn){return}gn.destroy();gn=b};var cm=function(){if(!ec||!dT.targetObj){return}var hF=bl.width*aC.scale;var hJ=bl.height*aC.scale;dT.sceneWidth=bm.imageWidth*aY.cropScaleX;dT.sceneHeight=bm.imageHeight*aY.cropScaleY;var hG=dT.sceneWidth;var o=hG/1.5;var hI=o/hJ;var hH=gH.camera.digitalCropFactor*gH.camera.focalLength*hI;var hD=2*THREE.Math.radToDeg(Math.atan(24/hH/2));dT.camera=new THREE.PerspectiveCamera(hD,dT.sceneWidth/dT.sceneHeight,0.1,10000);var hE=gt.parsePositionParameter(gH.camera.position);if(hE!==b){a6.x=hE.x;a6.y=hE.y;a6.z=hE.z}else{if(gH.camera.heightTable!==b&&gH.camera.heightCamera!==b){gH.camera.heightAboveTable=gH.camera.heightCamera-gH.camera.heightTable}if(gH.camera.shiftX===b){gH.camera.shiftX=0}a6.x=gH.camera.shiftX;a6.y=gH.camera.heightAboveTable;a6.z=gH.camera.distanceToTableCenter}if(a6.x===b){a6.x=0}if(a6.y===b){a6.y=0}if(a6.z===b){a6.z=0}dT.camera.position.x=a6.x;dT.camera.position.y=a6.y;dT.camera.position.z=a6.z;gt.cfg.cameraposition=a6.x+","+a6.y+","+a6.z;e4();dT.camera.lookAt(dT.targetObj.position);dT.camera.rotation.z=0;fo();dT.camera.setViewOffset(hF,hJ,-aC.drawOffsetX+aY.x,-aC.drawOffsetY+aY.y,hF,hJ)};var Q=function(){var o=Math.PI/180;gH.virtualSpace.baseRotationXRad=-gH.virtualSpace.baseRotationX*o;gH.virtualSpace.baseRotationYRad=-gH.virtualSpace.baseRotationY*o;gH.virtualSpace.baseRotationZRad=-gH.virtualSpace.baseRotationZ*o;gH.camera.armAngleStartRad=gH.camera.armAngleStart*o};var hy=function(){if(!ec){return}var h4;h4=window.THREE;var h3={};if(a.BrowserSupports.canvas()&&typeof h4!=="undefined"){if(i){dT.renderer=new h4.CanvasRenderer({canvas:gp,clearColor:0,clearAlpha:0,devicePixelRatio:1});dT.renderer.autoClear=false;h3.width=bl.width*aC.scale;h3.height=bl.height*aC.scale}else{dT.renderer=new h4.CanvasRenderer({clearColor:0,clearAlpha:0});dT.renderer.autoClear=false;h3.width=bl.width;h3.height=bl.height}dT.scene=new h4.Scene();dT.objects=new h4.Group();var hN=new h4.Object3D();var h2=gt.parsePositionParameter(gH.camera.targetPosition);if(h2===b){hN.position.x=gH.camera.targetWidthOffset;hN.position.y=gH.camera.targetHeightOffset;hN.position.z=0;gt.cfg.cameratargetposition=hN.position.x+","+hN.position.y+","+hN.position.z}else{hN.position.x=h2.x;hN.position.y=h2.y;hN.position.z=h2.z}dT.scene.add(hN);dT.targetObj=hN;var hM;if(gH.virtualSpace.cubeLineWidth>0&&gH.drawCube){var hS=gH.virtualSpace.cubeSegments;hS=Math.max(1,Math.min(10,hS));var h0,hE;if(gH.virtualSpace.cubeSizeX){h0=new h4.BoxGeometry(gH.virtualSpace.cubeSizeX,gH.virtualSpace.cubeSizeY,gH.virtualSpace.cubeSizeZ,hS,hS,hS);hM=gH.virtualSpace.cubeSizeY/2}else{h0=new h4.BoxGeometry(gH.virtualSpace.cubeSize,gH.virtualSpace.cubeSize,gH.virtualSpace.cubeSize,hS,hS,hS);hM=gH.virtualSpace.cubeSize/2}hE=new h4.MeshBasicMaterial({color:65280,wireframe:true,wireframeLinewidth:gH.virtualSpace.cubeLineWidth});var hI=new h4.Mesh(h0,hE);if(gH.virtualSpace.shiftY===b){gH.virtualSpace.shiftY=0}hI.position.x=gH.virtualSpace.shiftX;hI.position.y=hM+gH.virtualSpace.shiftY;hI.position.z=gH.virtualSpace.shiftZ;dT.cube=hI;dT.objects.add(hI)}if(gH.drawGroundPlate){var hF=new h4.GridHelper(Math.max(gH.virtualSpace.cubeSizeX,gH.virtualSpace.cubeSizeY),15,new h4.Color(15626314),new h4.Color(15626314));hF.position.set(gH.virtualSpace.shiftX,gH.virtualSpace.shiftY,gH.virtualSpace.shiftZ);dT.objects.add(hF);dT.plane=hF}if(gH.drawTable){var o=gH.tableDiameter/2;var hW=50;var hD=new h4.Geometry();var h5;h5=Math.PI*2/360;var hT=0;var hJ=function(h9,h8){var ib=0;var ic=0;var ih=0;var ia=0;for(var id=0;id<=36;id++,hT+=4){var h7=Math.sin(h5*id)*h9;var ig=Math.cos(h5*id)*h9;var h6=Math.sin(h5*id)*h8;var ie=Math.cos(h5*id)*h8;hD.vertices.push(new h4.Vector3(h6,ie,0));hD.vertices.push(new h4.Vector3(ih,ia,0));hD.vertices.push(new h4.Vector3(ib,ic,0));hD.vertices.push(new h4.Vector3(h7,ig,0));hD.faces.push(new h4.Face3(hT,hT+1,hT+2));ib=h7;ic=ig;ih=h6;ia=ie}};var hK=0;var hH=0;for(var h1=0;h1<=4;h1++,hT+=3){var hQ=Math.sin(h5*h1*90)*hW;var hP=Math.cos(h5*h1*90)*hW;hD.vertices.push(new h4.Vector3(0,0,0));hD.vertices.push(new h4.Vector3(hQ,hP,0));hD.vertices.push(new h4.Vector3(hK,hH,0));hD.faces.push(new h4.Face3(hT,hT+1,hT+2));hK=hQ;hH=hP}h5=Math.PI*2/36;var hV=0;var hU=hW;while(hU<o){hV+=hW;hU=hV+hW;if(hU>o){hU=o}hJ(hV,hU)}var hZ=new h4.Mesh(hD,new h4.MeshBasicMaterial({color:5810431,wireframe:true}));hZ.rotation.x=-Math.PI/2;dT.disk=hZ;dT.objects.add(hZ)}if(gH.hotspots&&gH.hotspots.points){a1();gz=gH.hotspotCallbackFunction;if(typeof(gz)=="string"){try{gz=window[gz]}catch(hY){}}else{if(typeof(gz)!="function"){gz=b}}var hR=1;eL={};for(var hX=0;hX<gH.hotspots.points.length;hX++,hR++){var hL=gH.hotspots.points[hX];hL.FSIHotspotID=hR;eL[hR]=hL;if(hL.perimeterAngle!==b&&hL.perimeterAngleY===b){hL.perimeterAngleY=hL.perimeterAngle;hL.perimeterAngleYRange=hL.perimeterAngleRange;hL.perimeterAngleYFadeOut=hL.perimeterAngleFadeOut}if(hL.perimeterAngleY&&hL.perimeterAngleY<0){hL.perimeterAngleY=360+hL.perimeterAngleY}hL.perimeterAngleYFadeOut=Math.min(hL.perimeterAngleYRange,hL.perimeterAngleYFadeOut);if(hL.perimeterAngleX!==b&&hL.perimeterAngleX<0){hL.perimeterAngleX=360+hL.perimeterAngleX}hL.perimeterAngleXFadeOut=Math.min(hL.perimeterAngleXRange,hL.perimeterAngleXFadeOut);if(gH.hotspots.defaults){for(var hG in gH.hotspots.defaults){if(gH.hotspots.defaults.hasOwnProperty(hG)){if(hL[hG]===b){hL[hG]=gH.hotspots.defaults[hG]}}}}dw(hL);var hO=new h4.Object3D();hO.position.x=hL.x+gH.virtualSpace.shiftX;hO.position.y=hL.y+gH.virtualSpace.shiftY;hO.position.z=hL.z+gH.virtualSpace.shiftZ;hL.object=hO;dT.objects.add(hO)}dE.log(hX+" HotSpots created.")}dT.scene.add(dT.objects);dP(h3.width,h3.height);cm()}eB();if(gS){L()}cL.run("onInit3D",[dT]);if(aM){aM()}};g3.showCube=function(o){if(dT&&dT.objects&&dT.cube){if(o===b){o=(dT.cube.visible===false)}var hD;if(o){if(dT.cube.visible!==true){dT.cube.visible=true;hD=true}}else{if(dT.cube.visible!==false){dT.cube.visible=false;hD=true}}if(hD){hm()}}};var fs=function(o){if(!this.FSIHotspot){return}var hE=o.type;var hD=this;if(hD.FSIHotspot._nTimeoutEvent!==b){clearTimeout(hD.FSIHotspot._nTimeoutEvent);hD.FSIHotspot._nTimeoutEvent=b}if(hE==="mouseleave"){this.FSIHotspot._nTimeoutEvent=setTimeout(function(){f2(hE,hD,o)},10)}else{f2(hE,hD,o)}};var f2=function(hH,hF,hM){var hJ=false;var hD=hF.FSIHotspot;if(!hD||!hH){return false}var o;switch(hH){case"mouseenter":if(!hD._bMouseOver){o=true;hH="mouseover";hD._bMouseOver=true}else{return}break;case"mousedown":o=true;break;case"mouseleave":if(hD._bMouseOver){o=true;hH="mouseout";hD._bMouseOver=false}else{return}break;default:o=true}if(gz){var hI=hD.FSIHotspotID;var hG=hD.tooltip;var hL=hD.actionParameter;var hK=gz(hH,bj,S,hI,hG,hL,hD.perimeterAngleY,hD.perimeterAngleX);if(hK===true){hJ=true}}var hN=cL.run("onHotspotEvent",[hH,hD.FSIHotspotID,hD.id,hD.text,hF,hM]);if(hN!==false){if(o){switch(hH){case"mouseover":a.addClassSVG(hD.marker,hD.hoverClass);a.addClass(hD.tooltip,hD.hoverClass);hD.marker.style.zIndex=hD.tooltip.style.zIndex=5000000;break;case"mousedown":a.addClassSVG(hD.marker,hD.activeClass);a.addClass(hD.tooltip,hD.activeClass);break;case"mouseout":a.removeClassSVG(hD.marker,hD.hoverClass);a.removeClass(hD.tooltip,hD.hoverClass);hD.marker.style.zIndex=hD.tooltip.style.zIndex=hD.zIndex;break;default:a.removeClassSVG(hD.marker,hD.activeClass);a.removeClass(hD.tooltip,hD.activeClass)}}if(hH==="click"){if(hD.url){window.open(hD.url,hD.urlTarget);hJ=true}if(!hJ&&hD.focusOnClick===true){var hE=fq(hD);ha(hE,true);hJ=true}}}return hJ};var ft=function(hE,hD,o){dT.objects.rotation.x=hE+gH.virtualSpace.baseRotationXRad;dT.objects.rotation.y=hD+gH.virtualSpace.baseRotationYRad;dT.objects.rotation.z=o+gH.virtualSpace.baseRotationZRad;if(aM){aM()}};var f6=function(){var o={projection:dT,drawRatioUnZoomed:bm,drawRatio:ad,viewport:bl,scenes:{sceneSets:a5,currentSceneSet:cX,nPreviewImages:e.length,nPreviewImageIndex:du},virtualSpace:gH.virtualSpace,rotation:{x:dT.objects.rotation.x,y:dT.objects.rotation.y,z:dT.objects.rotation.z,xm:dT.objects.rotation.x-gH.virtualSpace.baseRotationXRad,ym:dT.objects.rotation.y-gH.virtualSpace.baseRotationYRad,zm:dT.objects.rotation.z-gH.virtualSpace.baseRotationZRad}};cL.run("on3DWorldChanged",[o])};var ap;g3.setHotSpotObjectID=function(o,hD){ap[hD]=o};g3.getHotSpotObject=function(o){return ap[o]};g3.projectVectorOnScreen=function(hF){hF.project(dT.camera);var hD=aC.left;var hG=aC.top;var o=bl.width/2;var hE=bl.height/2;return{vectorX:hF.x,vectorY:hF.y,x:hD+hF.x*o+o,y:hG+hE-hF.y*hE}};var bT=function(){var hV,hW;var hO=new THREE.Vector3();var hY=aC.left;var hX=aC.top;var hZ=bl.width/2;var hF=bl.height/2;var hL;var hU=false;var hK;var h1=bl.width;var h0=bl.height;if(hl.spinFrame!==du){hl.spinFrame=du;if(hl.arSpotsAtFrame===b){hl.arSpotsAtFrame=new Array(ev)}var hT=hl.hotSpotsAtThisFrame;hl.hotSpotsAtThisFrame=hl.arSpotsAtFrame[du];if(hl.hotSpotsAtThisFrame===b){var hJ;if(cX.oSpinPositions){hJ=gH.virtualSpace.rotationYRange*cX.oSpinPositions.arPositions[du]}else{hJ=gH.virtualSpace.rotationYRange*hv(eG)/ev}hl.hotSpotsAtThisFrame=hl.arSpotsAtFrame[du]=[];for(hW=0;hW<gH.hotspots.points.length;hW++){hK=gH.hotspots.points[hW];hL=1;if(hK.perimeterAngleY!==b){var h2=Math.abs(hK.perimeterAngleY-hJ);if(h2>180){h2=Math.abs(360-h2)}if(h2<hK.perimeterAngleYRange){if(h2>hK.perimeterAngleYRange-hK.perimeterAngleYFadeOut){hL=(hK.perimeterAngleYRange-h2)/hK.perimeterAngleYFadeOut}}else{hL=0}}if(hL!==0){var hS={};hS.index=hW;hS.hotspot=hK;hS.op=hL;hl.hotSpotsAtThisFrame.push(hS);hO.setFromMatrixPosition(hK.object.matrixWorld);hK.zIndex=hS.zIndex=Math.round(hO.z);if(!hK._bMouseOver){hK.marker.style.zIndex=hK.tooltip.style.zIndex=hK.zIndex}}}}if(hT&&hT.length>0){var hR={};for(hV=0;hV<hl.hotSpotsAtThisFrame.length;hV++){var hD=hl.hotSpotsAtThisFrame[hV];hK=hD.hotspot;if(!hK._bMouseOver){hK.marker.style.zIndex=hK.tooltip.style.zIndex=hK.zIndex}hR[hD.index]=hK.bVisible}for(hV=0;hV<hT.length;hV++){if(!hR[hT[hV].index]){bQ(hT[hV].hotspot,false)}}}}if(hl.scale!==hf){hl.scale=hf;hU=true}for(hW=0;hW<hl.hotSpotsAtThisFrame.length;hW++){var hE=hl.hotSpotsAtThisFrame[hW];hK=hE.hotspot;hL=1;if(cX.visibleHotSpots){hL=cX.visibleHotSpots[hK.FSIHotspotID]}hL=hL*hE.op;if(!hU&&hK._opScale!==b){if(hK._opScale===0){hL=0}}else{hK._opScale=1;if(gH.enableZoom&&hK.perimeterZoom!==b){if(hf<hK.perimeterZoom){hL=hK._opScale=0}}if(hL!==0&&hK.perimeterImageWidth!==b){if(hl.testWidth<hK.perimeterImageWidth){hL=hK._opScale=0}}}if(hL!==0){hO.setFromMatrixPosition(hK.object.matrixWorld);hO.project(dT.camera);var hH=Math.round(hY+hO.x*hZ+hZ);var hG=Math.round(hX+hF-hO.y*hF);if(cc.enabled){if(hH<0||hG<0||hH>h1||hG>h0){hL=0}}}if(hL!==0){bQ(hK,true);if(hK._opacity!==hL){hK._opacity=hL;hK.marker.style.opacity=hK.tooltip.style.opacity=hL}var hM=hK.oSvg;hK.tooltip.style.left=hH+hM.endX+(hK.tooltip.offsetWidth*hM.xAlign)+"px";hK.tooltip.style.top=hG+hM.endY+(hK.tooltip.offsetHeight*hM.yAlign)+"px";hK.marker.style.left=hH+hM.startX+"px";hK.marker.style.top=hG+hM.startY+"px";if(hK.elSVGIcon){if(!hK._bIconCentered){hK._bIconCentered=true;var hI=hK.elSVGIcon.getBBox();var hQ=-hI.x-hI.width/2;var hP=-hI.y-hI.height/2;var hN="translate("+(hK._data.x1+hQ)+","+(hK._data.y1+hP)+")";hK.elSVGIcon.setAttribute("transform",hN)}}}else{bQ(hK,false)}}};var aW=function(hF,hK,hD,hJ,o,hI,hG,hE,hH){if(hE===b){hE=bD}if(hH===b){hH=1}var hL=document.createElementNS(dI,"polyline");hL.setAttribute("points",hF+","+hK+" "+hD+","+hJ+" "+o+" , "+hI+" "+hD+","+hJ+" "+hF+","+hK);hL.setAttribute("stroke",hG);hL.setAttribute("stroke-width",hE);hL.setAttribute("stroke-opacity",hH);hL.setAttribute("stroke-linecap","square");return hL};var a1=function(){var hD=aP=document.createElementNS(dI,"svg");try{if(!hD.style){aP=b;dE.log("ERROR: SVG Gradient not supported");return false}}catch(hF){aP=b;dE.log("ERROR: SVG Gradient not supported");return false}var hI=a.utils.getSVGID();var hE=gH.hotspotDotRadius;hD.setAttribute("xmlns",dI);hD.setAttribute("version",f1);hD.setAttribute("baseProfile","tiny");var o=bV=hD.cloneNode(true);try{var hK=document.createElementNS(dI,"radialGradient");hK.setAttribute("id",hI);hK.setAttribute("cx","0.5");hK.setAttribute("cy","0.5");hK.setAttribute("r","0.5");var hJ=document.createElementNS(dI,"stop");hJ.setAttribute("stop-color",gH.hotspotDotColor1);hJ.setAttribute("offset","0.5");var hH=document.createElementNS(dI,"stop");hH.setAttribute("stop-color",gH.hotspotDotColor2);hH.setAttribute("offset","1");hK.appendChild(hJ);hK.appendChild(hH);o.appendChild(hK);o.style.position="absolute";o.style.width="0px";o.style.height="0px";o.style.left="0";o.style.top="0";o.style.zIndex=-500000;o.style.visibility="hidden";ac.appendChild(o)}catch(hF){dE.log("ERROR: SVG Gradient not supported")}var hG=document.createElementNS(dI,"circle");hG.setAttribute("class","fsi-ui-hotspot-spot");hG.setAttribute("r",hE);hG.setAttribute("stroke",gH.hotspotLineColor2);hG.setAttribute("stroke-width","1px");hG.setAttribute("stroke-opacity","0.85");hG.setAttribute("fill","url(#"+hI+")");hG.setAttribute("fill-opacity","0.5");hD.appendChild(hG);return true};var be=function(hI){var hM=hI.horizontalMarkerSize;var hQ=Math.abs(hI.verticalMarkerSize);var hU;if(!aP){return{width:0,height:0,startX:0,startY:0,endX:0,endY:0,xAlign:0,yAlign:0}}var hK=hI.markerAngle*Math.PI/180;var hR,hG,hP,hF,hN,hE;var hW={};var hH=hW.radius=gH.hotspotDotRadius+1;hU=Math.max(0,Math.min(1,hI.horizontalMarkerPosition));if(hU>0.5){hM=-hM}hW.xAlign=-hU;hU=Math.max(0,Math.min(1,hI.verticalMarkerPosition));hW.yAlign=-hU;hR=0;hG=0;hP=hR+Math.sin(hK)*hQ;hF=hG-Math.cos(hK)*hQ;hN=hP+hM;var hS=Math.min(hR-hH,hP);var o=Math.min(hG-hH,hF);hS=Math.min(hS,hN);hR-=hS;hP-=hS;hN-=hS;hG-=o;hF-=o;hE=hF;hW.startX=-hR;hW.startY=-hG;hW.endX=hW.startX+hN;hW.endY=hW.startY+hE;var hV=Math.max(hR+hH,hP);hV=Math.max(hV,hN);var hD=Math.max(hG+hH,hF);var hL=hW.svg=aP.cloneNode(true);var hJ=hW.width=hV;var hO=hW.height=hD;hL.setAttribute("width",hJ);hL.setAttribute("height",hO);hL.setAttribute("viewBox","0 0 "+hJ+" "+hO);hL.setAttribute("class","fsi-ui-hotspot-line");var hT=hL.firstChild;hT.setAttribute("cx",hR);hT.setAttribute("cy",hG);hI._data={x1:hR,y1:hG,};hR+=Math.sin(hK)*hH;hG-=Math.cos(hK)*hH;hL.appendChild(aW(hR,hG,hP,hF,hN,hE,gH.hotspotLineColor1,"5px","0.25"));hL.appendChild(aW(hR,hG,hP,hF,hN,hE,gH.hotspotLineColor2,"1px"));return hW};var bQ=function(hD,o){if(hD.bVisible===o){return}hD.bVisible=o;if(o){hD._opacity=b;hD.marker.style.display="block";if(!hD.tooltip.FSIEmpty){hD.tooltip.style.display="block"}}else{hD.marker.style.display="none";if(!hD.tooltip.FSIEmpty){hD.tooltip.style.display="none"}hD._opacity=0;hD.marker.style.opacity=hD.tooltip.style.opacity=0}};var dw=function(hI){var hD;var hH=be(hI);if(!hI.text){hD=document.createElement("div");hD.style.display="none";hD.FSIEmpty=true;while(hH.svg.firstChild){hH.svg.removeChild(hH.svg.firstChild)}}else{hD=document.createElement("div");var hF="fsi-ui-hotspot";if(cd){hF+=" "+cd}if(hI.cssClass!==b&&hI.cssClass.length>0){hF+=" "+hI.cssClass}if(hI.normalClass.length>0){hI.normalClass=hF+" "+hI.normalClass}else{hI.normalClass=hF}if(hI.hoverClass.length>0){hI.hoverClass="fsi-ui-hotspot-hover "+hI.hoverClass}else{hI.hoverClass="fsi-ui-hotspot-hover"}if(hI.activeClass.length>0){hI.activeClass="fsi-ui-hotspot-active "+hI.activeClass}else{hI.activeClass="fsi-ui-hotspot-active"}hD.className=hI.normalClass;var hG="position:absolute;left:0px;top:0px;-webkit-user-drag: none; -webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;"+hI.cssStyle;a.utils.setStyleAttr(hD,hG);hD.innerHTML=hI.text;if(gH.decodeHTMLEntitiesInHotSpotTexts){hD.innerHTML=hD.innerText}}if(hI.icon){var hJ=document.createElementNS(dI,"g");hJ.innerHTML=a.trim(hI.icon);hJ.setAttribute("class","fsi-viewer-hotspot-icon");hI.elSVGIcon=hJ;hH.svg.appendChild(hJ);hH.svg.style.overflow="visible";if(hI.iconScaleX!==1||hI.iconScaleY!==1){hI.elSVGIcon.firstChild.setAttribute("transform-origin","center center");var hE="scale("+hI.iconScaleX+","+hI.iconScaleY+")";hI.elSVGIcon.firstChild.setAttribute("transform",hE)}}var o;if(hH&&hH.svg){o=hH.svg;o.style.position="absolute";ac.appendChild(o);o.FSIHotspot=hI;if(hI.interactive){a.addEvent(o,"mouseenter",fs);a.addEvent(o,"mouseleave",fs)}}else{o={style:{}}}ac.appendChild(hD);if(hI.interactive){hD.FSIHotspot=hI;if(!hD.FSIEmpty){a.addEvent(hD,"mouseenter",fs);a.addEvent(hD,"mouseleave",fs)}}else{hD.style.zIndex="1"}hI.bVisible=false;hI.tooltip=hD;hI.marker=o;hI.oSvg=hH;hD.style.display="none";o.style.display="none"};var c6=function(o){aI();var hD=true;var hE=(ev&&!de);fC=o.shiftKey;switch(o.keyCode){case 37:if(hE){bZ();dN=1;hc(el+dO)}hD=false;break;case 39:if(hE){bZ();dN=-1;hc(el-dO)}hD=false;break;case 32:hD=false;break}if(!hD&&o.preventDefault){o.preventDefault()}return hD};var cs=function(o){fC=o.shiftKey;if(dE&&dE.on){if(!fC){b6(b7)}}var hD=true;var hE=(ev&&!de);switch(o.keyCode){case 37:if(hE){eS(eG,true)}hD=false;break;case 39:if(hE){eS(eG,true)}hD=false;break;case 32:bj.resetView();hD=false;break}if(!hD){o.cancelBubble=true;if(o.stopPropagation){o.stopPropagation()}if(o.preventDefault){o.preventDefault()}}return hD};this.resetView=function(o){if(o===b){o=true}aI(false);eE();dx=bK;if(gH.initialview&&gH.initialViewPersistent){ha(gH.initialview,o)}else{ha("1,1,0,0,1,1",o)}dx=bK};this.spinToDegree=function(o){if(!cu){return}var hD=hv(Math.round(o/360*ev));bj.spinToTarget(hD)};this.spinToTarget=function(hF,hI,hG){if(!cu){return}hF=dq(hF);var hL=hv(eG);var hH=hF-hL;var o=(hI!==b&&!isNaN(hI)&&hI!==a5.nCurrent);if(hH===0&&!o){eo(hF,hF,0,0);return true}var hK;if(hH!==0){dN=(hH>0)?1:-1;hK=hL;if(!gH.noSceneLoop){if(Math.abs(hH)>ev/2){if(dN>0){hF-=ev}else{hK-=ev}dN=-dN;hH=Math.abs(hF-hK)}}}else{hK=hF}var hD=a5.nCurrent;var hJ;if(o&&!gH.noSetLoop&&a5.nSceneSets>1){hJ=hI-a5.nCurrent;if(Math.abs(hJ)>a5.nSceneSets/2){if(hJ>0){hI-=a5.nSceneSets}else{hD-=a5.nSceneSets}}}bZ();if(hG===b||isNaN(hG)){hG=4;if(hH!==0){hG=Math.ceil(0.2*360/ev*Math.abs(hH))}if(o){hJ=Math.abs(hI-hD);var hE=Math.ceil(0.1*360/a5.nSceneSets*hJ);hG=Math.max(hG,hE)}}eo(hK,hF,0,hG,hD,hI);return true};var ae=function(o){if(a5.nSceneSets<2){return 0}if(gH.noSetLoop){o=Math.max(0,Math.min(a5.nSceneSets-1,o))}else{o=o%a5.nSceneSets;if(o<0){o=a5.nSceneSets+o}}return o};var d8=function(){cX={};a5.bSetCameraPosition=false;a5.initialScene=a5.initialSceneSet=a5.nCurrent=0;a5.arCurrentSetIndex=false;bI=ak=he.length;cV=(e.length>0)?e.length:bI;aZ(cV);a0=false};var bs=function(){if(a5.bHasMultipleSets||!a5.bDefault){aZ(a5.quantizeMax);ak=a5.quantizeMax;a5.nCurrent=b;fY(0)}else{d8()}};var fY=function(hE){hE=ae(hE);if(hE===a5.nCurrent){return}a5.nCurrent=hE;cX=a5.arSets[hE];var hD=a5.arCurrentSetIndex=a5.arSets[hE].arScenes;a0=hD;bI=a5.quantizeMaxImages;cV=bI;if(a5.nVideoSet!==b){if(a5.nVideoSet===hE){ak=bI=hD.length;cV=dL;if(gn){gn.setPreviewImageSize(c1.croppedWidth,c1.croppedHeight)}if(!fp){eu("video",true)}a0=b}else{if(gn){gn.setPreviewImageSize()}ak=a5.quantizeMax;if(fp){eu("image",true)}}}fo();dQ();var o=eG;eU=eG=b;if(dt){dt.spinPos=b}cl(o);hm();return hE};var fo=function(){if(!a5.bSetCameraPosition||!cX.posCamera){return}var o=cX.posCamera;dT.camera.position.set(o.x,o.y,o.z);dT.camera.lookAt(dT.targetObj.position);dT.camera.rotation.z=0};var a7=function(o){o=Math.max(0,Math.min(ev-1,o));return o};var e8=function(o){o%=ev;if(o<0){o=ev+o}return o};var dq=function(hD,hG){if(!g9){return hD}var hF;var o=ev/bI;var hE=Math.round(hD/o)*o;if(!hG||hD===hE){hF=hE}else{if(dN===1){hF=Math.round(hE+o)}else{hF=Math.round(hE-o)}}hF=hv(hF);return hF};var eS=function(o,hF){var hD=(o!==b)?o:eG;var hE=dq(hD,hF);bj.spinToTarget(hE)};var eo=function(o,hG,hH,hF,hE,hD){o=Math.round(o);hG=Math.round(hG);bZ();if(hD!==b&&!isNaN(hD)&&hD!==a5.nCurrent){if(hE===b){hE=a5.nCurrent}}else{hE=b}if(o!==hG||hE!==hD){if(bt(o,hG,hH,hF,hE,hD)){b8("spinToFrame")}else{gv("doSpinToFrame")}}else{gv("doSpinToFrame")}};var bZ=function(){if(fI===b){return}cancelAnimationFrame(fI);fI=b;gv("cancelSpinToFrame")};var bt=function(hG,hM,hL,hH,hD,hJ){var hK=hM-hG;var hI;if(hK===0){hI=hM}else{hI=dU(hL,hH,hG,hK)}var hF;if(hD!==b){var hE=hJ-hD;hF=Math.round(dU(hL,hH,hD,hE))}if(hL!==hH){if(e1){e1.lockImageSourceDimension(b3,true);e1.lockImage(b3,true)}var o=Math.round(hI);if(o<0){o=ev+o}else{if(o===ev){o=0}}fI=requestAnimationFrame(function(){if(hD!==b){fY(hF)}if(o!==eG){dQ();cl(o);hm()}bt(hG,hM,++hL,hH,hD,hJ)});return true}else{fI=b;if(e1){e1.lockImage(b3,false)}cl(hv(hM));if(hJ!==b){fY(hJ)}ci();cn();gv("doSpinToFrame")}};var ci=function(){cl(hv(eG));hm();if(i){fr()}};var g1=function(hD){var o={};o.baseURL=gt.getImageURL(he[hD],fm);o.fullURL=o.baseURL+g4;return o};var fx=function(){if(!dt){return}cq=b;dt=b;bo=b;Y=true;V();ei()};var ei=function(){aT.abortPurpose("tile")};var bW=function(){if(bE===bS){return}bE=bS;var o=fz.getPixelRangeRect(bS);g4=fz.getPixelRangeParametersByCalculatedResult(o)};var aK=function(o){if(o===b){o=Math.round(eG/(ev/ak))}if(isNaN(o)||o<0||o>=ak){dE.error("invalid image index in loadHDImage "+o);return}if(a5.arCurrentSetIndex){o=a5.arCurrentSetIndex[o]}o-=dL;return o};var fr=function(hP){if(i&&!fp&&hf<=1){fx();return}if(fc||cq===bS){return}cq=bS;hP=aK(hP);bW();var o=g1(hP);if(bo===o.fullURL){return}if(dt&&o.fullURL===dt.src){return}cA={};cA.img=new Image();cA.nImage=hP;cA.renderScale=hf;var hD=ev/bI;cA.spinPos=dq(hP*hD);cA.img.crossOrigin="anonymous";cA.img.FSI_ImageObject=cA;bo=cA.src=o.fullURL;if(i){Y=true;cA.bTilesFading=false;cA.bFillsViewport=false;var hK=e2.width;var hJ=e2.height;var hI=bS;var hG=Math.round(hI/hK*hJ);ei();cA.width=hI;cA.height=hG;var hQ=fH;cA.tiles=[];var hN=0;var hL=0;var hO=hQ;var hM=hQ;hO=Math.min(hO,hI);hM=Math.min(hM,hG);var hF;var hE=false;while(hL<hG){hF={};hF.fnDraw=ex;hF.FSI_ImageObject=cA;hF.x=hN;hF.y=hL;if(hN+hO>=hI){hF.width=hI-hN;hO=Math.min(hQ,hI-hN);hE=true}hF.width=hO;hF.height=hM;var hH=fz.getPixelRangeParameters(hI,hG,hN,hL,hO,hM);hF.url=o.baseURL+hH;if(hE){hE=false;hL+=hQ;hN=0;hO=hQ;if(hL+hQ>hG){hM=Math.min(hQ,hG-hL)}}else{hN+=hQ}cA.tiles.push(hF)}cA.nTiles=cA.tiles.length;cA.arVisibleTiles=new Array(cA.nTiles);cA.nVisibleTiles=0;cA.nTilesLoading=0;cA.nTilesLoaded=0;cA.nTilesRequested=0;cA.nTileColumns=Math.ceil(hI/hQ);cA.nTileRows=Math.ceil(hG/hQ);C=true;W(null,cA)}};var en=function(o){o.bLoading=true;o.img=new Image();o.img.oTile=o;f9(o.img,o.url,"tile",bf)};var bf=function(){a.removeEvent(this,"load",bf);var hD=this.oTile;hD.bLoading=false;hD.bLoaded=true;var o=hD.FSI_ImageObject;if(o.nTilesLoaded===o.nTiles){o.bComplete=true;o.bFillsViewport=true}if(o.src!==bo){return}hD.alpha=0;hD.fnDraw=gY;o.nTilesLoading--;o.nTilesLoaded++;W(null,o);cy(this);hm();c4(25)};var ch=function(hD,o){return o.distance-hD.distance};var g8=function(){C=false;if(!dt){return}var hJ=dt;var hT,hS,hE,o;var hI;if(cc.enabled){fE.setRect(0,0,bl.width,bl.height);fE.scaleRect(1/cc.scale);fE.offsetRect(-cc.panPos.left/hf,-cc.panPos.top/hf);fE.offsetRect((bl.width-fE.width())/2,(bl.height-fE.height())/2);dS.copyRect(ba);dS.scaleRect(1/cc.scale);dS.offsetRect(fE.left,fE.top);hI=dS}else{hI=ba}ct(hI);hT=fX.left;hS=fX.top;hE=fX.right;o=fX.bottom;var hP=Math.max(0,Math.floor(hT/fH));var hF=Math.min(hJ.nTileColumns-1,Math.floor(hE/fH));var hO=Math.max(0,Math.floor(hS/fH));var hD=Math.min(hJ.nTileRows-1,Math.floor(o/fH));var hG=hF-hP+1;var hK=hD-hO+1;var hL=Math.max(0,hK)*hG;if(hJ.nFirstTileXLastGetVisible===hP&&hJ.nFirstTileYLastGetVisible===hO&&hJ.nTilesLastGetVisible===hL){return}hJ.nFirstTileXLastGetVisible=hP;hJ.nFirstTileYLastGetVisible=hO;hJ.nTilesLastGetVisible=hL;var hV=hJ.tiles;var hU=hJ.arVisibleTiles;var hM=hO*hJ.nTileColumns;var hH=hP;var hN;var hR=ht;for(var hQ=0;hQ<hL;hQ++){hN=hU[hQ]=hV[hM+hH];if(!hR&&hN.alpha!==1){hR=true}if(++hH>hF){hH=hP;hM+=hJ.nTileColumns}}hJ.nVisibleTiles=hL;hJ.bFilesArePreparedForLoading=false;if(hR&&!Y){cB.globalAlpha=1;gf()}if(hR){Y=hR}c4(50)};var V=function(){if(gK){clearTimeout(gK);gK=b}};var c4=function(o){if(gK!==b){return}if(!dt||dt.bRequestsComplete){return}gK=setTimeout(gV,o)};var gV=function(){V();G()};var G=function(){if(X){return}var hG=dt;if(hG.nTilesLoading>=eY){return}var hJ,hE,hD,hF,hI;if(!hG.bFilesArePreparedForLoading){hG.bFilesArePreparedForLoading=true;if(!hG.arTilesToLoad||hG.arTilesToLoad.length!==0){hG.arTilesToLoad=[]}hJ=hG.arTilesToLoad;var hH=hG.arVisibleTiles;for(hF=0;hF<hG.nVisibleTiles;hF++){if(!hH[hF].bLoaded&&!hH[hF].bLoading){hJ.push(hH[hF])}}if(hJ.length>1){cc.centerX=fX.left+fX.width()/2;cc.centerY=fX.top+fX.height()/2;for(hF=0;hF<hJ.length;hF++){hI=hJ[hF];hE=hI.x-cc.centerX+hI.width/2;hD=hI.y-cc.centerY+hI.height/2;hI.distance=Math.abs(hE)+Math.abs(hD)}hJ.sort(ch)}}var o=0;hJ=hG.arTilesToLoad;while(hG.nTilesLoading<eY&&hJ.length>0){hI=hJ.pop();en(hI);o++;hG.nTilesLoading++}hG.nTilesRequested+=o;if(hG.nTilesRequested===hG.nTiles){hG.bRequestsComplete=true}};var W=function(o,hD){if(hD===b){a.removeEvent(this,"load",W);hD=this.FSI_ImageObject;hD.width=this.width;hD.height=this.height}if(hD.src!==bo){return}cy(this);dt=hD;if(hA){return}if(gA){hm()}};this.clickMenuButton=function(o){g3.pressMenuButton(o,b,true);g3.releaseMenuButton(o,b,true);g3.clickMenuButton(o,b,true)};this.pressMenuButton=function(o){cZ.pressButton(o)};this.releaseMenuButton=function(o){cZ.releaseButton(o)};g3.onUserAction=function(){};g3.getInteractive=function(){return cu};g3.pressMenuButton=function(hE,o,hG){if(!hG){g3.onUserAction()}if(hE!=="ToggleAutoSpin"&&hE!=="ToggleFullScreen"){aI()}eE();bY();var hD,hF;if(hE.indexOf("_")!==-1){hD=hE.split("_");hE=hD[0];hF=hD[1]}switch(hE){case"ToggleCube3D":g3.showCube(b);break;case"Reset":bj.resetView();break;case"ZoomOut":case"ZoomIn":ah(hE,150,10);break;case"MouseMode":fk(parseInt(hF));break;case"MaxZoom":fP(b,b,cc.scaleToSourceImage-hf,false,30);break}};var cH=function(hD,o){if(!cZ){return false}return cZ.enableButton(hD,o)};g3.releaseMenuButton=function(hD,o,hE){if(!hE){g3.onUserAction()}bY()};g3.clickMenuButton=function(hF,o,hH){var hD,hG;if(typeof(hF)==="string"&&hF.indexOf("_")!==-1){hD=hF.split("_");hF=hD[0];hG=hD[1]}switch(hF){case"ToggleFullScreen":if(a.FullScreen.getEnabled()){a.FullScreen.quit();dB()}else{var hE=dK;if(typeof(hE)==="string"){hE=document.getElementById(hE);if(!hE){hE=aw}}d0=hE;a.FullScreen.start(hE);dB()}break;case"HotSpots":ds=cZ.getButtonPressed("HotSpots");gc(ds);break;case"ToggleAutoSpin":gN();break}};var al=function(hD){if(!cc.enabled){return}var o=hf;gd(hD);cc.panPos.left*=hf/o;cc.panPos.top*=hf/o;ca(true)};var fG=function(hD){var o;if(!hD){hD=bO.cmd;bO.nRepeatCount++}switch(hD){case"ZoomOut":o=(bO.nRepeatCount<1)?1.01:1.035;al(cc.scale/o);break;case"ZoomIn":o=(bO.nRepeatCount<1)?1.01:1.035;al(cc.scale*o);break}if(bO.nRepeatCount===1){if(bO.intervalTimeFirst!==bO.intervalTimeRepeat){clearInterval(bO.interval);bO.interval=setInterval(fG,bO.intervalTimeRepeat)}}};var ah=function(hE,o,hD){aV(false);bY();bO={};bO.bRunning=true;if(o===b){o=500}bO.intervalTimeFirst=o;if(hD===b){bO.intervalTimeRepeat=o}else{bO.intervalTimeRepeat=hD}bO.nRepeatCount=0;bO.cmd=hE;bO.interval=setInterval(fG,bO.intervalTimeFirst);fG(hE)};var bY=function(){if(!bO.bRunning){return}aV(true);clearInterval(bO.interval);switch(bO.cmd){case"ZoomOut":case"ZoomIn":e0();break}bO={}};var eZ=function(o){if(Z!==b){if(Z.width!==bm.imageWidth){bL()}else{return}}if(fJ>0&&e.length===fJ){return}bL();aT.abortPurpose("asyncResize");Z={};Z.width=bm.imageWidth;Z.previewImageCanvasWidthBeforeResize=o;Z.uniqueInstanceID=au;Z.nTimeout=setTimeout(ed,50)};var ed=function(){if(!cu){Z.nTimeout=setTimeout(ed,250);return}Z.nTimeout=b;Z.img=new Image();a.addEvent(Z.img,"load",at);a.addEvent(Z.img,"error",at);var hE=0;var hD=du;Z.pos=0;Z.arIndex=new Array(he.length);if(hD>=fJ){Z.arIndex[0]=hD;hE+=1}for(var o=fJ;o<e.length;o++){if(o!==du){Z.arIndex[hE++]=o}}at()};var at=function(o){if(o!==b){if(!Z||Z.uniqueInstanceID!==au){return}a.removeEvent(Z.img,"load",at);cy(Z.img);e[Z.indexCurrent]=Z.img;if(Z.indexCurrent===du){aH=b;c9=b;eU=b;b4(Z.indexCurrent);hm()}Z.img=new Image();a.addEvent(Z.img,"load",at)}Z.indexCurrent=Z.arIndex[Z.pos];Z.pos++;if(Z.pos>he.length){bL()}else{var hD=bS;bS=aN;bW();Z.url=g1(Z.indexCurrent-dL).fullURL;bS=hD;bW();Z.nTimeout=setTimeout(dm,25)}};var dm=function(){f9(Z.img,Z.url,"asyncResize")};var bL=function(){if(Z===b){return}if(Z.nTimeout){clearTimeout(Z.nTimeout);Z.nTimeout=b}a.removeEvent(Z.img,"load",at);a.removeEvent(Z.img,"error",at);Z=b};var cY=function(){dB()};var a4=function(){dE.error("ERROR entering FullScreen")};this.setFullScreenElement=function(o){if(eh){dB();a.FullScreen.quit()}dK=gt.cfg.fullscreenelement=o};var dB=function(){var o=a.FullScreen.getEnabled();if(o&&eT()){return}if(o===eh){return}if(cZ){cZ.setButtonPressed("ToggleFullScreen",o)}cL.runPersistent("onFullScreen",[o]);eh=o;a.setCustomEventListenerProperty(gZ,"skiptreshold",true);if(m){bj.showAboutWindow()}if(o){a.addClass(d0,"fsi-fullscreen-element")}else{a.removeClass(d0,"fsi-fullscreen-element")}if(!o){d0=b}if(o){cK()}else{if(fQ.bRestore){gg();if(ge.bEnabledByConfig){setTimeout(fN,0)}}}};this.getInFullScreenMode=function(){return eh};this.getSpinFrames=function(){return ev};this.getImageIsTransparent=function(){return dW};this.getSrcDim=function(){return e2};if(typeof(er)!=="object"||a.makeBool(er.autoInit,true)){bj.init(gy,er)}};a.customTags.register("fsi-viewer",{constructorClass:a.Viewer,viewerCSS:"display:block;width:300px;height:300px;",parameterAliases:{src:"imagesrc"}});a.dispatchEvent("FSIViewerLoaded")}(window.$FSI=window.$FSI||{}));