/*!
 * FSI Image Flow
 * Build: 19.05.6483
 * 
 * Copyright (c) 2019 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2019",strBuild:"19.05.6483",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}if(ar.renderer===b){ar.renderer="jpeg"}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim]}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=a.utils.urlDecode(ay[0]).toLowerCase();if(ax.length>0){ar=a.utils.urlDecode(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=a.utils.urlDecode(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=a.utils.urlDecode(n.getAttributeValue(aO,"src"))}if(!aK){aK=a.utils.urlDecode(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(au){var aA,ay,av;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var az=n.cfg.fpxsources;if(typeof(az)==="string"||(typeof(az)==="object")&&typeof(az.push)==="function"){aA={};aA.oXML=null;if(typeof(az)==="string"){if(ae===false){aA.arImages=az.split(",");for(ay=0;ay<aA.arImages.length;ay++){aA.arImages[ay]=a.utils.urlDecode(aA.arImages[ay])}}else{var ax=az.split(",");aA.arImages=[];for(ay=0;ay<ax.length;ay++){av=a.utils.urlDecode(ax[ay]);if(ae(av)){aA.arImages.push(av)}}}}else{aA.arImages=az}}}if(!aA&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aB=n.arUnrecognizedConfigNodes;for(ay=0;ay<aB.length;ay++){var aw=aB[ay];if(typeof(aw.nodeName)==="string"){var at=aw.nodeName.toLowerCase();if(at==="images"||at==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aA=S(aw,au);aA.oXML=aw;break}}}}}if(!aA&&n.cfg&&n.cfg.fpxsrc!==b){aA={};aA.oXML=null;if(ae===false){aA.arImages=[a.utils.urlDecode(n.cfg.fpxsrc)]}else{av=a.utils.urlDecode(n.cfg.fpxsrc);if(ae()){aA.arImages=[av]}}}return aA};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=n.XMLChildNodesToString(aF)}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(a.getViewerLocation()+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=a.getViewerLocation()+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!==b){return}a.Easing={easeLinear:function(f,g,e,h){return h*(f/g)+e},easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f===0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f===g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f===0){return e}if(f===g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j/2)===2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.ImageFlow!==b){return}a.utils.API.ImageFlow=function(d,e){var c=this;c.scriptMainFile="FSI.ImageFlow.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},closeZoom:{a:"evt, bImmediate"},destroy:{},dumpListeners:{},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getConfigValue:{a:"strName",r:"mixed"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getParameters:{r:"oParameters"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},printAPI:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},zoomImage:{a:"nImage"}};c.oCallbacks={onClick:{a:"nImageIndex, strImagePath"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ImageFlow!==b){return}a.ImageFlow=function(aH,d){var a0={};var bG={strVersion:"2019",strBuild:"19.05.6483",strConfigSection:"ImageFlow",bHasListeners:true};var bE=new a.utils.ClassDef(this,"FSI ImageFlow",bG);bE.oAPI=new a.utils.API.ImageFlow(this,a0);var aN=bE.instance;a.utils.guessFSIViewerLocation("fsiimageflow.js",3);var bf=a.utils.getViewerInstanceID();this.getInstanceID=function(){return bf};this.getInstanceName=function(){return bE.strClassName+" ["+aB+"]"};var a7=(d)?a.utils.cloneParameters(d):{};var at;var aB;var ao;var bQ=false;var bh;var w;var bR=[];var cq;var aO;var a8;var W=0;var bz={};var bx;var am,aV;var bN;var bw;var aR={};var a4=false;var B;var by;var b1;var U;var aJ;var bk;var bU;var aI;var bZ;var c=4;var aL;var bP=false;var aT=false;var bJ;var z;var aK;var K=false;var cg;var l;var bc;var bM;var aS;var bl;var ck;var aF,aQ,y;var P=0;var bW=0;var q;var b2;var ae;var ba;var bD;var aj;var bt;var bb,bC;var V=[];var ac={};var a3;var be;var p={};var b0;var b4;var Q={};var az={};var ch;var S={};var Y;var co;var a2;var aD=0;var bT;var ci;var bX;var x;var bn={};var aU;var D;var aX=/((\?)|&)(width|height)=[^&]*/ig;var aP;var bS;var cr;var ce;var a5;var ap;var aq;var bd;var aM;var i;var b5={};var f=0;var ag=8;var g=[];var ca=true;var A=false;var cd=0;var ab;var bL={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",scrollColor:"#999",placeHolderColor:"#EEEEEE",backgroundColor:"#FFF",zoomBorderStyle:"solid",zoomBorderColor:"#777",zoomBackgroundColor:"white",zoomFadeColor:"white",imageBorderColor:"none",presentationType:"carousel",elementWidth:"10%",elementSpacing:"0.25%"},booleans:{autoDestroy:true,autoResize:true,enableZoom:true,enableScrollBar:true,transparency:false,centerZoomedImage:true,zoomCenteredImageOnly:false,positionQuantization:false,endlessScrolling:false,duplicateImagesIfNeeded:false},floats:{mirrorHeight:0.5,mirrorStartOpacity:0.5,backgroundDarkness:0.3,depthFadeout:0.2,curveHeight:0.35,autoRotateSpeed:0,scrollAlphaNormal:0.35,scrollAlphaActive:1},integers:{zIndexZoom:1000,preloadCount:20,paddingTop:10,paddingBottom:0,zoomFadeOpacity:80,zoomBorderWidth:4,scrollPadding:0,scrollHeight:16}};var r=new a.EmptyDebugger();var ay=function(ct,cs){if(cs&&!r.on&&ct.on){if(by){by.stopPendingRequests()}aN.destroy();aN.init(ab,a7,true);return true}r=ct;if(r.on){r.setPrefix(aN.getInstanceName())}};this.init=function(ct,cw,cs){var cu;ab=ct;if(!a.BrowserSupports.canvas()){r.error("<canvas> element not supported.");return}if(!ct){return}if(typeof(ct)==="object"){if(typeof(ct.id)==="string"){aB=ct.id}}else{if(typeof(ct)==="string"){aB=ct}}if(!aB){aB="fsi.imageflow #"+bf}if(aN._fsi_parameters){cw=aN._fsi_parameters;delete aN._fsi_parameters}if(typeof(ct)==="object"&&ct.tagName!==b){cu=ct}else{cu=document.getElementById(ct)}if(!cu){return}if(bQ){aN.destroy()}cd++;bh=cu;bh.setAttribute("data-fsi-id",aB);cu.innerHTML="";w=document.createElement("div");a.utils.setStyleAttr(w,"width:100%;height:100%;border:0px;none;margin:0px;padding:0px;overflow:hidden");bh.appendChild(w);a7=(cw)?a.utils.cloneParameters(cw):a7;var cx={};cx.onConfigsReady=av;cx.onDebuggerChange=ay;by=new a.Config(null,cx,{strSection:bE.strConfigSection});b1=a0.iCallbacks=new a.Callbacks(aN,by);if(b1.isset("onInit")){b1.run("onInit",[a7])}var cv=a7;if(cs){cv=a.utils.cloneObject(a7);cv.debug=true}by.init(cv);r.log(aN.getVersion());ao={};by.loadConfigs();bQ=true};this.getConfigValue=function(cs){if(by&&typeof(cs)==="string"){return by.cfg[a.trim(cs.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(a7)};this.getInitDone=function(){return bQ};var bF=function(ct){var cs=ct.oCrop={};bs(cs,"rectLeft",ct.sourceWidth,0);bs(cs,"rectTop",ct.sourceHeight,0);bs(cs,"rectRight",ct.sourceWidth,1);bs(cs,"rectBottom",ct.sourceHeight,1);cs.rectWidth=1-cs.rectRight-cs.rectLeft;cs.rectHeight=1-cs.rectBottom-cs.rectTop;cs.bCrop=true;cs.query=cs.rectLeft+","+cs.rectTop+","+cs.rectWidth+","+cs.rectHeight};var bs=function(cx,cu,cv,ct){var cw=b5[cu];if(typeof(cw)!=="string"){cx[cu]=cw;return}var cs=parseInt(cw);if(isNaN(cs)){cx[cu]=ct;return}cs=Math.max(0,Math.min(cv,cs));cx[cu]=cs/cv};var bA=function(cu,ct){cu=cu.toLowerCase();var cs=ct;if(cu.indexOf("px")!==-1){cs=parseInt(cu);if(isNaN(cs)||cs<=0){cs=ct}else{cs=""+cs+"live";b5.bLive=true}}else{if(cu.indexOf("%")!==-1){cs=Math.max(0,Math.min(100,parseFloat(cu)));cs/=100;if(isNaN(cs)||cs<0){cs=ct}}else{cs=Math.max(0,Math.min(1,parseFloat(cu)));if(isNaN(cs)||cs<0){cs=ct}}}return cs};var ad=function(){var ct;var cu=b5;cu.rectWidth=cu.rectHeight=1;cu.rectLeft=cu.rectTop=0;cu.bCrop=b5.bLive=false;cu.query="";if(ao.cropValues&&ao.cropValues.length>6){ct=ao.cropValues.split(",");cu.rectLeft=bA(ct[0],0);cu.rectTop=bA(ct[1],0);cu.rectRight=bA(ct[2],0);cu.rectBottom=bA(ct[3],0);cu.rectWidth=1-cu.rectRight-cu.rectLeft;cu.rectHeight=1-cu.rectBottom-cu.rectTop;cu.bCrop=true;if(!cu.bLive){cu.query=cu.rectLeft+","+cu.rectTop+","+cu.rectWidth+","+cu.rectHeight}}else{if(ao.cropRect&&ao.cropRect.length>6){ct=ao.cropRect.split(",");if(ct.length>3){while(ct.length>4){ct.pop()}for(var cs=0;cs<ct.length;cs++){ct[cs]=parseFloat(ct[cs])}var cv=ct[0]*ct[1]*ct[2]*ct[3];if(isNaN(cv)){return}cu.rectLeft=ct[0];cu.rectTop=ct[1];cu.rectRight=ct[2];cu.rectBottom=ct[3];cu.rectWidth=ct[2]-ct[0];cu.rectHeight=ct[3]-ct[1];cu.bCrop=true;cu.query=cu.rectLeft+","+cu.rectTop+","+cu.rectWidth+","+cu.rectHeight}}}};var av=function(){if(by.cfg.viewerid){aN.assignFSIViewer(by.cfg.viewerid)}var ct=by.cfg.dir;if(!ct||ct.length===0){var cs=by.getImageList();if(cs){ai(cs.arImages,cs)}}else{by.loadImageList(by.cfg.dir,ai)}if(b1.isset("onConfigsReady")){b1.run("onConfigsReady",[a.utils.cloneObject(by.cfg)])}};var ai=function(cs,ct){if(!bQ){return}Y=0;if(!cs){cs=[]}bR=cs;r.log("Image list loaded ("+bR.length+" images)");C();j()};var C=function(){s(ao)};var aZ=function(ct,cs,cw,cu){for(var cv in cw){if(cw.hasOwnProperty(cv)){cs[cv]=ct.getFloatParameter(cu+cv,cw[cv])}}};var bo=function(ct,cs,cw,cu){for(var cv in cw){if(cw.hasOwnProperty(cv)){cs[cv]=ct.getIntParameter(cu+cv,cw[cv])}}};var an=function(cu,ct,cs,cv){for(var cw in cs){if(cs.hasOwnProperty(cw)){ct[cw]=cu.getStringParameter(cv+cw,cs[cw])}}};var ah=function(ct,cs,cv,cu){for(var cw in cv){if(cv.hasOwnProperty(cw)){cs[cw]=ct.makeBool(ct.getStringParameter(cu+cw),cv[cw])}}};var t=function(ct,cs,cv,cu){var cw;if(cv&&cv.length>0){if(cs[cv]===b){cs[cv]={}}cu=cu[cv];cw=cs[cv]}else{cw=cs}if(cu.strings){an(ct,cw,cu.strings,cv)}if(cu.booleans){ah(ct,cw,cu.booleans,cv)}if(cu.floats){aZ(ct,cw,cu.floats,cv)}if(cu.integers){bo(ct,cw,cu.integers,cv)}};var s=function(cs){if(cs===b){cs={}}cs.serverBase=by.serverBase;t(by,cs,"",bL);var cv=/[\dabcdef]{3,6}/i;for(var cw in bL.strings){if(bL.strings.hasOwnProperty(cw)){if(cw.indexOf("Color")!==-1){var cu=ao[cw];if(cu.indexOf("#")!==0){var ct=cu.match(cv);if(ct){if(ct[0].length===cu.length&&(ct[0].length===3||ct[0].length===6)){ao[cw]="#"+ct[0]}}}}}}};var j=function(){var ct;bJ=ao.presentationType.toLowerCase();if(a.isMobileDevice){c=3}else{c=1}ce=ao.transparency;bP=ao.endlessScrolling;ad();ch=bR.length;ct=ao.placeHolderColor.toLowerCase();bS=(ct!=="none"&&ct!=="transparent");ct=ao.imageBorderColor.toLowerCase();i=(ct!=="none"&&ct!=="false");if(ao.zoomCenteredImageOnly){bM=true}else{bM=ao.positionQuantization}ct=bj();aF=y=aQ=ct;ap=-ao.autoRotateSpeed;cg="rgba(0,255,0,";ct=ao.backgroundColor.toLowerCase();if(ct==="false"||ct==="transparent"||ct==="none"){ao.backgroundColor=false;aL=br;w.style.backgroundColor="transparent"}else{if(!ce&&ao.backgroundDarkness===0){aL=J}else{aL=br}ct=ao.backgroundColor;if(ct.indexOf("#")===0){ct=ct.substr(1)}if(ct.length===3){ct=ct.charAt(0)+ct.charAt(0)+ct.charAt(1)+ct.charAt(1)+ct.charAt(2)+ct.charAt(2)}var cv=parseInt("0x"+ct.substr(0,2));if(isNaN(cv)){cv=0}var cu=parseInt("0x"+ct.substr(2,2));if(isNaN(cu)){cu=0}var cs=parseInt("0x"+ct.substr(4,2));if(isNaN(cs)){cs=0}cg="rgba("+cv+","+cu+","+cs+",";w.style.backgroundColor=ao.backgroundColor}cr=(aL===br);al();cq=a.utils.cloneArray(bR);aO={};if(ao.autoResize===true){if(bc===b){bc=a.addCustomEvent(bh,"FSIElementDimension",b7);a.setCustomEventListenerProperty(bc,"treshold",200)}}else{if(bc!==b){a.removeCustomEvent(bh,"FSIElementDimension",b7);bc=b}}bH();a1()};var bu=function(cu){var ct,cs;if(typeof(cu)==="string"){cs=cu.indexOf("%");ct=parseFloat(cu)}else{cs=-1;ct=cu}if(cs!==-1){ct=Math.round(aF.width*ct/100)}return{val:ct,bRelative:(cs!==-1)}};var al=function(){var cs;cs=bu(ao.elementWidth);if(isNaN(cs.val)){cs=bu(bL.strings.elementWidth)}aS=bz.width=Math.max(1,cs.val);bz.widthRelative=cs.bRelative;cs=bu(ao.elementSpacing);if(isNaN(cs.val)){cs=bu(bL.strings.elementSpacing)}bl=bz.spacing=cs.val;bz.spacingRelative=cs.bRelative};var bH=function(){a4=false;n();if(cq.length<1){return}bx=0;a8={};W=0;cd++;if(bR.length!==cq.length){bR=a.utils.cloneArray(cq)}ch=bR.length;a2=!ao.enableScrollBar;b2=aS+bl;aF=aQ;bb=aF.width/2;var cx=0;aT=false;switch(bJ){case"stacks":cx=2;A=false;ca=false;break;case"flat":aT=!bP;ao.zoomCenteredImageOnly=false;cx=1;if(!bP){bb=0}else{bb-=b2/2}ca=false;A=true;break;default:cx=2;bJ="carousel";A=false;ca=true;break}if(bJ==="stacks"){bC=aF.width/2-aS/2}else{bC=aF.width/2-aS/4}E();var cv=b0;if(bP){var cy=false;P=0;if(ch===1){cy=true;bR.push(bR[0]);ch++}aE();u();if(cy){bR.pop();ch=1}if(V.length+cx>ch){if(!ao.duplicateImagesIfNeeded){bP=false}else{var cu=(V.length+cx-ch);for(var ct=0;ct<cu;ct++){bR.push(bR[ct%ch])}ch=bR.length}}}aE();E();if(b0<=0){a2=true}b4={height:ao.scrollHeight,padding:ao.scrollPadding,alphaNormal:ao.scrollAlphaNormal,alphaActive:ao.scrollAlphaActive};b4.height=Math.max(3,b4.height);b4.padding=Math.max(0,b4.padding);b4.alpha=b4.alphaTarget=b4.alphaNormal;b4.width=Math.round(aF.width-2*b4.padding);b4.y=Math.round(aF.height-b4.height-b4.padding);if(!a2){var cs=Math.max(0,cv);b4.buttonWidth=Math.round(Math.max(20,b4.width*Math.min(1,aF.width/(aF.width+cs))))}else{b4.buttonWidth=20}b4.range=b4.width-b4.buttonWidth;if(!a2){a2=(b4.buttonWidth>=b4.width)}co=(ch<2);if(!a2){a2=co}if(!bP&&bJ==="flat"&&ch*b2<aF.width){bb=(aF.width-ch*b2)/2}var cz=ao.paddingBottom;if(!a2){cz=Math.max(b4.height,cz)}bd=aF.height-ao.paddingTop-cz;ae=0;ao.mirrorHeight=Math.max(0,Math.min(1,ao.mirrorHeight));if(ao.mirrorHeight>0){ae=Math.round(ao.mirrorHeight*bd/2);ba=(ae>0)}else{ba=false}bd-=ae;if(ca){aM=Math.round(ao.curveHeight*bd)}else{aM=0}aA();if(l!==b){var cw=l.offsetLeft/l.xAdvance;P=cw*b2;l=b}if(bM){P=Math.round(P/b2)*b2}P=aa(P);a4=true;if(bd<1){r.error("Insufficient instance height. Resulting image height is "+bd+"px");return}bx=bR.length;am=aW;aV=m;ar();if(ao.preloadCount>0){R()}if(ap!==0){Z()}};var aE=function(){if(ch<2){bN=o}else{if(aT){bN=h}else{bN=cl}}};var a1=function(){if(b1.isset("onStart")){b1.run("onStart",[ao.dir,bR.length,a.utils.cloneArray(bR)])}G(0);cb()};var E=function(){b0=ch*b2;if(!bP){if(bJ==="flat"){b0-=aF.width}else{b0-=b2}}};var aA=function(){if(!aF||aF.width<1||aF.height<1){return false}if(!B){B=document.createElement("canvas");B.setAttribute("draggable","false");B.style.width=B.style.height="100%";if(a.isIETouch){B.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}B.setAttribute("width",aF.width);B.setAttribute("height",aF.height);ck=B.getContext("2d");w.appendChild(B)}else{B.setAttribute("width",aF.width);B.setAttribute("height",aF.height)}if(ba&&!U){U=document.createElement("canvas");aJ=U.getContext("2d");aI=U.cloneNode();bZ=aI.getContext("2d");bk=U.cloneNode();bU=bk.getContext("2d")}if(ba){var cs=Math.ceil(aS);var cu=Math.ceil((bd+1));U.setAttribute("width",cs);U.setAttribute("height",cu);aI.setAttribute("width",cs);aI.setAttribute("height",cu);bk.setAttribute("width",cs);bk.setAttribute("height",cu);bD=aJ.createLinearGradient(0,0,0,ae);if(cr){bD.addColorStop(0,cg+ao.mirrorStartOpacity+")");bD.addColorStop(1,cg+"0)")}else{bD.addColorStop(0,cg+(1-ao.mirrorStartOpacity)+")");bD.addColorStop(1,cg+"1)")}aJ.strokeStyle=ao.imageBorderColor;aJ.fillStyle=bD;aJ.lineWidth=0;bU.strokeStyle=ao.imageBorderColor}if(ao.backgroundDarkness>0){aj=ck.createLinearGradient(0,0,aF.width,0);var ct="rgba(0,0,0,";aj.addColorStop(0,ct+ao.backgroundDarkness+")");aj.addColorStop(0.4,ct+"0)");aj.addColorStop(0.6,ct+"0)");aj.addColorStop(1,ct+ao.backgroundDarkness+")");bt=true}else{bt=false}if(!at){var cv={};cv.detectClick=true;cv.afterTouch={enabled:true};cv.afterTouch.modifyTarget=bv;cv.afterTouch.factorAmount=23;cv.afterTouch.factorFrames=3.7;cv.afterTouch.minFrames=5;cv.afterTouch.offsetFrames=3;cv.afterTouch.useAnimationFrame=true;cv.detectGestures=true;at=new a.TouchHandler(B,cv,bB,bK,a9);at.setCapture(true,false)}};var bv=function(cu){if(bM){var ct=Q.offsetLeft-Q.x-Q.startX;var cs=Math.round((cu.x+ct)/b2)*b2;cu.x=cs-ct}return cu};var bY=function(){var cs=a.getElementClientPos(B);Q.x=cs.left;Q.y=cs.top};var bB=function(cs,cv,cu){bY();az.x=cv.x-Q.x;az.y=cv.y-Q.y;bO(b4.alphaActive);aw();ap=0;cancelAnimationFrame(be);be=b;P=aa(P);if(O(az.x,az.y)){at.enableAfterTouch(false);Q.scrollOffsetX=0;bO(b4.alphaActive);b4.bDragging=true;bK(cs,cv,cu);af();var ct=b4.padding+b4.x+b4.buttonWidth/2;Q.scrollOffsetX=(ct-az.x)}else{at.enableAfterTouch(true);b4.bImageDragging=true;Q.startX=az.x;Q.startY=az.y;Q.offsetLeft=P}ar();return true};var bK=function(ct,cv){az.x=cv.x-Q.x;az.y=cv.y-Q.y;if(b4.bDragging){var cs=az.x+Q.scrollOffsetX-b4.padding-b4.buttonWidth/2;cs=Math.max(0,Math.min(b0-1,Math.round(cs*b0/b4.range)));P=aa(Math.min(0,Math.max(-cs,-b0)));ar()}else{if(b4.bImageDragging){Q.dx=az.x-Q.startX;Q.dy=az.y-Q.startY;var cu=P;P=aa(Q.offsetLeft+Q.dx);ar();if(cu===P||Math.abs(Q.dy)>3*Math.abs(Q.dx)){ct.FSI_allowEventDefault=true}}}};var a9=function(cA,cv){var cy=cA._FSI_Click;az.x=cv.x-Q.x;az.y=cv.y-Q.y;bO(b4.alphaNormal);if(b4.bDragging){bO(b4.alphaNormal);b4.bDragging=false;if(bM){var cB=Math.round(P/b2)*b2;var cs=Math.round(-aa(cB)/b2);G(cs);bq(cB,true,55)}}else{if(b4.bImageDragging){b4.bImageDragging=false;if(cy){var cx=az.x;var cw=az.y;var cz=0;var ct;for(var cu=0;cu<V.length;cu++){ct=V[cu];if(cx>=ct.x&&cw>=ct.y&&cx<=ct.x+ct.drawWidth&&cw<=ct.y+ct.drawHeight){cz=1;if(b1.isset("onClick")){b1.run("onClick",[ct.nIndex,bR[ct.nIndex]])}if(!ao.zoomCenteredImageOnly||aD===ct.nIndex){if(ao.enableZoom){b9(ct)}}if(ao.centerZoomedImage){cf(ct)}break}}}else{cj()}}}ar()};var cj=function(){if(bM){var cs=Math.round(P/b2)*b2;if(Math.abs(cs-P)>0.5){var ct=Math.round(-aa(cs)/b2);G(ct);bq(cs,true,30)}}};var G=function(cs){aD=cs;aP=b;if(b1.isset("onFocus")){var ct=aO[cs];if(ct){b1.run("onFocus",[ct.nIndex,bR[ct.nIndex]])}}};this.assignFSIViewer=function(cs){if(cs&&typeof(cs)==="string"){if(cs.toLowerCase()==="auto"){var ct=document.getElementsByTagName("fsi-viewer");if(ct&&ct.length>0){cs=ct[0]}else{cs=b}}else{cs=document.getElementById(cs)}}if(!cs||typeof(cs.changeImage)!=="function"){z=b}else{z=cs}aK=false;cb()};var cb=function(){if(!bQ||!z||aK||bR.length<1){return}aK=true;var cs={};cs.path=bR[0];L(cs)};var L=function(cs){if(!cs||!z||typeof(z.changeImage)!=="function"){return}var ct={};ct.fpxsrc=cs.path;ct.imageWidth=cs.sourceWidth;ct.imageHeight=cs.sourceHeight;ct.cropRect=by.cfg.croprect;ct.cropValues=by.cfg.cropvalues;ct.effects=by.cfg.effects;z.changeImage(ct)};var b9=function(cy){if(z!==b){L(cy);return}I(b,true);if(!cy.bReady){return}bT=document.createElement("div");ci=document.createElement("div");x=document.createElement("img");bn.alphaShader=0;var cK=a.utils.getDocumentScale();var cL=ao.zoomBorderWidth/cK;var cD=ao.zIndexZoom;var cE="position:absolute;z-index:"+(cD+1)+";border:"+cL+"px "+ao.zoomBorderStyle+" "+ao.zoomBorderColor+";line-height:0px;box-sizing: content-box;";var cA=ao.zoomBackgroundColor.toLowerCase();if(cA!=="none"&&cA!=="transparent"){cE+="background-color:"+ao.zoomBackgroundColor}bT.setAttribute("style",cE);var cw="position:absolute;z-index:"+cD+";background-color:"+ao.zoomFadeColor+";opacity:0.0;filter:Alpha(opacity=0);";bX=cy.img.cloneNode();bX.style.width=bX.style.height="100%";bT.appendChild(bX);var cx=a.getElementClientPos(B);var cu=a.getElementClientPos(document.body);var cC=-cu.left;var cB=-cu.top;bn.startX=cC+cx.left+cy.x-cL;bn.startY=cB+cx.top+cy.y-cL;bn.startWidth=cy.width;bn.startHeight=cy.height;bT.style.width=bn.startWidth+"px";bT.style.height=bn.startHeight+"px";bT.style.left=bn.startX+"px";bT.style.top=bn.startY+"px";var cJ=a.getViewportSize(window);if(a.getDevicePixelRatio()!==1){cJ.width-=1;cJ.height-=1}a.addEvent(ci,"mousedown",I,false);a.addEvent(window,"touchstart",I,false);a.addEvent(bT,"mousedown",I,false);a.addEvent(window,"scroll",I,false);var cH=Math.ceil(40/cK);var ct=cJ.width-cH-2*cL;var cI=cJ.height-cH-2*cL;var cz=cy.maxWidth;var cG=cy.maxHeight;if(ct/cz<cI/cG){cz=ct;cG=Math.round(cz*cy.maxHeight/cy.maxWidth)}else{cG=cI;cz=Math.round(cG*cy.maxWidth/cy.maxHeight)}if(cz>cy.maxWidth||cG>cy.maxHeight){cz=cy.maxWidth;cG=cy.maxHeight}bn.endWidth=cz;bn.enddHeight=cG;bn.dWidth=cz-bn.startWidth;bn.dHeight=cG-bn.startHeight;bn.endX=window.pageXOffset+Math.round((cJ.width-cz)/2);bn.endY=window.pageYOffset+Math.round((cJ.height-cG)/2);bn.dx=bn.endX-bn.startX;bn.dy=bn.endY-bn.startY;cw+="left:"+window.pageXOffset+"px;top:"+window.pageYOffset+"px;width:"+(cJ.width)+"px;height:"+cJ.height+"px";bn.bImageReady=false;var cv=cy.img.src;cv=cv.replace(aX,"$1");var cs=Math.min(cy.maxWidth,Math.round(cK*cz));var cF=Math.min(cy.maxHeight,Math.round(cK*cG));cv+="&width="+cs+"&height="+cF;aq=true;a.addEvent(x,"load",cc,false);x.style.width=bn.endWidth+"px";x.style.height=bn.endHeight+"px";x.setAttribute("crossorigin","anonymous");x.src=cv;bn.pos=0;bn.frames=b8(20);ci.setAttribute("style",cw);document.body.appendChild(ci);document.body.appendChild(bT);bn.alphaShader=0;cancelAnimationFrame(aU);aU=requestAnimationFrame(au);bn.posFader=0;bn.framesShader=10;bn.startAlpha=bn.alphaShader;bn.endAlpha=ao.zoomFadeOpacity;bn.dAlpha=bn.endAlpha-bn.startAlpha;D=requestAnimationFrame(v);b1.run("onZoomStart",[cy.nIndex,cv]);if(!a.isMobileDevice){a.addEvent(window,"resize",I,false)}else{a.addEvent(window,"orientationchange",I,false)}};var cn=a.Easing.easeOutCubic;var au=function(){bn.pos++;if(bn.pos>bn.frames){aU=b;requestAnimationFrame(cp);return}var cs=cn(bn.pos,bn.frames,bn.startX,bn.dx);var cv=cn(bn.pos,bn.frames,bn.startY,bn.dy);var ct=cn(bn.pos,bn.frames,bn.startWidth,bn.dWidth);var cu=cn(bn.pos,bn.frames,bn.startHeight,bn.dHeight);bT.style.left=cs+"px";bT.style.top=cv+"px";bT.style.width=ct+"px";bT.style.height=cu+"px";aU=requestAnimationFrame(au)};var cp=function(){if(!bT||!bn.bImageReady||aU!==b){return}bT.firstChild.style.width=x.style.width;bT.firstChild.style.height=x.style.height;bT.firstChild.src=x.src;x=b;bT.style.width="";bT.style.height=""};var cc=function(){bn.bImageReady=true;a.removeEvent(x,"load",cc,false);aq=false;cp()};var I=this.closeZoom=function(cs,ct){if(!bT){return}aP=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",I,false)}else{a.removeEvent(window,"orientationchange",I,false)}if(D){cancelAnimationFrame(D);D=b}cancelAnimationFrame(aU);aU=b;a.removeEvent(ci,"mousedown",I,false);a.removeEvent(bT,"mousedown",I,false);a.removeEvent(window,"touchstart",I,false);a.removeEvent(window,"scroll",I,false);if(aq){a.removeEvent(x,"load",cc,false)}if(x){x=b}a.removeChild(bT.parentNode,bT);bT=b;if(ct===true){a.removeChild(ci.parentNode,ci);ci=b}else{bn.posFader=0;bn.framesShader=10;bn.startAlpha=bn.alphaShader;bn.endAlpha=0;bn.dAlpha=bn.endAlpha-bn.startAlpha;D=requestAnimationFrame(v)}b1.run("onZoomEnd");if(cs&&cs.touches&&cs.touches.length===1){cs.cancelBubble=true;if(cs.stopPropagation){cs.stopPropagation()}if(cs.preventDefault){cs.preventDefault()}}};var T=function(cs){bn.alphaShader=cs;ci.style.opacity=cs/100;ci.style.filter="Alpha(opacity="+cs+")"};var v=function(){bn.posFader++;if(bn.posFader>bn.framesShader){if(bn.endAlpha===0){a.removeChild(ci.parentNode,ci);ci=b}D=b;return}var cs=cn(bn.posFader,bn.framesShader,bn.startAlpha,bn.dAlpha,3);T(cs);D=requestAnimationFrame(v)};var O=function(cs,ct){return(!a2&&cs>=b4.padding&&ct>=b4.y&&cs<=b4.padding+b4.width&&ct<=b4.y+b4.height)};this.focusImage=function(cs){if(cs<0||cs>=bR){return false}var ct=b6(cs);cf(ct);return true};this.zoomImage=function(cs){if(!ao.enableZoom||!this.focusImage(cs)){return false}var ct=b6(cs);aP=ct.nIndex;ax()};var cf=function(ct,cs){if(!ct){return false}G(ct.nIndex);return bq(-ct.nIndex*b2,cs,30)};var aa=function(cs){if(bP){cs=Math.round(cs)%b0;if(cs>0){cs-=b0}}else{cs=Math.min(0,Math.max(-b0,cs))}return cs};var b8=function(cs){if(a.isMobileDevice){cs=Math.ceil(cs/1.8)}return cs};var bq=function(cv,cs,cu){cu=b8(cu);aw();if(cu===b){cu=40}if(!cs&&bP){cv=aa(cv);P=aa(P);var ct=cv-P;if(Math.abs(ct)>b0/2){if(ct>0){cv=-b0+cv}else{cv=b0+cv}}}if(cv===P||(be!==b&&cv===p.end)){return false}cancelAnimationFrame(be);be=b;p.frames=cu;p.pos=0;p.start=P;p.end=cv;p.diff=p.end-p.start;be=requestAnimationFrame(bI);return true};var bI=function(){p.pos++;if(p.pos===p.frames){P=aa(p.end);be=b;bm();ax();return}P=cn(p.pos,p.frames,p.start,p.diff,3);if(!bP){P=aa(P)}bm();ax();be=requestAnimationFrame(bI)};var cm=function(ct,cv,cw){if(!bQ){return}if(!cv||!cw||cw.nInitID!==cd){return}f--;var cs,cu;cs=parseInt(cv.width);cu=parseInt(cv.height);if(isNaN(cs)&&isNaN(cu)){r.error("Failed to get image info.")}cw.nThumbnailDimWidth=aS;cw.nThumbnailDimHeight=bd;cw.bInfoReady=true;cw.bDrawPlaceHolder=bS;cw.sourceWidth=cs;cw.sourceHeight=cu;if(b5.bLive){bF(cw)}cw.src="&effects="+ao.effects;if(b5.bCrop){cw.rectWidth=b5.rectWidth;cw.rectHeight=b5.rectHeight}a.utils.expandSourceDimensionForPadEffect(cw,aS,bd);if(b5.bCrop){cw.objCropCurrent=(cw.oCrop)?cw.oCrop:b5;cw.maxWidth=Math.round(cw.objCropCurrent.rectWidth*cw.sourceWidth);cw.maxHeight=Math.round(cw.objCropCurrent.rectHeight*cw.sourceHeight)}else{cw.maxWidth=cw.sourceWidth;cw.maxHeight=cw.sourceHeight}aG(cw)};var aG=function(ct){var cz,cv;if(!ct.bInfoReady){return false}ct.nThumbnailDimWidth=aS;ct.nThumbnailDimHeight=bd;if(!ct.bThumbLoading){f++}ct.bThumbLoading=true;ct.bThumbLoadStarted=true;var cw=aS;var cy=bd;if(cw/ct.maxWidth<cy/ct.maxHeight){cz=cw;cv=Math.round(cz*ct.maxHeight/ct.maxWidth)}else{cv=cy;cz=Math.round(cv*ct.maxWidth/ct.maxHeight)}var cx=true;if(cz<1||cv<1){cz=cv=0;cx=false}ct.width=cz;ct.height=cv;ct.offsetX=(cw-cz)/2;ct.offsetY=cy-cv-aM+ao.paddingTop;var cA={width:cz};if(ct.bHasPadEffect){cA.height=cv}if(ct.objCropCurrent){cA.rect=ct.objCropCurrent.query}if(ao.effects.length>0){cA.effects=ao.effects}if(ao.overlays.length>0){cA.overlays=ao.overlays}if(ao.quality.length>0){cA.quality=ao.quality}if(ao.fpxservertemplate.length>0){cA.renderer=ao.fpxservertemplate}var cs=by.getImageURL(ct.path,cA);if(by.hasImageParameterConditions){cs=by.reWriteImageURLByConditions(cs)}var cu;if(ct.img===b){cu=ct.img=document.createElement("img");cu.oSprite=ct;cu.crossOrigin="anonymous"}else{cu=ct.img}ct.nInitID=cd;if(!ct.bHasEvents){aR[ct.nIndex]=ct;ct.bHasEvents=true;a.addEvent(cu,"load",H,false);a.addEvent(cu,"error",N,false)}if(ct.bDrawPlaceHolder){if(ct.myX!==b){b3(ct)}if(bg(ct)){ar()}}if(!cx){N.call(cu)}else{ct.src=cu.src=cs}return true};var bp=function(cs){return(cs.nThumbnailDimWidth===aS&&cs.nThumbnailDimHeight===bd)};var ak=function(cs){return(cs&&cs.nInitID===cd)};var a6=function(cs){if(cs.bHasEvents){delete aR[cs.nIndex];a.removeEvent(cs.img,"load",H,false);a.removeEvent(cs.img,"error",N,false);cs.bHasEvents=false}};var N=function(){var cs=this.oSprite;if(!cs){return}cs.bReady=false;cs.bDrawPlaceHolder=false;cs.bLoadComplete=true;cs.bThumbLoading=false;a6(cs);if(ak(cs)){f--}aV()};var H=function(){var cs=this.oSprite;if(!cs){return}a6(cs);if(!bQ){return}cs.bReady=true;cs.bLoadComplete=true;cs.bThumbLoading=false;cs.bDrawPlaceHolder=false;if(!ak(cs)){return}f--;if(!bp(cs)){return}F(cs);if(bg(cs)&&cs.myX!==b){b3(cs);ar()}ax();aV()};var ax=function(){if(aP===b){return}var cs=b6(aP);if(!cs.bReady||!bg(cs)){return}b9(cs);aP=b};var b6=function(cu,cx,cs){var cv;cu%=ch;if(cu<0){cu+=ch}if(a8[cu]!==b){return a8[cu]}var cw=aO[cu];if(cw===b){Y++;cw=aO[cu]={};cw.nIndex=cu;var ct=bd;cw.width=aS;cw.height=ct;cw.offsetX=0;cw.offsetY=ct-cw.height-aM+ao.paddingTop;cw.path=bR[cu];cv=true}else{if(cw.bThumbLoadStarted&&(cw.nThumbnailDimWidth!==aS||cw.nThumbnailDimHeight!==bd)){if(cw.bReady){cw.bReady=false;cw.oMirrorData=null;cw.bDrawPlaceHolder=false}cv=true}else{if(!cw.bLoadStarted){cv=true}}}if(cv){cw.bPreload=cx;g.push(cw);if(!cs){am()}}return cw};var k=function(){};var n=function(){am=aV=k;if(bw){clearTimeout(bw);bw=b}};var aW=function(){if(!bw){bw=setTimeout(m,50)}};var m=function(){if(bw){clearTimeout(bw);bw=b}while(g.length>0&&f<ag){var ct=g.shift();if(a8[ct.nIndex]===b&&(ct.bPreload||bg(ct))){a8[ct.nIndex]=ct;W++;if(W===ch){n()}bx--;ct.bLoadStarted=true;ct.nInitID=cd;if(!ct.bInfoLoading){f++;ct.bInfoLoading=true;var cs=by.getImageInfoURL(ct.path);by.loadFile(cs,cm,b,ct)}else{aG(ct)}}}};var aY=function(cu,cs){if(!bP&&(cu<0||cu>=ch)){return 0}var cv=b6(cu,false,true);cv.nImage=cu;cv.myX=cs;var ct=b3(cv);if(ct){V.push(cv)}return ct};var b3=function(cw){var cu,cv;if(A){var ct=bb+cw.myX;cv=(ct+b2>=0&&ct<=aF.width)?1:0;cw.z=1}else{cu=cw.myX/bC;cv=Math.cos(cu/1.3);if(ca){cw.z=cv}else{cw.z=1}}if(cv<ao.depthFadeout){ac[cw.nIndex]=false;return 0}cw.drawWidth=cw.z*cw.width;cw.drawHeight=cw.z*cw.height;ac[cw.nIndex]=true;if(A){cw.x=bb+cw.myX+Math.round((b2-cw.width)/2)}else{var cs=bC*Math.sin(cu);cw.x=bb+cs-cw.drawWidth/2}if(ca){cw.y=aM*cw.z+cw.offsetY+(cw.height-cw.drawHeight)}else{cw.y=cw.offsetY+(cw.height-cw.drawHeight)}return 1};var bg=function(cs){if(!cs){return false}return ac[cs.nIndex]};var u=function(){if(g.length>0){g=[]}V=[];ac={};var cv;var ct;if(A){ct=aa(P)}else{ct=P}if(ct>0){cv=Math.ceil(-ct/b2)}else{cv=Math.floor(-ct/b2)}var cs=ct%b2;aY(cv,cs);var cu=bN(cv,cs);if(S.interval!==b&&be===b){S.nLastLeftImage=cv-cu+1;S.nLastRightImage=cv+cu-1;S.nLoad=ao.preloadCount}};var o=function(){return 0};var cl=function(cv,cs){var cw;var cu=0;var ct=0;do{cu+=b2;ct++;cw=aY(cv-ct,cs-cu);cw+=aY(cv+ct,cs+cu)}while(cw>0&&ct<ch);return ct};var h=function(cv,cs){var cw;var cu=0;var ct=0;do{cu+=b2;ct++;cw=aY(cv+ct,cs+cu)}while(cw>0&&ct<ch);return ct};var R=function(){if(S.interval!==b){return}S.interval=setInterval(aC,100)};var bV=function(){clearInterval(S.interval);S.interval=b};var aC=function(){if(g.length>0||S.nLoad<=0){return}if(bx<1){bV();return}while(g.length<2&&S.nLoad>0){if(!aT){b6(--S.nLastLeftImage,true,true);S.nLoad--}b6(++S.nLastRightImage,true,true);S.nLoad--}aV()};var ar=function(){if(q!==b){return}q=requestAnimationFrame(bm)};var bm=function(){if(q!==b){cancelAnimationFrame(q);q=b}if(K){return}u();aL();am()};var br=function(){if(!bQ){return}ck.globalCompositeOperation="source-over";ck.globalAlpha=1;ck.clearRect(0,0,aF.width,aF.height);ck.strokeStyle=ao.imageBorderColor;ck.lineWidth=0;for(var cu=V.length-1;cu>-1;cu--){var cv=V[cu];if(cv.bReady){ck.drawImage(cv.img,cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}else{if(cv.bDrawPlaceHolder){ck.fillStyle=ao.placeHolderColor;ck.fillRect(cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}}if(cv.oMirrorData){var ct=cv.y+cv.drawHeight;var cw=Math.abs(cv.z)*cv.nMirrorWidthOut;var cs=Math.abs(cv.z)*cv.nMirrorHeightOut;if(!ce){ck.clearRect(cv.x,ct,cw,cs)}if(cv.bCorsFix){ck.drawImage(cv.mirrorCanvas,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}else{bZ.clearRect(0,0,cv.nMirrorWidth,cv.nMirrorHeight);bZ.putImageData(cv.oMirrorData,0,0);ck.drawImage(aI,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}}}if(bt){ck.globalCompositeOperation="source-atop";ck.fillStyle=aj;ck.fillRect(0,0,aF.width,aF.height)}e()};var J=function(){var cu,cv;if(!bQ){return}ck.globalCompositeOperation="source-over";ck.globalAlpha=1;ck.clearRect(0,0,aF.width,aF.height);ck.strokeStyle=ao.imageBorderColor;ck.lineWidth=0;for(cu=V.length-1;cu>-1;cu--){cv=V[cu];if(cv.bReady){ck.drawImage(cv.img,cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}else{if(cv.bDrawPlaceHolder){ck.fillStyle=ao.placeHolderColor;ck.fillRect(cv.x,cv.y,cv.drawWidth,cv.drawHeight);if(i){ck.strokeRect(cv.x+0.5,cv.y+0.5,cv.drawWidth-1,cv.drawHeight-1)}}}}if(bt){ck.globalCompositeOperation="source-atop";ck.fillStyle=aj;ck.fillRect(0,0,aF.width,aF.height)}ck.globalCompositeOperation="destination-over";for(cu=0;cu<V.length;cu++){cv=V[cu];if(cv.oMirrorData){var ct=cv.y+cv.drawHeight;var cw=Math.abs(cv.z)*cv.nMirrorWidthOut;var cs=Math.abs(cv.z)*cv.nMirrorHeightOut;if(cv.bCorsFix){ck.drawImage(cv.mirrorCanvas,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}else{bZ.clearRect(0,0,cv.nMirrorWidth,cv.nMirrorHeight);bZ.putImageData(cv.oMirrorData,0,0);ck.drawImage(aI,0,0,cv.nMirrorWidth,cv.nMirrorHeight,cv.x,ct,cw,cs)}}}e()};var bO=function(cs){if(a2||b4.alphaTarget===cs){return}b4.alphaTarget=cs;ar()};var af=function(){var cs=aa(P);b4.x=Math.min(b4.range,-cs/b0*b4.range)};var e=function(){if(a2){return}af();ck.globalCompositeOperation="source-over";if(b4.alpha!==b4.alphaTarget){if(Math.abs(b4.alpha-b4.alphaTarget)>0.01){b4.alpha+=(b4.alphaTarget-b4.alpha)/10;ar()}else{b4.alpha=b4.alphaTarget}}ck.globalAlpha=b4.alpha;ck.fillStyle=ao.scrollColor;var cw=b4.y;var cu=cw+b4.height-1;var cv=cu-cw-1;ck.fillRect(b4.padding,cw,b4.width,1);ck.fillRect(b4.padding,cu,b4.width,1);cw++;ck.fillRect(b4.padding,cw,1,cv);ck.fillRect(b4.width-1,cw,1,cv);var cs=Math.max(1,Math.round(b4.x));var ct=Math.min(b4.buttonWidth,b4.width-1-cs);ck.fillRect(b4.padding+cs,b4.y+1,ct,b4.height-2)};var F=function(cw){if(!ba||!bQ){return}var cu=c;cu=Math.min(cu,Math.min(cw.img.width/20,cw.img.height/20));var cs=Math.min(U.width,cw.img.width/cu);var ct=Math.min(U.height,cw.img.height/cu);var cy=Math.min(ae/cu,Math.floor(ct*ao.mirrorHeight));var cx=ct-cy;aJ.save();aJ.globalCompositeOperation="source-over";if(!cr){aJ.clearRect(0,0,cs,cy);aJ.scale(1,-1);aJ.drawImage(cw.img,0,cx*cu,cs*cu,cy*cu,0,-cy,cs,cy);aJ.restore();aJ.save();if(i){aJ.strokeRect(0,0,cs,ct)}aJ.scale(1,cy/ae);aJ.fillRect(0,0,cs+1,ae+1)}else{aJ.clearRect(0,0,cs,cy);aJ.scale(1,cy/ae);aJ.fillRect(0,0,cs+1,ae+1);aJ.restore();aJ.save();aJ.globalCompositeOperation="source-in";aJ.scale(1,-1);if(i){bU.clearRect(0,0,cs,cy);bU.drawImage(cw.img,0,cx*cu,cs*cu,cy*cu,0,0,cs,cy);bU.strokeRect(0,0,cs,cw.height);aJ.drawImage(bk,0,0,cs,cy,0,-cy,cs,cy)}else{aJ.drawImage(cw.img,0,cx*cu,cs*cu,cy*cu,0,-cy,cs,cy)}}aJ.restore();try{cw.oMirrorData=aJ.getImageData(0,0,cs,cy)}catch(cv){cw.mirrorCanvas=U.cloneNode();cw.oMirrorData=cw.mirrorCanvas.getContext("2d");cw.oMirrorData.drawImage(U,0,0);cw.bCorsFix=true}cw.nMirrorWidth=cs;cw.nMirrorHeight=cy;cw.nMirrorWidthOut=cs*cu;cw.nMirrorHeightOut=cy*cu};var Z=function(){if(a5!==b){return}a5=requestAnimationFrame(X)};var X=function(){P=aa(P+ap);ar();a5=requestAnimationFrame(X)};var aw=function(){if(a5===b){return}cancelAnimationFrame(a5);a5=b};var bj=function(){var cs=a.getElementDimension(w);if(cs.width<1){cs.width=1}if(cs.height<1){cs.height=1}return cs};var bi=function(){aF=aQ=bj()};var b7=function(cs){if(!a4||cq.length<1){return}if(l===b){l={};l.offsetLeft=P;l.xAdvance=b2;l.nCenter=bb}if(cs.FSI_after_treshold!==b){aw();cancelAnimationFrame(be);K=false;at.enable(true);n();bV();g=[];bi();if(aF.width>1&&aF.height>1){if(B){B.style.display="block"}var ct=aF.height/y.height;aS=Math.round(bz.width*ct);bl=Math.round(bz.spacing*ct);bH()}else{}return}if(!K){K=true;at.cancel();at.enable(false);if(B){ck.clearRect(0,0,aF.width,aF.height)}}};this.destroyOnDetach=function(){if(ao&&ao.autoDestroy!==false){M()}};this.addListener=function(cv,ct,cu){var cs=false;if(b1){cs=b1.addListener(cv,ct,cu)}return cs};this.removeListener=function(cu,ct){var cs=false;if(b1){cs=b1.removeListener(cu,ct)}return cs};var M=this.destroy=function(){if(by){by.destroy()}if(!bQ){return}bQ=false;bh.removeAttribute("data-fsi-id");n();bV();for(var cs in aR){if(aR.hasOwnProperty(cs)){a6(aR[cs])}}aR={};if(bc!==b){a.removeCustomEvent(bh,"FSIElementDimension",b7);bc=b}g=[];aw();aP=b;I(b,true);aD=0;cancelAnimationFrame(aU);cancelAnimationFrame(q);q=b;cancelAnimationFrame(be);be=b;cancelAnimationFrame(D);D=b;V=[];S={};Y=0;if(at){at.destroy();at=b}P=bW=0;a3=b;bR=[];if(B){a.removeChild(w,B);B=b}ck=b;aI=bZ=aJ=U=bU=bk=b;b5={};ac={};f=0;a.removeChild(w.parentNode,w);if(b1){b1.run("onDestroy");b1.destroy()}}};a.customTags.register("fsi-imageflow",{constructorClass:a.ImageFlow,viewerCSS:"display:block;width:300px;height:300px;"});a.dispatchEvent("FSIImageFlowLoaded")}(window.$FSI=window.$FSI||{}));