/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class MultiResolutionRenderableImage
implements WritablePropertySource,
RenderableImage,
Serializable {
    protected transient RenderedImage[] renderedSource;
    private int numSources;
    protected float aspect;
    protected float minX;
    protected float minY;
    protected float width;
    protected float height;
    protected PropertyChangeSupportJAI eventManager = new PropertyChangeSupportJAI(this);
    protected WritablePropertySourceImpl properties = new WritablePropertySourceImpl(null, null, this.eventManager);

    private MultiResolutionRenderableImage() {
    }

    public MultiResolutionRenderableImage(Vector vector, float f, float f2, float f3) {
        this();
        int n;
        if (f3 <= 0.0f) {
            throw new IllegalArgumentException(JaiI18N.getString("MultiResolutionRenderableImage0"));
        }
        this.numSources = vector.size();
        this.renderedSource = new RenderedImage[this.numSources];
        for (n = 0; n < this.numSources; ++n) {
            this.renderedSource[n] = (RenderedImage)vector.elementAt(n);
        }
        n = this.renderedSource[0].getWidth();
        int n2 = this.renderedSource[0].getHeight();
        this.aspect = (float)n / (float)n2;
        this.minX = f;
        this.width = f3 * this.aspect;
        this.minY = f2;
        this.height = f3;
    }

    public Vector getSources() {
        return null;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.properties.getPropertyNames(string);
    }

    public Class getPropertyClass(String string) {
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.minX + this.width;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxY() {
        return this.minY + this.height;
    }

    public boolean isDynamic() {
        return false;
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        Object object;
        int n3;
        int n4;
        if (n <= 0 && n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("MultiResolutionRenderableImage1"));
        }
        for (n4 = this.numSources - 1; n4 > 0 && !(n2 > 0 ? (n3 = this.renderedSource[n4].getHeight()) >= n2 : (n3 = this.renderedSource[n4].getWidth()) >= n); --n4) {
        }
        RenderedImage renderedImage = this.renderedSource[n4];
        if (n <= 0) {
            n = Math.round(n2 * renderedImage.getWidth() / renderedImage.getHeight());
        } else if (n2 <= 0) {
            n2 = Math.round(n * renderedImage.getHeight() / renderedImage.getWidth());
        }
        double d = (double)n / (double)renderedImage.getWidth();
        double d2 = (double)n2 / (double)renderedImage.getHeight();
        double d3 = (double)(this.getMinX() - (float)renderedImage.getMinX()) * d;
        double d4 = (double)(this.getMinY() - (float)renderedImage.getMinY()) * d2;
        Interpolation interpolation = Interpolation.getInstance(0);
        if (renderingHints != null && (object = renderingHints.get(JAI.KEY_INTERPOLATION)) != null) {
            interpolation = (Interpolation)object;
        }
        object = new ParameterBlock();
        ((ParameterBlock)object).addSource(renderedImage);
        ((ParameterBlock)object).add((float)d);
        ((ParameterBlock)object).add((float)d2);
        ((ParameterBlock)object).add((float)d3);
        ((ParameterBlock)object).add((float)d4);
        ((ParameterBlock)object).add(interpolation);
        return JAI.create("scale", (ParameterBlock)object, null);
    }

    public RenderedImage createDefaultRendering() {
        return this.renderedSource[0];
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Object object;
        int n;
        int n2;
        if (renderContext == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        int n3 = affineTransform.getType();
        if (n3 == 2 || n3 == 4) {
            int n4 = (int)Math.ceil(affineTransform.getScaleX() * (double)this.getWidth());
            int n5 = (int)Math.ceil(affineTransform.getScaleY() * (double)this.getHeight());
            return this.createScaledRendering(n4, n5, renderingHints);
        }
        int n6 = (int)Math.ceil(Math.sqrt(affineTransform.getDeterminant()) * (double)this.getHeight());
        for (n2 = this.numSources - 1; n2 > 0 && (n = this.renderedSource[n2].getHeight()) < n6; --n2) {
        }
        RenderedImage renderedImage = this.renderedSource[n2];
        double d = (double)this.getWidth() / (double)renderedImage.getWidth();
        double d2 = (double)this.getHeight() / (double)renderedImage.getHeight();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(-renderedImage.getMinX(), -renderedImage.getMinY());
        affineTransform2.scale(d, d2);
        affineTransform2.translate(this.getMinX(), this.getMinY());
        affineTransform2.preConcatenate(affineTransform);
        Interpolation interpolation = Interpolation.getInstance(0);
        if (renderingHints != null && (object = renderingHints.get(JAI.KEY_INTERPOLATION)) != null) {
            interpolation = (Interpolation)object;
        }
        object = new ParameterBlock();
        ((ParameterBlock)object).addSource(renderedImage);
        ((ParameterBlock)object).add(affineTransform2);
        ((ParameterBlock)object).add(interpolation);
        return JAI.create("affine", (ParameterBlock)object, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = new Object[this.numSources];
        for (int i = 0; i < this.numSources; ++i) {
            objectArray[i] = this.renderedSource[i] instanceof Serializable ? this.renderedSource[i] : SerializerFactory.getState(this.renderedSource[i]);
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        this.numSources = objectArray.length;
        this.renderedSource = new RenderedImage[this.numSources];
        for (int i = 0; i < this.numSources; ++i) {
            if (objectArray[i] instanceof SerializableState) {
                SerializableState serializableState = (SerializableState)objectArray[i];
                this.renderedSource[i] = (RenderedImage)serializableState.getObject();
                continue;
            }
            this.renderedSource[i] = (RenderedImage)objectArray[i];
        }
    }
}

