/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import com.neptunelabs.fsiserver.framework.helpers.FileEventCallback;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileEventCursor
extends Thread {
    private final FSILogger \u00d300000;
    private WatchService new;
    private final Map<WatchKey, RegisteredPath> \u00d500000;
    private final Map<Path, RegisteredPath> \u00d400000 = new HashMap<Path, RegisteredPath>();
    private boolean o00000;

    public FileEventCursor(FSILogger fSILogger) {
        this.setName("FileEventCursor");
        this.\u00d300000 = fSILogger;
        try {
            this.new = FileSystems.getDefault().newWatchService();
        }
        catch (IOException iOException) {
            this.new = null;
        }
        this.\u00d500000 = new HashMap<WatchKey, RegisteredPath>();
    }

    @Override
    public void run() {
        this.o00000 = true;
        WatchKey watchKey = null;
        try {
            while (this.o00000 && this.new != null) {
                boolean bl;
                watchKey = this.new.take();
                RegisteredPath registeredPath = this.\u00d500000.get(watchKey);
                if (registeredPath == null) continue;
                boolean bl2 = false;
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (StandardWatchEventKinds.OVERFLOW == kind) continue;
                    Path path = (Path)watchEvent.context();
                    Path path2 = (Path)watchKey.watchable();
                    Path path3 = path2.resolve(path);
                    if (Files.isRegularFile(path3, new LinkOption[0]) || Files.notExists(path3, new LinkOption[0])) {
                        bl2 = registeredPath.evaluatePath(path3);
                    } else if (registeredPath.Object && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        try {
                            if (Files.isDirectory(path3, LinkOption.NOFOLLOW_LINKS)) {
                                this.registerAll(path3, registeredPath);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!bl2) continue;
                    break;
                }
                if (watchKey == null || (bl = watchKey.reset())) continue;
                this.\u00d500000.remove(watchKey);
            }
        }
        catch (InterruptedException | ClosedWatchServiceException exception) {
            this.o00000 = false;
        }
    }

    public synchronized RegisteredPath addPathMonitor(Path path, List<FileEventCallback> list) throws IOException, ClosedWatchServiceException {
        if (Files.exists(path, new LinkOption[0]) && !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException("Path must be a regular file");
        }
        Path path3 = path.toAbsolutePath();
        Path path4 = path3.getParent();
        RegisteredPath registeredPath = this.\u00d400000.get(path4);
        if (registeredPath == null) {
            registeredPath = new RegisteredPath();
            registeredPath.\u00d500000 = path4;
        }
        registeredPath.Object = false;
        registeredPath.\u00d400000 = false;
        DirectoryStream.Filter<Path> filter = path2 -> Files.isSameFile(path3, path2);
        registeredPath.addFilterCallback(filter, list);
        if (this.\u00d300000 != null) {
            this.\u00d300000.log(1051, path3);
        }
        this.register(path4, registeredPath);
        this.\u00d400000.put(path4, registeredPath);
        return registeredPath;
    }

    public synchronized RegisteredPath addPathMonitor(Path path, DirectoryStream.Filter<Path> filter, boolean bl, List<FileEventCallback> list) throws IOException, ClosedWatchServiceException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Path must be a directory: " + path);
        }
        Path path2 = path.toAbsolutePath();
        RegisteredPath registeredPath = this.\u00d400000.get(path2);
        if (registeredPath == null) {
            registeredPath = new RegisteredPath();
            registeredPath.\u00d500000 = path2;
        }
        registeredPath.Object = bl;
        registeredPath.\u00d400000 = false;
        registeredPath.addFilterCallback(filter, list);
        if (this.\u00d300000 != null) {
            this.\u00d300000.log(1051, path2);
        }
        if (bl) {
            this.registerAll(path2, registeredPath);
        } else {
            this.register(path2, registeredPath);
        }
        this.\u00d400000.put(path2, registeredPath);
        return registeredPath;
    }

    public void halt() {
        this.o00000 = false;
        this.interrupt();
        try {
            this.new.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void registerAll(Path path, final RegisteredPath registeredPath) throws IOException, ClosedWatchServiceException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult o00000(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                try {
                    FileEventCursor.this.register(path, registeredPath);
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void register(Path path, RegisteredPath registeredPath) throws IOException, ClosedWatchServiceException {
        WatchKey watchKey = path.register(this.new, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.\u00d500000.put(watchKey, registeredPath);
    }

    private void invokeCallbacks(List<FileEventCallback> list) {
        if (list != null) {
            for (FileEventCallback fileEventCallback : list) {
                try {
                    Method method;
                    Object[] objectArray;
                    Class[] classArray;
                    Class<?> clazz = fileEventCallback.getClazz().getClass();
                    if (clazz == null) continue;
                    if (fileEventCallback.getParameters() != null) {
                        classArray = new Class[fileEventCallback.getParameters().length];
                        objectArray = new Object[fileEventCallback.getParameters().length];
                        for (int i = 0; i < fileEventCallback.getParameters().length; ++i) {
                            classArray[i] = fileEventCallback.getParameters()[i].getClass();
                            objectArray[i] = fileEventCallback.getParameters()[i];
                        }
                    } else {
                        classArray = null;
                        objectArray = new Object[]{};
                    }
                    if ((method = clazz.getMethod(fileEventCallback.getMethod(), classArray)) == null) continue;
                    method.invoke(fileEventCallback.getClazz(), objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                    if (this.\u00d300000 == null) continue;
                    this.\u00d300000.logException(noSuchMethodException, 9001, "No such method: " + noSuchMethodException.getLocalizedMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                    if (this.\u00d300000 == null) continue;
                    this.\u00d300000.logException(invocationTargetException, 9001, "Invocation Target: " + invocationTargetException.getLocalizedMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    if (this.\u00d300000 == null) continue;
                    this.\u00d300000.logException(illegalAccessException, 9001, "Illegal Access" + illegalAccessException.getLocalizedMessage());
                }
            }
        } else if (this.\u00d300000 != null) {
            this.\u00d300000.log(9003, "Invoke callback but nothing declared");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class _o {
        DirectoryStream.Filter<Path> \u00d200000;
        List<FileEventCallback> \u00d300000;

        _o() {
        }
    }

    public class RegisteredPath {
        boolean \u00d400000 = false;
        Path \u00d500000;
        boolean Object;
        final List<_o> \u00d200000 = new ArrayList<_o>();

        public void setSuspended(boolean bl) {
            this.\u00d400000 = bl;
        }

        public boolean isSuspended() {
            return this.\u00d400000;
        }

        void addFilterCallback(DirectoryStream.Filter<Path> filter, List<FileEventCallback> list) {
            _o _o2 = new _o();
            _o2.\u00d200000 = filter;
            _o2.\u00d300000 = list;
            this.\u00d200000.add(_o2);
        }

        boolean evaluatePath(Path path) {
            boolean bl = false;
            for (_o _o2 : this.\u00d200000) {
                boolean bl2;
                block6: {
                    if (_o2.\u00d200000 != null) {
                        try {
                            if (_o2.\u00d200000.accept(path)) {
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                        catch (IOException iOException) {
                            bl2 = false;
                        }
                    } else {
                        bl2 = true;
                    }
                }
                if (!FileEventCursor.this.o00000 || !bl2 || _o2.\u00d300000 == null || this.\u00d400000) continue;
                this.changedPath(_o2.\u00d300000);
                bl = true;
            }
            return bl;
        }

        protected void changedPath(List<FileEventCallback> list) {
            FileEventCursor.this.invokeCallbacks(list);
        }
    }
}

