/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area;

import com.neptunelabs.fsiserver.imagemanipulator.area.Crop;
import com.neptunelabs.fsiserver.imagemanipulator.area.TrimPositions;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;

public final class Trim {
    private Trim() {
    }

    public static FSIImage transform(FSIImage fSIImage, float f, TrimPickupPosition trimPickupPosition, boolean bl) throws ImageManipulatorException {
        if (fSIImage == null) {
            throw new ImageManipulatorException("Trim Input Image is null");
        }
        if (f < 0.0f || f > 100.0f) {
            throw new IllegalArgumentException("Threshold must be >= 0 and <= 100");
        }
        if (fSIImage instanceof FSIImageLimited) {
            int n = fSIImage.getWidth();
            int n2 = fSIImage.getHeight();
            int n3 = trimPickupPosition == TrimPickupPosition.\u00d200000 ? fSIImage.getSample(0, 0) : (trimPickupPosition == TrimPickupPosition.class ? fSIImage.getSample(n - 1, 0) : (trimPickupPosition == TrimPickupPosition.super ? fSIImage.getSample(0, n2 - 1) : fSIImage.getSample(n - 1, n2 - 1)));
            TrimPositions trimPositions = Trim.findTrimPositions((FSIImageLimited)fSIImage, f, n3);
            if (trimPositions.\u00d400000 == -1) {
                trimPositions.\u00d400000 = 0;
            }
            if (trimPositions.\u00d200000 == -1) {
                trimPositions.\u00d200000 = n - 1;
            }
            if (trimPositions.Object == -1) {
                trimPositions.Object = 0;
            }
            if (trimPositions.o00000 == -1) {
                trimPositions.o00000 = n2 - 1;
            }
            int n4 = trimPositions.\u00d200000 - trimPositions.\u00d400000 + 1;
            int n5 = trimPositions.o00000 - trimPositions.Object + 1;
            if (n4 == 0) {
                n4 = 1;
            }
            if (n5 == 0) {
                n5 = 1;
            }
            FSIImage fSIImage2 = n4 != fSIImage.getWidth() || n5 != fSIImage.getHeight() ? Crop.transform(fSIImage, trimPositions.\u00d400000, trimPositions.Object, n4, n5, 0, null, 0.0f, 0.0f) : fSIImage.createCopy();
            if (!bl) {
                fSIImage.dispose();
            }
            return fSIImage2;
        }
        throw new IllegalArgumentException("Trim is currently only implemented for FSIImageLimited");
    }

    public static TrimPositions findTrimPositions(FSIImageLimited fSIImageLimited, float f, int n) throws ImageManipulatorException {
        int n2;
        int n3 = fSIImageLimited.getWidth();
        int n4 = fSIImageLimited.getHeight();
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = n3;
        int n10 = fSIImageLimited.hasAlpha() ? n >> 24 & 0xFF : 255;
        if (n10 == 0) {
            int n11;
            int n12;
            int n13;
            n2 = Math.round(f * 255.0f / 100.0f);
            block0: for (n13 = 0; n13 < n4; ++n13) {
                fSIImageLimited.setPosition(n13 * n3);
                for (n12 = 0; n12 < n9; ++n12) {
                    n11 = fSIImageLimited.getSample() >> 24 & 0xFF;
                    if (n11 <= n2) continue;
                    if (n12 < n9) {
                        n9 = n12;
                        n5 = n12;
                    }
                    if (n6 != -1) continue block0;
                    n6 = n13;
                    continue block0;
                }
            }
            if (n5 != -1) {
                n9 = n5;
                block2: for (n13 = n4 - 1; n13 >= n6; --n13) {
                    for (n12 = n3 - 1; n12 >= n9; --n12) {
                        n11 = fSIImageLimited.getSample(n13 * n3 + n12) >> 24 & 0xFF;
                        if (n11 <= n2) continue;
                        if (n12 > n9) {
                            n9 = n12;
                            n7 = n12;
                        }
                        if (n8 != -1) continue block2;
                        n8 = n13;
                        continue block2;
                    }
                }
            }
        } else {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            n2 = Math.round(f * 255.0f / 100.0f);
            int n20 = n >> 16 & 0xFF;
            int n21 = n >> 8 & 0xFF;
            int n22 = n & 0xFF;
            block4: for (n19 = 0; n19 < n4; ++n19) {
                fSIImageLimited.setPosition(n19 * n3);
                for (n18 = 0; n18 < n9; ++n18) {
                    n17 = fSIImageLimited.getSample();
                    n16 = n17 >> 16 & 0xFF;
                    n15 = n17 >> 8 & 0xFF;
                    n14 = n17 & 0xFF;
                    if (!Trim.outThreshold(n16, n20, n2) && !Trim.outThreshold(n15, n21, n2) && !Trim.outThreshold(n14, n22, n2)) continue;
                    if (n18 < n9) {
                        n9 = n18;
                        n5 = n18;
                    }
                    if (n6 != -1) continue block4;
                    n6 = n19;
                    continue block4;
                }
            }
            if (n5 != -1) {
                n9 = n5;
                block6: for (n19 = n4 - 1; n19 >= n6; --n19) {
                    for (n18 = n3 - 1; n18 >= n9; --n18) {
                        n17 = fSIImageLimited.getSample(n19 * n3 + n18);
                        n16 = n17 >> 16 & 0xFF;
                        n15 = n17 >> 8 & 0xFF;
                        n14 = n17 & 0xFF;
                        if (!Trim.outThreshold(n16, n20, n2) && !Trim.outThreshold(n15, n21, n2) && !Trim.outThreshold(n14, n22, n2)) continue;
                        if (n18 > n9) {
                            n9 = n18;
                            n7 = n18;
                        }
                        if (n8 != -1) continue block6;
                        n8 = n19;
                        continue block6;
                    }
                }
            }
        }
        TrimPositions trimPositions = new TrimPositions();
        trimPositions.\u00d400000 = n5;
        trimPositions.\u00d200000 = n7;
        trimPositions.Object = n6;
        trimPositions.o00000 = n8;
        return trimPositions;
    }

    private static boolean outThreshold(int n, int n2, int n3) {
        return Math.abs(n - n2) > n3;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum TrimPickupPosition {
        \u00d200000,
        class,
        super,
        \u00d400000;

    }
}

