/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.converter;

import com.neptunelabs.fsiserver.imagereader.converter.G;
import com.neptunelabs.fsiserver.imagereader.converter.GrayColorCache;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.converter.RGBColorCache256k;
import com.neptunelabs.fsiserver.imagereader.helper.ICCDefaultReader;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ColorConverterCache {
    private final ConcurrentHashMap<String, G> new;
    private final ConcurrentHashMap<String, ICCProfileWrap> o00000;
    private final int \u00d500000;
    private ICCProfileWrap \u00d400000;
    private final ReentrantLock \u00d300000 = new ReentrantLock();

    public ColorConverterCache(int n) {
        ICC_Profile iCC_Profile;
        this.\u00d500000 = n;
        this.new = new ConcurrentHashMap(n);
        this.o00000 = new ConcurrentHashMap(n);
        try {
            iCC_Profile = ICCDefaultReader.getDefaultICCProfile("rgb");
        }
        catch (IOException iOException) {
            iCC_Profile = ICC_Profile.getInstance(1000);
        }
        if (iCC_Profile != null) {
            this.\u00d400000 = new ICCProfileWrap(iCC_Profile.getData());
        }
    }

    public ICCProfileWrap getSRGBProfile() {
        return this.\u00d400000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public G registerProfile(ICCProfileWrap iCCProfileWrap, int n) {
        G g = null;
        if (iCCProfileWrap != null) {
            this.\u00d300000.lock();
            g = this.new.get(iCCProfileWrap.getHash());
            try {
                if (g == null) {
                    if (n == 1) {
                        g = new GrayColorCache();
                    } else if (n == 3) {
                        g = new RGBColorCache256k();
                    }
                    if (g != null) {
                        this.new.put(iCCProfileWrap.getHash(), g);
                        this.cleanUp();
                    }
                }
            }
            finally {
                this.\u00d300000.unlock();
            }
        }
        return g;
    }

    public G getColorCache(ICCProfileWrap iCCProfileWrap) {
        if (iCCProfileWrap != null) {
            return this.new.get(iCCProfileWrap.getHash());
        }
        return null;
    }

    public G getEmptyColorCache(int n) {
        G g = null;
        if (n == 1) {
            g = new GrayColorCache();
        } else if (n == 3) {
            g = new RGBColorCache256k();
        }
        return g;
    }

    public ICCProfileWrap getICCProfileWrap(String string) {
        return this.o00000.get(string);
    }

    public void close(String string) {
        this.\u00d300000.lock();
        try {
            this.new.remove(string);
            this.o00000.remove(string);
        }
        finally {
            this.\u00d300000.unlock();
        }
    }

    public void dispose() {
        this.\u00d300000.lock();
        try {
            this.new.clear();
        }
        finally {
            this.\u00d300000.unlock();
        }
    }

    private void cleanUp() {
        while (this.new.size() > this.\u00d500000) {
            long l = Long.MAX_VALUE;
            String string = null;
            for (Map.Entry<String, G> entry : this.new.entrySet()) {
                if (entry.getValue().getLastUsage() >= l) continue;
                l = entry.getValue().getLastUsage();
                string = entry.getKey();
            }
            if (string == null) continue;
            this.new.remove(string);
        }
    }
}

