/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.area.LayerBlend;
import com.neptunelabs.fsiserver.imagemanipulator.color.AlphaMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardImageRenderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class SimpleWatermarkRenderer
extends RendererAbstract {
    private static final boolean \u00d3\u00d40000 = true;
    private static final Pattern o\u00d40000 = Pattern.compile("(.*?)\\(([0-9]*)(?:,(TL|TC|TR|CL|CC|CR|BL|BC|BR))?+(?:,([0-9\\.\\-]*))?+(?:,([0-9\\.\\-]*))?+\\),?");
    private final StandardImageRenderer forObject;
    private final ImageBuilder \u00d4\u00d40000;
    private final List<_o> \u00d5\u00d40000 = new ArrayList<_o>();
    private String nullObject = "";

    public SimpleWatermarkRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.forObject = new StandardImageRenderer(requestProcessorSettings, string);
        this.\u00d4\u00d40000 = requestProcessorSettings.getImageBuilder();
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        RendererImageResponse rendererImageResponse = (RendererImageResponse)this.forObject.processRequest(httpServletRequest, map);
        if (rendererImageResponse.getStatus() == 200) {
            try {
                this.renderOverlays(rendererImageResponse, httpServletRequest);
            }
            catch (NotConfiguredException notConfiguredException) {
                rendererImageResponse.setStatus(503);
                this.new.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
            }
            catch (ProcessingException processingException) {
                SimpleWatermarkRenderer.disposeImages(rendererImageResponse.getImage());
                throw processingException;
            }
        }
        return rendererImageResponse;
    }

    private void renderOverlays(RendererImageResponse rendererImageResponse, HttpServletRequest httpServletRequest) throws NotConfiguredException, ProcessingException, InterruptedException {
        Object object;
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        ArrayList<_o> arrayList = new ArrayList<_o>(this.\u00d5\u00d40000);
        String string = parameters.get(Parameters.FileImage.Objectsuper);
        if (string != null && string.length() > 0) {
            object = o\u00d40000.matcher(string);
            while (((Matcher)object).find()) {
                _o object2 = this.extractLayerProperties((Matcher)object);
                arrayList.add(object2);
            }
        }
        for (_o l : arrayList) {
            SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(l.\u00d600000);
            try {
                MetaData metaData = this.\u00d4\u00d40000.getImageMetaData(sourceConnectorReader, l.\u00d600000, 0, true, httpServletRequest.getSession(false));
                if (metaData instanceof ImageMetaData) {
                    l.\u00d300000 = (ImageMetaData)metaData;
                    continue;
                }
                throw new IllegalArgumentException("Overlays not supported for non-image files.");
            }
            catch (IOException iOException) {
            }
        }
        object = rendererImageResponse.getImage();
        try {
            for (_o _o2 : arrayList) {
                object = this.loadAndBlendLayer((FSIImage)object, _o2);
            }
            rendererImageResponse.setResponseImage((FSIImageLimited)object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long l = rendererImageResponse.getDateHeader("Last-Modified");
        for (_o _o3 : arrayList) {
            l += _o3.\u00d300000.getLastModified();
        }
        rendererImageResponse.setDateHeader("Last-Modified", l /= (long)(arrayList.size() + 1));
    }

    private _o extractLayerProperties(Matcher matcher) {
        _o _o2 = new _o();
        _o2.\u00d600000 = matcher.group(1);
        try {
            _o2.\u00d200000 = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (matcher.group(3) != null) {
            _o2.o00000 = matcher.group(3);
        }
        if (matcher.group(4) != null) {
            try {
                _o2.\u00d500000 = Float.parseFloat(matcher.group(4));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (matcher.group(5) != null) {
            try {
                _o2.String = Float.parseFloat(matcher.group(5));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return _o2;
    }

    private FSIImage loadAndBlendLayer(FSIImage fSIImage, _o _o2) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        FSIImageLimited fSIImageLimited = null;
        try {
            SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(_o2.\u00d600000);
            fSIImageLimited = this.\u00d4\u00d40000.getImage(null, sourceConnectorReader, _o2.\u00d600000, new Pair<Integer, Boolean>(_o2.\u00d300000.getWidth(), false), new Pair<Integer, Boolean>(_o2.\u00d300000.getHeight(), false), 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.o00000, null);
            Pair<Integer, Integer> pair = this.calculateOffset(_o2, fSIImageLimited, fSIImage.getWidth(), fSIImage.getHeight());
            LayerBlend layerBlend = new LayerBlend(this.new);
            fSIImage = layerBlend.transform(fSIImage, fSIImageLimited, pair.getItem1(), pair.getItem2(), BlendMode.\u00d5O0000, AlphaMode.String, _o2.\u00d200000, false);
        }
        catch (FSIImageException fSIImageException) {
            if (fSIImageLimited != null) {
                fSIImageLimited.dispose();
            }
            this.new.log(2504, _o2.\u00d600000, fSIImageException.getLocalizedMessage());
        }
        catch (ProcessingException processingException) {
            SimpleWatermarkRenderer.disposeImages(fSIImageLimited);
            throw processingException;
        }
        return fSIImage;
    }

    private Pair<Integer, Integer> calculateOffset(_o _o2, FSIImageLimited fSIImageLimited, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (_o2.o00000.equals("TL")) {
            n3 = (int)_o2.\u00d500000;
            n4 = (int)_o2.String;
        } else if (_o2.o00000.equals("TC")) {
            n3 = (int)((float)n / 2.0f - (float)fSIImageLimited.getWidth() / 2.0f + _o2.\u00d500000);
            n4 = (int)_o2.String;
        } else if (_o2.o00000.equals("TR")) {
            n3 = (int)((float)(n - fSIImageLimited.getWidth()) + _o2.\u00d500000);
            n4 = (int)_o2.String;
        } else if (_o2.o00000.equals("CL")) {
            n3 = (int)_o2.\u00d500000;
            n4 = (int)((float)n2 / 2.0f - (float)fSIImageLimited.getHeight() / 2.0f + _o2.String);
        } else if (_o2.o00000.equals("CC")) {
            n3 = (int)((float)n / 2.0f - (float)fSIImageLimited.getWidth() / 2.0f + _o2.\u00d500000);
            n4 = (int)((float)n2 / 2.0f - (float)fSIImageLimited.getHeight() / 2.0f + _o2.String);
        } else if (_o2.o00000.equals("CR")) {
            n3 = (int)((float)(n - fSIImageLimited.getWidth()) + _o2.\u00d500000);
            n4 = (int)((float)n2 / 2.0f - (float)fSIImageLimited.getHeight() / 2.0f + _o2.String);
        } else if (_o2.o00000.equals("BL")) {
            n3 = (int)_o2.\u00d500000;
            n4 = (int)((float)(n2 - fSIImageLimited.getHeight()) + _o2.String);
        } else if (_o2.o00000.equals("BC")) {
            n3 = (int)((float)n / 2.0f - (float)fSIImageLimited.getWidth() / 2.0f + _o2.\u00d500000);
            n4 = (int)((float)(n2 - fSIImageLimited.getHeight()) + _o2.String);
        } else if (_o2.o00000.equals("BR")) {
            n3 = (int)((float)(n - fSIImageLimited.getWidth()) + _o2.\u00d500000);
            n4 = (int)((float)(n2 - fSIImageLimited.getHeight()) + _o2.String);
        }
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(n3, n4);
        return pair;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("keepaspectratio");
        treeSet.add("errorfallback");
        treeSet.add("importingfallback");
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("overlay");
        treeSet.add("applyrangetooverlays");
        return treeSet;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        string2 = string.equalsIgnoreCase("overlay") ? this.nullObject : this.forObject.getOption(string);
        return string2;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("overlay")) {
            Matcher matcher = o\u00d40000.matcher(string2);
            while (matcher.find()) {
                _o _o2 = this.extractLayerProperties(matcher);
                this.\u00d5\u00d40000.add(_o2);
            }
            this.nullObject = string2;
        } else {
            this.forObject.setOption(string, string2);
        }
    }

    private static class _o {
        String \u00d600000;
        String o00000 = "CC";
        int \u00d200000 = 100;
        float \u00d500000 = 0.0f;
        float String = 0.0f;
        ImageMetaData \u00d300000 = null;

        _o() {
        }
    }
}

