/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.FreemarkerEntityFixer;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class StandardInfoRenderer
extends RendererAbstract {
    private final ImageBuilder oo0000;
    private String \u00f8O0000 = null;
    private String Stringsuper = null;
    private boolean Oo0000 = false;

    public StandardInfoRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.oo0000 = requestProcessorSettings.getImageBuilder();
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("errorFallback")) {
            string2 = this.\u00f8O0000;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            string2 = this.Stringsuper;
        } else if (string.equalsIgnoreCase("noredirect")) {
            string2 = String.valueOf(this.Oo0000);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        if (parameters.getAssetURLPath() == null) {
            return StandardInfoRenderer.generateMissingParameterResponse("source");
        }
        if (parameters.getType() != Parameters.Type.super) {
            throw new IllegalArgumentException("Invalid type requested");
        }
        RendererTextResponse rendererTextResponse = this.processInfoRequest(this.oo0000, parameters, httpSession);
        return rendererTextResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("errorfallback");
        treeSet.add("importingfallback");
        treeSet.add("noredirect");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        if ("noredirect".equals(string) && "true".equals(string2)) {
            this.Oo0000 = true;
        } else if (string.equalsIgnoreCase("errorFallback")) {
            this.\u00f8O0000 = string2;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            this.Stringsuper = string2;
        }
    }

    private RendererTextResponse processInfoRequest(ImageBuilder imageBuilder, Parameters parameters, HttpSession httpSession) throws IllegalArgumentException {
        RendererTextResponse rendererTextResponse;
        block9: {
            try {
                String string = parameters.contains(Parameters.General.\u00f4\u00d40000) ? parameters.get(Parameters.General.\u00f4\u00d40000) : "info.xml";
                Template template = this.\u00d300000.getTemplateCache().getTemplate(TemplateType.new, string + ".ftl");
                TemplateAttributes templateAttributes = new TemplateAttributes(this.new, template);
                if (!this.checkTemplateAccessRestrictions(templateAttributes, httpSession)) {
                    rendererTextResponse = StandardInfoRenderer.generateNotAuthorizedResponse();
                    break block9;
                }
                Escaper.EscaperType escaperType = templateAttributes.getStaticEscape();
                int n = templateAttributes.getReadFlag();
                HashMap<String, Parameters> hashMap = new HashMap<String, Parameters>();
                hashMap.put("query", parameters);
                try {
                    rendererTextResponse = this.handleSingleSource(parameters, httpSession, imageBuilder, template, hashMap, escaperType, n);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if (StandardInfoRenderer.multiSources(parameters.get(Parameters.General.\u00f8\u00d40000))) {
                        rendererTextResponse = this.handleMultiSource(parameters.get(Parameters.General.\u00f8\u00d40000), httpSession, imageBuilder, template, hashMap, n);
                    }
                    throw noSuchFileException;
                }
                templateAttributes.setRendererResponseContentType(rendererTextResponse);
            }
            catch (NoSuchFileException noSuchFileException) {
                rendererTextResponse = StandardInfoRenderer.generateNotFoundResponse();
            }
            catch (TemplateException | IOException throwable) {
                rendererTextResponse = StandardInfoRenderer.generateErrorResponse();
                this.new.logException((Exception)throwable, 3191, throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            }
            catch (NotConfiguredException notConfiguredException) {
                rendererTextResponse = StandardInfoRenderer.generateUnavailableResponse();
                this.new.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
            }
            catch (Exception exception) {
                rendererTextResponse = StandardInfoRenderer.generateErrorResponse();
                this.new.logException(exception, 3191, exception.getClass().getName() + ": " + exception.getLocalizedMessage());
            }
        }
        return rendererTextResponse;
    }

    private boolean isURLPathDirectory(String string, HttpSession httpSession) throws NotConfiguredException {
        if (string != null && (string.equals("_trash") || string.equals("_downloads") || string.equals("_viewers") || string.equals("_configs"))) {
            return true;
        }
        SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string, httpSession);
        if (sourceConnectorReader == null) {
            return false;
        }
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
            return this.isStorageDirectory(string);
        }
        PathCached pathCached = sourceConnectorReader.getSourceFileFromAssetURLPath(string);
        return pathCached.isDirectory();
    }

    private boolean isStorageDirectory(String string) throws NotConfiguredException {
        StorageHelperV1002 storageHelperV1002 = this.\u00d300000.getStorageHelper();
        return storageHelperV1002.isStorageDirectory(string);
    }

    private RendererTextResponse handleSingleSource(Parameters parameters, HttpSession httpSession, ImageBuilder imageBuilder, Template template, Map map, Escaper.EscaperType escaperType, int n) throws IOException, TemplateException, NotConfiguredException {
        Object object;
        Object object2;
        Object object3;
        MetaData metaData;
        String string = parameters.getAssetURLPath();
        PermissionSet permissionSet = this.\u00d300000.getUserAuthenticationInterface().getPermissions(string, httpSession, true);
        if (permissionSet == null) {
            return StandardInfoRenderer.generateNotAuthorizedResponse();
        }
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        Map map2 = null;
        if (string.equals("_downloads") || string.equals("_trash")) {
            metaData = new MetaData();
            metaData.setAssetURLPath(string);
            metaData.setLastModified(System.currentTimeMillis());
            map2 = this.getSimpleHashFromMetaData(metaData, escaperType, permissionSet.read);
        } else if (string.startsWith("_configs") || string.startsWith("_viewers")) {
            object3 = this.\u00d300000.getSourceConnectorFromAssetURLPath(string, httpSession);
            metaData = imageBuilder.getImageMetaData((SourceConnectorReader)object3, string, n, true, httpSession);
            map2 = this.getSimpleHashFromMetaData(metaData, escaperType, permissionSet.read);
        } else {
            boolean bl;
            object3 = this.\u00d300000.getSourceConnectorFromAssetURLPath(string, httpSession);
            if (object3 != null && (((SourceConnectorReader)object3).getMountType() == SourceConnectorReader.SourceConnectorType.o00000 || ((SourceConnectorReader)object3).getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000)) {
                object2 = ((SourceConnectorReader)object3).getSourceFileFromAssetURLPath(string);
                bl = ((PathCached)object2).isDirectory();
            } else {
                bl = false;
                object2 = null;
            }
            if (object3 != null && ((SourceConnectorReader)object3).getMountType() != SourceConnectorReader.SourceConnectorType.o00000 && ((SourceConnectorReader)object3).getMountType() != SourceConnectorReader.SourceConnectorType.\u00d500000) {
                try {
                    object = this.\u00d400000.getRealEisFile(string, this.\u00d300000.getStorageLockHandler());
                }
                catch (NoSuchFileException noSuchFileException) {
                    object = null;
                }
            } else {
                object = null;
            }
            if (!bl && (object != null && Files.exists(object, new LinkOption[0]) || object3 != null && ((SourceConnectorReader)object3).getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000 || object3 != null && ((SourceConnectorReader)object3).getMountType() == SourceConnectorReader.SourceConnectorType.o00000)) {
                short s;
                metaData = imageBuilder.getImageMetaData((SourceConnectorReader)object3, string, n, true, httpSession);
                if (!this.Oo0000 && metaData instanceof ImageMetaData && ((s = (short)((ImageMetaData)metaData).getImportStatus()) == 3 || s == 2 || s == 5)) {
                    this.createFallbackResponse(string, parameters, s, rendererTextResponse);
                    return rendererTextResponse;
                }
            } else if (object3 != null && this.isURLPathDirectory(string, httpSession)) {
                if (object2 == null) {
                    object2 = ((SourceConnectorReader)object3).getSourceFileFromAssetURLPath(string);
                }
                metaData = imageBuilder.getDirectoryMetaData((SourceConnectorReader)object3, string, (PathCached)object2, n);
            } else {
                throw new NoSuchFileException(string);
            }
            if (metaData != null) {
                map2 = this.getSimpleHashFromMetaData(metaData, escaperType, permissionSet.read);
            }
            if (map2 != null && string.equals(((SourceConnectorReader)object3).getPrefix())) {
                SourceManagerSettings sourceManagerSettings;
                SourceConnectorReader sourceConnectorReader;
                map2.put("connectortype", ((SourceConnectorReader)object3).getMountType().name());
                Object object4 = this.\u00d300000.getServletContext().getAttribute("settings.sourceManager");
                if (object4 != null && (sourceConnectorReader = (sourceManagerSettings = (SourceManagerSettings)object4).getSourceConnector(((SourceConnectorReader)object3).getPrefix())) != null) {
                    map2.put("connectorTotalContent", sourceConnectorReader.getCurrentImageCount());
                }
            }
        }
        if (permissionSet.read.basicMetadata.booleanValue() || string.equals("_trash")) {
            rendererTextResponse.setDateHeader("Last-Modified", metaData.getLastModified());
        }
        if (metaData instanceof ImageMetaData && ((ImageMetaData)metaData).getImportStatus() != 1) {
            rendererTextResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        }
        map.put("info", map2);
        map.put("entityFixer", new FreemarkerEntityFixer());
        object3 = new StringWriterFast();
        object2 = null;
        try {
            Environment environment = template.createProcessingEnvironment((Object)map, (Writer)object3);
            environment.process();
            object = String.valueOf(metaData.hashCode()) + template.getCustomAttribute("checksum");
            rendererTextResponse.setETagModifier((String)object);
            rendererTextResponse.setBody(((StringWriterFast)object3).toString());
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object2 != null) {
                    try {
                        ((StringWriterFast)object3).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((StringWriterFast)object3).close();
                }
            }
        }
        rendererTextResponse.setStatus(200);
        return rendererTextResponse;
    }

    private RendererTextResponse handleMultiSource(String string, HttpSession httpSession, ImageBuilder imageBuilder, Template template, Map map, int n) throws IOException, TemplateException, NotConfiguredException {
        String[] stringArray = string.split(",", 2);
        SourceConnectorReader[] sourceConnectorReaderArray = new SourceConnectorReader[stringArray.length];
        PermissionSet.Read[] readArray = new PermissionSet.Read[stringArray.length];
        HashMap<String, PermissionSet> hashMap = new HashMap<String, PermissionSet>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = URL.cleanUpSourceParameter(stringArray[i]);
            sourceConnectorReaderArray[i] = this.\u00d300000.getSourceConnectorFromAssetURLPath(string2);
            if (sourceConnectorReaderArray[i] == null) continue;
            PermissionSet permissionSet = (PermissionSet)hashMap.get(sourceConnectorReaderArray[i].getPrefix());
            if (permissionSet == null) {
                permissionSet = this.\u00d300000.getUserAuthenticationInterface().getPermissions(sourceConnectorReaderArray[i], httpSession, true);
                hashMap.put(sourceConnectorReaderArray[i].getPrefix(), permissionSet);
            }
            if (permissionSet == null) {
                return StandardInfoRenderer.generateNotAuthorizedResponse();
            }
            readArray[i] = permissionSet.read;
        }
        long l = 0L;
        boolean bl = true;
        MetaData[] metaDataArray = new MetaData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            metaDataArray[i] = imageBuilder.getImageMetaData(sourceConnectorReaderArray[i], stringArray[i], n, true, httpSession);
            l = Math.max(l, metaDataArray[i].getLastModified());
            if (!(metaDataArray[i] instanceof ImageMetaData) || ((ImageMetaData)metaDataArray[i]).getImportStatus() == 1) continue;
            bl = false;
        }
        map.put("info", this.getMultiHashFromMetaData(metaDataArray, readArray));
        map.put("entityFixer", new FreemarkerEntityFixer());
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setDateHeader("Last-Modified", l);
        if (!bl) {
            rendererTextResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        }
        try (StringWriterFast stringWriterFast = new StringWriterFast();){
            Environment environment = template.createProcessingEnvironment((Object)map, (Writer)stringWriterFast);
            environment.process();
            stringWriterFast.close();
            rendererTextResponse.setBody(stringWriterFast.toString());
        }
        rendererTextResponse.setStatus(200);
        return rendererTextResponse;
    }

    private Map getMultiHashFromMetaData(MetaData[] metaDataArray, PermissionSet.Read[] readArray) {
        boolean bl = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", "file");
        if (metaDataArray[0] instanceof ImageMetaData) {
            ImageMetaData imageMetaData = (ImageMetaData)metaDataArray[0];
            int n = imageMetaData.getWidth();
            int n2 = imageMetaData.getHeight();
            boolean bl2 = imageMetaData.hasAlpha();
            long l = imageMetaData.getLastModified();
            short s = imageMetaData.getImportStatus();
            ICCProfileWrap iCCProfileWrap = imageMetaData.getICC();
            String string = iCCProfileWrap != null ? iCCProfileWrap.getName() : null;
            for (int i = 1; i < metaDataArray.length; ++i) {
                ImageMetaData imageMetaData2;
                if (metaDataArray[i] instanceof ImageMetaData) {
                    imageMetaData2 = (ImageMetaData)metaDataArray[i];
                    if (imageMetaData2.getWidth() != n) {
                        bl = true;
                        break;
                    }
                    if (imageMetaData2.getHeight() != n2) {
                        bl = true;
                        break;
                    }
                    bl2 |= imageMetaData2.hasAlpha();
                } else {
                    bl = true;
                    break;
                }
                l = Math.max(l, imageMetaData2.getLastModified());
            }
            if (n > 0) {
                hashMap.put("width", n);
            }
            if (n2 > 0) {
                hashMap.put("height", n2);
            }
            if (string != null) {
                hashMap.put("icc", string);
            }
            hashMap.put("alpha", Boolean.toString(bl2));
            hashMap.put("lastmodified", l);
            hashMap.put("importstatus", s);
        } else {
            bl = true;
        }
        if (bl) {
            hashMap = null;
        }
        return hashMap;
    }
}

