/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.service.oOOO;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/icc")
public final class ICCService
extends oOOO
implements Serializable {
    private static final long serialVersionUID = -9152917183661928786L;

    @GET
    @Path(value="/{filepath:.+?}")
    @Produces(value={"*/*"})
    public Response getICC(@PathParam(value="filepath") String string) {
        try {
            HttpSession httpSession = this.\u00f800000(false);
            SourceManagerSettings sourceManagerSettings = this.\u00d6O0000();
            SourceConnectorReader sourceConnectorReader = sourceManagerSettings.getSourceConnectorFromAssetURLPath(string, httpSession);
            PermissionSet permissionSet = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
            if (permissionSet == null || !permissionSet.read.iccProfiles.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            ImageBuilder imageBuilder = new ImageBuilder(sourceManagerSettings, null, null);
            string = URL.cleanUpSourceParameter(string);
            java.nio.file.Path path = this.\u00f8o0000(string, sourceConnectorReader);
            MetaData metaData = imageBuilder.getImageMetaData(sourceConnectorReader, string, 2, true, httpSession);
            if (metaData != null && metaData instanceof ImageMetaData) {
                ImageMetaData imageMetaData = (ImageMetaData)metaData;
                byte[] byArray = null;
                ICCProfileWrap iCCProfileWrap = imageMetaData.getICC();
                if (iCCProfileWrap != null) {
                    byArray = iCCProfileWrap.getBytes();
                }
                if (byArray != null && byArray.length > 0) {
                    Response.ResponseBuilder responseBuilder;
                    String string2 = iCCProfileWrap.getName();
                    if ((string2 == null || string2.equals("")) && (responseBuilder = FileOperations.splitFilename(path.getFileName().toString())) != null) {
                        string2 = responseBuilder[0];
                    }
                    responseBuilder = Response.ok();
                    responseBuilder.header("Content-disposition", (Object)("attachment; filename=\"" + string2 + ".icc\""));
                    responseBuilder.header("Content-length", (Object)byArray.length);
                    responseBuilder.type("application/force-download");
                    responseBuilder.lastModified(new Date(imageMetaData.getLastModified()));
                    responseBuilder.entity((Object)new ByteArrayInputStream(byArray));
                    return responseBuilder.build();
                }
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (NotConfiguredException notConfiguredException) {
            throw new WebApplicationException(503);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (IOException iOException) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

