/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;

public final class BorderExtenderConstant
extends BorderExtender {
    private double[] constants;

    public BorderExtenderConstant(double[] dArray) {
        this.constants = dArray;
    }

    private int clamp(int n, int n2, int n3) {
        double d;
        int n4 = this.constants.length;
        if (n4 == 1) {
            d = this.constants[0];
        } else if (n < n4) {
            d = this.constants[n];
        } else {
            throw new UnsupportedOperationException(JaiI18N.getString("BorderExtenderConstant0"));
        }
        return d > (double)n2 ? (d > (double)n3 ? n3 : (int)d) : n2;
    }

    public final double[] getConstants() {
        return this.constants;
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        if (writableRaster == null || planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getMinX();
        int n5 = n4 + n;
        int n6 = writableRaster.getMinY();
        int n7 = n6 + n2;
        int n8 = Math.max(planarImage.getMinX(), n4);
        int n9 = Math.min(planarImage.getMaxX(), n5);
        int n10 = Math.max(planarImage.getMinY(), n6);
        int n11 = Math.min(planarImage.getMaxY(), n7);
        int n12 = writableRaster.getSampleModel().getDataType();
        if (n12 == 4) {
            float[] fArray = new float[n3];
            for (int i = 0; i < n3; ++i) {
                fArray[i] = i < this.constants.length ? (float)this.constants[i] : 0.0f;
            }
            float[] fArray2 = new float[n * n3];
            int n13 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    fArray2[n13++] = fArray[j];
                }
            }
            if (n8 > n9 || n10 > n11) {
                for (int i = n6; i < n7; ++i) {
                    writableRaster.setPixels(n4, i, n, 1, fArray2);
                }
            } else {
                int n14;
                for (n14 = n6; n14 < n10; ++n14) {
                    writableRaster.setPixels(n4, n14, n, 1, fArray2);
                }
                for (n14 = n10; n14 < n11; ++n14) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n14, n8 - n4, 1, fArray2);
                    }
                    if (n9 >= n5) continue;
                    writableRaster.setPixels(n9, n14, n5 - n9, 1, fArray2);
                }
                for (n14 = n11; n14 < n7; ++n14) {
                    writableRaster.setPixels(n4, n14, n, 1, fArray2);
                }
            }
        } else if (n12 == 5) {
            double[] dArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray[i] = i < this.constants.length ? this.constants[i] : 0.0;
            }
            double[] dArray2 = new double[n * n3];
            int n15 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray2[n15++] = dArray[j];
                }
            }
            if (n8 > n9 || n10 > n11) {
                for (int i = n6; i < n7; ++i) {
                    writableRaster.setPixels(n4, i, n, 1, dArray2);
                }
            } else {
                int n16;
                for (n16 = n6; n16 < n10; ++n16) {
                    writableRaster.setPixels(n4, n16, n, 1, dArray2);
                }
                for (n16 = n10; n16 < n11; ++n16) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n16, n8 - n4, 1, dArray2);
                    }
                    if (n9 >= n5) continue;
                    writableRaster.setPixels(n9, n16, n5 - n9, 1, dArray2);
                }
                for (n16 = n11; n16 < n7; ++n16) {
                    writableRaster.setPixels(n4, n16, n, 1, dArray2);
                }
            }
        } else {
            int[] nArray = new int[n3];
            switch (n12) {
                case 0: {
                    int n17;
                    for (n17 = 0; n17 < n3; ++n17) {
                        nArray[n17] = this.clamp(n17, 0, 255);
                    }
                    break;
                }
                case 2: {
                    int n17;
                    for (n17 = 0; n17 < n3; ++n17) {
                        nArray[n17] = this.clamp(n17, Short.MIN_VALUE, Short.MAX_VALUE);
                    }
                    break;
                }
                case 1: {
                    int n17;
                    for (n17 = 0; n17 < n3; ++n17) {
                        nArray[n17] = this.clamp(n17, 0, 65535);
                    }
                    break;
                }
                case 3: {
                    int n17;
                    for (n17 = 0; n17 < n3; ++n17) {
                        nArray[n17] = this.clamp(n17, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
                }
            }
            int[] nArray2 = new int[n * n3];
            int n18 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    nArray2[n18++] = nArray[j];
                }
            }
            if (n8 > n9 || n10 > n11) {
                for (int i = n6; i < n7; ++i) {
                    writableRaster.setPixels(n4, i, n, 1, nArray2);
                }
            } else {
                int n19;
                for (n19 = n6; n19 < n10; ++n19) {
                    writableRaster.setPixels(n4, n19, n, 1, nArray2);
                }
                for (n19 = n10; n19 < n11; ++n19) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n19, n8 - n4, 1, nArray2);
                    }
                    if (n9 >= n5) continue;
                    writableRaster.setPixels(n9, n19, n5 - n9, 1, nArray2);
                }
                for (n19 = n11; n19 < n7; ++n19) {
                    writableRaster.setPixels(n4, n19, n, 1, nArray2);
                }
            }
        }
    }
}

