/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.image;

import com.neptunelabs.fsiserver.framework.cache.CacheableData;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.helpers.swap.UnlimitedByteBuffer;
import com.neptunelabs.fsiserver.framework.helpers.swap.UnlimitedIntBuffer;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public final class FSIImageUnlimited
extends FSIImage {
    private UnlimitedIntBuffer \u00d6\u00f40000;
    private UnlimitedByteBuffer[] \u00d5\u00f40000;

    public FSIImageUnlimited(FSILogger fSILogger, SwapPool swapPool, ByteOrder byteOrder, int n, int n2, String string, FSIImageMode fSIImageMode, UnlimitedIntBuffer unlimitedIntBuffer, boolean bl) throws FSIImageException {
        this(fSILogger, swapPool, byteOrder, n, n2, string, fSIImageMode, unlimitedIntBuffer, null, bl);
    }

    private FSIImageUnlimited(FSILogger fSILogger, SwapPool swapPool, ByteOrder byteOrder, int n, int n2, String string, FSIImageMode fSIImageMode, UnlimitedIntBuffer unlimitedIntBuffer, UnlimitedByteBuffer[] unlimitedByteBufferArray, boolean bl) throws FSIImageException {
        super(fSILogger, swapPool, n, n2, string, fSIImageMode, byteOrder);
        try {
            if (bl && unlimitedIntBuffer != null) {
                this.\u00d6\u00f40000 = unlimitedIntBuffer.slice();
                if (unlimitedByteBufferArray != null) {
                    this.\u00d5\u00f40000 = new UnlimitedByteBuffer[unlimitedByteBufferArray.length];
                    for (int i = 0; i < unlimitedByteBufferArray.length; ++i) {
                        this.\u00d5\u00f40000[i] = unlimitedByteBufferArray[i].slice();
                    }
                }
            } else {
                this.\u00d6\u00f40000 = new UnlimitedIntBuffer(swapPool, byteOrder, this.o\u00d80000);
            }
            if (this.\u00d6\u00f40000.hasError()) {
                this.\u00d5\u00d80000 = true;
                this.\u00d6\u00f40000.dispose();
                throw new FSIImageException("Creating MappedImage with size " + this.o\u00d80000 + " failed: " + string + " in " + swapPool.getSwapDir());
            }
        }
        catch (IOException iOException) {
            throw new FSIImageException("Creating MappedImage with size " + this.o\u00d80000 + " failed: " + iOException.getLocalizedMessage() + " :" + string);
        }
        this.\u00d6\u00d80000 = fSIImageMode == FSIImageMode.\u00d500000 || fSIImageMode == FSIImageMode.new;
    }

    @Override
    public FSIImage createCompatibleImage(int n, int n2) throws FSIImageException {
        FSIImageUnlimited fSIImageUnlimited = new FSIImageUnlimited(this.\u00f6\u00d80000, this.whileclass, this.\u00d8\u00d80000, n, n2, this.\u00f6\u00d60000, this.\u00d3\u00d80000, null, false);
        if (this.\u00d5\u00f40000 != null) {
            fSIImageUnlimited.createExtraAlpha(this.\u00d5\u00f40000.length);
        }
        return fSIImageUnlimited;
    }

    @Override
    public FSIImage createCompatibleImage() throws FSIImageException {
        return this.createCompatibleImage(this.\u00f8\u00d60000, this.\u00f8\u00d80000);
    }

    @Override
    public FSIImage createCopy() throws FSIImageException {
        Object object;
        int n;
        if (this.returnclass) {
            throw new FSIImageException("Image already disposed");
        }
        FSIImageUnlimited fSIImageUnlimited = new FSIImageUnlimited(this.\u00f6\u00d80000, this.whileclass, this.\u00d8\u00d80000, this.\u00f8\u00d60000, this.\u00f8\u00d80000, this.\u00f6\u00d60000, this.\u00d3\u00d80000, null, false);
        try {
            n = this.\u00d6\u00f40000.getSwapCount();
            object = fSIImageUnlimited.getUnlimitedBuffer();
            for (int i = 0; i < n; ++i) {
                ((UnlimitedIntBuffer)object).copyIntBuffer(this.\u00d6\u00f40000.getSwapIntBuffer(i));
            }
            this.\u00d6\u00f40000.position(0L);
            ((UnlimitedIntBuffer)object).position(0L);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer copy " + this.\u00f5\u00d80000 + " :" + this.\u00f6\u00d60000);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new FSIImageException("BufferOverflowException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer copy " + this.\u00f5\u00d80000 + " :" + this.\u00f6\u00d60000);
        }
        if (this.\u00d5\u00f40000 != null) {
            fSIImageUnlimited.createExtraAlpha(this.\u00d5\u00f40000.length);
            for (n = 0; n < this.\u00d5\u00f40000.length; ++n) {
                object = this.\u00d5\u00f40000[n];
                UnlimitedByteBuffer unlimitedByteBuffer = fSIImageUnlimited.getExtraAlphaUnlimitedBuffer(n);
                int n2 = ((UnlimitedByteBuffer)object).getSwapCount();
                for (int i = 0; i < n2; ++i) {
                    unlimitedByteBuffer.copyByteBuffer(((UnlimitedByteBuffer)object).getSwapIntBuffer(i));
                }
                ((UnlimitedByteBuffer)object).position(0L);
                unlimitedByteBuffer.position(0L);
            }
        }
        return fSIImageUnlimited;
    }

    @Override
    public FSIImageUnlimited createSlice() throws FSIImageException {
        if (this.returnclass) {
            throw new FSIImageException("Image already disposed");
        }
        return new FSIImageUnlimited(this.\u00f6\u00d80000, this.whileclass, this.\u00d8\u00d80000, this.\u00f8\u00d60000, this.\u00f8\u00d80000, this.\u00f6\u00d60000, this.\u00d3\u00d80000, this.\u00d6\u00f40000, this.\u00d5\u00f40000, true);
    }

    @Override
    public boolean createExtraAlpha(int n) {
        boolean bl = true;
        if (this.\u00d5\u00f40000 == null) {
            int n2;
            try {
                this.\u00d5\u00f40000 = new UnlimitedByteBuffer[n];
                n2 = this.\u00f8\u00d60000 * this.\u00f8\u00d80000;
                for (int i = 0; i < n; ++i) {
                    try {
                        this.\u00d5\u00f40000[i] = new UnlimitedByteBuffer(this.whileclass, this.\u00d8\u00d80000, n2);
                        continue;
                    }
                    catch (Error | Exception throwable) {
                        bl = false;
                        break;
                    }
                }
            }
            catch (Error | Exception throwable) {
                bl = false;
            }
            if (!bl) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (this.\u00d5\u00f40000[n2] == null) continue;
                    this.\u00d5\u00f40000[n2].dispose();
                }
            }
        }
        return bl;
    }

    @Override
    public int getExtraAlphaCount() {
        if (this.\u00d5\u00f40000 != null) {
            return this.\u00d5\u00f40000.length;
        }
        return 0;
    }

    @Override
    public void copyInPlace(FSIImage fSIImage, int n, int n2) throws FSIImageException {
        int n3;
        int n4 = fSIImage.getWidth();
        int n5 = fSIImage.getHeight();
        int[] nArray = new int[n4];
        byte[] byArray = new byte[n4];
        for (n3 = 0; n3 < n5; ++n3) {
            fSIImage.setPosition(n3 * n4);
            fSIImage.getSamples(nArray, 0, nArray.length);
            this.setSamples((long)(n + (n2 + n3) * this.\u00f8\u00d60000), nArray);
        }
        if (fSIImage.getExtraAlphaCount() > 0) {
            this.createExtraAlpha(fSIImage.getExtraAlphaCount());
            for (n3 = 0; n3 < this.\u00d5\u00f40000.length; ++n3) {
                for (int i = 0; i < n5; ++i) {
                    fSIImage.setPositionExtraAlpha(n3, i * n4);
                    fSIImage.getSamplesExtraAlpha(n3, byArray, 0, byArray.length);
                    this.setSamplesExtraAlpha(n3, n + (n2 + i) * this.\u00f8\u00d60000, byArray);
                }
            }
        }
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    UnlimitedIntBuffer sliceBuffer() throws IOException {
        return this.\u00d6\u00f40000.slice();
    }

    @Override
    public void setSample(long l, int n) throws FSIImageException {
        try {
            this.\u00d6\u00f40000.put(l, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + l + " in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void setSample(int n, int n2, int n3) throws FSIImageException {
        try {
            this.\u00d6\u00f40000.put((long)n2 * (long)this.\u00f8\u00d60000 + (long)n, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + ((long)n2 * (long)this.\u00f8\u00d60000 + (long)n) + " in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void setSampleExtraAlpha(int n, byte by) throws FSIImageException {
        try {
            this.\u00d5\u00f40000[n].put(by);
        }
        catch (Exception exception) {
            throw new FSIImageException("BufferOverflowException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void setSampleExtraAlpha(int n, long l, byte by) throws FSIImageException {
        try {
            this.\u00d5\u00f40000[n].put(l, by);
        }
        catch (Exception exception) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + l + " in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void setSampleExtraAlpha(int n, int n2, int n3, byte by) throws FSIImageException {
        try {
            this.\u00d5\u00f40000[n].put((long)n3 * (long)this.\u00f8\u00d60000 + (long)n2, by);
        }
        catch (Exception exception) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + ((long)n3 * (long)this.\u00f8\u00d60000 + (long)n2) + " in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void setSampleSafe(int n, int n2, int n3) {
        if (n >= 0 && n < this.\u00f8\u00d60000 && n2 >= 0 && n2 < this.\u00f8\u00d80000) {
            this.\u00d6\u00f40000.put((long)n2 * (long)this.\u00f8\u00d60000 + (long)n, n3);
        }
    }

    void setSample(UnlimitedIntBuffer unlimitedIntBuffer, int n, int n2, int n3) throws FSIImageException {
        try {
            unlimitedIntBuffer.put((long)n2 * (long)this.\u00f8\u00d60000 + (long)n, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("IndexOutOfBoundsException pos " + ((long)n2 * (long)this.\u00f8\u00d60000 + (long)n) + " in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public int getSample() throws FSIImageException {
        int n;
        try {
            n = this.\u00d6\u00f40000.get();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("BufferUnderflowException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
        return n;
    }

    @Override
    public void setSample(int n) throws FSIImageException {
        try {
            this.\u00d6\u00f40000.put(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("BufferOverflowException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public int getSample(long l) throws FSIImageException {
        try {
            return this.\u00d6\u00f40000.get(l);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Position out of range: " + l + " in " + this.\u00d6\u00f40000.capacity() / 4L + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public int getSample(int n, int n2) throws FSIImageException {
        try {
            return this.\u00d6\u00f40000.get((long)n2 * (long)this.\u00f8\u00d60000 + (long)n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            throw new FSIImageException("Position out of range (IOOB): " + n + "x" + n2 + " in " + this.\u00d6\u00f40000.capacity() / 4L + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("Position out of range (BU): " + n + "x" + n2 + " in " + this.\u00d6\u00f40000.capacity() / 4L + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public byte getSampleExtraAlpha(int n) throws FSIImageException {
        byte by;
        try {
            by = (byte)this.\u00d5\u00f40000[n].get();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("IndexOutOfBoundsException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("BufferUnderflowException in " + this.\u00d6\u00f40000.capacity() + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
        return by;
    }

    @Override
    public byte getSampleExtraAlpha(int n, long l) throws FSIImageException {
        try {
            return (byte)this.\u00d5\u00f40000[n].get(l);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Position out of range: " + l + " in " + this.\u00d6\u00f40000.capacity() / 4L + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public byte getSampleExtraAlpha(int n, int n2, int n3) throws FSIImageException {
        try {
            return (byte)this.\u00d5\u00f40000[n].get((long)n3 * (long)this.\u00f8\u00d60000 + (long)n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            throw new FSIImageException("Position out of range (IOOB): " + n2 + "x" + n3 + " in " + this.\u00d6\u00f40000.capacity() / 4L + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("Position out of range (BU): " + n2 + "x" + n3 + " in " + this.\u00d6\u00f40000.capacity() / 4L + " unlimited buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSampleFloat(int n, int n2, float[] fArray) throws FSIImageException {
        try {
            int n3 = this.\u00d6\u00f40000.get((long)n2 * (long)this.\u00f8\u00d60000 + (long)n);
            fArray[0] = (float)(n3 >>> 24) / 255.0f;
            fArray[1] = (float)(n3 >> 16 & 0xFF) / 255.0f;
            fArray[2] = (float)(n3 >> 8 & 0xFF) / 255.0f;
            fArray[3] = (float)(n3 & 0xFF) / 255.0f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Position out of range: " + n + "x" + n2 + " in " + this.\u00d6\u00f40000.capacity() / 4L + " integer buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSampleFloat(int n, int n2, float[] fArray, int n3) throws FSIImageException {
        try {
            int n4 = this.\u00d6\u00f40000.get((long)n2 * (long)this.\u00f8\u00d60000 + (long)n);
            fArray[n3] = (float)(n4 >>> 24) / 255.0f;
            fArray[n3 + 1] = (float)(n4 >> 16 & 0xFF) / 255.0f;
            fArray[n3 + 2] = (float)(n4 >> 8 & 0xFF) / 255.0f;
            fArray[n3 + 3] = (float)(n4 & 0xFF) / 255.0f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Position out of range: " + n + "x" + n2 + " in " + this.\u00d6\u00f40000.capacity() / 4L + " integer buffer: " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSampleRange(int n, int n2, int n3, int n4, int[] nArray) throws FSIImageException {
        try {
            int n5 = n3 - n;
            int n6 = 0;
            for (int i = n2; i <= n4; ++i) {
                this.\u00d6\u00f40000.position((long)n + (long)i * (long)this.\u00f8\u00d60000);
                this.\u00d6\u00f40000.get(nArray, n6, n5 + 1);
                n6 += n5 + 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Coordinates out of range (IOOB): " + n + " " + n2 + " " + n3 + " " + n4 + " :" + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("Coordinates out of range (BU): " + n + " " + n2 + " " + n3 + " " + n4 + " :" + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSampleExtraAlphaRange(int n, int n2, int n3, int n4, int n5, byte[] byArray) throws FSIImageException {
        try {
            int n6 = n4 - n2;
            int n7 = 0;
            for (int i = n3; i <= n5; ++i) {
                this.\u00d5\u00f40000[n].position((long)n2 + (long)i * (long)this.\u00f8\u00d60000);
                this.\u00d5\u00f40000[n].get(byArray, n7, n6 + 1);
                n7 += n6 + 1;
            }
        }
        catch (Exception exception) {
            throw new FSIImageException("Coordinates out of range (IOOB): " + n2 + " " + n3 + " " + n4 + " " + n5 + " :" + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSampleRangeBytes(int n, int n2, int n3, int n4, byte[] byArray) throws FSIImageException {
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        int n7 = n3 - n + 1;
        int[] nArray = new int[n7];
        try {
            for (l = (long)n2; l <= (long)n4; ++l) {
                this.\u00d6\u00f40000.position((long)n + l * (long)this.\u00f8\u00d60000);
                this.\u00d6\u00f40000.get(nArray, 0, nArray.length);
                for (int i = 0; i < n7; ++i) {
                    n6 = nArray[i];
                    byArray[n5++] = (byte)(n6 >>> 24);
                    byArray[n5++] = (byte)(n6 >> 16);
                    byArray[n5++] = (byte)(n6 >> 8);
                    byArray[n5++] = (byte)n6;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Coordinates out of range (IOOB): " + n + " " + n2 + " " + n3 + " " + n4 + "(Pos " + n5 + " of " + byArray.length + " and " + this.\u00d6\u00f40000.capacity() + ") :" + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("Coordinates out of range (BU): " + n + " " + n2 + " " + n3 + " " + n4 + "(Pos " + n5 + " of " + byArray.length + " and " + this.\u00d6\u00f40000.capacity() + ") :" + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSamples(int[] nArray, int n, int n2) throws FSIImageException {
        try {
            this.\u00d6\u00f40000.get(nArray, n, n2);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("BufferUnderflowException :" + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void getSamplesExtraAlpha(int n, byte[] byArray, int n2, int n3) throws FSIImageException {
        try {
            this.\u00d5\u00f40000[n].get(byArray, n2, n3);
        }
        catch (Exception exception) {
            throw new FSIImageException("BufferUnderflowException :" + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void clear() {
        if (this.returnclass) {
            throw new FSIImageException("Image already disposed: " + this.\u00f6\u00d60000);
        }
        this.\u00d6\u00f40000.clear();
    }

    @Override
    public long getPosition() {
        return this.\u00d6\u00f40000.position();
    }

    @Override
    public void setPosition(long l) {
        this.\u00d6\u00f40000.position(l);
    }

    @Override
    public void setPositionExtraAlpha(int n, long l) {
        this.\u00d5\u00f40000[n].position(l);
    }

    @Override
    public void setPosition(int n, int n2) {
        this.\u00d6\u00f40000.position((long)n2 * (long)this.\u00f8\u00d60000 + (long)n);
    }

    @Override
    public void setPositionExtraAlpha(int n, int n2, int n3) {
        this.\u00d5\u00f40000[n].position((long)n3 * (long)this.\u00f8\u00d60000 + (long)n2);
    }

    @Override
    public void setSamples(long l, int[] nArray) throws FSIImageException {
        int n = nArray.length;
        try {
            this.\u00d6\u00f40000.position(l);
            long l2 = UnlimitedIntBuffer.getSwapPosition(l);
            int n2 = (int)(l2 >> 32);
            int n3 = (int)l2;
            long l3 = UnlimitedIntBuffer.getSwapPosition(l + (long)n);
            int n4 = (int)(l3 >> 32);
            int n5 = (int)l3;
            if (n2 == n4 && l + (long)n <= this.\u00d6\u00f40000.capacity()) {
                this.\u00d6\u00f40000.put(nArray);
            } else {
                long l4 = Math.min((long)n, this.\u00d6\u00f40000.capacity() - this.\u00d6\u00f40000.position());
                int n6 = 0;
                long l5 = 0L;
                while (l5 < l4) {
                    this.\u00d6\u00f40000.put(nArray[n6]);
                    ++l5;
                    ++n6;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Coordinates out of range: " + this.\u00f6\u00d60000 + " (SL:" + n + " P:" + l + ")\n" + this.\u00d6\u00f40000);
        }
    }

    @Override
    public void setSamplesExtraAlpha(int n, long l, byte[] byArray) throws FSIImageException {
        int n2 = byArray.length;
        try {
            this.\u00d5\u00f40000[n].position(l);
            long l2 = UnlimitedIntBuffer.getSwapPosition(l);
            int n3 = (int)(l2 >> 32);
            int n4 = (int)l2;
            long l3 = UnlimitedIntBuffer.getSwapPosition(l + (long)n2);
            int n5 = (int)(l3 >> 32);
            int n6 = (int)l3;
            if (n3 == n5 && l + (long)n2 <= this.\u00d6\u00f40000.capacity()) {
                this.\u00d5\u00f40000[n].put(byArray);
            } else {
                long l4 = Math.min((long)n2, this.\u00d6\u00f40000.capacity() - this.\u00d6\u00f40000.position());
                int n7 = 0;
                long l5 = 0L;
                while (l5 < l4) {
                    this.\u00d5\u00f40000[n].put(byArray[n7]);
                    ++l5;
                    ++n7;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Coordinates out of range: " + this.\u00f6\u00d60000 + " (SL:" + n2 + " P:" + l + ")\n" + this.\u00d6\u00f40000);
        }
    }

    @Override
    public void setSamples(long l, IntBuffer intBuffer) throws FSIImageException {
        try {
            this.\u00d6\u00f40000.position(l);
            int n = intBuffer.capacity();
            long l2 = UnlimitedIntBuffer.getSwapPosition(l);
            int n2 = (int)(l2 >> 32);
            int n3 = (int)l2;
            long l3 = UnlimitedIntBuffer.getSwapPosition(l + (long)n);
            int n4 = (int)(l3 >> 32);
            int n5 = (int)l3;
            if (n2 == n4 && l + (long)n <= this.\u00d6\u00f40000.capacity()) {
                intBuffer.position(0);
                this.\u00d6\u00f40000.copyIntBuffer(intBuffer);
            } else {
                long l4 = Math.min((long)n, this.\u00d6\u00f40000.capacity() - this.\u00d6\u00f40000.position()) + l;
                intBuffer.position(0);
                for (long i = l; i < l4; ++i) {
                    this.\u00d6\u00f40000.put(intBuffer.get());
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            throw new FSIImageException("Coordinates out of range (IOOB): " + this.\u00f6\u00d60000);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new FSIImageException("Coordinates out of range (BO): " + this.\u00f6\u00d60000);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new FSIImageException("Coordinates out of range (BU): " + this.\u00f6\u00d60000);
        }
    }

    @Override
    public void setSamples(int n, int n2, int n3, int n4, int[] nArray) throws FSIImageException {
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.setSample(n + j, n2 + i, nArray[n5++]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws FSIImageException {
        if (!this.returnclass) {
            try {
                this.\u00d6\u00f40000.dispose();
                if (this.\u00d5\u00f40000 != null) {
                    for (UnlimitedByteBuffer unlimitedByteBuffer : this.\u00d5\u00f40000) {
                        try {
                            unlimitedByteBuffer.dispose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                this.returnclass = true;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("@" + Integer.toHexString(this.hashCode()));
        stringBuilder.append(": ");
        stringBuilder.append(this.\u00f8\u00d60000);
        stringBuilder.append("x");
        stringBuilder.append(this.\u00f8\u00d80000);
        stringBuilder.append(";Mode:");
        stringBuilder.append((Object)this.\u00d3\u00d80000);
        if (this.\u00d5\u00f40000 != null) {
            stringBuilder.append(";extraAlpha:" + this.\u00d5\u00f40000.length);
        }
        stringBuilder.append(";alpha:");
        stringBuilder.append(this.\u00d6\u00d80000);
        stringBuilder.append(";disposed:");
        stringBuilder.append(this.returnclass);
        stringBuilder.append(";error:");
        stringBuilder.append(this.\u00d5\u00d80000);
        stringBuilder.append(";ub:");
        stringBuilder.append(this.\u00d6\u00f40000);
        stringBuilder.append(";hash:");
        return stringBuilder.toString();
    }

    @Override
    public boolean addAlpha() {
        boolean bl = false;
        try {
            if (!this.\u00d6\u00d80000) {
                this.\u00d6\u00f40000.position(0L);
                for (long i = 0L; i < this.\u00d6\u00f40000.capacity(); ++i) {
                    this.\u00d6\u00f40000.put(i, 0xFF000000 | this.\u00d6\u00f40000.get(i));
                }
                this.\u00d6\u00d80000 = true;
            }
            if (this.\u00d3\u00d80000 == FSIImageMode.o00000) {
                this.\u00d3\u00d80000 = FSIImageMode.new;
            } else if (this.\u00d3\u00d80000 == FSIImageMode.\u00d400000) {
                this.\u00d3\u00d80000 = FSIImageMode.\u00d500000;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new FSIImageException("Coordinates out of range: " + this.\u00f6\u00d60000);
        }
        return false;
    }

    @Override
    public boolean isDisposed() {
        return this.returnclass;
    }

    private UnlimitedIntBuffer getUnlimitedBuffer() {
        return this.\u00d6\u00f40000;
    }

    private UnlimitedByteBuffer getExtraAlphaUnlimitedBuffer(int n) {
        return this.\u00d5\u00f40000[n];
    }

    @Override
    public CacheableData<FSIImage> copy() {
        return this.createCopy();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasExtraAlpha() {
        return this.\u00d5\u00f40000 != null;
    }
}

