/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.download;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

@Obfuscation
public final class DownloadJob
implements Comparable<DownloadJob>,
Serializable {
    private static final long serialVersionUID = 7821300352297580600L;
    private final AtomicInteger progressCount = new AtomicInteger(0);
    private long creationTime = 0L;
    private long scheduledStart = 0L;
    private long startTime = 0L;
    private long finishedTime = 0L;
    private String user;
    private Set<String> groups;
    private Set<String> files;
    private String name;
    private String id;
    private String renderingQuery = null;
    private long archiveSize = 0L;
    private boolean replaceFilenameExtension = false;
    private JobState status = JobState.UNKNOWN;
    private ArchiveType archiveType = ArchiveType.ZIP;
    private int queuePos = -1;
    private int fileCount = 1;

    private DownloadJob() {
    }

    public static long getSerialVersionUID() {
        return 7821300352297580600L;
    }

    public static DownloadJob createJob() {
        DownloadJob downloadJob = new DownloadJob();
        downloadJob.creationTime = System.currentTimeMillis();
        downloadJob.id = String.valueOf(downloadJob.creationTime);
        return downloadJob;
    }

    public static DownloadJob createFromFile(Path path) throws IOException {
        try {
            return (DownloadJob)FileOperations.readObjectFromFile(path);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public final int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int n) {
        this.fileCount = n;
    }

    public final AtomicInteger getProgressCount() {
        return this.progressCount;
    }

    public final Set<String> getGroups() {
        return this.groups;
    }

    public final void setGroups(Set<String> set) {
        this.groups = set;
    }

    public final Set<String> getFiles() {
        return this.files;
    }

    public final void setFiles(Set<String> set) {
        this.files = set;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getRenderingQuery() {
        return this.renderingQuery;
    }

    public final void setRenderingQuery(String string) {
        this.renderingQuery = string;
    }

    public final long getArchiveSize() {
        return this.archiveSize;
    }

    public final void setArchiveSize(long l) {
        this.archiveSize = l;
    }

    public final long getScheduledStart() {
        return this.scheduledStart;
    }

    public final void setScheduledStart(long l) {
        this.scheduledStart = l;
    }

    public final void setCreator(String string) {
        this.user = string;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    public final long getFinishedTime() {
        return this.finishedTime;
    }

    public final void setFinishedTime(long l) {
        this.finishedTime = l;
    }

    public final String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public final JobState getStatus() {
        if (this.status != null) {
            return this.status;
        }
        return JobState.UNKNOWN;
    }

    public void setStatus(JobState jobState) {
        if (jobState != null) {
            this.status = jobState;
        }
    }

    public final int getQueuePos() {
        return this.queuePos;
    }

    public void setQueuePos(int n) {
        this.queuePos = n;
    }

    public final ArchiveType getArchiveType() {
        return this.archiveType;
    }

    public final void setArchiveType(ArchiveType archiveType) {
        this.archiveType = archiveType;
    }

    public final long getLastModified() {
        long l = 0L;
        if (this.status != null) {
            switch (this.status) {
                case COMPLETE: 
                case ERROR: {
                    if (l >= this.finishedTime) break;
                    l = this.finishedTime;
                    break;
                }
                case PROCESSING: 
                case UNKNOWN: {
                    l = System.currentTimeMillis();
                    break;
                }
                case QUEUED: {
                    if (l >= this.creationTime) break;
                    l = this.creationTime;
                    break;
                }
                case CANCELLED: {
                    l = this.startTime != 0L ? this.startTime : this.creationTime;
                }
            }
        }
        return l;
    }

    public boolean equals(Object object) {
        if (object instanceof DownloadJob) {
            DownloadJob downloadJob = (DownloadJob)object;
            return downloadJob.id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(DownloadJob downloadJob) {
        if (this.equals(downloadJob)) {
            return 0;
        }
        return (int)(downloadJob.creationTime - this.creationTime);
    }

    void saveToFile(Path path) throws IOException {
        FileOperations.writeObjectToFile(path, this);
    }

    public final boolean isReplaceFilenameExtension() {
        return this.replaceFilenameExtension;
    }

    public final void setReplaceFilenameExtension(boolean bl) {
        this.replaceFilenameExtension = bl;
    }

    public String toString() {
        return "DownloadJob(progressCount=" + this.getProgressCount() + ", creationTime=" + this.getCreationTime() + ", scheduledStart=" + this.getScheduledStart() + ", startTime=" + this.getStartTime() + ", finishedTime=" + this.getFinishedTime() + ", user=" + this.getUser() + ", groups=" + this.getGroups() + ", files=" + this.getFiles() + ", name=" + this.getName() + ", id=" + this.getId() + ", renderingQuery=" + this.getRenderingQuery() + ", archiveSize=" + this.getArchiveSize() + ", replaceFilenameExtension=" + this.isReplaceFilenameExtension() + ", status=" + (Object)((Object)this.getStatus()) + ", archiveType=" + (Object)((Object)this.getArchiveType()) + ", queuePos=" + this.getQueuePos() + ", fileCount=" + this.getFileCount() + ")";
    }

    public static enum ArchiveType {
        ZIP,
        TAR_GZ,
        TAR_BZ2;

    }

    public static enum JobState {
        UNKNOWN,
        COMPLETE,
        PROCESSING,
        ERROR,
        QUEUED,
        CANCELLED;

    }
}

