/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.licensing;

import com.neptunelabs.fsiserver.framework.helpers.FileEventCallback;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.licensing.LicenceConsumer;
import com.neptunelabs.fsiserver.framework.licensing.LicenceContainer;
import com.neptunelabs.fsiserver.framework.licensing.RawLicence;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Obfuscation
public class LicenceManager {
    private final FSILogger logger;
    private final Path licenceFile;
    private final List<LicenceConsumer> licenceConsumers = new ArrayList<LicenceConsumer>();
    private FileEventCursor.RegisteredPath eventPath;
    private FileEventCursor fileEventCursor;
    private LicenceContainer licenceContainer = null;

    public LicenceManager(FSILogger fSILogger, Path path) {
        this.logger = fSILogger;
        this.licenceFile = path;
        this.readLicence();
    }

    @Obfuscation
    public void readLicence() {
        try {
            byte[] byArray = FileOperations.readFile(this.licenceFile);
            long l = FileOperations.getSafeLastModified(this.licenceFile);
            this.replaceLicence(byArray, l, false);
        }
        catch (IOException | IllegalArgumentException exception) {
            this.licenceContainer = null;
            for (LicenceConsumer licenceConsumer : this.licenceConsumers) {
                licenceConsumer.updateLicenceFromLicenceManager();
            }
        }
    }

    public boolean replaceLicence(byte[] byArray, long l, boolean bl) throws IllegalArgumentException {
        this.licenceContainer = LicenceContainer.getInstance(l, byArray);
        boolean bl2 = true;
        if (bl) {
            try {
                bl2 = this.saveLicence(byArray);
            }
            catch (IOException iOException) {
                bl2 = false;
            }
        }
        if (this.licenceContainer.hasInitializationErrors() || !this.licenceContainer.isValid()) {
            this.logger.log(7003, this.licenceContainer.getErrorMessage());
        }
        for (LicenceConsumer licenceConsumer : this.licenceConsumers) {
            licenceConsumer.updateLicenceFromLicenceManager();
        }
        return bl2;
    }

    private boolean saveLicence(byte[] byArray) throws IOException {
        if (this.eventPath != null) {
            this.eventPath.setSuspended(true);
        }
        boolean bl = FileOperations.writeFile(this.licenceFile, byArray);
        if (this.eventPath != null) {
            this.eventPath.setSuspended(false);
        }
        return bl;
    }

    private void deleteLicence() throws IOException {
        if (this.eventPath != null) {
            this.eventPath.setSuspended(true);
        }
        Files.delete(this.licenceFile);
        if (this.eventPath != null) {
            this.eventPath.setSuspended(false);
        }
    }

    public void setFileEventCursor(FileEventCursor fileEventCursor) {
        this.fileEventCursor = fileEventCursor;
        this.startWatcher();
    }

    public void removeAllLicences() throws IOException {
        this.licenceContainer = null;
        this.deleteLicence();
    }

    public RawLicence getRawLicence(Integer n, Integer n2) {
        RawLicence rawLicence = null;
        if (this.licenceContainer != null) {
            Map<Integer, RawLicence> map;
            Map<Integer, Map<Integer, RawLicence>> map2 = this.licenceContainer.getLicences();
            if (n != null && map2.containsKey(n) && (map = map2.get(n)).containsKey(n2)) {
                rawLicence = map.get(n2);
            }
        }
        return rawLicence;
    }

    public boolean hasRawLicences(Integer n) {
        boolean bl = false;
        if (this.licenceContainer != null) {
            Map<Integer, RawLicence> map;
            Map<Integer, Map<Integer, RawLicence>> map2 = this.licenceContainer.getLicences();
            if (n != null && map2.containsKey(n) && (map = map2.get(n)) != null) {
                bl = true;
            }
        }
        return bl;
    }

    public List<RawLicence> getAllLicences() {
        ArrayList<RawLicence> arrayList = new ArrayList<RawLicence>();
        if (this.licenceContainer != null) {
            Map<Integer, Map<Integer, RawLicence>> map = this.licenceContainer.getLicences();
            for (Map.Entry<Integer, Map<Integer, RawLicence>> entry : map.entrySet()) {
                for (Map.Entry<Integer, RawLicence> entry2 : entry.getValue().entrySet()) {
                    arrayList.add(entry2.getValue());
                }
            }
        }
        return arrayList;
    }

    public String getLicenceContainerHash() {
        if (this.licenceContainer != null) {
            return this.licenceContainer.getContainerHash();
        }
        return "";
    }

    public void addConsumer(LicenceConsumer licenceConsumer) {
        this.licenceConsumers.add(licenceConsumer);
    }

    public void setLicenceContainer(LicenceContainer licenceContainer) {
        this.licenceContainer = licenceContainer;
    }

    public void shutdown() {
    }

    private void startWatcher() {
        FileEventCallback fileEventCallback = new FileEventCallback(this, "readLicence", null);
        ArrayList<FileEventCallback> arrayList = new ArrayList<FileEventCallback>();
        arrayList.add(fileEventCallback);
        try {
            this.eventPath = this.fileEventCursor.addPathMonitor(this.licenceFile, arrayList);
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

