/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.color;

import com.neptunelabs.fsiserver.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;

public final class Posterize
extends ColorOperatorImpl {
    private final int[] nullclass = new int[256];

    public Posterize(int n) throws ImageManipulatorException {
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        n = (n < 2 ? 2 : n) - 1;
        float f = 255.0f / (float)n;
        float f2 = f / 2.0f;
        for (int i = 0; i < 256; ++i) {
            this.nullclass[i] = (int)((float)((int)(((float)i + f2) / f)) * f);
        }
    }

    @Override
    public final int transform(int n, int n2) {
        int n3 = n >>> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        return n3 << 24 | this.nullclass[n4] << 16 | this.nullclass[n5] << 8 | this.nullclass[n6];
    }
}

