/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.helpers.FloatingParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imagemanipulator.area.Crop;
import com.neptunelabs.fsiserver.imagemanipulator.area.LayerBlend;
import com.neptunelabs.fsiserver.imagemanipulator.color.AlphaMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.ContactSheetImageRenderingParameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;

public abstract class AbstractContactSheetRenderer
extends RendererAbstract {
    private int forclass = 1;
    private Crop.CropPadPosition \u00f4\u00d80000 = Crop.CropPadPosition.\u00f600000;
    private int \u00f5\u00d80000 = 0;
    int \u00d8\u00d80000 = 24;

    AbstractContactSheetRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
    }

    void doWork(Parameters parameters, String[] stringArray, RendererImageResponse rendererImageResponse, HttpSession httpSession) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        FSIImage fSIImage = null;
        try {
            int n;
            int n2;
            int n3;
            int n4 = this.determineBackgroundColor(parameters);
            Crop.CropPadPosition cropPadPosition = this.determineAlignment(parameters);
            Pair<Integer, Boolean> pair = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f6\u00d30000));
            Pair<Integer, Boolean> pair2 = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            Pair<Integer, Integer> pair3 = this.getRowsAndColumns(parameters, stringArray.length);
            ContactSheetImageRenderingParameters contactSheetImageRenderingParameters = new ContactSheetImageRenderingParameters();
            AbstractContactSheetRenderer.determineSpacing(contactSheetImageRenderingParameters, parameters);
            AbstractContactSheetRenderer.determinePadding(contactSheetImageRenderingParameters, parameters);
            List<ImageMetaData> list = this.getMetaDataList(stringArray, httpSession);
            int n5 = pair3.getItem2();
            int n6 = pair3.getItem1();
            if (!pair.getItem2().booleanValue() && pair2.getItem2().booleanValue()) {
                contactSheetImageRenderingParameters.\u00d500000 = pair.getItem1();
                if (contactSheetImageRenderingParameters.Object == -1) {
                    contactSheetImageRenderingParameters.Object = (int)(contactSheetImageRenderingParameters.\u00f400000 * (double)contactSheetImageRenderingParameters.\u00d500000);
                }
                if (contactSheetImageRenderingParameters.\u00d200000 == -1) {
                    contactSheetImageRenderingParameters.\u00d200000 = (int)(contactSheetImageRenderingParameters.void * (double)contactSheetImageRenderingParameters.o00000);
                }
                contactSheetImageRenderingParameters.\u00d400000 = (contactSheetImageRenderingParameters.\u00d500000 - (n5 - 1) * contactSheetImageRenderingParameters.Object - 2 * contactSheetImageRenderingParameters.\u00d200000) / n5;
                contactSheetImageRenderingParameters.\u00d600000 = 0;
                for (ImageMetaData object : list) {
                    n3 = object.getWidth();
                    n2 = object.getHeight();
                    n = n2 * contactSheetImageRenderingParameters.\u00d400000 / n3;
                    if (n <= contactSheetImageRenderingParameters.\u00d600000) continue;
                    contactSheetImageRenderingParameters.\u00d600000 = n;
                }
                contactSheetImageRenderingParameters.o00000 = n6 * contactSheetImageRenderingParameters.\u00d600000 + (n6 - 1) * contactSheetImageRenderingParameters.Object + 2 * contactSheetImageRenderingParameters.\u00d200000;
            } else if (pair.getItem2().booleanValue() && !pair2.getItem2().booleanValue()) {
                contactSheetImageRenderingParameters.o00000 = pair2.getItem1();
                if (contactSheetImageRenderingParameters.Object == -1) {
                    contactSheetImageRenderingParameters.Object = (int)(contactSheetImageRenderingParameters.\u00f400000 * (double)contactSheetImageRenderingParameters.o00000);
                }
                if (contactSheetImageRenderingParameters.\u00d200000 == -1) {
                    contactSheetImageRenderingParameters.\u00d200000 = (int)(contactSheetImageRenderingParameters.void * (double)contactSheetImageRenderingParameters.o00000);
                }
                contactSheetImageRenderingParameters.\u00d600000 = (contactSheetImageRenderingParameters.o00000 - (n6 - 1) * contactSheetImageRenderingParameters.Object - 2 * contactSheetImageRenderingParameters.\u00d200000) / n6;
                for (ImageMetaData imageMetaData : list) {
                    n3 = imageMetaData.getWidth();
                    n = n3 * contactSheetImageRenderingParameters.\u00d600000 / (n2 = imageMetaData.getHeight());
                    if (n <= contactSheetImageRenderingParameters.\u00d400000) continue;
                    contactSheetImageRenderingParameters.\u00d400000 = n;
                }
                contactSheetImageRenderingParameters.\u00d500000 = n5 * contactSheetImageRenderingParameters.\u00d400000 + (n5 - 1) * contactSheetImageRenderingParameters.Object + 2 * contactSheetImageRenderingParameters.\u00d200000;
            } else {
                contactSheetImageRenderingParameters.\u00d500000 = pair.getItem1();
                contactSheetImageRenderingParameters.o00000 = pair2.getItem1();
                if (contactSheetImageRenderingParameters.Object == -1) {
                    contactSheetImageRenderingParameters.Object = (int)(contactSheetImageRenderingParameters.\u00f400000 * (double)contactSheetImageRenderingParameters.\u00d500000);
                }
                if (contactSheetImageRenderingParameters.\u00d200000 == -1) {
                    contactSheetImageRenderingParameters.\u00d200000 = (int)(contactSheetImageRenderingParameters.void * (double)contactSheetImageRenderingParameters.\u00d500000);
                }
                contactSheetImageRenderingParameters.\u00d400000 = (contactSheetImageRenderingParameters.\u00d500000 - (n5 - 1) * contactSheetImageRenderingParameters.Object - 2 * contactSheetImageRenderingParameters.\u00d200000) / n5;
                contactSheetImageRenderingParameters.\u00d600000 = (contactSheetImageRenderingParameters.o00000 - (n6 - 1) * contactSheetImageRenderingParameters.Object - 2 * contactSheetImageRenderingParameters.\u00d200000) / n6;
            }
            int n7 = 0;
            for (ImageMetaData imageMetaData : list) {
                SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(imageMetaData.getAssetURLPath());
                FSIImageLimited fSIImageLimited = this.\u00d300000.getImageBuilder().getImage(null, sourceConnectorReader, imageMetaData.getAssetURLPath(), new Pair<Integer, Boolean>(contactSheetImageRenderingParameters.\u00d400000, false), new Pair<Integer, Boolean>(contactSheetImageRenderingParameters.\u00d600000, false), 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.o00000, null);
                LayerBlend layerBlend = new LayerBlend(this.new);
                int n8 = n7 % n5;
                int n9 = n7 / n5;
                int n10 = contactSheetImageRenderingParameters.\u00d200000 + n8 * (contactSheetImageRenderingParameters.\u00d400000 + contactSheetImageRenderingParameters.Object);
                int n11 = contactSheetImageRenderingParameters.\u00d200000 + n9 * (contactSheetImageRenderingParameters.\u00d600000 + contactSheetImageRenderingParameters.Object);
                if (fSIImageLimited.getWidth() != contactSheetImageRenderingParameters.\u00d400000 && cropPadPosition != Crop.CropPadPosition.\u00f400000 && cropPadPosition != Crop.CropPadPosition.\u00d500000 && cropPadPosition != Crop.CropPadPosition.\u00f500000) {
                    if (cropPadPosition == Crop.CropPadPosition.float || cropPadPosition == Crop.CropPadPosition.\u00f600000 || cropPadPosition == Crop.CropPadPosition.o00000) {
                        n10 += (contactSheetImageRenderingParameters.\u00d400000 - fSIImageLimited.getWidth()) / 2;
                    } else if (cropPadPosition == Crop.CropPadPosition.Object || cropPadPosition == Crop.CropPadPosition.\u00d200000 || cropPadPosition == Crop.CropPadPosition.void) {
                        n10 += contactSheetImageRenderingParameters.\u00d400000 - fSIImageLimited.getWidth();
                    }
                }
                if (fSIImageLimited.getHeight() != contactSheetImageRenderingParameters.\u00d600000 && cropPadPosition != Crop.CropPadPosition.\u00f400000 && cropPadPosition != Crop.CropPadPosition.float && cropPadPosition != Crop.CropPadPosition.Object) {
                    if (cropPadPosition == Crop.CropPadPosition.\u00f600000 || cropPadPosition == Crop.CropPadPosition.\u00d500000 || cropPadPosition == Crop.CropPadPosition.\u00d200000) {
                        n11 += (contactSheetImageRenderingParameters.\u00d600000 - fSIImageLimited.getHeight()) / 2;
                    } else if (cropPadPosition == Crop.CropPadPosition.\u00f500000 || cropPadPosition == Crop.CropPadPosition.o00000 || cropPadPosition == Crop.CropPadPosition.void) {
                        n11 += contactSheetImageRenderingParameters.\u00d600000 - fSIImageLimited.getHeight();
                    }
                }
                fSIImage = fSIImage != null ? layerBlend.transform(fSIImage, fSIImageLimited, n10, n11, BlendMode.\u00d5O0000, AlphaMode.o00000, 100.0f, false) : Crop.transform(fSIImageLimited, 0, 0, contactSheetImageRenderingParameters.\u00d500000, contactSheetImageRenderingParameters.o00000, n4, Crop.CropPadPosition.\u00f400000, n10, n11, false);
                ++n7;
            }
            if (pair.getItem2().booleanValue()) {
                parameters.put(Parameters.GeneralImage.\u00f6\u00d30000, String.valueOf(contactSheetImageRenderingParameters.\u00d500000));
            }
            if (pair2.getItem2().booleanValue()) {
                parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(contactSheetImageRenderingParameters.o00000));
            }
            rendererImageResponse.setStatus(200);
            rendererImageResponse.setResponseImage((FSIImageLimited)fSIImage);
            rendererImageResponse.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(list));
        }
        catch (ProcessingException processingException) {
            if (fSIImage != null) {
                fSIImage.dispose();
            }
            throw processingException;
        }
    }

    private static void determinePadding(ContactSheetImageRenderingParameters contactSheetImageRenderingParameters, Parameters parameters) {
        if (parameters.contains(Parameters.GeneralImage.\u00d4\u00d30000)) {
            String string = parameters.get(Parameters.GeneralImage.\u00d4\u00d30000);
            if (string.contains(".")) {
                contactSheetImageRenderingParameters.void = FloatingParser.parseDouble(string);
            } else {
                contactSheetImageRenderingParameters.\u00d200000 = Integer.parseInt(string);
            }
        } else {
            contactSheetImageRenderingParameters.\u00d200000 = 0;
        }
    }

    private static void determineSpacing(ContactSheetImageRenderingParameters contactSheetImageRenderingParameters, Parameters parameters) {
        if (parameters.contains(Parameters.GeneralImage.\u00d8\u00d20000)) {
            String string = parameters.get(Parameters.GeneralImage.\u00d8\u00d20000);
            if (string.contains(".")) {
                contactSheetImageRenderingParameters.\u00f400000 = FloatingParser.parseDouble(string);
            } else {
                contactSheetImageRenderingParameters.Object = Integer.parseInt(string);
            }
        } else {
            contactSheetImageRenderingParameters.Object = 0;
        }
    }

    private Crop.CropPadPosition determineAlignment(Parameters parameters) {
        Crop.CropPadPosition cropPadPosition = this.\u00f4\u00d80000;
        if (parameters.contains(Parameters.FileImage.\u00f800000)) {
            try {
                cropPadPosition = Crop.CropPadPosition.valueOf(parameters.get(Parameters.FileImage.\u00f800000).toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cropPadPosition;
    }

    private int determineBackgroundColor(Parameters parameters) {
        int n = this.\u00f5\u00d80000;
        if (parameters.contains(Parameters.GeneralImage.\u00d6\u00d40000)) {
            n = ColorParser.parseColorWithDefault(parameters.get(Parameters.GeneralImage.\u00d6\u00d40000), n);
        }
        return n;
    }

    private List<ImageMetaData> getMetaDataList(String[] stringArray, HttpSession httpSession) throws IOException, NotConfiguredException {
        ArrayList<ImageMetaData> arrayList = new ArrayList<ImageMetaData>();
        for (String string : stringArray) {
            SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string);
            MetaData metaData = this.\u00d300000.getImageBuilder().getImageMetaData(sourceConnectorReader, string, 0, true, httpSession);
            if (!(metaData instanceof ImageMetaData)) continue;
            arrayList.add((ImageMetaData)metaData);
        }
        return arrayList;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        } else if (string.equalsIgnoreCase("backgroundcolor")) {
            string2 = String.valueOf(this.\u00f5\u00d80000);
        } else if (string.equalsIgnoreCase("defaultAlignment")) {
            string2 = String.valueOf((Object)this.\u00f4\u00d80000);
        } else if (string.equalsIgnoreCase("defaultRows")) {
            string2 = String.valueOf(this.forclass);
        } else if (string.equalsIgnoreCase("maxImages")) {
            string2 = String.valueOf(this.\u00d8\u00d80000);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("backgroundcolor");
        treeSet.add("defaultRows");
        treeSet.add("maxImages");
        treeSet.add("defaultAlignment");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("backgroundColor")) {
            try {
                this.\u00f5\u00d80000 = ColorParser.parseColor(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultRows")) {
            try {
                this.forclass = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultAlignment")) {
            try {
                this.\u00f4\u00d80000 = Crop.CropPadPosition.valueOf(string2.toUpperCase());
            }
            catch (Exception exception) {}
        } else if (string.equalsIgnoreCase("maxImages")) {
            try {
                this.\u00d8\u00d80000 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private Pair<Integer, Integer> getRowsAndColumns(Parameters parameters, int n) {
        if (parameters.contains(Parameters.GeneralImage.O\u00d30000)) {
            return this.getRowsAndColumnsFromRowsParam(parameters.get(Parameters.GeneralImage.O\u00d30000), n);
        }
        if (parameters.contains(Parameters.GeneralImage.\u00d2\u00d20000)) {
            return this.getRowsAndColumnsFromColsParam(parameters.get(Parameters.GeneralImage.\u00d2\u00d20000), n);
        }
        return new Pair<Integer, Integer>(this.forclass, AbstractContactSheetRenderer.calculateColsFromRows(this.forclass, n));
    }

    private Pair<Integer, Integer> getRowsAndColumnsFromColsParam(String string, int n) {
        int n2;
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
        }
        if (n3 <= 0) {
            n2 = this.forclass;
            n3 = AbstractContactSheetRenderer.calculateColsFromRows(n2, n);
        } else {
            n2 = AbstractContactSheetRenderer.calculateRowsFromCols(n3, n);
        }
        return new Pair<Integer, Integer>(n2, n3);
    }

    private Pair<Integer, Integer> getRowsAndColumnsFromRowsParam(String string, int n) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        if (n2 <= 0) {
            n2 = this.forclass;
        }
        return new Pair<Integer, Integer>(n2, AbstractContactSheetRenderer.calculateColsFromRows(n2, n));
    }

    private static int calculateColsFromRows(int n, int n2) {
        return (int)Math.ceil((double)n2 / (double)n);
    }

    private static int calculateRowsFromCols(int n, int n2) {
        return (int)Math.ceil((double)n2 / (double)n);
    }
}

