/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.anaglyph.AnaglyphMode;
import com.neptunelabs.fsiserver.imagemanipulator.anaglyph.AnaglyphRenderer;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class AnaglyphImageRenderer
extends RendererAbstract {
    private final ImageBuilder \u00d5\u00d20000;

    public AnaglyphImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.\u00d5\u00d20000 = requestProcessorSettings.getImageBuilder();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("defaultWidth");
        treeSet.add("defaultHeight");
        treeSet.add("maxWidth");
        treeSet.add("maxHeight");
        return treeSet;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws IllegalArgumentException, ProcessingException, InterruptedException {
        Object object;
        HttpSession httpSession = httpServletRequest.getSession(false);
        RendererImageResponse rendererImageResponse = new RendererImageResponse();
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string = parameters.get(Parameters.General.\u00f8\u00d40000);
        String string2 = null;
        String string3 = null;
        if (string == null) throw new IllegalArgumentException("source required");
        String[] stringArray = string.split(",", 2);
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalArgumentException("source invalid - require 2 comma separated sources");
        }
        string2 = URL.cleanUpSourceParameter(stringArray[0]);
        string3 = URL.cleanUpSourceParameter(stringArray[1]);
        int n = 0xFFFFFF;
        int n2 = 0xFFFFFF;
        String string4 = parameters.get(Parameters.FileImage.\u00d3O0000);
        String string5 = parameters.get(Parameters.FileImage.\u00f400000);
        String string6 = parameters.get(Parameters.FileImage.super);
        if (string6 != null) {
            object = string6.split(",", 2);
            if (object == null || ((String[])object).length != 2) throw new IllegalArgumentException("colormode " + string6 + " invalid - require 2 comma separated values");
            n = this.evaluateColorMode(object[0]);
            if (n == -1) {
                throw new IllegalArgumentException("colormode " + (String)object[0] + " invalid");
            }
            n2 = this.evaluateColorMode((String)object[1]);
            if (n2 == -1) {
                throw new IllegalArgumentException("colormode " + (String)object[1] + " invalid");
            }
        } else if (string4 == null || string5 == null) {
            throw new IllegalArgumentException("colormode or lefteffects and righteffects required");
        }
        object = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f6\u00d30000));
        Pair<Integer, Boolean> pair = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
        if (((Boolean)((Pair)object).getItem2()).booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00f6\u00d30000, String.valueOf(((Pair)object).getItem1()));
        }
        if (pair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(pair.getItem1()));
        }
        try {
            void var29_46;
            void var28_38;
            Object object2;
            void var29_42;
            void var28_34;
            SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string2);
            SourceConnectorReader sourceConnectorReader2 = this.\u00d300000.getSourceConnectorFromAssetURLPath(string3);
            MetaData metaData = this.\u00d5\u00d20000.getImageMetaData(sourceConnectorReader, string2, 64, true, httpSession);
            MetaData metaData2 = this.\u00d5\u00d20000.getImageMetaData(sourceConnectorReader2, string3, 64, true, httpSession);
            if (!(metaData instanceof ImageMetaData) || !(metaData2 instanceof ImageMetaData)) {
                throw new IllegalArgumentException("two valid sources required");
            }
            ImageMetaData imageMetaData = (ImageMetaData)metaData;
            ImageMetaData imageMetaData2 = (ImageMetaData)metaData2;
            if (imageMetaData.getImportStatus() != 1 || imageMetaData2.getImportStatus() != 1) throw new IllegalArgumentException("two valid sources required");
            double[] dArray = Arrays.copyOf(oO0000, 4);
            double[] dArray2 = Arrays.copyOf(oO0000, 4);
            int[] nArray = Arrays.copyOf(\u00d8O0000, 4);
            int[] nArray2 = Arrays.copyOf(\u00d8O0000, 4);
            int[] nArray3 = null;
            boolean bl = false;
            if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d6\u00d30000) || parameters.contains(Parameters.GeneralImage.\u00d6\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d3\u00d40000) || parameters.contains(Parameters.GeneralImage.intnew)) {
                AnaglyphImageRenderer.getRelativeRangeFromParameters(parameters, dArray);
                AnaglyphImageRenderer.getRelativeRangeFromParameters(parameters, dArray2);
            } else if (parameters.contains(Parameters.GeneralImage.supernew) || parameters.contains(Parameters.GeneralImage.floatObject) || parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d2\u00d30000)) {
                nArray3 = AnaglyphImageRenderer.getReferenceDimensions(parameters);
                bl = true;
                this.getPixelRangeFromParameters(parameters, nArray);
                this.getPixelRangeFromParameters(parameters, nArray2);
            }
            Object var28_31 = null;
            Object var29_39 = null;
            try {
                if (bl && nArray3 != null) {
                    FSIImageLimited fSIImageLimited = this.\u00d5\u00d20000.getImagePixelBased(null, sourceConnectorReader, string2, nArray3[0], nArray3[1], nArray[0], nArray[1], nArray[2], nArray[3], true, FSIInterpolation.o00000);
                    FSIImageLimited fSIImageLimited2 = this.\u00d5\u00d20000.getImagePixelBased(null, sourceConnectorReader2, string3, nArray3[0], nArray3[1], nArray2[0], nArray2[1], nArray2[2], nArray2[3], true, FSIInterpolation.o00000);
                } else {
                    FSIImageLimited fSIImageLimited = this.\u00d5\u00d20000.getImage(null, sourceConnectorReader, string2, (Pair<Integer, Boolean>)object, pair, dArray[0], dArray[1], dArray[2], dArray[3], true, FSIInterpolation.o00000, null);
                    FSIImageLimited fSIImageLimited3 = this.\u00d5\u00d20000.getImage(null, sourceConnectorReader2, string3, (Pair<Integer, Boolean>)object, pair, dArray2[0], dArray2[1], dArray2[2], dArray2[3], true, FSIInterpolation.o00000, null);
                }
            }
            catch (FSIImageException fSIImageException) {
                this.new.log(2504, string3, fSIImageException.getLocalizedMessage());
                AnaglyphImageRenderer.disposeImages(var28_31, var29_39);
                throw fSIImageException;
            }
            catch (ProcessingException processingException) {
                AnaglyphImageRenderer.disposeImages(var28_31, var29_39);
                throw processingException;
            }
            if (var28_34 == null || var29_42 == null) return rendererImageResponse;
            if (parameters.contains(Parameters.FileImage.interface)) {
                object2 = parameters.get(Parameters.FileImage.interface);
                FSIImage fSIImage = this.applyEffects((FSIImage)var28_34, imageMetaData.getSelections(), parameters, (String)object2);
                FSIImage fSIImage2 = this.applyEffects((FSIImage)var29_42, imageMetaData2.getSelections(), parameters, (String)object2);
            }
            if (parameters.contains(Parameters.FileImage.\u00d3O0000)) {
                void var28_36;
                object2 = parameters.get(Parameters.FileImage.\u00d3O0000);
                FSIImage fSIImage = this.applyEffects((FSIImage)var28_36, imageMetaData.getSelections(), parameters, (String)object2);
            }
            if (parameters.contains(Parameters.FileImage.\u00f400000)) {
                void var29_44;
                object2 = parameters.get(Parameters.FileImage.\u00f400000);
                FSIImage fSIImage = this.applyEffects((FSIImage)var29_44, imageMetaData2.getSelections(), parameters, (String)object2);
            }
            object2 = new AnaglyphRenderer(this.new);
            ((AnaglyphRenderer)object2).setImages((FSIImage)var28_38, (FSIImage)var29_46);
            ((AnaglyphRenderer)object2).setLeftColor(n);
            ((AnaglyphRenderer)object2).setRightColor(n2);
            FSIImageLimited fSIImageLimited = (FSIImageLimited)((AnaglyphRenderer)object2).render(false);
            rendererImageResponse.setResponseImage(fSIImageLimited);
            rendererImageResponse.setStatus(200);
            return rendererImageResponse;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("two valid sources required");
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererImageResponse.setStatus(503);
            this.new.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
        }
        return rendererImageResponse;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.new.log(3043, string2, string, this.\u00d800000);
            }
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.new.log(3043, string2, string, this.\u00d800000);
            }
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.new.log(3043, string2, string, this.\u00d800000);
            }
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.new.log(3043, string2, string, this.\u00d800000);
            }
        }
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        }
        return string2;
    }

    private FSIImage applyEffects(FSIImage fSIImage, byte[] byArray, Parameters parameters, String string) throws ProcessingException {
        try {
            fSIImage = this.\u00d300000.getEffectsManager().applyEffects(fSIImage, byArray, string, parameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.new.log(3153, null, string, "");
        }
        return fSIImage;
    }

    private int evaluateColorMode(String string) {
        int n = -1;
        try {
            AnaglyphMode anaglyphMode = AnaglyphMode.valueOf(string.toUpperCase());
            switch (anaglyphMode) {
                case \u00d500000: {
                    n = 255;
                    break;
                }
                case \u00f500000: {
                    n = 65535;
                    break;
                }
                case o00000: {
                    n = 65280;
                    break;
                }
                case new: {
                    n = 0xFF00FF;
                    break;
                }
                case \u00f400000: {
                    n = 0xFF0000;
                    break;
                }
                case return: {
                    n = 0xFFFF00;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                n = ColorParser.parseColor(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

