/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.helpers.FloatingParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.area.Crop;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.fsiserver.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.fsiserver.imagemanipulator.combine.Join;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DoublePageImageRenderingParameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DoublePageImageRenderer
extends RendererAbstract {
    private final ImageBuilder \u00f4\u00d40000;
    private Crop.CropPadPosition \u00f5\u00d40000 = Crop.CropPadPosition.\u00f600000;
    private int privateObject = 0;

    public DoublePageImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.\u00f4\u00d40000 = requestProcessorSettings.getImageBuilder();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string = parameters.getAssetURLPath();
        if (string == null) {
            throw new IllegalArgumentException("source required");
        }
        String[] stringArray = this.extractSourcesFromParameter(string);
        Pair<Integer, Boolean> pair = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f6\u00d30000));
        Pair<Integer, Boolean> pair2 = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
        FSIImage fSIImage = null;
        FSIImage fSIImage2 = null;
        try {
            Object object;
            HttpSession httpSession = httpServletRequest.getSession(false);
            for (String string2 : stringArray) {
                object = this.\u00d300000.getUserAuthenticationInterface().getPermissions(string2, httpSession, true);
                if (object != null && ((PermissionSet)object).read.renderedImages.booleanValue()) continue;
                return DoublePageImageRenderer.generateNotAuthorizedResponse();
            }
            List<ImageMetaData> list = this.getMetaDataList(stringArray, httpSession);
            RendererImageResponse rendererImageResponse = new RendererImageResponse();
            if (list.size() > 1) {
                DoublePageImageRenderingParameters doublePageImageRenderingParameters = new DoublePageImageRenderingParameters();
                short s = this.checkImageStatus(list);
                if (s != 1) {
                    this.createFallbackResponse(string, parameters, s, rendererImageResponse);
                    return rendererImageResponse;
                }
                this.calculateRenderingParameters(parameters, pair, pair2, list, doublePageImageRenderingParameters);
                fSIImage = this.getLeftPage(((ImageMetaData)list.get(0)).getAssetURLPath(), doublePageImageRenderingParameters);
                fSIImage2 = this.getRightPage(((ImageMetaData)list.get(1)).getAssetURLPath(), doublePageImageRenderingParameters);
                object = this.joinImages(fSIImage, fSIImage2, doublePageImageRenderingParameters);
                if (((FSIImage)object).hasAlpha()) {
                    ParallelColorOperation parallelColorOperation = new ParallelColorOperation(this.new);
                    object = parallelColorOperation.transform((FSIImage)object, new MatteTransparent(doublePageImageRenderingParameters.\u00f600000, false), false);
                }
                parameters.put(Parameters.GeneralImage.\u00f6\u00d30000, String.valueOf(((FSIImage)object).getWidth()));
                parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(((FSIImage)object).getHeight()));
                rendererImageResponse.setStatus(200);
                rendererImageResponse.setResponseImage((FSIImageLimited)object);
                rendererImageResponse.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(list));
            } else {
                rendererImageResponse.setStatus(404);
            }
            return rendererImageResponse;
        }
        catch (NoSuchFileException noSuchFileException) {
            DoublePageImageRenderer.disposeImages(fSIImage, fSIImage2);
            return DoublePageImageRenderer.generateNotFoundResponse();
        }
        catch (IOException iOException) {
            DoublePageImageRenderer.disposeImages(fSIImage, fSIImage2);
            return DoublePageImageRenderer.generateErrorResponse();
        }
        catch (NotConfiguredException notConfiguredException) {
            this.new.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
            return DoublePageImageRenderer.generateUnavailableResponse();
        }
        catch (ProcessingException processingException) {
            DoublePageImageRenderer.disposeImages(fSIImage, fSIImage2);
            throw processingException;
        }
    }

    private short checkImageStatus(List<ImageMetaData> list) {
        ImageMetaData imageMetaData = list.get(0);
        if (imageMetaData.getImportStatus() != 1 && imageMetaData.getImportStatus() != 4) {
            return imageMetaData.getImportStatus();
        }
        imageMetaData = list.get(1);
        if (imageMetaData.getImportStatus() != 1 && imageMetaData.getImportStatus() != 4) {
            return imageMetaData.getImportStatus();
        }
        return 1;
    }

    private void calculateRenderingParameters(Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, List<ImageMetaData> list, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        doublePageImageRenderingParameters.float = pair.getItem1() / 2;
        this.parseAlignmentParameters(parameters, doublePageImageRenderingParameters);
        this.parseCropParameters(parameters, doublePageImageRenderingParameters);
        this.parseBackgroundColor(parameters, doublePageImageRenderingParameters);
        if (!pair.getItem2().booleanValue() && pair2.getItem2().booleanValue()) {
            this.calculateRenderingParamsFromGivenWidth(parameters, list, doublePageImageRenderingParameters);
        } else if (pair.getItem2().booleanValue() && !pair2.getItem2().booleanValue()) {
            this.calculateRenderingParamsFromGivenHeight(parameters, pair2, list, doublePageImageRenderingParameters);
        } else {
            this.calculateRenderingParamsFromGivenWidthAndHeight(parameters, pair2, list, doublePageImageRenderingParameters);
        }
    }

    private void calculateRenderingParamsFromGivenWidth(Parameters parameters, List<ImageMetaData> list, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        int n = list.get(0).getWidth();
        int n2 = list.get(0).getHeight();
        int n3 = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.do), n);
        doublePageImageRenderingParameters.Object = this.calculateBoundingBoxWidth(n, doublePageImageRenderingParameters.\u00d500000[2], n3, doublePageImageRenderingParameters.float);
        doublePageImageRenderingParameters.\u00d600000 = doublePageImageRenderingParameters.float - doublePageImageRenderingParameters.Object;
        int n4 = list.get(1).getWidth();
        int n5 = list.get(1).getHeight();
        int n6 = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.int), n4);
        doublePageImageRenderingParameters.\u00f500000 = this.calculateBoundingBoxWidth(n4, doublePageImageRenderingParameters.\u00f400000[2], n6, doublePageImageRenderingParameters.float);
        doublePageImageRenderingParameters.void = doublePageImageRenderingParameters.float - doublePageImageRenderingParameters.\u00f500000;
        int n7 = this.calcOptimalPageHeight(n, n2, doublePageImageRenderingParameters.\u00d500000[2], doublePageImageRenderingParameters.\u00d500000[3], doublePageImageRenderingParameters.Object);
        int n8 = this.calcOptimalPageHeight(n4, n5, doublePageImageRenderingParameters.\u00f400000[2], doublePageImageRenderingParameters.\u00f400000[3], doublePageImageRenderingParameters.\u00f500000);
        doublePageImageRenderingParameters.\u00d200000 = Math.max(n7, n8);
    }

    private void calculateRenderingParamsFromGivenHeight(Parameters parameters, Pair<Integer, Boolean> pair, List<ImageMetaData> list, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        int n = list.get(0).getWidth();
        int n2 = list.get(0).getHeight();
        doublePageImageRenderingParameters.\u00d200000 = pair.getItem1();
        int n3 = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.do), n);
        int n4 = this.calculateOptimalBoundingBoxWidth(n, n2, doublePageImageRenderingParameters.\u00d500000[2], doublePageImageRenderingParameters.\u00d500000[3], pair.getItem1());
        doublePageImageRenderingParameters.\u00d600000 = (int)((double)(n4 * n3) / (double)n);
        int n5 = n4 + doublePageImageRenderingParameters.\u00d600000;
        int n6 = list.get(1).getWidth();
        int n7 = list.get(1).getHeight();
        int n8 = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.int), n6);
        int n9 = this.calculateOptimalBoundingBoxWidth(n6, n7, doublePageImageRenderingParameters.\u00f400000[2], doublePageImageRenderingParameters.\u00f400000[3], pair.getItem1());
        doublePageImageRenderingParameters.void = (int)((double)(n9 * n8) / (double)n6);
        int n10 = n9 + doublePageImageRenderingParameters.void;
        if (n5 > n10) {
            doublePageImageRenderingParameters.float = n5;
            doublePageImageRenderingParameters.Object = n4;
            doublePageImageRenderingParameters.\u00f500000 = n9 + n5 - n10;
        } else {
            doublePageImageRenderingParameters.float = n10;
            doublePageImageRenderingParameters.Object = n4 + n10 - n5;
            doublePageImageRenderingParameters.\u00f500000 = n9;
        }
    }

    private void calculateRenderingParamsFromGivenWidthAndHeight(Parameters parameters, Pair<Integer, Boolean> pair, List<ImageMetaData> list, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        doublePageImageRenderingParameters.\u00d200000 = pair.getItem1();
        int n = list.get(0).getWidth();
        int n2 = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.do), n);
        doublePageImageRenderingParameters.Object = this.calculateBoundingBoxWidth(n, doublePageImageRenderingParameters.\u00d500000[2], n2, doublePageImageRenderingParameters.float);
        doublePageImageRenderingParameters.\u00d600000 = doublePageImageRenderingParameters.float - doublePageImageRenderingParameters.Object;
        int n3 = list.get(1).getWidth();
        int n4 = this.parseInnerGapParameter(parameters.get(Parameters.FileImage.int), n3);
        doublePageImageRenderingParameters.\u00f500000 = this.calculateBoundingBoxWidth(n3, doublePageImageRenderingParameters.\u00f400000[2], n4, doublePageImageRenderingParameters.float);
        doublePageImageRenderingParameters.void = doublePageImageRenderingParameters.float - doublePageImageRenderingParameters.\u00f500000;
    }

    private FSIImage getLeftPage(String string, DoublePageImageRenderingParameters doublePageImageRenderingParameters) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        double d = doublePageImageRenderingParameters.\u00d500000[0];
        double d2 = doublePageImageRenderingParameters.\u00d500000[1];
        double d3 = doublePageImageRenderingParameters.\u00d500000[2];
        double d4 = doublePageImageRenderingParameters.\u00d500000[3];
        Pair<Integer, Boolean> pair = new Pair<Integer, Boolean>(doublePageImageRenderingParameters.Object, false);
        Pair<Integer, Boolean> pair2 = new Pair<Integer, Boolean>(doublePageImageRenderingParameters.\u00d200000, false);
        SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string);
        FSIImage fSIImage = this.\u00f4\u00d40000.getImage(null, sourceConnectorReader, string, pair, pair2, d, d2, d3, d4, true, FSIInterpolation.o00000, null);
        if (fSIImage.getWidth() != doublePageImageRenderingParameters.Object || fSIImage.getHeight() != doublePageImageRenderingParameters.\u00d200000) {
            fSIImage = Crop.transform(fSIImage, 0, 0, doublePageImageRenderingParameters.Object, doublePageImageRenderingParameters.\u00d200000, doublePageImageRenderingParameters.\u00f600000, doublePageImageRenderingParameters.o00000, 0.0f, 0.0f, false);
        }
        return fSIImage;
    }

    private FSIImage getRightPage(String string, DoublePageImageRenderingParameters doublePageImageRenderingParameters) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        double d = doublePageImageRenderingParameters.\u00f400000[0];
        double d2 = doublePageImageRenderingParameters.\u00f400000[1];
        double d3 = doublePageImageRenderingParameters.\u00f400000[2];
        double d4 = doublePageImageRenderingParameters.\u00f400000[3];
        Pair<Integer, Boolean> pair = new Pair<Integer, Boolean>(doublePageImageRenderingParameters.\u00f500000, false);
        Pair<Integer, Boolean> pair2 = new Pair<Integer, Boolean>(doublePageImageRenderingParameters.\u00d200000, false);
        SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string);
        FSIImage fSIImage = this.\u00f4\u00d40000.getImage(null, sourceConnectorReader, string, pair, pair2, d, d2, d3, d4, true, FSIInterpolation.o00000, null);
        if (fSIImage.getWidth() != doublePageImageRenderingParameters.\u00f500000 || fSIImage.getHeight() != doublePageImageRenderingParameters.\u00d200000) {
            fSIImage = Crop.transform(fSIImage, 0, 0, doublePageImageRenderingParameters.\u00f500000, doublePageImageRenderingParameters.\u00d200000, doublePageImageRenderingParameters.\u00f600000, doublePageImageRenderingParameters.\u00d400000, 0.0f, 0.0f, false);
        }
        return fSIImage;
    }

    private FSIImage joinImages(FSIImage fSIImage, FSIImage fSIImage2, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        if (doublePageImageRenderingParameters.\u00d600000 > 0) {
            fSIImage = Crop.transform(fSIImage, 0, 0, fSIImage.getWidth() + doublePageImageRenderingParameters.\u00d600000, fSIImage.getHeight(), doublePageImageRenderingParameters.\u00f600000, Crop.CropPadPosition.\u00d500000, 0.0f, 0.0f, false);
        }
        if (doublePageImageRenderingParameters.void > 0) {
            fSIImage2 = Crop.transform(fSIImage2, 0, 0, fSIImage2.getWidth() + doublePageImageRenderingParameters.void, fSIImage2.getHeight(), doublePageImageRenderingParameters.\u00f600000, Crop.CropPadPosition.\u00d200000, 0.0f, 0.0f, false);
        }
        if (fSIImage.hasAlpha() && !fSIImage2.hasAlpha()) {
            fSIImage2.addAlpha();
        } else if (!fSIImage.hasAlpha() && fSIImage2.hasAlpha()) {
            fSIImage.addAlpha();
        }
        return Join.transform(fSIImage, fSIImage2, Join.JoinPosition.\u00d200000, false);
    }

    private void parseAlignmentParameters(Parameters parameters, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        if (parameters.contains(Parameters.FileImage.class)) {
            doublePageImageRenderingParameters.o00000 = Crop.CropPadPosition.valueOf(parameters.get(Parameters.FileImage.class).toUpperCase());
        }
        if (parameters.contains(Parameters.FileImage.\u00d6O0000)) {
            doublePageImageRenderingParameters.\u00d400000 = Crop.CropPadPosition.valueOf(parameters.get(Parameters.FileImage.\u00d6O0000).toUpperCase());
        }
    }

    private void parseCropParameters(Parameters parameters, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        if (parameters.contains(Parameters.FileImage.\u00d400000)) {
            doublePageImageRenderingParameters.\u00d500000 = DoublePageImageRenderer.parseRangeParameterValue(parameters.get(Parameters.FileImage.\u00d400000));
        }
        if (parameters.contains(Parameters.FileImage.\u00d4O0000)) {
            doublePageImageRenderingParameters.\u00f400000 = DoublePageImageRenderer.parseRangeParameterValue(parameters.get(Parameters.FileImage.\u00d4O0000));
        }
    }

    private int calcOptimalPageHeight(int n, int n2, double d, double d2, int n3) {
        int n4 = (int)((double)n * d);
        int n5 = (int)((double)n2 * d2);
        return (int)((double)n3 * (double)n5 / (double)n4);
    }

    private int calculateOptimalBoundingBoxWidth(int n, int n2, double d, double d2, int n3) {
        int n4 = (int)((double)n * d);
        int n5 = (int)((double)n2 * d2);
        return (int)((double)n3 * (double)n4 / (double)n5);
    }

    private int parseInnerGapParameter(String string, int n) {
        int n2 = 0;
        if (string != null) {
            try {
                Double d = FloatingParser.parseDouble(string);
                n2 = (int)Math.ceil((double)n * d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private int calculateBoundingBoxWidth(int n, double d, int n2, int n3) {
        int n4 = (int)Math.ceil(d * (double)n);
        double d2 = (double)n3 / (double)(n4 + n2);
        return (int)(d2 * (double)n4);
    }

    private void parseBackgroundColor(Parameters parameters, DoublePageImageRenderingParameters doublePageImageRenderingParameters) {
        int n = this.privateObject;
        if (parameters.contains(Parameters.GeneralImage.\u00d6\u00d40000)) {
            n = ColorParser.parseColorWithDefault(parameters.get(Parameters.GeneralImage.\u00d6\u00d40000), n);
        }
        doublePageImageRenderingParameters.\u00f600000 = n;
    }

    private String[] extractSourcesFromParameter(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = URL.cleanUpSourceParameter(stringArray[i]);
        }
        if (stringArray.length > 2) {
            String[] stringArray2 = new String[2];
            for (int i = 0; i < 2; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    private List<ImageMetaData> getMetaDataList(String[] stringArray, HttpSession httpSession) throws NoSuchFileException, IOException, NotConfiguredException {
        ArrayList<ImageMetaData> arrayList = new ArrayList<ImageMetaData>();
        for (String string : stringArray) {
            SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string);
            MetaData metaData = this.\u00d300000.getImageBuilder().getImageMetaData(sourceConnectorReader, string, 0, true, httpSession);
            if (!(metaData instanceof ImageMetaData)) {
                throw new IllegalArgumentException("two valid sources required");
            }
            metaData.setAssetURLPath(string);
            arrayList.add((ImageMetaData)metaData);
        }
        return arrayList;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        } else if (string.equalsIgnoreCase("backgroundcolor")) {
            string2 = String.valueOf(this.privateObject);
        } else if (string.equalsIgnoreCase("defaultAlignment")) {
            string2 = String.valueOf((Object)this.\u00f5\u00d40000);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("backgroundcolor");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        try {
            if (string.equalsIgnoreCase("maxWidth")) {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            } else if (string.equalsIgnoreCase("maxHeight")) {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            } else if (string.equalsIgnoreCase("defaultWidth")) {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            } else if (string.equalsIgnoreCase("defaultHeight")) {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            } else if (string.equalsIgnoreCase("backgroundColor")) {
                this.privateObject = ColorParser.parseColor(string2);
            } else if (string.equalsIgnoreCase("defaultAlignment")) {
                this.\u00f5\u00d40000 = Crop.CropPadPosition.valueOf(string2.toUpperCase());
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.new.log(2035, this.\u00d800000 + ".xml", string2, string);
        }
    }
}

