/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.service.C;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Password;
import com.neptunelabs.fsiserver.utils.service.SaltResponse;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/password")
public final class PasswordService
extends C
implements Serializable {
    private static final long serialVersionUID = -7709019603957201866L;

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getPasswordChangeSalt() {
        if (!this.null()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        UserAuthenticationInterface userAuthenticationInterface = this.\u00d2o0000();
        if (!userAuthenticationInterface.isPasswordChangePossible()) {
            ActionResponse actionResponse = new ActionResponse();
            actionResponse.setStatuscode(403);
            actionResponse.setCause("Not supported by Configuration");
            actionResponse.setDetails("Passwords are managed externally.");
            Response.ResponseBuilder responseBuilder = Response.ok((Object)actionResponse);
            responseBuilder.cacheControl(new);
            return responseBuilder.build();
        }
        String string = (String)this.ifsuper("passwordChangeSalt");
        if (string == null) {
            string = this.\u00f6O0000();
            this.\u00f5O0000("passwordChangeSalt", string);
        }
        Response.ResponseBuilder responseBuilder = Response.ok((Object)new SaltResponse(null, string, null));
        responseBuilder.cacheControl(new);
        return responseBuilder.build();
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updatePassword(Password password) {
        String string;
        if (!this.null()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ActionResponse actionResponse = new ActionResponse();
        UserAuthenticationInterface userAuthenticationInterface = this.\u00d2o0000();
        if (userAuthenticationInterface.isPasswordChangePossible()) {
            string = (String)this.ifsuper("passwordChangeSalt");
            if (string != null) {
                String string2 = password.getOldPasswordHash();
                String string3 = this.\u00d500000();
                UserAuthenticationInterface.AuthenticationCode authenticationCode = userAuthenticationInterface.validateCredentials(string3, string2, string);
                this.\u00f5O0000("passwordChangeSalt", null);
                if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.\u00d500000) {
                    String string4 = password.getNewPasswordHash();
                    boolean bl = userAuthenticationInterface.setUserPasswordHash(string3, string4);
                    if (bl) {
                        actionResponse.setStatuscode(200);
                        this.\u00d800000().log(140, string3);
                    } else {
                        actionResponse.setStatuscode(500);
                        actionResponse.setCause("Unknown Error changing password.");
                        this.\u00d800000().log(141, string3);
                    }
                } else if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.o00000) {
                    actionResponse.setStatuscode(403);
                    actionResponse.setCause("Wrong password");
                    this.\u00d800000().log(141, string3);
                } else if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.Object) {
                    actionResponse.setStatuscode(409);
                    actionResponse.setCause("Unknown User");
                    this.\u00d800000().log(141, string3);
                } else if (authenticationCode == UserAuthenticationInterface.AuthenticationCode.\u00d200000) {
                    actionResponse.setStatuscode(500);
                    actionResponse.setCause("Authentication Module is currently not available.");
                    this.\u00d800000().log(141, string3);
                }
            } else {
                actionResponse.setStatuscode(412);
                actionResponse.setCause("No Salt");
                actionResponse.setDetails("Please request a salt before attempting a password change.");
            }
        } else {
            actionResponse.setStatuscode(403);
            actionResponse.setCause("Not supported by Configuration");
            actionResponse.setDetails("Passwords are managed externally.");
        }
        string = Response.ok((Object)actionResponse);
        string.cacheControl(new);
        return string.build();
    }
}

