/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.XMLOperations;
import com.neptunelabs.fsiserver.service.B;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.DownloadPresetsResponse;
import com.neptunelabs.fsiserver.utils.service.Pref;
import com.neptunelabs.fsiserver.utils.service.PrefsResponse;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.w3c.dom.Document;

@Path(value="/prefs")
public class PrefsService
extends B
implements Serializable {
    private static final long serialVersionUID = 2464871671251148919L;
    private final Object \u00f800000 = new Object();

    @GET
    @Path(value="/{prefsname:\\w+}")
    @Produces(value={"application/json", "application/xml"})
    public Response getPrefs(@PathParam(value="prefsname") String string, @HeaderParam(value="Accept") String string2) {
        Response.ResponseBuilder responseBuilder;
        if (this.null()) {
            if (string.equalsIgnoreCase("system")) {
                PrefsResponse prefsResponse = this.handleSystemPrefsGetRequest();
                responseBuilder = prefsResponse.prefs.size() == 0 && string2.contains("application/json") ? Response.ok((Object)"{}") : Response.ok((Object)prefsResponse);
            } else {
                responseBuilder = string.equalsIgnoreCase("publishing") ? this.handleCustomPrefsRequest("publishing") : (string.equalsIgnoreCase("interface") ? this.handleCustomPrefsRequest("interface") : (string.equalsIgnoreCase("preview") ? this.handleCustomPrefsRequest("preview") : (string.equalsIgnoreCase("archivepresets") ? this.handleDownloadPresetsRequest("archivepresets.xml") : (string.equalsIgnoreCase("batchpresets") ? this.handleDownloadPresetsRequest("batchpresets.xml") : Response.status((Response.Status)Response.Status.NOT_FOUND)))));
            }
        } else if (string.equalsIgnoreCase("preview")) {
            responseBuilder = Response.status((Response.Status)Response.Status.TEMPORARY_REDIRECT);
            String string3 = this.\u00d500000.getRequestURL().toString();
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            String string4 = string3.replace("service/prefs/preview", "#preview");
            responseBuilder = responseBuilder.header("Location", (Object)string4);
        } else {
            responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        }
        responseBuilder.cacheControl(new);
        return responseBuilder.build();
    }

    @POST
    @Path(value="/{prefsname:\\w+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response savePrefsPerPost(@PathParam(value="prefsname") String string, @FormParam(value="data") String string2) {
        return this.setPrefs(string, string2);
    }

    @PUT
    @Path(value="/{prefsname:\\w+}")
    @Consumes(value={"application/json", "text/html"})
    @Produces(value={"application/json"})
    public Response setPrefs(@PathParam(value="prefsname") String string, String string2) {
        ActionResponse actionResponse;
        if (this.null()) {
            PermissionSet permissionSet = this.\u00d6O0000().getUserAuthenticationInterface().getPermissions((SourceConnectorReader)null, this.\u00f800000(false), true);
            if (!permissionSet.general.writePreferences.booleanValue()) {
                actionResponse = new ActionResponse();
                actionResponse.setStatuscode(403);
                actionResponse.setCause("Forbidden");
            } else if (string.equalsIgnoreCase("publishing")) {
                actionResponse = this.saveCustomPrefs("publishing", string2);
            } else if (string.equalsIgnoreCase("interface")) {
                actionResponse = this.saveCustomPrefs("interface", string2);
            } else if (string.equalsIgnoreCase("preview")) {
                actionResponse = this.saveCustomPrefs("preview", string2);
            } else {
                actionResponse = new ActionResponse();
                actionResponse.setStatuscode(403);
                actionResponse.setCause("Forbidden");
            }
        } else {
            actionResponse = new ActionResponse();
            actionResponse.setStatuscode(403);
            actionResponse.setCause("Not Authorized");
        }
        return this.returnsuper(actionResponse);
    }

    private java.nio.file.Path getCustomPrefsFile(String string) {
        String string2 = this.\u00d500000();
        java.nio.file.Path path = this.\u00d6O0000().getConfigHome();
        java.nio.file.Path path2 = path.resolve("userprefs");
        java.nio.file.Path path3 = path2.resolve(string2);
        String string3 = string.equals("preview") ? string + ".html" : string + ".json";
        return path3.resolve(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse saveCustomPrefs(String string, String string2) {
        boolean bl;
        ActionResponse actionResponse = new ActionResponse();
        java.nio.file.Path path = this.getCustomPrefsFile(string);
        Object object = this.\u00f800000;
        synchronized (object) {
            bl = FileOperations.writeTextFileContent(this.\u00d800000(), path, string2, FileOperations.\u00d200000);
        }
        if (bl) {
            actionResponse.setStatuscode(200);
        } else {
            actionResponse.setStatuscode(500);
            actionResponse.setCause("Could not save file");
        }
        return actionResponse;
    }

    private Response.ResponseBuilder handleDownloadPresetsRequest(String string) {
        Response.ResponseBuilder responseBuilder;
        java.nio.file.Path path = this.\u00d6O0000().getConfigHome();
        java.nio.file.Path path2 = path.resolve(string);
        if (Files.exists(path2, new LinkOption[0])) {
            try {
                Document document = FileOperations.getXMLFileContent(this.\u00d800000(), path2);
                String string2 = XMLOperations.elementNamesToLowerCase(this.\u00d800000(), document);
                DownloadPresetsResponse downloadPresetsResponse = XMLOperations.unmarshalJAXB(string2, DownloadPresetsResponse.class);
                responseBuilder = Response.ok();
                responseBuilder.entity((Object)downloadPresetsResponse);
            }
            catch (IOException iOException) {
                responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            }
        } else {
            responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND);
        }
        return responseBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response.ResponseBuilder handleCustomPrefsRequest(String string) {
        long l;
        String string2;
        java.nio.file.Path path = this.getCustomPrefsFile(string);
        Response.ResponseBuilder responseBuilder = Response.ok();
        Object object = this.\u00f800000;
        synchronized (object) {
            try {
                string2 = FileOperations.getTextFileContent(path, FileOperations.\u00d200000);
                l = FileOperations.getSafeLastModified(path);
            }
            catch (IOException iOException) {
                string2 = "{}";
                l = System.currentTimeMillis();
            }
        }
        responseBuilder = Response.ok();
        if (string.equals("preview")) {
            responseBuilder.type("text/html");
        } else {
            responseBuilder.type("application/json");
        }
        responseBuilder.lastModified(new Date(l));
        responseBuilder.entity((Object)string2);
        return responseBuilder;
    }

    private PrefsResponse handleSystemPrefsGetRequest() {
        PrefsResponse prefsResponse = new PrefsResponse();
        java.nio.file.Path path = this.\u00d6O0000().getConfigHome();
        Map<String, String> map = this.\u00f6o0000(path);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            prefsResponse.prefs.add(new Pref(entry.getKey(), entry.getValue()));
        }
        prefsResponse.prefs.add(new Pref("batch-processing", String.valueOf(this.\u00d6O0000().getLicence().isBatchProcessingEnabled())));
        prefsResponse.prefs.add(new Pref("search-enabled", String.valueOf(this.\u00d600000() != null)));
        prefsResponse.prefs.add(new Pref("password-change-enabled", String.valueOf(this.\u00d6O0000().getUserAuthenticationInterface().isPasswordChangePossible())));
        return prefsResponse;
    }
}

