/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.utils.SPXParserUtils;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import java.nio.ByteOrder;

public class SPXMetaDataParser {
    public static ImageMetaData getFromSPXBytes(byte[] byArray, ByteOrder byteOrder) {
        ImageMetaData imageMetaData = new ImageMetaData();
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, byteOrder);
        block17: while (byteArrayWalker.remaining() > 0) {
            short s = byteArrayWalker.getShort();
            int n = byteArrayWalker.getInt();
            switch (s) {
                case 2: {
                    imageMetaData.setImportStatus((byte)byteArrayWalker.getShort());
                    break;
                }
                case 11: {
                    imageMetaData.setWidth(byteArrayWalker.getInt());
                    break;
                }
                case 12: {
                    imageMetaData.setHeight(byteArrayWalker.getInt());
                    break;
                }
                case 14: {
                    String string = SPXParserUtils.getTagContentAsString(byteArrayWalker, n);
                    imageMetaData.setImportModuleName(string);
                    break;
                }
                case 15: {
                    String string = SPXParserUtils.getTagContentAsString(byteArrayWalker, n);
                    imageMetaData.setImportModuleVersion(string);
                    break;
                }
                case 16: {
                    imageMetaData.setLastModified(byteArrayWalker.getLong());
                    break;
                }
                case 17: {
                    imageMetaData.setSourceFileSize(byteArrayWalker.getLong());
                    break;
                }
                case 18: {
                    imageMetaData.setImportTime(byteArrayWalker.getLong());
                    break;
                }
                case 200: {
                    byte[] byArray2 = SPXParserUtils.getTagContentAsByteArray(byteArrayWalker, n);
                    imageMetaData.setKeyHook(byArray2);
                    break;
                }
                case 210: {
                    String string = SPXParserUtils.getTagContentAsString(byteArrayWalker, n);
                    ICCProfileWrap iCCProfileWrap = new ICCProfileWrap(null);
                    iCCProfileWrap.overwriteName(string);
                    imageMetaData.setICC(iCCProfileWrap);
                    break;
                }
                case 23: {
                    imageMetaData.setImageReaderVersion(byteArrayWalker.getInt());
                    break;
                }
                case 501: {
                    int n2 = n / 16;
                    Level[] levelArray = new Level[n2];
                    for (int i = 0; i < n2; ++i) {
                        Level level = new Level(i);
                        level.Object = byteArrayWalker.getInt();
                        level.\u00d200000 = byteArrayWalker.getInt();
                        level.\u00d400000 = byteArrayWalker.getInt();
                        level.o00000 = byteArrayWalker.getInt();
                        levelArray[i] = level;
                    }
                    imageMetaData.setZoomLevels(levelArray);
                    break;
                }
                case 509: {
                    byte[] byArray3 = SPXParserUtils.getTagContentAsByteArray(byteArrayWalker, n);
                    imageMetaData.setAlphaTypes(byArray3);
                    for (byte by : byArray3) {
                        if (by != 1) continue;
                        imageMetaData.setHasAlpha(true);
                    }
                    continue block17;
                }
                case 508: {
                    imageMetaData.setExtraAlphaCount(byteArrayWalker.getInt());
                    break;
                }
                case 503: {
                    byte by = byteArrayWalker.get();
                    if (by == 4 || by == 2) {
                        imageMetaData.setHasAlpha(true);
                    }
                    imageMetaData.setTileFormat(by);
                    break;
                }
                default: {
                    byteArrayWalker.position(byteArrayWalker.position() + n);
                }
            }
        }
        return imageMetaData;
    }
}

