/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.converter;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.fsiserver.imagereader.converter.ColorConverterCache;
import com.neptunelabs.fsiserver.imagereader.converter.ColorLookUpTableCache;
import com.neptunelabs.fsiserver.imagereader.converter.ColorType;
import com.neptunelabs.fsiserver.imagereader.converter.F;
import com.neptunelabs.fsiserver.imagereader.converter.FastMath;
import com.neptunelabs.fsiserver.imagereader.converter.G;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.converter.ProfileDirection;
import com.neptunelabs.fsiserver.imagereader.converter.RgbProfileConverter;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import java.awt.color.CMMException;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public final class BufferedImageConverterThreaded
extends BufferedImageConverter {
    private final int \u00d800000 = 262144;
    private final F \u00d600000;
    private final ColorConverterCache String;
    private static final float[] \u00d500000 = new float[]{0.299f, 0.587f, 0.114f, -0.16874f, -0.33126f, 0.5f, 0.5f, -0.41869f, -0.08131f};

    public BufferedImageConverterThreaded(FSILogger fSILogger, ColorConverterCache colorConverterCache) {
        super(fSILogger);
        this.String = colorConverterCache;
        ICCProfileWrap iCCProfileWrap = colorConverterCache.getSRGBProfile();
        this.\u00d600000 = new RgbProfileConverter(this.\u00d200000, iCCProfileWrap, ProfileDirection.o00000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean convert(int n, BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n2, int n3) throws FSIImageException, InterruptedException {
        boolean bl;
        int n4;
        int n5;
        if (bufferedImageWrap.hasAlpha() && bufferedImageWrap.isAlphaPremultiplied()) {
            this.removePremultiplication(bufferedImageWrap);
        }
        boolean bl2 = false;
        if (bufferedImageWrap.\u00d4o0000 != null && bufferedImageWrap.\u00f6o0000) {
            bl2 = true;
        }
        int n6 = 0;
        if (bufferedImageWrap.\u00d400000 == ColorType.new || bufferedImageWrap.\u00d400000 == ColorType.\u00d800000 || bufferedImageWrap.\u00d400000 == ColorType.return) {
            n6 = 3;
        } else if (bufferedImageWrap.\u00d400000 == ColorType.o00000) {
            n6 = 3;
        } else if (bufferedImageWrap.\u00d400000 == ColorType.if || bufferedImageWrap.\u00d400000 == ColorType.\u00d400000) {
            n6 = 1;
        }
        G g = this.String.getColorCache(bufferedImageWrap.\u00d5O0000);
        if (g == null && bufferedImageWrap.\u00d5O0000 != null) {
            g = this.String.registerProfile(bufferedImageWrap.\u00d5O0000, n6);
        } else if (g == null) {
            g = this.String.getEmptyColorCache(n6);
        }
        DataBuffer dataBuffer = bufferedImageWrap.interfacesuper.getDataBuffer();
        int n7 = dataBuffer.getSize();
        if (n == 1 || bufferedImageWrap.\u00d2\u00d20000 == 12 || bufferedImageWrap.\u00d2\u00d20000 == 13) {
            n5 = 1;
        } else {
            n5 = n;
            if (n5 > 1) {
                n4 = (int)Math.ceil((float)n7 / 262144.0f);
                if (n5 > n4) {
                    n5 = n4;
                }
                if (n5 > bufferedImageWrap.Object) {
                    n5 = bufferedImageWrap.Object;
                }
            }
            if (n > n5) {
                n5 = n;
            }
        }
        if (n5 <= 0) {
            n5 = 1;
        }
        n4 = bufferedImageWrap.O\u00d20000.getRaster().getNumDataElements();
        if (this.\u00d300000) {
            System.out.println("Convert");
            System.out.println("Threads:" + n5);
            System.out.println("ColorType:" + (Object)((Object)bufferedImageWrap.\u00d400000));
            System.out.println("Type:" + bufferedImageWrap.\u00d2\u00d20000);
            System.out.println("Bands:" + bufferedImageWrap.\u00d2O0000);
            System.out.println("dblen:" + n7);
            System.out.println("dbtype:" + dataBuffer.getDataType());
            System.out.println("dbbanks:" + dataBuffer.getNumBanks());
            System.out.println("DB ElementsPerPixel:" + n4);
            System.out.println("Raster:" + bufferedImageWrap.O\u00d20000.getRaster());
            System.out.println("BIW\n" + bufferedImageWrap.toString());
            System.out.println("ICC:" + bufferedImageWrap.\u00d5O0000);
            System.out.println("colorComponents:" + bufferedImageWrap.Oo0000);
            System.out.println("totalComponents:" + bufferedImageWrap.\u00d6O0000);
            System.out.println("conversionRequired:" + bufferedImageWrap.\u00f6o0000);
            System.out.println("-----------------");
        }
        int n8 = 0;
        if (n5 > 1) {
            ExecutorService executorService = ExecutorPool.createExecutorService("BIC", n5, 1);
            ArrayList<CompletableFuture<Boolean>> arrayList = new ArrayList<CompletableFuture<Boolean>>();
            try {
                for (int i = 0; i < n5; ++i) {
                    int n9 = n8;
                    n8 = i + 1 == n5 ? bufferedImageWrap.Object : (int)((float)(i + 1) * ((float)bufferedImageWrap.Object / (float)n5));
                    if (n8 > fSIImage.getHeight()) {
                        n8 = fSIImage.getHeight();
                    }
                    int n10 = bufferedImageWrap.o00000 * n9 * n4;
                    int n11 = bufferedImageWrap.o00000 * n8 * n4;
                    _Oo _Oo2 = new _Oo(bufferedImageWrap, fSIImage, g, dataBuffer, n10, n11, n2, n3 + n9, bl2);
                    arrayList.add(CompletableFuture.supplyAsync(_Oo2, executorService));
                }
            }
            finally {
                bl = ExecutorPool.shutdownAndWait(executorService, arrayList, 60);
                if (bl) {
                    for (CompletableFuture completableFuture : arrayList) {
                        try {
                            bl &= ((Boolean)completableFuture.get()).booleanValue();
                        }
                        catch (CancellationException | ExecutionException exception) {
                            bl = false;
                            Throwable throwable = exception.getCause();
                            if (!(throwable instanceof FSIImageException)) break;
                            throw (FSIImageException)throwable;
                        }
                    }
                }
            }
        }
        boolean bl3 = false;
        _Oo _Oo3 = new _Oo(bufferedImageWrap, fSIImage, g, dataBuffer, 0, n7, n2, n3, bl2);
        try {
            bl = _Oo3.o00000();
        }
        catch (Exception exception) {
            bl = false;
            if (exception instanceof FSIImageException) {
                throw (FSIImageException)exception;
            }
            this.o00000.logException(exception, 3800, exception.getLocalizedMessage());
        }
        return bl;
    }

    private void removePremultiplication(BufferedImageWrap bufferedImageWrap) {
        block21: {
            int n;
            DataBuffer dataBuffer;
            block24: {
                int n2;
                int n3;
                block26: {
                    block25: {
                        block23: {
                            block19: {
                                int n4;
                                DataBuffer dataBuffer2;
                                int n5;
                                int n6;
                                block22: {
                                    block20: {
                                        if (this.\u00d300000) {
                                            System.out.println("removePremultiplication");
                                        }
                                        n3 = bufferedImageWrap.\u00d6O0000;
                                        n2 = bufferedImageWrap.Oo0000;
                                        n6 = bufferedImageWrap.\u00f500000;
                                        n5 = bufferedImageWrap.getAlphaBand();
                                        if (n5 == -1) break block19;
                                        WritableRaster writableRaster = bufferedImageWrap.O\u00d20000.getRaster();
                                        dataBuffer2 = writableRaster.getDataBuffer();
                                        n4 = dataBuffer2.getSize();
                                        if (dataBuffer2.getDataType() != 0) break block20;
                                        for (int i = 0; i < n4; i += n3) {
                                            int n7 = dataBuffer2.getElem(0, i + n5);
                                            if (n7 == 0 || n7 == 255) continue;
                                            float f = (float)n7 / 255.0f;
                                            for (int j = 0; j < n6; ++j) {
                                                int n8 = dataBuffer2.getElem(0, i + j);
                                                dataBuffer2.setElem(0, i + j, (int)((float)n8 / f));
                                            }
                                        }
                                        break block21;
                                    }
                                    if (dataBuffer2.getDataType() != 1) break block22;
                                    for (int i = 0; i < n4; i += n3) {
                                        int n9 = dataBuffer2.getElem(0, i + n5);
                                        if (n9 == 0 || n9 == 65535) continue;
                                        float f = (float)n9 / 65535.0f;
                                        for (int j = 0; j < n6; ++j) {
                                            int n10 = dataBuffer2.getElem(0, i + j);
                                            dataBuffer2.setElem(0, i + j, (int)((float)n10 / f));
                                        }
                                    }
                                    break block21;
                                }
                                if (dataBuffer2.getDataType() != 4) break block21;
                                for (int i = 0; i < n4; i += n3) {
                                    float f = dataBuffer2.getElemFloat(0, i + n5);
                                    if (f == 0.0f || f == 255.0f) continue;
                                    for (int j = 0; j < n6; ++j) {
                                        float f2 = dataBuffer2.getElemFloat(0, i + j);
                                        dataBuffer2.setElemFloat(0, i + j, f2 / f);
                                    }
                                }
                                break block21;
                            }
                            if (n3 == n2) break block21;
                            WritableRaster writableRaster = bufferedImageWrap.O\u00d20000.getRaster();
                            dataBuffer = writableRaster.getDataBuffer();
                            n = dataBuffer.getSize();
                            if (bufferedImageWrap.\u00d2\u00d20000 != 1 && bufferedImageWrap.\u00d2\u00d20000 != 4 && bufferedImageWrap.\u00d2\u00d20000 != 2 && bufferedImageWrap.\u00d2\u00d20000 != 3) break block23;
                            for (int i = 0; i < n; ++i) {
                                int n11 = dataBuffer.getElem(0, i);
                                int n12 = n11 >> 24 & 0xFF;
                                int n13 = n11 >> 16 & 0xFF;
                                int n14 = n11 >> 8 & 0xFF;
                                int n15 = n11 & 0xFF;
                                if (n12 == 0 || n12 == 255) continue;
                                float f = 255.0f / (float)n12;
                                n13 = (int)((float)n13 * f);
                                n14 = (int)((float)n14 * f);
                                n15 = (int)((float)n15 * f);
                                if (n13 > 255) {
                                    n13 = 255;
                                }
                                if (n14 > 255) {
                                    n14 = 255;
                                }
                                if (n15 > 255) {
                                    n15 = 255;
                                }
                                int n16 = n12 << 24 | n13 << 16 | n14 << 8 | n15;
                                dataBuffer.setElem(0, i, n16);
                            }
                            break block21;
                        }
                        if (bufferedImageWrap.\u00d2\u00d20000 != 0) break block24;
                        if (dataBuffer.getDataType() != 0) break block25;
                        for (int i = 0; i < n; i += n3) {
                            int n17 = dataBuffer.getElem(0, i + n2);
                            if (n17 == 0 || n17 == 255) continue;
                            float f = (float)n17 / 255.0f;
                            for (int j = 0; j < n2; ++j) {
                                int n18 = dataBuffer.getElem(0, i + j);
                                dataBuffer.setElem(0, i + j, (int)((float)n18 / f));
                            }
                        }
                        break block21;
                    }
                    if (dataBuffer.getDataType() != 1) break block26;
                    for (int i = 0; i < n; i += n3) {
                        int n19 = dataBuffer.getElem(0, i + n2);
                        if (n19 == 0 || n19 == 65535) continue;
                        float f = (float)n19 / 65535.0f;
                        for (int j = 0; j < n2; ++j) {
                            int n20 = dataBuffer.getElem(0, i + j);
                            dataBuffer.setElem(0, i + j, (int)((float)n20 / f));
                        }
                    }
                    break block21;
                }
                if (dataBuffer.getDataType() != 4) break block21;
                for (int i = 0; i < n; i += n3) {
                    float f = dataBuffer.getElemFloat(0, i + n2);
                    if (f == 0.0f || f == 255.0f) continue;
                    for (int j = 0; j < n2; ++j) {
                        float f3 = dataBuffer.getElemFloat(0, i + j);
                        dataBuffer.setElemFloat(0, i + j, f3 / f);
                    }
                }
                break block21;
            }
            if (bufferedImageWrap.\u00d2\u00d20000 == 6 || bufferedImageWrap.\u00d2\u00d20000 == 7) {
                for (int i = 0; i < n; i += 4) {
                    int n21 = dataBuffer.getElem(0, i);
                    if (n21 == 0 || n21 == 255) continue;
                    int n22 = dataBuffer.getElem(0, i + 1);
                    int n23 = dataBuffer.getElem(0, i + 2);
                    int n24 = dataBuffer.getElem(0, i + 3);
                    float f = (float)n21 / 255.0f;
                    dataBuffer.setElem(0, i + 1, (int)((float)n22 / f));
                    dataBuffer.setElem(0, i + 2, (int)((float)n23 / f));
                    dataBuffer.setElem(0, i + 3, (int)((float)n24 / f));
                }
            }
        }
    }

    @Override
    public ColorLookUpTableCache getClutCache() {
        return this.\u00d200000;
    }

    @Override
    public void dispose() {
        this.\u00d200000.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertLinearRaw(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, DataBuffer dataBuffer, int n3, int n4, int n5, Histogram histogram, ColorType colorType) {
        if (this.\u00d300000) {
            System.out.println("convertLinearRaw");
        }
        int n6 = bufferedImageWrap.getAlphaBand();
        boolean bl = bufferedImageWrap.hasAlpha() && n6 != -1;
        F f = bufferedImageWrap.\u00d4o0000;
        F f2 = this.\u00d600000;
        int n7 = n;
        int n8 = n2;
        int n9 = n + bufferedImageWrap.o00000;
        if (bufferedImageWrap.\u00d2\u00d20000 == 1) {
            if (this.\u00d300000) {
                System.out.println("TYPE_INT_RGB");
            }
            for (int i = n3; i < n4; ++i) {
                int n10 = dataBuffer.getElem(0, i) & 0xFFFFFF;
                fSIImage.setSample(n7, n8, n10);
                if (histogram != null) {
                    histogram.pushRGB(n10);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 5) {
            if (this.\u00d300000) {
                System.out.println("TYPE_3BYTE_BGR");
            }
            for (int i = n3; i < n4; i += 3) {
                int n11 = dataBuffer.getElem(0, i + 2) << 16 | dataBuffer.getElem(0, i + 1) << 8 | dataBuffer.getElem(0, i);
                fSIImage.setSample(n7, n8, n11);
                if (histogram != null) {
                    histogram.pushRGB(n11);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 6) {
            if (this.\u00d300000) {
                System.out.println("TYPE_4BYTE_ABGR");
            }
            if (colorType != ColorType.\u00d300000) throw new FSIImageException("Unsupported image format");
            float[] fArray = new float[4];
            float[] fArray2 = new float[3];
            float[] fArray3 = new float[3];
            int n12 = -1;
            int n13 = 0;
            for (int i = n3; i < n4; i += 4) {
                int n14;
                int n15;
                int n16;
                int n17 = dataBuffer.getElem(0, i + 3);
                int n18 = n17 << 24 | (n16 = dataBuffer.getElem(0, i + 2)) << 16 | (n15 = dataBuffer.getElem(0, i + 1)) << 8 | (n14 = bufferedImageWrap.\u00d6o0000 ? 255 - dataBuffer.getElem(0, i) : dataBuffer.getElem(0, i));
                if (n18 != n12) {
                    fArray[0] = (float)n17 / 255.0f;
                    fArray[1] = (float)n16 / 255.0f;
                    fArray[2] = (float)n15 / 255.0f;
                    fArray[3] = (float)n14 / 255.0f;
                    f.toCIEXYZ(fArray, fArray2);
                    f2.fromCIEXYZ(fArray2, fArray3);
                    int n19 = BufferedImageConverterThreaded.floatArray1ToInt(fArray3);
                    fSIImage.setSample(n7, n8, n19);
                    if (histogram != null) {
                        histogram.pushRGB(n19);
                    }
                    n12 = n18;
                    n13 = n19;
                } else {
                    fSIImage.setSample(n7, n8, n13);
                    if (histogram != null) {
                        histogram.pushRGB(n13);
                    }
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 2 || bufferedImageWrap.\u00d2\u00d20000 == 3 || bufferedImageWrap.\u00d2\u00d20000 == 1) {
            if (this.\u00d300000) {
                System.out.println("TYPE_INT_ARGB");
            }
            if (colorType == ColorType.\u00d300000) {
                if (this.\u00d300000) {
                    System.out.println(" ColorType.CMYK");
                }
                float[] fArray = new float[4];
                float[] fArray4 = new float[3];
                float[] fArray5 = new float[3];
                int n20 = -1;
                int n21 = 0;
                for (int i = n3; i < n4; ++i) {
                    int n22;
                    int n23 = dataBuffer.getElem(0, i);
                    int n24 = n23 >> 1 & 0xFF;
                    int n25 = n23 >> 8 & 0xFF;
                    int n26 = n23 & 0xFF;
                    int n27 = n23 >> 24 & 0xFF;
                    if (bufferedImageWrap.\u00d6o0000) {
                        n27 = 255 - n27;
                    }
                    if ((n22 = n23) != n20) {
                        fArray[0] = (float)n24 / 255.0f;
                        fArray[1] = (float)n25 / 255.0f;
                        fArray[2] = (float)n26 / 255.0f;
                        fArray[3] = (float)n27 / 255.0f;
                        f.toCIEXYZ(fArray, fArray4);
                        f2.fromCIEXYZ(fArray4, fArray5);
                        int n28 = BufferedImageConverterThreaded.floatArray1ToInt(fArray5);
                        fSIImage.setSample(n7, n8, n28);
                        if (histogram != null) {
                            histogram.pushRGB(n28);
                        }
                        n20 = n22;
                        n21 = n28;
                    } else {
                        fSIImage.setSample(n7, n8, n21);
                        if (histogram != null) {
                            histogram.pushRGB(n21);
                        }
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else if (bl) {
                for (int i = n3; i < n4; ++i) {
                    int n29 = dataBuffer.getElem(0, i);
                    fSIImage.setSample(n7, n8, n29);
                    if (histogram != null) {
                        histogram.pushARGB(n29);
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else {
                for (int i = n3; i < n4; ++i) {
                    int n30 = dataBuffer.getElem(0, i) & 0xFFFFFF;
                    fSIImage.setSample(n7, n8, n30);
                    if (histogram != null) {
                        histogram.pushRGB(n30);
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 4) {
            if (this.\u00d300000) {
                System.out.println("TYPE_INT_BGR");
            }
            for (int i = n3; i < n4; ++i) {
                int n31 = dataBuffer.getElem(0, i) & 0xFFFFFF;
                int n32 = n31 >> 16 | n31 & 0xFF00 | n31 << 16 & 0xFF0000;
                fSIImage.setSample(n7, n8, n32);
                if (histogram != null) {
                    histogram.pushRGB(n32);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 0) {
            if (this.\u00d300000) {
                System.out.println("TYPE_CUSTOM:" + (Object)((Object)colorType));
            }
            if (colorType == ColorType.\u00d300000) {
                if (this.\u00d300000) {
                    System.out.println("ColorType.CMYK");
                }
                float[] fArray = new float[4];
                float[] fArray6 = new float[3];
                float[] fArray7 = new float[3];
                int n33 = -1;
                int n34 = 0;
                int n35 = 255;
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n36;
                    int n37 = dataBuffer.getElem(0, i);
                    int n38 = dataBuffer.getElem(0, i + 1);
                    int n39 = dataBuffer.getElem(0, i + 2);
                    int n40 = bufferedImageWrap.\u00d6o0000 ? 255 - dataBuffer.getElem(0, i + 3) : dataBuffer.getElem(0, i + 3);
                    n35 = bl ? dataBuffer.getElem(0, i + n6) : 255;
                    int n41 = n37 << 24 | n38 << 16 | n39 << 8 | n40;
                    if (n41 != n33) {
                        fArray[0] = (float)n37 / 255.0f;
                        fArray[1] = (float)n38 / 255.0f;
                        fArray[2] = (float)n39 / 255.0f;
                        fArray[3] = (float)n40 / 255.0f;
                        f.toCIEXYZ(fArray, fArray6);
                        f2.fromCIEXYZ(fArray6, fArray7);
                        n36 = BufferedImageConverterThreaded.floatArray1ToInt(fArray7);
                        n33 = n41;
                        n34 = n36;
                    } else {
                        n36 = n34;
                    }
                    int n42 = n35 << 24 | n36;
                    fSIImage.setSample(n7, n8, n42);
                    if (histogram != null) {
                        histogram.pushRGB(n42);
                    }
                    int n43 = bufferedImageWrap.\u00f500000;
                    int n44 = 0;
                    while (n43 < bufferedImageWrap.oo0000) {
                        n35 = dataBuffer.getElem(0, i + n43);
                        fSIImage.setSampleExtraAlpha(n44, n7, n8, (byte)n35);
                        ++n43;
                        ++n44;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else {
                if (colorType != ColorType.new || bufferedImageWrap.\u00d6O0000 != 4) throw new FSIImageException("Unsupported image format");
                for (int i = n3; i < n4; i += 4) {
                    int n45 = dataBuffer.getElem(0, i + 3) << 24 | dataBuffer.getElem(0, i) << 16 | dataBuffer.getElem(0, i + 1) << 8 | dataBuffer.getElem(0, i + 2);
                    fSIImage.setSample(n7, n8, n45);
                    if (histogram != null) {
                        histogram.pushARGB(n45);
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 12) {
            if (n5 != 0 || bufferedImageWrap.\u00d2O0000 != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(bufferedImageWrap, fSIImage, n, n2, dataBuffer, n3, n4, histogram, colorType);
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 8) {
            if (n5 != 1 || bufferedImageWrap.\u00d2O0000 != 3) throw new FSIImageException("Unsupported image format");
            for (int i = n3; i < n4; ++i) {
                int n46 = dataBuffer.getElem(0, i);
                int n47 = (((n46 & 0xF800) >> 11) + 1) * 8 - 1;
                int n48 = (((n46 & 0x7E0) >> 5) + 1) * 4 - 1;
                int n49 = ((n46 & 0x1F) + 1) * 8 - 1;
                int n50 = n47 << 16 | n48 << 8 | n49;
                fSIImage.setSample(n7, n8, n50);
                if (histogram != null) {
                    histogram.pushRGB(n50);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 9) {
            if (n5 != 1 || bufferedImageWrap.\u00d2O0000 != 3) throw new FSIImageException("Unsupported image format");
            for (int i = n3; i < n4; ++i) {
                int n51 = dataBuffer.getElem(0, i);
                int n52 = (((n51 & 0x7C00) >> 10) + 1) * 8 - 1;
                int n53 = (((n51 & 0x7E0) >> 5) + 1) * 8 - 1;
                int n54 = ((n51 & 0x1F) + 1) * 8 - 1;
                int n55 = n52 << 16 | n53 << 8 | n54;
                fSIImage.setSample(n7, n8, n55);
                if (histogram != null) {
                    histogram.pushRGB(n55);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 10) {
            for (int i = n3; i < n4; ++i) {
                int n56 = dataBuffer.getElem(0, i);
                int n57 = n56 << 16 | n56 << 8 | n56;
                fSIImage.setSample(n7, n8, n57);
                if (histogram != null) {
                    histogram.pushRGB(n57);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2O0000 == 3) {
            for (int i = n3; i < n4; i += 3) {
                int n58 = dataBuffer.getElem(0, i) << 16 | dataBuffer.getElem(0, i + 1) << 8 | dataBuffer.getElem(0, i + 2);
                fSIImage.setSample(n7, n8, n58);
                if (histogram != null) {
                    histogram.pushRGB(n58);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else {
            if (bufferedImageWrap.\u00d2O0000 != 1) throw new FSIImageException("Unsupported image format");
            for (int i = n3; i < dataBuffer.getSize(); ++i) {
                int n59 = dataBuffer.getElem(0, i) & 0xFF;
                fSIImage.setSample(n7, n8, n59);
                if (histogram != null) {
                    histogram.pushRGB(n59);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
        }
    }

    private void convertLinearIndexed(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, DataBuffer dataBuffer, int n3, int n4, Histogram histogram, ColorType colorType) {
        if (bufferedImageWrap.\u00d2\u00d20000 == 12 || bufferedImageWrap.\u00d2\u00d20000 == 13 || bufferedImageWrap.\u00d2\u00d20000 == 10) {
            if (bufferedImageWrap.\u00d2O0000 != 1) {
                throw new FSIImageException("Unsupported image format");
            }
        } else {
            throw new FSIImageException("Unsupported image format");
        }
        this.convertByteBinary(bufferedImageWrap, fSIImage, n, n2, dataBuffer, n3, n4, histogram, colorType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertLinearRGB(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, DataBuffer dataBuffer, int n3, int n4, int n5, Histogram histogram, ColorType colorType) {
        int n6 = bufferedImageWrap.getAlphaBand();
        boolean bl = bufferedImageWrap.hasAlpha() && n6 != -1;
        int n7 = n;
        int n8 = n2;
        int n9 = n + bufferedImageWrap.o00000;
        if (bufferedImageWrap.\u00d2\u00d20000 == 1) {
            int[] nArray = ((DataBufferInt)dataBuffer).getData(0);
            for (int i = n3; i < n4; ++i) {
                int n10 = nArray[i];
                fSIImage.setSample(n7, n8, n10);
                if (histogram != null) {
                    histogram.pushRGB(n10);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 2) {
            int[] nArray = ((DataBufferInt)dataBuffer).getData(0);
            for (int i = n3; i < n4; ++i) {
                int n11 = nArray[i];
                fSIImage.setSample(n7, n8, n11);
                if (histogram != null) {
                    histogram.pushARGB(n11);
                }
                int n12 = bufferedImageWrap.\u00f500000;
                int n13 = 0;
                while (n12 < bufferedImageWrap.oo0000) {
                    int n14 = dataBuffer.getElem(0, i + n12 - 3);
                    fSIImage.setSampleExtraAlpha(n13, n7, n8, (byte)n14);
                    ++n12;
                    ++n13;
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 5) {
            for (int i = n3; i < n4; i += 3) {
                int n15 = dataBuffer.getElem(0, i);
                int n16 = dataBuffer.getElem(0, i + 1);
                int n17 = dataBuffer.getElem(0, i + 2);
                int n18 = n17 << 16 | n16 << 8 | n15;
                fSIImage.setSample(n7, n8, n18);
                if (histogram != null) {
                    histogram.pushRGB(n17, n16, n15);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 6) {
            if (n5 != 0 || dataBuffer.getNumBanks() != 1) throw new FSIImageException("Unsupported image format");
            int n19 = 255;
            byte[] byArray = ((DataBufferByte)dataBuffer).getData(0);
            for (int i = n3; i < n4; i += 4) {
                n19 = byArray[i] & 0xFF;
                int n20 = byArray[i + 1] & 0xFF;
                int n21 = byArray[i + 2] & 0xFF;
                int n22 = byArray[i + 3] & 0xFF;
                int n23 = n19 << 24 | n22 << 16 | n21 << 8 | n20;
                fSIImage.setSample(n7, n8, n23);
                fSIImage.setSampleExtraAlpha(0, n7, n8, (byte)n19);
                if (histogram != null) {
                    histogram.pushARGB(n23);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 0) {
            if (this.\u00d300000) {
                System.out.println("TYPE_CUSTOM");
            }
            if (n5 == 0) {
                if (this.\u00d300000) {
                    System.out.println("TYPE_BYTE:" + bufferedImageWrap.\u00d6O0000);
                }
                int n24 = 255;
                byte[] byArray = ((DataBufferByte)dataBuffer).getData(0);
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n25 = byArray[i + 0] & 0xFF;
                    int n26 = byArray[i + 1] & 0xFF;
                    int n27 = byArray[i + 2] & 0xFF;
                    n24 = bl ? byArray[i + n6] & 0xFF : 255;
                    int n28 = n24 << 24 | n25 << 16 | n26 << 8 | n27;
                    fSIImage.setSample(n7, n8, n28);
                    if (histogram != null) {
                        histogram.pushARGB(n28);
                    }
                    int n29 = bufferedImageWrap.\u00f500000;
                    int n30 = 0;
                    while (n29 < bufferedImageWrap.oo0000) {
                        n24 = byArray[i + n29] & 0xFF;
                        fSIImage.setSampleExtraAlpha(n30, n7, n8, (byte)n24);
                        ++n29;
                        ++n30;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else if (n5 == 1) {
                int n31 = 255;
                short[] sArray = ((DataBufferUShort)dataBuffer).getData(0);
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n32 = BufferedImageConverterThreaded.sample16to8(sArray[i] & 0xFFFF);
                    int n33 = BufferedImageConverterThreaded.sample16to8(sArray[i + 1] & 0xFFFF);
                    int n34 = BufferedImageConverterThreaded.sample16to8(sArray[i + 2] & 0xFFFF);
                    n31 = bl ? BufferedImageConverterThreaded.sample16to8(sArray[i + n6] & 0xFFFF) : 255;
                    int n35 = n31 << 24 | n32 << 16 | n33 << 8 | n34;
                    fSIImage.setSample(n7, n8, n35);
                    if (histogram != null) {
                        histogram.pushARGB(n35);
                    }
                    int n36 = bufferedImageWrap.\u00f500000;
                    int n37 = 0;
                    while (n36 < bufferedImageWrap.oo0000) {
                        n31 = BufferedImageConverterThreaded.sample16to8(sArray[i + n36] & 0xFFFF);
                        fSIImage.setSampleExtraAlpha(n37, n7, n8, (byte)n31);
                        ++n36;
                        ++n37;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else {
                if (n5 != 4) throw new FSIImageException("Unsupported image format");
                int n38 = 255;
                float[] fArray = ((DataBufferFloat)dataBuffer).getData(0);
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n39 = (int)(fArray[i] * 255.0f + 0.5f);
                    int n40 = (int)(fArray[i + 1] * 255.0f + 0.5f);
                    int n41 = (int)(fArray[i + 2] * 255.0f + 0.5f);
                    if (bl) {
                        float f = fArray[i + n6];
                        n38 = (int)(f * 255.0f + 0.5f);
                    } else {
                        n38 = 255;
                    }
                    int n42 = n38 << 24 | n39 << 16 | n40 << 8 | n41;
                    fSIImage.setSample(n7, n8, n42);
                    if (histogram != null) {
                        histogram.pushARGB(n42);
                    }
                    int n43 = bufferedImageWrap.\u00f500000;
                    int n44 = 0;
                    while (n43 < bufferedImageWrap.oo0000) {
                        n38 = (int)(fArray[i + n43] * 255.0f + 0.5f);
                        fSIImage.setSampleExtraAlpha(n44, n7, n8, (byte)n38);
                        ++n43;
                        ++n44;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
            }
            return;
        } else {
            if (bufferedImageWrap.\u00d2\u00d20000 != 12) throw new FSIImageException("Unsupported image format:" + bufferedImageWrap.\u00d2\u00d20000);
            if (n5 != 0 || bufferedImageWrap.\u00d2O0000 != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(bufferedImageWrap, fSIImage, n, n2, dataBuffer, n3, n4, histogram, colorType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertLinearGray(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, DataBuffer dataBuffer, int n3, int n4, int n5, Histogram histogram, ColorType colorType) {
        int n6 = bufferedImageWrap.getAlphaBand();
        boolean bl = bufferedImageWrap.hasAlpha() && n6 != -1;
        int n7 = n;
        int n8 = n2;
        int n9 = n + bufferedImageWrap.o00000;
        if (bufferedImageWrap.\u00d2\u00d20000 == 10) {
            for (int i = n3; i < n4; ++i) {
                int n10 = dataBuffer.getElem(0, i) & 0xFF;
                int n11 = n10 << 16 | n10 << 8 | n10;
                fSIImage.setSample(n11);
                if (histogram == null) continue;
                histogram.pushRGB(n11);
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 12) {
            if (n5 != 0 || bufferedImageWrap.\u00d2O0000 != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(bufferedImageWrap, fSIImage, n, n2, dataBuffer, n3, n4, histogram, colorType);
            return;
        } else {
            if (bufferedImageWrap.\u00d2\u00d20000 != 0 && bufferedImageWrap.\u00d2\u00d20000 != 11) throw new FSIImageException("Unsupported image format");
            if (n5 == 0) {
                int n12 = 255;
                byte[] byArray = ((DataBufferByte)dataBuffer).getData(0);
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n13 = byArray[i] & 0xFF;
                    n12 = bl ? byArray[i + n6] & 0xFF : 255;
                    int n14 = n12 << 24 | n13 << 16 | n13 << 8 | n13;
                    fSIImage.setSample(n7, n8, n14);
                    if (histogram != null) {
                        histogram.pushARGB(n14);
                    }
                    int n15 = bufferedImageWrap.\u00f500000;
                    int n16 = 0;
                    while (n15 < bufferedImageWrap.oo0000) {
                        n12 = byArray[i + n15] & 0xFF;
                        fSIImage.setSampleExtraAlpha(n16, n7, n8, (byte)n12);
                        ++n15;
                        ++n16;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else if (n5 == 1) {
                int n17 = 255;
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n18 = (dataBuffer.getElem(0, i) + 1) / 256 - 1;
                    int n19 = n18 = n18 < 0 ? 0 : n18;
                    n17 = bl ? ((n17 = (dataBuffer.getElem(0, i + n6) + 1) / 256 - 1) < 0 ? 0 : n17) : 255;
                    int n20 = n17 << 24 | n18 << 16 | n18 << 8 | n18;
                    fSIImage.setSample(n7, n8, n20);
                    if (histogram != null) {
                        histogram.pushARGB(n20);
                    }
                    int n21 = bufferedImageWrap.\u00f500000;
                    int n22 = 0;
                    while (n21 < bufferedImageWrap.oo0000) {
                        n17 = (dataBuffer.getElem(0, i + n21) + 1) / 256 - 1;
                        fSIImage.setSampleExtraAlpha(n22, n7, n8, (byte)n17);
                        ++n21;
                        ++n22;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else {
                if (n5 != 4) throw new FSIImageException("Unsupported image format");
                int n23 = 255;
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    float f = dataBuffer.getElemFloat(0, i);
                    int n24 = (int)(f * 255.0f + 0.5f);
                    n23 = bl ? (int)(dataBuffer.getElemFloat(0, i + n6) * 255.0f + 0.5f) : 255;
                    int n25 = n23 << 24 | n24 << 16 | n24 << 8 | n24;
                    fSIImage.setSample(n7, n8, n25);
                    if (histogram != null) {
                        histogram.pushARGB(n25);
                    }
                    int n26 = bufferedImageWrap.\u00f500000;
                    int n27 = 0;
                    while (n26 < bufferedImageWrap.oo0000) {
                        n23 = (int)(dataBuffer.getElemFloat(0, i + n26) * 255.0f + 0.5f);
                        fSIImage.setSampleExtraAlpha(n27, n7, n8, (byte)n23);
                        ++n26;
                        ++n27;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertICCRGB(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, G g, DataBuffer dataBuffer, int n3, int n4, int n5, Histogram histogram) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n6 = -16777216;
        int n7 = 255;
        int n8 = n;
        int n9 = n2;
        int n10 = n + bufferedImageWrap.o00000;
        int n11 = bufferedImageWrap.getAlphaBand();
        boolean bl = bufferedImageWrap.hasAlpha() && n11 != -1;
        F f = bufferedImageWrap.\u00d4o0000;
        F f2 = this.\u00d600000;
        int n12 = bufferedImageWrap.\u00d6O0000;
        if (bufferedImageWrap.\u00d2\u00d20000 == 2 || bufferedImageWrap.\u00d2\u00d20000 == 3 || bufferedImageWrap.\u00d2\u00d20000 == 1) {
            if (this.\u00d300000) {
                System.out.println("TYPE_INT_ARGB");
            }
            int[] nArray = ((DataBufferInt)dataBuffer).getData(0);
            for (int i = n3; i < n4; ++i) {
                int n13;
                int n14 = nArray[i];
                int n15 = n14 >> 16 & 0xFF;
                int n16 = n14 >> 8 & 0xFF;
                int n17 = n14 & 0xFF;
                if (bl) {
                    n6 = n14 & 0xFF000000;
                }
                if ((n13 = g.get(n15, n16, n17)) == -1) {
                    f.toCIEXYZ((float)n15 / 255.0f, (float)n16 / 255.0f, (float)n17 / 255.0f, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    n13 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                    g.put(n15, n16, n17, n13);
                }
                int n18 = bl ? n6 | n13 : n13;
                fSIImage.setSample(n8, n9, n18);
                if (histogram != null) {
                    if (bl) {
                        histogram.pushARGB(n6, n15, n16, n17);
                    } else {
                        histogram.pushRGB(n15, n16, n17);
                    }
                }
                if (++n8 != n10) continue;
                n8 = n;
                ++n9;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 4) {
            if (this.\u00d300000) {
                System.out.println("TYPE_INT_BGR");
            }
            int[] nArray = ((DataBufferInt)dataBuffer).getData(0);
            for (int i = n3; i < n4; ++i) {
                int n19 = nArray[i] & 0xFFFFFF;
                int n20 = n19 & 0xFF;
                int n21 = n19 >> 8 & 0xFF;
                int n22 = n19 >> 16 & 0xFF;
                int n23 = g.get(n20, n21, n22);
                if (n23 == -1) {
                    f.toCIEXYZ(n20, n21, n22, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    n23 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                    g.put(n20, n21, n22, n23);
                }
                fSIImage.setSample(n8, n9, n23);
                if (histogram != null) {
                    histogram.pushRGB(n23);
                }
                if (++n8 != n10) continue;
                n8 = n;
                ++n9;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 0) {
            if (this.\u00d300000) {
                System.out.println("TYPE_CUSTOM");
            }
            if (this.\u00d300000) {
                System.out.println(bufferedImageWrap.O\u00d20000);
            }
            if (this.\u00d300000) {
                System.out.println(bufferedImageWrap.O\u00d20000.getColorModel());
            }
            if (n5 == 3) {
                if (this.\u00d300000) {
                    System.out.println("TYPE_INT");
                }
                int[] nArray = ((DataBufferInt)dataBuffer).getData(0);
                for (int i = n3; i < n4; ++i) {
                    int n24;
                    int n25 = nArray[i];
                    int n26 = n25 >> 16 & 0xFF;
                    int n27 = n25 >> 8 & 0xFF;
                    int n28 = n25 & 0xFF;
                    if (bl) {
                        n6 = n25 & 0xFF000000;
                    }
                    if ((n24 = g.get(n26, n27, n28)) == -1) {
                        f.toCIEXYZ((float)n26 / 255.0f, (float)n27 / 255.0f, (float)n28 / 255.0f, fArray);
                        f2.fromCIEXYZ(fArray, fArray2);
                        n24 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                        g.put(n26, n27, n28, n24);
                    }
                    int n29 = bl ? n6 | n24 : n24;
                    fSIImage.setSample(n8, n9, n29);
                    if (histogram != null) {
                        if (bl) {
                            histogram.pushARGB(n29);
                        } else {
                            histogram.pushRGB(n29);
                        }
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
                return;
            } else if (n5 == 0) {
                if (this.\u00d300000) {
                    System.out.println("TYPE_BYTE");
                }
                byte[] byArray = ((DataBufferByte)dataBuffer).getData(0);
                for (int i = n3; i < n4; i += n12) {
                    int n30 = byArray[i] & 0xFF;
                    int n31 = byArray[i + 1] & 0xFF;
                    int n32 = byArray[i + 2] & 0xFF;
                    n7 = bl ? byArray[i + n11] & 0xFF : 255;
                    int n33 = g.get(n30, n31, n32);
                    if (n33 == -1) {
                        f.toCIEXYZ((float)n30 / 255.0f, (float)n31 / 255.0f, (float)n32 / 255.0f, fArray);
                        f2.fromCIEXYZ(fArray, fArray2);
                        n33 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                        g.put(n30, n31, n32, n33);
                    }
                    int n34 = n7 << 24 | n33;
                    fSIImage.setSample(n8, n9, n34);
                    if (histogram != null) {
                        histogram.pushARGB(n7, n30, n31, n32);
                    }
                    int n35 = bufferedImageWrap.\u00f500000;
                    int n36 = 0;
                    while (n35 < bufferedImageWrap.oo0000) {
                        n7 = byArray[i + n35] & 0xFF;
                        fSIImage.setSampleExtraAlpha(n36, n8, n9, (byte)n7);
                        ++n35;
                        ++n36;
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
                return;
            } else if (n5 == 1) {
                if (this.\u00d300000) {
                    System.out.println("TYPE_USHORT");
                }
                short[] sArray = ((DataBufferUShort)dataBuffer).getData(0);
                for (int i = n3; i < n4; i += n12) {
                    f.toCIEXYZ((float)(sArray[i] & 0xFFFF) / 65535.0f, (float)(sArray[i + 1] & 0xFFFF) / 65535.0f, (float)(sArray[i + 2] & 0xFFFF) / 65535.0f, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    n7 = bl ? BufferedImageConverterThreaded.sample16to8(sArray[i + n11] & 0xFFFF) : 255;
                    int n37 = n7 << 24 | BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                    fSIImage.setSample(n8, n9, n37);
                    if (histogram != null) {
                        histogram.pushARGB(n37);
                    }
                    int n38 = bufferedImageWrap.\u00f500000;
                    int n39 = 0;
                    while (n38 < bufferedImageWrap.oo0000) {
                        n7 = BufferedImageConverterThreaded.sample16to8(sArray[i + n38] & 0xFFFF);
                        fSIImage.setSampleExtraAlpha(n39, n8, n9, (byte)n7);
                        ++n38;
                        ++n39;
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
                return;
            } else {
                if (n5 != 4) throw new FSIImageException("Unsupported image format: " + bufferedImageWrap.\u00d2\u00d20000 + " " + n5);
                for (int i = n3; i < n4; i += n12) {
                    f.toCIEXYZ(dataBuffer.getElemFloat(0, i), dataBuffer.getElemFloat(0, i + 1), dataBuffer.getElemFloat(0, i + 2), fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    if (bl) {
                        float f3 = dataBuffer.getElemFloat(0, i + n11);
                        n7 = (int)(f3 * 255.0f + 0.5f);
                    } else {
                        n7 = 255;
                    }
                    int n40 = n7 << 24 | BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                    fSIImage.setSample(n8, n9, n40);
                    if (histogram != null) {
                        histogram.pushARGB(n40);
                    }
                    int n41 = bufferedImageWrap.\u00f500000;
                    int n42 = 0;
                    while (n41 < bufferedImageWrap.oo0000) {
                        n7 = (int)(dataBuffer.getElemFloat(0, i + n41) * 255.0f + 0.5f);
                        fSIImage.setSampleExtraAlpha(n42, n8, n9, (byte)n7);
                        ++n41;
                        ++n42;
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 1) {
            fArray = new float[3];
            fArray2 = new float[3];
            int[] nArray = ((DataBufferInt)dataBuffer).getData(0);
            for (int i = n3; i < n4; ++i) {
                int n43 = nArray[i];
                f.toCIEXYZ(n43 >> 16 & 0xFF, n43 >> 8 & 0xFF, n43 & 0xFF, fArray);
                f2.fromCIEXYZ(fArray, fArray2);
                int n44 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                fSIImage.setSample(n8, n9, n44);
                if (histogram != null) {
                    histogram.pushRGB(n44);
                }
                if (++n8 != n10) continue;
                n8 = n;
                ++n9;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 5) {
            for (int i = n3; i < n4; i += 3) {
                int n45 = dataBuffer.getElem(0, i);
                int n46 = dataBuffer.getElem(0, i + 1);
                int n47 = dataBuffer.getElem(0, i + 2);
                int n48 = g.get(n47, n46, n45);
                if (n48 == -1) {
                    f.toCIEXYZ((float)n47 / 255.0f, (float)n46 / 255.0f, (float)n45 / 255.0f, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    n48 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                    g.put(n47, n46, n45, n48);
                }
                fSIImage.setSample(n8, n9, n48);
                if (histogram != null) {
                    histogram.pushRGB(n48);
                }
                if (++n8 != n10) continue;
                n8 = n;
                ++n9;
            }
            return;
        } else {
            if (bufferedImageWrap.\u00d2\u00d20000 != 6) throw new FSIImageException("Unsupported image format");
            for (int i = n3; i < n4; i += 4) {
                n6 = dataBuffer.getElem(0, i);
                int n49 = dataBuffer.getElem(0, i + 1);
                int n50 = dataBuffer.getElem(0, i + 2);
                int n51 = dataBuffer.getElem(0, i + 3);
                int n52 = g.get(n51, n50, n49);
                if (n52 == -1) {
                    f.toCIEXYZ((float)n51 / 255.0f, (float)n50 / 255.0f, (float)n49 / 255.0f, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    n52 = BufferedImageConverterThreaded.floatArray1ToInt(fArray2);
                    g.put(n51, n50, n49, n52);
                }
                int n53 = n6 << 24 | n52;
                fSIImage.setSample(n8, n9, n53);
                int n54 = bufferedImageWrap.\u00f500000;
                int n55 = 0;
                while (n54 < bufferedImageWrap.oo0000) {
                    fSIImage.setSampleExtraAlpha(n55, n8, n9, (byte)n6);
                    ++n54;
                    ++n55;
                }
                if (histogram != null) {
                    histogram.pushARGB(n6, n51, n50, n49);
                }
                if (++n8 != n10) continue;
                n8 = n;
                ++n9;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertICCGray(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, G g, DataBuffer dataBuffer, int n3, int n4, int n5, Histogram histogram, ColorType colorType) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n6 = 255;
        int n7 = bufferedImageWrap.\u00d6O0000;
        int n8 = n;
        int n9 = n2;
        int n10 = n + bufferedImageWrap.o00000;
        int n11 = bufferedImageWrap.getAlphaBand();
        boolean bl = bufferedImageWrap.hasAlpha() && n11 != -1;
        F f = bufferedImageWrap.\u00d4o0000;
        F f2 = this.\u00d600000;
        if (bufferedImageWrap.\u00d2\u00d20000 == 10) {
            for (int i = n3; i < n4; i += n7) {
                int n12 = dataBuffer.getElem(0, i) & 0xFF;
                n6 = bl ? dataBuffer.getElem(0, i + n11) & 0xFF : 255;
                int n13 = g.get(n12);
                if (n13 == -1) {
                    f.toCIEXYZ((float)n12 / 255.0f, 0.0f, 0.0f, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    int n14 = (int)(fArray2[0] * 255.0f + 0.5f);
                    n14 = n12;
                    n13 = n14 << 16 | n14 << 8 | n14;
                    g.put(n12, n13);
                }
                int n15 = n6 << 24 | n13;
                fSIImage.setSample(n8, n9, n15);
                if (histogram != null) {
                    histogram.pushARGB(n15);
                }
                int n16 = bufferedImageWrap.\u00f500000;
                int n17 = 0;
                while (n16 < bufferedImageWrap.oo0000) {
                    n6 = dataBuffer.getElem(0, i + n16);
                    fSIImage.setSampleExtraAlpha(n17, n8, n9, (byte)n6);
                    ++n16;
                    ++n17;
                }
                if (++n8 != n10) continue;
                n8 = n;
                ++n9;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 0 || bufferedImageWrap.\u00d2\u00d20000 == 11) {
            if (n5 == 0) {
                for (int i = n3; i < n4; i += n7) {
                    int n18 = dataBuffer.getElem(0, i);
                    n6 = bl ? dataBuffer.getElem(0, i + n11) : 255;
                    int n19 = g.get(n18);
                    if (n19 == -1) {
                        f.toCIEXYZ((float)n18 / 255.0f, 0.0f, 0.0f, fArray);
                        f2.fromCIEXYZ(fArray, fArray2);
                        int n20 = (int)(fArray2[0] * 255.0f + 0.5f);
                        n19 = n20 << 16 | n20 << 8 | n20;
                        g.put(n18, n19);
                    }
                    int n21 = n6 << 24 | n19;
                    fSIImage.setSample(n8, n9, n21);
                    if (histogram != null) {
                        histogram.pushARGB(n21);
                    }
                    int n22 = bufferedImageWrap.\u00f500000;
                    int n23 = 0;
                    while (n22 < bufferedImageWrap.oo0000) {
                        n6 = dataBuffer.getElem(0, i + n22);
                        fSIImage.setSampleExtraAlpha(n23, n8, n9, (byte)n6);
                        ++n22;
                        ++n23;
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
                return;
            } else if (n5 == 4) {
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    float f3 = dataBuffer.getElemFloat(0, i);
                    n6 = bl ? (int)(dataBuffer.getElemFloat(0, i + n11) * 255.0f + 0.5f) : 255;
                    f.toCIEXYZ(f3, 0.0f, 0.0f, fArray);
                    f2.fromCIEXYZ(fArray, fArray2);
                    int n24 = (int)(fArray2[0] * 255.0f + 0.5f);
                    int n25 = n6 << 24 | n24 << 16 | n24 << 8 | n24;
                    fSIImage.setSample(n8, n9, n25);
                    if (histogram != null) {
                        histogram.pushARGB(n25);
                    }
                    int n26 = bufferedImageWrap.\u00f500000;
                    int n27 = 0;
                    while (n26 < bufferedImageWrap.oo0000) {
                        n6 = (int)(dataBuffer.getElemFloat(0, i + n26) * 255.0f + 0.5f);
                        fSIImage.setSampleExtraAlpha(n27, n8, n9, (byte)n6);
                        ++n26;
                        ++n27;
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
                return;
            } else {
                if (n5 != 1) throw new FSIImageException("Unsupported image format");
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n28 = dataBuffer.getElem(0, i);
                    n6 = bl ? BufferedImageConverterThreaded.sample16to8(dataBuffer.getElem(0, i + n11)) : 255;
                    int n29 = g.get(n28);
                    if (n29 == -1) {
                        f.toCIEXYZ((float)n28 / 65535.0f, 0.0f, 0.0f, fArray);
                        f2.fromCIEXYZ(fArray, fArray2);
                        int n30 = (int)(fArray2[0] * 255.0f + 0.5f);
                        n29 = n30 << 16 | n30 << 8 | n30;
                        g.put(n28, n29);
                    }
                    int n31 = n6 << 24 | n29;
                    fSIImage.setSample(n8, n9, n31);
                    if (histogram != null) {
                        histogram.pushARGB(n31);
                    }
                    int n32 = bufferedImageWrap.\u00f500000;
                    int n33 = 0;
                    while (n32 < bufferedImageWrap.oo0000) {
                        n6 = BufferedImageConverterThreaded.sample16to8(dataBuffer.getElem(0, i + n32));
                        fSIImage.setSampleExtraAlpha(n33, n8, n9, (byte)n6);
                        ++n32;
                        ++n33;
                    }
                    if (++n8 != n10) continue;
                    n8 = n;
                    ++n9;
                }
            }
            return;
        } else {
            if (bufferedImageWrap.\u00d2\u00d20000 != 12) throw new FSIImageException("Unsupported image format");
            if (n5 != 0 || bufferedImageWrap.\u00d2O0000 != 1) throw new FSIImageException("Unsupported image format");
            this.convertByteBinary(bufferedImageWrap, fSIImage, n, n2, dataBuffer, n3, n4, histogram, colorType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertICCCMYK(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, DataBuffer dataBuffer, int n3, int n4, int n5, Histogram histogram) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        int n6 = 255;
        int n7 = n;
        int n8 = n2;
        int n9 = n + bufferedImageWrap.o00000;
        int n10 = bufferedImageWrap.getAlphaBand();
        boolean bl = bufferedImageWrap.hasAlpha() && n10 != -1;
        F f = bufferedImageWrap.\u00d4o0000;
        F f2 = this.\u00d600000;
        if (bufferedImageWrap.\u00d2\u00d20000 == 6) {
            int n11 = -1;
            int n12 = 0;
            for (int i = n3; i < n4; i += 4) {
                int n13;
                int n14;
                int n15;
                int n16 = dataBuffer.getElem(0, i + 3);
                int n17 = n16 << 24 | (n15 = dataBuffer.getElem(0, i + 2)) << 16 | (n14 = dataBuffer.getElem(0, i + 1)) << 8 | (n13 = bufferedImageWrap.\u00d6o0000 ? 255 - dataBuffer.getElem(0, i) : dataBuffer.getElem(0, i));
                if (n17 != n11) {
                    fArray[0] = (float)n16 / 255.0f;
                    fArray[1] = (float)n15 / 255.0f;
                    fArray[2] = (float)n14 / 255.0f;
                    fArray[3] = (float)n13 / 255.0f;
                    f.toCIEXYZ(fArray, fArray2);
                    f2.fromCIEXYZ(fArray2, fArray3);
                    int n18 = BufferedImageConverterThreaded.floatArray1ToInt(fArray3);
                    fSIImage.setSample(n7, n8, n18);
                    n11 = n17;
                    n12 = n18;
                    if (histogram != null) {
                        histogram.pushRGB(n18);
                    }
                } else {
                    fSIImage.setSample(n7, n8, n12);
                    if (histogram != null) {
                        histogram.pushRGB(n12);
                    }
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
            return;
        } else if (bufferedImageWrap.\u00d2\u00d20000 == 0) {
            if (n5 == 0) {
                int n19 = -1;
                int n20 = 0;
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    int n21;
                    int n22 = dataBuffer.getElem(0, i + 0);
                    int n23 = dataBuffer.getElem(0, i + 1);
                    int n24 = dataBuffer.getElem(0, i + 2);
                    int n25 = bufferedImageWrap.\u00d6o0000 ? 255 - dataBuffer.getElem(0, i + 3) : dataBuffer.getElem(0, i + 3);
                    n6 = bl ? dataBuffer.getElem(0, i + n10) : 255;
                    int n26 = n22 << 24 | n23 << 16 | n24 << 8 | n25;
                    if (n26 != n19) {
                        fArray[0] = (float)n22 / 255.0f;
                        fArray[1] = (float)n23 / 255.0f;
                        fArray[2] = (float)n24 / 255.0f;
                        fArray[3] = (float)n25 / 255.0f;
                        f.toCIEXYZ(fArray, fArray2);
                        f2.fromCIEXYZ(fArray2, fArray3);
                        n21 = BufferedImageConverterThreaded.floatArray1ToInt(fArray3);
                        n19 = n26;
                        n20 = n21;
                    } else {
                        n21 = n20;
                    }
                    int n27 = n6 << 24 | n21 & 0xFFFFFF;
                    fSIImage.setSample(n7, n8, n27);
                    if (histogram != null) {
                        histogram.pushARGB(n27);
                    }
                    int n28 = bufferedImageWrap.\u00f500000;
                    int n29 = 0;
                    while (n28 < bufferedImageWrap.oo0000) {
                        n6 = dataBuffer.getElem(0, i + n28);
                        fSIImage.setSampleExtraAlpha(n29, n7, n8, (byte)n6);
                        ++n28;
                        ++n29;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
                return;
            } else {
                if (n5 != 1 && n5 != 2) throw new FSIImageException("Unsupported image format");
                for (int i = n3; i < n4; i += bufferedImageWrap.\u00d6O0000) {
                    fArray[0] = (float)dataBuffer.getElem(0, i) / 65535.0f;
                    fArray[1] = (float)dataBuffer.getElem(0, i + 1) / 65535.0f;
                    fArray[2] = (float)dataBuffer.getElem(0, i + 2) / 65535.0f;
                    fArray[3] = bufferedImageWrap.\u00d6o0000 ? 1.0f - (float)dataBuffer.getElem(0, i + 3) / 65535.0f : (float)dataBuffer.getElem(0, i + 3) / 65535.0f;
                    n6 = bl ? BufferedImageConverterThreaded.sample16to8(dataBuffer.getElem(0, i + n10)) : 255;
                    f.toCIEXYZ(fArray, fArray2);
                    f2.fromCIEXYZ(fArray2, fArray3);
                    int n30 = n6 << 24 | BufferedImageConverterThreaded.floatArray1ToInt(fArray3);
                    fSIImage.setSample(n7, n8, n30);
                    if (histogram != null) {
                        histogram.pushRGB(n30);
                    }
                    int n31 = bufferedImageWrap.\u00f500000;
                    int n32 = 0;
                    while (n31 < bufferedImageWrap.oo0000) {
                        n6 = BufferedImageConverterThreaded.sample16to8(dataBuffer.getElem(0, i + n31));
                        fSIImage.setSampleExtraAlpha(n32, n7, n8, (byte)n6);
                        ++n31;
                        ++n32;
                    }
                    if (++n7 != n9) continue;
                    n7 = n;
                    ++n8;
                }
            }
            return;
        } else {
            if (bufferedImageWrap.\u00d2\u00d20000 != 2) throw new FSIImageException("Unsupported image format");
            int n33 = -1;
            int n34 = 0;
            for (int i = n3; i < n4; ++i) {
                int n35;
                int n36;
                int n37 = dataBuffer.getElem(0, i);
                int n38 = n37 >> 24 & 0xFF;
                int n39 = n37 >> 16 & 0xFF;
                int n40 = n37 >> 8 & 0xFF;
                int n41 = n37 & 0xFF;
                if (bufferedImageWrap.\u00d6o0000) {
                    n38 = 255 - n38;
                }
                if ((n36 = n39 << 24 | n40 << 16 | n41 << 8 | n38) != n33) {
                    fArray[0] = (float)n39 / 255.0f;
                    fArray[1] = (float)n40 / 255.0f;
                    fArray[2] = (float)n41 / 255.0f;
                    fArray[3] = (float)n38 / 255.0f;
                    f.toCIEXYZ(fArray, fArray2);
                    f2.fromCIEXYZ(fArray2, fArray3);
                    n35 = BufferedImageConverterThreaded.floatArray1ToInt(fArray3);
                    n33 = n36;
                    n34 = n35;
                } else {
                    n35 = n34;
                }
                int n42 = n6 << 24 | n35;
                fSIImage.setSample(n7, n8, n42);
                if (histogram != null) {
                    histogram.pushRGB(n42);
                }
                if (++n7 != n9) continue;
                n7 = n;
                ++n8;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertByteBinary(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, int n, int n2, DataBuffer dataBuffer, int n3, int n4, Histogram histogram, ColorType colorType) throws FSIImageException {
        int n5 = n;
        int n6 = n2;
        int n7 = n + bufferedImageWrap.o00000;
        int n8 = -16777216;
        if (bufferedImageWrap.\u00f400000 instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)bufferedImageWrap.\u00f400000;
            int[] nArray = new int[indexColorModel.getMapSize()];
            int n9 = indexColorModel.getTransparentPixel();
            indexColorModel.getRGBs(nArray);
            int n10 = (int)(Math.ceil((float)fSIImage.getWidth() / 8.0f) * 8.0);
            if (bufferedImageWrap.o\u00d20000 == 1) {
                int n11;
                int n12;
                if (bufferedImageWrap.O\u00d20000.getColorModel() instanceof IndexColorModel) {
                    n12 = nArray[0];
                    n11 = nArray[1];
                } else if (colorType != ColorType.\u00d400000) {
                    n12 = 0;
                    n11 = 0xFFFFFF;
                } else {
                    n11 = 0;
                    n12 = 0xFFFFFF;
                }
                int n13 = 0;
                for (int i = n3; i < n4; ++i) {
                    int n14 = dataBuffer.getElem(0, i);
                    for (int j = 7; j >= 0; --j) {
                        if (n13 < fSIImage.getWidth()) {
                            int n15 = n14 >> j & 1;
                            int n16 = n15 == 0 ? n12 : n11;
                            fSIImage.setSample(n5, n6, n16);
                            if (histogram != null) {
                                histogram.pushRGB(n16);
                            }
                            if (++n5 == n7) {
                                n5 = n;
                                ++n6;
                            }
                        }
                        if (++n13 < n10) continue;
                        n13 = 0;
                    }
                }
                return;
            } else if (bufferedImageWrap.o\u00d20000 == 2) {
                int n17 = 0;
                for (int i = n3; i < n4; ++i) {
                    int n18;
                    int n19;
                    int n20 = dataBuffer.getElem(0, i);
                    int n21 = n20 >>> 6;
                    int n22 = n20 >> 4 & 3;
                    int n23 = n20 >> 2 & 3;
                    int n24 = n20 & 3;
                    if (n17 < fSIImage.getWidth() && n21 < nArray.length) {
                        if (n24 == n9) {
                            n19 = 0;
                            n18 = 0;
                        } else {
                            n19 = 0xFF000000 | nArray[n21];
                            n18 = 255;
                        }
                        fSIImage.setSample(n5, n6, n19);
                        if (histogram != null) {
                            histogram.pushRGB(n19);
                        }
                        if (fSIImage.hasExtraAlpha()) {
                            fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n18);
                        }
                        if (++n5 == n7) {
                            n5 = n;
                            ++n6;
                        }
                    }
                    if (++n17 >= fSIImage.getWidth()) {
                        n17 = 0;
                        continue;
                    }
                    if (n17 < fSIImage.getWidth() && n22 < nArray.length) {
                        if (n24 == n9) {
                            n19 = 0;
                            n18 = 0;
                        } else {
                            n19 = 0xFF000000 | nArray[n22];
                            n18 = 255;
                        }
                        fSIImage.setSample(n5, n6, n19);
                        if (histogram != null) {
                            histogram.pushRGB(n19);
                        }
                        if (fSIImage.hasExtraAlpha()) {
                            fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n18);
                        }
                        if (++n5 == n7) {
                            n5 = n;
                            ++n6;
                        }
                    }
                    if (++n17 >= fSIImage.getWidth()) {
                        n17 = 0;
                        continue;
                    }
                    if (n17 < fSIImage.getWidth() && n23 < nArray.length) {
                        if (n24 == n9) {
                            n19 = 0;
                            n18 = 0;
                        } else {
                            n19 = 0xFF000000 | nArray[n23];
                            n18 = 255;
                        }
                        fSIImage.setSample(n5, n6, n19);
                        if (histogram != null) {
                            histogram.pushRGB(n19);
                        }
                        if (fSIImage.hasExtraAlpha()) {
                            fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n18);
                        }
                        if (++n5 == n7) {
                            n5 = n;
                            ++n6;
                        }
                    }
                    if (++n17 >= fSIImage.getWidth()) {
                        n17 = 0;
                        continue;
                    }
                    if (n17 < fSIImage.getWidth() && n24 < nArray.length) {
                        if (n24 == n9) {
                            n19 = 0;
                            n18 = 0;
                        } else {
                            n19 = 0xFF000000 | nArray[n24];
                            n18 = 255;
                        }
                        fSIImage.setSample(n5, n6, n19);
                        if (histogram != null) {
                            histogram.pushRGB(n19);
                        }
                        if (fSIImage.hasExtraAlpha()) {
                            fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n18);
                        }
                        if (++n5 == n7) {
                            n5 = n;
                            ++n6;
                        }
                    }
                    if (++n17 < fSIImage.getWidth()) continue;
                    n17 = 0;
                }
                return;
            } else if (bufferedImageWrap.o\u00d20000 == 4) {
                int n25 = 0;
                for (int i = n3; i < n4; ++i) {
                    int n26;
                    int n27;
                    int n28 = dataBuffer.getElem(0, i);
                    int n29 = n28 >>> 4;
                    int n30 = n28 & 0xF;
                    if (n25 == fSIImage.getWidth()) {
                        n25 = 0;
                    }
                    if (n29 < nArray.length && n25 < fSIImage.getWidth()) {
                        if (n29 == n9) {
                            n27 = 0;
                            n26 = 0;
                        } else {
                            n27 = 0xFF000000 | nArray[n29];
                            n26 = 255;
                        }
                        fSIImage.setSample(n5, n6, n27);
                        if (histogram != null) {
                            histogram.pushRGB(n27);
                        }
                        if (fSIImage.hasExtraAlpha()) {
                            fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n26);
                        }
                        if (++n5 == n7) {
                            n5 = n;
                            ++n6;
                        }
                    } else {
                        n25 = 0;
                        continue;
                    }
                    if (n30 < nArray.length && ++n25 < fSIImage.getWidth()) {
                        if (n30 == n9) {
                            n27 = 0;
                            n26 = 0;
                        } else {
                            n27 = 0xFF000000 | nArray[n30];
                            n26 = 255;
                        }
                        fSIImage.setSample(n5, n6, n27);
                        if (histogram != null) {
                            histogram.pushRGB(n27);
                        }
                        if (fSIImage.hasExtraAlpha()) {
                            fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n26);
                        }
                        if (++n5 == n7) {
                            n5 = n;
                            ++n6;
                        }
                    } else {
                        n25 = 0;
                        continue;
                    }
                    ++n25;
                }
                return;
            } else {
                if (bufferedImageWrap.o\u00d20000 != 8) throw new FSIImageException("Unsupported image format");
                indexColorModel.getRGBs(nArray);
                for (int i = n3; i < n4; ++i) {
                    int n31;
                    int n32;
                    int n33 = dataBuffer.getElem(0, i);
                    if (n33 >= nArray.length) continue;
                    if (n33 == n9) {
                        n32 = 0;
                        n31 = 0;
                    } else {
                        n32 = 0xFF000000 | nArray[n33];
                        n31 = 255;
                    }
                    fSIImage.setSample(n5, n6, n32);
                    if (histogram != null) {
                        histogram.pushRGB(n32);
                    }
                    if (fSIImage.hasExtraAlpha()) {
                        fSIImage.setSampleExtraAlpha(0, n5, n6, (byte)n31);
                    }
                    if (++n5 != n7) continue;
                    n5 = n;
                    ++n6;
                }
            }
            return;
        } else {
            if (!(bufferedImageWrap.\u00f400000 instanceof ComponentColorModel)) throw new FSIImageException("Unsupported image format");
            throw new FSIImageException("Unsupported image format");
        }
    }

    private static int floatArray1ToInt(float[] fArray) {
        return (int)(fArray[0] * 255.0f + 0.5f) << 16 | (int)(fArray[1] * 255.0f + 0.5f) << 8 | (int)(fArray[2] * 255.0f + 0.5f);
    }

    private static int sample16to8(int n) {
        return FastMath.ceil((float)(n + 1) / 256.0f) - 1;
    }

    private static int convertYCbCr2RGB(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n2 + 45 * (n4 -= 128) / 32;
        int n6 = n2 - (11 * (n3 -= 128) + 23 * n4) / 32;
        int n7 = n2 + 113 * n3 / 64;
        int n8 = n5 > 255 ? 255 : (n5 = n5 < 0 ? 0 : n5);
        int n9 = n6 > 255 ? 255 : (n5 = n6 < 0 ? 0 : n6);
        n5 = n7 > 255 ? 255 : (n7 < 0 ? 0 : n7);
        return n5 << 16 | n6 << 8 | n7;
    }

    private static int convertRGB2YCbCr(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = Math.round(\u00d500000[0] * (float)n2 + \u00d500000[1] * (float)n3 + \u00d500000[2] * (float)n4);
        int n6 = Math.round(\u00d500000[3] * (float)n2 + \u00d500000[4] * (float)n3 + \u00d500000[5] * (float)n4) + 127;
        int n7 = Math.round(\u00d500000[6] * (float)n2 + \u00d500000[7] * (float)n3 + \u00d500000[8] * (float)n4) + 127;
        return n5 << 16 | n6 << 8 | n7;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class _o {
        DataBuffer \u00d800000;
        int return;
        int \u00d300000;
        int new;
        int \u00f400000;
        int \u00d500000;
        int \u00d400000;

        private _o() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class _Oo
    implements Supplier<Boolean> {
        private final BufferedImageWrap \u00d600000;
        private final FSIImage \u00f600000;
        private final G \u00d800000;
        private final DataBuffer \u00f800000;
        private final int \u00f500000;
        private final int \u00d200000;
        private final int \u00d300000;
        private final int null;
        private final int \u00d500000;
        private boolean o00000;

        _Oo(BufferedImageWrap bufferedImageWrap, FSIImage fSIImage, G g, DataBuffer dataBuffer, int n, int n2, int n3, int n4, boolean bl) {
            this.\u00d600000 = bufferedImageWrap;
            this.\u00f600000 = fSIImage;
            this.\u00d800000 = g;
            this.\u00f800000 = dataBuffer;
            this.\u00f500000 = dataBuffer.getDataType();
            this.\u00d200000 = n;
            this.\u00d300000 = n2;
            this.null = n3;
            this.\u00d500000 = n4;
            this.o00000 = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Boolean o00000() {
            boolean bl = false;
            this.o00000 = false;
            try {
                if (this.o00000) {
                    if (this.\u00d600000.\u00d400000 == ColorType.\u00d300000) {
                        if (BufferedImageConverterThreaded.this.\u00d300000) {
                            System.out.println("convertICCCMYK");
                        }
                        BufferedImageConverterThreaded.this.convertICCCMYK(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00f500000, this.\u00d600000.\u00f5O0000);
                    } else if (this.\u00d600000.\u00d400000 == ColorType.if || this.\u00d600000.\u00d400000 == ColorType.\u00d400000) {
                        if (BufferedImageConverterThreaded.this.\u00d300000) {
                            System.out.println("convertICCGray");
                        }
                        BufferedImageConverterThreaded.this.convertICCGray(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00d800000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00f500000, this.\u00d600000.\u00f5O0000, this.\u00d600000.\u00d400000);
                    } else {
                        if (this.\u00d600000.\u00d400000 != ColorType.new && this.\u00d600000.\u00d400000 != ColorType.o00000) throw new FSIImageException("Unsupported image format");
                        if (BufferedImageConverterThreaded.this.\u00d300000) {
                            System.out.println("convertICCRGB");
                        }
                        BufferedImageConverterThreaded.this.convertICCRGB(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00d800000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00f500000, this.\u00d600000.\u00f5O0000);
                    }
                } else if (this.\u00d600000.\u00d400000 == ColorType.if || this.\u00d600000.\u00d400000 == ColorType.\u00d400000) {
                    if (BufferedImageConverterThreaded.this.\u00d300000) {
                        System.out.println("convertLinearGray");
                    }
                    BufferedImageConverterThreaded.this.convertLinearGray(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00f500000, this.\u00d600000.\u00f5O0000, this.\u00d600000.\u00d400000);
                } else if (this.\u00d600000.\u00d400000 == ColorType.new || this.\u00d600000.\u00d400000 == ColorType.o00000) {
                    if (BufferedImageConverterThreaded.this.\u00d300000) {
                        System.out.println("convertLinearRGB");
                    }
                    BufferedImageConverterThreaded.this.convertLinearRGB(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00f500000, this.\u00d600000.\u00f5O0000, this.\u00d600000.\u00d400000);
                } else if (this.\u00d600000.\u00d400000 == ColorType.\u00f800000) {
                    if (BufferedImageConverterThreaded.this.\u00d300000) {
                        System.out.println("convertLinearIndexed");
                    }
                    BufferedImageConverterThreaded.this.convertLinearIndexed(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00d600000.\u00f5O0000, this.\u00d600000.\u00d400000);
                } else {
                    if (BufferedImageConverterThreaded.this.\u00d300000) {
                        System.out.println("convertLinearRaw:" + (Object)((Object)this.\u00d600000.\u00d400000));
                    }
                    BufferedImageConverterThreaded.this.convertLinearRaw(this.\u00d600000, this.\u00f600000, this.null, this.\u00d500000, this.\u00f800000, this.\u00d200000, this.\u00d300000, this.\u00f500000, this.\u00d600000.\u00f5O0000, this.\u00d600000.\u00d400000);
                }
                bl = true;
                return bl;
            }
            catch (BufferOverflowException bufferOverflowException) {
                bufferOverflowException.printStackTrace();
                BufferedImageConverterThreaded.this.o00000.logException(bufferOverflowException, 3821, "BO:" + bufferOverflowException.getLocalizedMessage(), this.\u00d600000.\u00f600000);
                bl = false;
                return bl;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
                BufferedImageConverterThreaded.this.o00000.logException(arrayIndexOutOfBoundsException, 3821, "AIOB:" + arrayIndexOutOfBoundsException.getLocalizedMessage(), this.\u00d600000.\u00f600000);
                bl = false;
                return bl;
            }
            catch (CMMException cMMException) {
                cMMException.printStackTrace();
                throw new FSIImageException("Unsupported ICC profile detected");
            }
        }
    }
}

