/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.XMLOperations;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public class XMLFileAuthentication
extends UserAuthenticationInterface {
    private final Path \u00f5o0000;
    private final Path privatesuper;

    public XMLFileAuthentication(SourceManagerSettings sourceManagerSettings) {
        super(sourceManagerSettings);
        Path path = sourceManagerSettings.getConfigHome();
        this.\u00f5o0000 = path.resolve("users.xml");
        this.privatesuper = path.resolve("groups.xml");
        this.return = path.resolve("permissionsets");
        this.oO0000 = path.resolve("propertysets");
        this.Stringsuper = path.resolve("publishingsets");
        this.readPropertyConfig();
        this.readPermissionConfig();
        Path[] pathArray = new Path[]{this.\u00f5o0000, this.privatesuper};
        Path[] pathArray2 = new Path[]{this.return};
        this.setupMonitoring("updateSourceConnectorAccessRules", pathArray, pathArray2);
        Path[] pathArray3 = new Path[]{this.oO0000, this.Stringsuper};
        this.setupMonitoring("updateSourceConnectorAccessRules", null, pathArray3);
    }

    @Override
    protected void readGroups() {
        this.\u00f5O0000.clear();
        this.setupDefaultGroups();
        try {
            Document document = FileOperations.getXMLFileContent(this.\u00f4O0000.getLogger(), this.privatesuper);
            String string = XMLOperations.elementNamesToLowerCase(this.\u00f4O0000.getLogger(), document);
            Groups groups = XMLOperations.unmarshalJAXB(string, Groups.class);
            if (groups != null && groups.getGroups() != null) {
                for (Group group : groups.getGroups()) {
                    String string2 = group.getName();
                    if (!string2.equalsIgnoreCase("authenticated") && !string2.equals("public")) {
                        this.\u00f5O0000.put(group.getName(), group);
                        continue;
                    }
                    if (group.getPermissionSet() != null && this.\u00f5O0000.get(group.getName()) != null) {
                        ((Group)this.\u00f5O0000.get(group.getName())).setPermissionSet(group.getPermissionSet());
                    }
                    if (group.getPropertySet() == null || this.\u00f5O0000.get(group.getName()) == null) continue;
                    ((Group)this.\u00f5O0000.get(group.getName())).setPropertySet(group.getPropertySet());
                }
            }
        }
        catch (IOException iOException) {
            this.\u00f4O0000.getLogger().log(2048, this.privatesuper, iOException.getLocalizedMessage());
        }
    }

    @Override
    protected void readUsers() {
        this.if.clear();
        try {
            Document document = FileOperations.getXMLFileContent(this.\u00f4O0000.getLogger(), this.\u00f5o0000);
            String string = XMLOperations.elementNamesToLowerCase(this.\u00f4O0000.getLogger(), document);
            Users users = XMLOperations.unmarshalJAXB(string, Users.class);
            if (users.users != null) {
                Group group = (Group)this.\u00f5O0000.get("authenticated");
                if (group != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (Users.User user : users.users) {
                        hashSet.add(user.name);
                    }
                    group.setUsers(hashSet);
                }
                this.if.addAll(users.users);
            }
        }
        catch (IOException iOException) {
            this.\u00f4O0000.getLogger().log(2048, this.\u00f5o0000, iOException.getLocalizedMessage());
        }
    }

    @Override
    protected synchronized boolean savePermissionSets() {
        new.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = false;
        try {
            HashSet<Path> hashSet = new HashSet<Path>();
            for (PathCached object : FileOperations.listFiles(this.return, "*.xml")) {
                hashSet.add(object.getPath());
            }
            for (Map.Entry entry : this.\u00d300000.entrySet()) {
                Path path = this.return.resolve((String)entry.getKey() + ".xml");
                try {
                    JAXB.marshal(entry.getValue(), (File)path.toFile());
                    hashSet.remove(path);
                    bl &= true;
                }
                catch (DataBindingException dataBindingException) {
                    this.\u00f4O0000.getLogger().log(2048, path, dataBindingException.getLocalizedMessage());
                }
            }
            for (Path path : hashSet) {
                Files.delete(path);
            }
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.setFileMonitorTasksSuspended(false);
        new.unlock();
        return bl;
    }

    @Override
    public boolean duplicateGroup(String string, String string2) {
        boolean bl = false;
        if (this.\u00f5O0000.containsKey(string) && !this.\u00f5O0000.containsKey(string2)) {
            Group group = new Group(string2);
            HashSet<String> hashSet = new HashSet<String>(((Group)this.\u00f5O0000.get(string)).getUsers());
            group.setUsers(hashSet);
            this.\u00f5O0000.put(string2, group);
            bl = this.saveGroups();
        }
        return bl;
    }

    @Override
    protected synchronized boolean saveGroups() {
        new.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = this.saveGroupsToFile(this.privatesuper);
        this.setFileMonitorTasksSuspended(false);
        new.unlock();
        return bl;
    }

    @Override
    protected synchronized boolean saveUsers() {
        new.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = this.saveUsersToFile(this.\u00f5o0000);
        this.setFileMonitorTasksSuspended(false);
        new.unlock();
        return bl;
    }

    public Path getUsersFile() {
        return this.\u00f5o0000;
    }

    public Path getGroupsFile() {
        return this.privatesuper;
    }

    public Path getPermissionSetsDirectory() {
        return this.return;
    }

    @Override
    public boolean isUserModificationPossible() {
        return true;
    }
}

