/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class CompositeOpImage
extends PointOpImage {
    protected RenderedImage source1Alpha;
    protected RenderedImage source2Alpha;
    protected boolean alphaPremultiplied;
    private int aOffset;
    private int cOffset;
    private byte maxValueByte;
    private short maxValueShort;
    private int maxValue;
    private float invMaxValue;

    public CompositeOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, RenderedImage renderedImage3, RenderedImage renderedImage4, boolean bl, boolean bl2) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        this.source1Alpha = renderedImage3;
        this.source2Alpha = renderedImage4;
        this.alphaPremultiplied = bl;
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = sampleModel.getTransferType();
        int n2 = colorModel instanceof IndexColorModel ? colorModel.getNumComponents() : sampleModel.getNumBands();
        if (this.sampleModel.getTransferType() != n || this.sampleModel.getNumBands() != ++n2) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, n, this.tileWidth, this.tileHeight, n2);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.aOffset = bl2 ? 0 : n2 - 1;
        this.cOffset = bl2 ? 1 : 0;
        switch (n) {
            case 0: {
                this.maxValue = 255;
                this.maxValueByte = (byte)-1;
                break;
            }
            case 1: {
                this.maxValue = 65535;
                this.maxValueShort = (short)-1;
                break;
            }
            case 2: {
                this.maxValue = Short.MAX_VALUE;
                this.maxValueShort = Short.MAX_VALUE;
                break;
            }
            case 3: {
                this.maxValue = Integer.MAX_VALUE;
                break;
            }
        }
        this.invMaxValue = 1.0f / (float)this.maxValue;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RenderedImage[] renderedImageArray = this.source2Alpha == null ? new RenderedImage[3] : new RenderedImage[4];
        renderedImageArray[0] = this.getSourceImage(0);
        renderedImageArray[1] = this.getSourceImage(1);
        renderedImageArray[2] = this.source1Alpha;
        Raster raster = this.source1Alpha.getData(rectangle);
        Raster raster2 = null;
        if (this.source2Alpha != null) {
            renderedImageArray[3] = this.source2Alpha;
            raster2 = this.source2Alpha.getData(rectangle);
        }
        RasterFormatTag[] rasterFormatTagArray = RasterAccessor.findCompatibleTags(renderedImageArray, this);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(raster, rectangle, rasterFormatTagArray[2], this.source1Alpha.getColorModel());
        RasterAccessor rasterAccessor4 = null;
        RasterAccessor rasterAccessor5 = null;
        if (this.source2Alpha != null) {
            rasterAccessor4 = new RasterAccessor(raster2, rectangle, rasterFormatTagArray[3], this.source2Alpha.getColorModel());
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[4], this.getColorModel());
        } else {
            rasterAccessor4 = null;
            rasterAccessor5 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[3], this.getColorModel());
        }
        switch (rasterAccessor5.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2, rasterAccessor3, rasterAccessor4, rasterAccessor5);
            }
        }
        rasterAccessor5.copyDataToRaster();
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[] byArray3 = rasterAccessor3.getByteDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        byte[] byArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            byArray4 = rasterAccessor4.getByteDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        byte[][] byArray5 = rasterAccessor5.getByteDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n16;
                    int n22 = n17;
                    int n23 = n18;
                    int n24 = n20;
                    for (int j = 0; j < n; ++j) {
                        float f = 1.0f - (float)(byArray3[n23 + n10] & 0xFF) * this.invMaxValue;
                        byArray5[this.aOffset][n24 + nArray3[this.aOffset]] = this.maxValueByte;
                        for (int k = 0; k < n3; ++k) {
                            int n25 = k + this.cOffset;
                            byArray5[n25][n24 + nArray3[n25]] = (byte)((float)(byArray[k][n21 + nArray[k]] & 0xFF) + (float)(byArray2[k][n22 + nArray2[k]] & 0xFF) * f);
                        }
                        n21 += n5;
                        n22 += n7;
                        n23 += n9;
                        n24 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n26 = n16;
                    int n27 = n17;
                    int n28 = n18;
                    int n29 = n19;
                    int n30 = n20;
                    for (int j = 0; j < n; ++j) {
                        int n31 = byArray3[n28 + n10] & 0xFF;
                        float f = 1.0f - (float)n31 * this.invMaxValue;
                        byArray5[this.aOffset][n30 + nArray3[this.aOffset]] = (byte)((float)n31 + (float)(byArray4[n29 + n13] & 0xFF) * f);
                        for (int k = 0; k < n3; ++k) {
                            int n32 = k + this.cOffset;
                            byArray5[n32][n30 + nArray3[n32]] = (byte)((float)(byArray[k][n26 + nArray[k]] & 0xFF) + (float)(byArray2[k][n27 + nArray2[k]] & 0xFF) * f);
                        }
                        n26 += n5;
                        n27 += n7;
                        n28 += n9;
                        n29 += n12;
                        n30 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                }
            }
        } else if (rasterAccessor4 == null) {
            for (int i = 0; i < n2; ++i) {
                int n33 = n16;
                int n34 = n17;
                int n35 = n18;
                int n36 = n20;
                for (int j = 0; j < n; ++j) {
                    float f = (float)(byArray3[n35 + n10] & 0xFF) * this.invMaxValue;
                    float f2 = 1.0f - f;
                    byArray5[this.aOffset][n36 + nArray3[this.aOffset]] = this.maxValueByte;
                    for (int k = 0; k < n3; ++k) {
                        int n37 = k + this.cOffset;
                        byArray5[n37][n36 + nArray3[n37]] = (byte)((float)(byArray[k][n33 + nArray[k]] & 0xFF) * f + (float)(byArray2[k][n34 + nArray2[k]] & 0xFF) * f2);
                    }
                    n33 += n5;
                    n34 += n7;
                    n35 += n9;
                    n36 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n38 = n16;
                int n39 = n17;
                int n40 = n18;
                int n41 = n19;
                int n42 = n20;
                for (int j = 0; j < n; ++j) {
                    float f;
                    float f3;
                    int n43 = byArray3[n40 + n10] & 0xFF;
                    float f4 = (1.0f - (float)n43 * this.invMaxValue) * (float)(byArray4[n41 + n13] & 0xFF);
                    float f5 = (float)n43 + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)n43 / f5;
                        f = f4 / f5;
                    }
                    byArray5[this.aOffset][n42 + nArray3[this.aOffset]] = (byte)f5;
                    for (int k = 0; k < n3; ++k) {
                        int n44 = k + this.cOffset;
                        byArray5[n44][n42 + nArray3[n44]] = (byte)((float)(byArray[k][n38 + nArray[k]] & 0xFF) * f3 + (float)(byArray2[k][n39 + nArray2[k]] & 0xFF) * f);
                    }
                    n38 += n5;
                    n39 += n7;
                    n40 += n9;
                    n41 += n12;
                    n42 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n16;
                    int n22 = n17;
                    int n23 = n18;
                    int n24 = n20;
                    for (int j = 0; j < n; ++j) {
                        float f = 1.0f - (float)(sArray3[n23 + n10] & 0xFFFF) * this.invMaxValue;
                        sArray5[this.aOffset][n24 + nArray3[this.aOffset]] = this.maxValueShort;
                        for (int k = 0; k < n3; ++k) {
                            int n25 = k + this.cOffset;
                            sArray5[n25][n24 + nArray3[n25]] = (short)((float)(sArray[k][n21 + nArray[k]] & 0xFFFF) + (float)(sArray2[k][n22 + nArray2[k]] & 0xFFFF) * f);
                        }
                        n21 += n5;
                        n22 += n7;
                        n23 += n9;
                        n24 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n26 = n16;
                    int n27 = n17;
                    int n28 = n18;
                    int n29 = n19;
                    int n30 = n20;
                    for (int j = 0; j < n; ++j) {
                        int n31 = sArray3[n28 + n10] & 0xFFFF;
                        float f = 1.0f - (float)n31 * this.invMaxValue;
                        sArray5[this.aOffset][n30 + nArray3[this.aOffset]] = (short)((float)n31 + (float)(sArray4[n29 + n13] & 0xFFFF) * f);
                        for (int k = 0; k < n3; ++k) {
                            int n32 = k + this.cOffset;
                            sArray5[n32][n30 + nArray3[n32]] = (short)((float)(sArray[k][n26 + nArray[k]] & 0xFFFF) + (float)(sArray2[k][n27 + nArray2[k]] & 0xFFFF) * f);
                        }
                        n26 += n5;
                        n27 += n7;
                        n28 += n9;
                        n29 += n12;
                        n30 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                }
            }
        } else if (rasterAccessor4 == null) {
            for (int i = 0; i < n2; ++i) {
                int n33 = n16;
                int n34 = n17;
                int n35 = n18;
                int n36 = n20;
                for (int j = 0; j < n; ++j) {
                    float f = (float)(sArray3[n35 + n10] & 0xFFFF) * this.invMaxValue;
                    float f2 = 1.0f - f;
                    sArray5[this.aOffset][n36 + nArray3[this.aOffset]] = this.maxValueShort;
                    for (int k = 0; k < n3; ++k) {
                        int n37 = k + this.cOffset;
                        sArray5[n37][n36 + nArray3[n37]] = (short)((float)(sArray[k][n33 + nArray[k]] & 0xFFFF) * f + (float)(sArray2[k][n34 + nArray2[k]] & 0xFFFF) * f2);
                    }
                    n33 += n5;
                    n34 += n7;
                    n35 += n9;
                    n36 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n38 = n16;
                int n39 = n17;
                int n40 = n18;
                int n41 = n19;
                int n42 = n20;
                for (int j = 0; j < n; ++j) {
                    float f;
                    float f3;
                    int n43 = sArray3[n40 + n10] & 0xFFFF;
                    float f4 = (1.0f - (float)n43 * this.invMaxValue) * (float)(sArray4[n41 + n13] & 0xFFFF);
                    float f5 = (float)n43 + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)n43 / f5;
                        f = f4 / f5;
                    }
                    sArray5[this.aOffset][n42 + nArray3[this.aOffset]] = (short)f5;
                    for (int k = 0; k < n3; ++k) {
                        int n44 = k + this.cOffset;
                        sArray5[n44][n42 + nArray3[n44]] = (short)((float)(sArray[k][n38 + nArray[k]] & 0xFFFF) * f3 + (float)(sArray2[k][n39 + nArray2[k]] & 0xFFFF) * f);
                    }
                    n38 += n5;
                    n39 += n7;
                    n40 += n9;
                    n41 += n12;
                    n42 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[] sArray3 = rasterAccessor3.getShortDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        short[] sArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            sArray4 = rasterAccessor4.getShortDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        short[][] sArray5 = rasterAccessor5.getShortDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n16;
                    int n22 = n17;
                    int n23 = n18;
                    int n24 = n20;
                    for (int j = 0; j < n; ++j) {
                        float f = 1.0f - (float)sArray3[n23 + n10] * this.invMaxValue;
                        sArray5[this.aOffset][n24 + nArray3[this.aOffset]] = this.maxValueShort;
                        for (int k = 0; k < n3; ++k) {
                            int n25 = k + this.cOffset;
                            sArray5[n25][n24 + nArray3[n25]] = (short)((float)sArray[k][n21 + nArray[k]] + (float)sArray2[k][n22 + nArray2[k]] * f);
                        }
                        n21 += n5;
                        n22 += n7;
                        n23 += n9;
                        n24 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n26 = n16;
                    int n27 = n17;
                    int n28 = n18;
                    int n29 = n19;
                    int n30 = n20;
                    for (int j = 0; j < n; ++j) {
                        short s = sArray3[n28 + n10];
                        float f = 1.0f - (float)s * this.invMaxValue;
                        sArray5[this.aOffset][n30 + nArray3[this.aOffset]] = (short)((float)s + (float)sArray4[n29 + n13] * f);
                        for (int k = 0; k < n3; ++k) {
                            int n31 = k + this.cOffset;
                            sArray5[n31][n30 + nArray3[n31]] = (short)((float)sArray[k][n26 + nArray[k]] + (float)sArray2[k][n27 + nArray2[k]] * f);
                        }
                        n26 += n5;
                        n27 += n7;
                        n28 += n9;
                        n29 += n12;
                        n30 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                }
            }
        } else if (rasterAccessor4 == null) {
            for (int i = 0; i < n2; ++i) {
                int n32 = n16;
                int n33 = n17;
                int n34 = n18;
                int n35 = n20;
                for (int j = 0; j < n; ++j) {
                    float f = (float)sArray3[n34 + n10] * this.invMaxValue;
                    float f2 = 1.0f - f;
                    sArray5[this.aOffset][n35 + nArray3[this.aOffset]] = this.maxValueShort;
                    for (int k = 0; k < n3; ++k) {
                        int n36 = k + this.cOffset;
                        sArray5[n36][n35 + nArray3[n36]] = (short)((float)sArray[k][n32 + nArray[k]] * f + (float)sArray2[k][n33 + nArray2[k]] * f2);
                    }
                    n32 += n5;
                    n33 += n7;
                    n34 += n9;
                    n35 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n37 = n16;
                int n38 = n17;
                int n39 = n18;
                int n40 = n19;
                int n41 = n20;
                for (int j = 0; j < n; ++j) {
                    float f;
                    float f3;
                    short s = sArray3[n39 + n10];
                    float f4 = (1.0f - (float)s * this.invMaxValue) * (float)sArray4[n40 + n13];
                    float f5 = (float)s + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)s / f5;
                        f = f4 / f5;
                    }
                    sArray5[this.aOffset][n41 + nArray3[this.aOffset]] = (short)f5;
                    for (int k = 0; k < n3; ++k) {
                        int n42 = k + this.cOffset;
                        sArray5[n42][n41 + nArray3[n42]] = (short)((float)sArray[k][n37 + nArray[k]] * f3 + (float)sArray2[k][n38 + nArray2[k]] * f);
                    }
                    n37 += n5;
                    n38 += n7;
                    n39 += n9;
                    n40 += n12;
                    n41 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        int[][] nArray = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray4 = rasterAccessor2.getBandOffsets();
        int[] nArray5 = rasterAccessor3.getIntDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        int[] nArray6 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            nArray6 = rasterAccessor4.getIntDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        int[][] nArray7 = rasterAccessor5.getIntDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray8 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n16;
                    int n22 = n17;
                    int n23 = n18;
                    int n24 = n20;
                    for (int j = 0; j < n; ++j) {
                        float f = 1.0f - (float)nArray5[n23 + n10] * this.invMaxValue;
                        nArray7[this.aOffset][n24 + nArray8[this.aOffset]] = this.maxValue;
                        for (int k = 0; k < n3; ++k) {
                            int n25 = k + this.cOffset;
                            nArray7[n25][n24 + nArray8[n25]] = (int)((float)nArray[k][n21 + nArray2[k]] + (float)nArray3[k][n22 + nArray4[k]] * f);
                        }
                        n21 += n5;
                        n22 += n7;
                        n23 += n9;
                        n24 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n26 = n16;
                    int n27 = n17;
                    int n28 = n18;
                    int n29 = n19;
                    int n30 = n20;
                    for (int j = 0; j < n; ++j) {
                        int n31 = nArray5[n28 + n10];
                        float f = 1.0f - (float)n31 * this.invMaxValue;
                        nArray7[this.aOffset][n30 + nArray8[this.aOffset]] = (int)((float)n31 + (float)nArray6[n29 + n13] * f);
                        for (int k = 0; k < n3; ++k) {
                            int n32 = k + this.cOffset;
                            nArray7[n32][n30 + nArray8[n32]] = (int)((float)nArray[k][n26 + nArray2[k]] + (float)nArray3[k][n27 + nArray4[k]] * f);
                        }
                        n26 += n5;
                        n27 += n7;
                        n28 += n9;
                        n29 += n12;
                        n30 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                }
            }
        } else if (rasterAccessor4 == null) {
            for (int i = 0; i < n2; ++i) {
                int n33 = n16;
                int n34 = n17;
                int n35 = n18;
                int n36 = n20;
                for (int j = 0; j < n; ++j) {
                    float f = (float)nArray5[n35 + n10] * this.invMaxValue;
                    float f2 = 1.0f - f;
                    nArray7[this.aOffset][n36 + nArray8[this.aOffset]] = this.maxValue;
                    for (int k = 0; k < n3; ++k) {
                        int n37 = k + this.cOffset;
                        nArray7[n37][n36 + nArray8[n37]] = (int)((float)nArray[k][n33 + nArray2[k]] * f + (float)nArray3[k][n34 + nArray4[k]] * f2);
                    }
                    n33 += n5;
                    n34 += n7;
                    n35 += n9;
                    n36 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n38 = n16;
                int n39 = n17;
                int n40 = n18;
                int n41 = n19;
                int n42 = n20;
                for (int j = 0; j < n; ++j) {
                    float f;
                    float f3;
                    int n43 = nArray5[n40 + n10];
                    float f4 = (1.0f - (float)n43 * this.invMaxValue) * (float)nArray6[n41 + n13];
                    float f5 = (float)n43 + f4;
                    if (f5 == 0.0f) {
                        f3 = 0.0f;
                        f = 0.0f;
                    } else {
                        f3 = (float)n43 / f5;
                        f = f4 / f5;
                    }
                    nArray7[this.aOffset][n42 + nArray8[this.aOffset]] = (int)f5;
                    for (int k = 0; k < n3; ++k) {
                        int n44 = k + this.cOffset;
                        nArray7[n44][n42 + nArray8[n44]] = (int)((float)nArray[k][n38 + nArray2[k]] * f3 + (float)nArray3[k][n39 + nArray4[k]] * f);
                    }
                    n38 += n5;
                    n39 += n7;
                    n40 += n9;
                    n41 += n12;
                    n42 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[] fArray3 = rasterAccessor3.getFloatDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        float[] fArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            fArray4 = rasterAccessor4.getFloatDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        float[][] fArray5 = rasterAccessor5.getFloatDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        float f = 2.938736E-39f;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n16;
                    int n22 = n17;
                    int n23 = n18;
                    int n24 = n20;
                    for (int j = 0; j < n; ++j) {
                        float f2 = 1.0f - fArray3[n23 + n10] * f;
                        fArray5[this.aOffset][n24 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                        for (int k = 0; k < n3; ++k) {
                            int n25 = k + this.cOffset;
                            fArray5[n25][n24 + nArray3[n25]] = fArray[k][n21 + nArray[k]] + fArray2[k][n22 + nArray2[k]] * f2;
                        }
                        n21 += n5;
                        n22 += n7;
                        n23 += n9;
                        n24 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n26 = n16;
                    int n27 = n17;
                    int n28 = n18;
                    int n29 = n19;
                    int n30 = n20;
                    for (int j = 0; j < n; ++j) {
                        float f3 = fArray3[n28 + n10];
                        float f4 = 1.0f - f3 * f;
                        fArray5[this.aOffset][n30 + nArray3[this.aOffset]] = f3 + fArray4[n29 + n13] * f4;
                        for (int k = 0; k < n3; ++k) {
                            int n31 = k + this.cOffset;
                            fArray5[n31][n30 + nArray3[n31]] = fArray[k][n26 + nArray[k]] + fArray2[k][n27 + nArray2[k]] * f4;
                        }
                        n26 += n5;
                        n27 += n7;
                        n28 += n9;
                        n29 += n12;
                        n30 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                }
            }
        } else if (rasterAccessor4 == null) {
            for (int i = 0; i < n2; ++i) {
                int n32 = n16;
                int n33 = n17;
                int n34 = n18;
                int n35 = n20;
                for (int j = 0; j < n; ++j) {
                    float f5 = fArray3[n34 + n10] * f;
                    float f6 = 1.0f - f5;
                    fArray5[this.aOffset][n35 + nArray3[this.aOffset]] = Float.MAX_VALUE;
                    for (int k = 0; k < n3; ++k) {
                        int n36 = k + this.cOffset;
                        fArray5[n36][n35 + nArray3[n36]] = fArray[k][n32 + nArray[k]] * f5 + fArray2[k][n33 + nArray2[k]] * f6;
                    }
                    n32 += n5;
                    n33 += n7;
                    n34 += n9;
                    n35 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n37 = n16;
                int n38 = n17;
                int n39 = n18;
                int n40 = n19;
                int n41 = n20;
                for (int j = 0; j < n; ++j) {
                    float f7;
                    float f8;
                    float f9 = fArray3[n39 + n10];
                    float f10 = (1.0f - f9 * f) * fArray4[n40 + n13];
                    float f11 = f9 + f10;
                    if (f11 == 0.0f) {
                        f8 = 0.0f;
                        f7 = 0.0f;
                    } else {
                        f8 = f9 / f11;
                        f7 = f10 / f11;
                    }
                    fArray5[this.aOffset][n41 + nArray3[this.aOffset]] = f11;
                    for (int k = 0; k < n3; ++k) {
                        int n42 = k + this.cOffset;
                        fArray5[n42][n41 + nArray3[n42]] = fArray[k][n37 + nArray[k]] * f8 + fArray2[k][n38 + nArray2[k]] * f7;
                    }
                    n37 += n5;
                    n38 += n7;
                    n39 += n9;
                    n40 += n12;
                    n41 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3, RasterAccessor rasterAccessor4, RasterAccessor rasterAccessor5) {
        int n = rasterAccessor5.getWidth();
        int n2 = rasterAccessor5.getHeight();
        int n3 = rasterAccessor.getNumBands();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[] dArray3 = rasterAccessor3.getDoubleDataArray(0);
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int n10 = rasterAccessor3.getBandOffset(0);
        double[] dArray4 = null;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (rasterAccessor4 != null) {
            dArray4 = rasterAccessor4.getDoubleDataArray(0);
            n11 = rasterAccessor4.getScanlineStride();
            n12 = rasterAccessor4.getPixelStride();
            n13 = rasterAccessor4.getBandOffset(0);
        }
        double[][] dArray5 = rasterAccessor5.getDoubleDataArrays();
        int n14 = rasterAccessor5.getScanlineStride();
        int n15 = rasterAccessor5.getPixelStride();
        int[] nArray3 = rasterAccessor5.getBandOffsets();
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        double d = 5.562684646268003E-309;
        if (this.alphaPremultiplied) {
            if (rasterAccessor4 == null) {
                for (int i = 0; i < n2; ++i) {
                    int n21 = n16;
                    int n22 = n17;
                    int n23 = n18;
                    int n24 = n20;
                    for (int j = 0; j < n; ++j) {
                        double d2 = 1.0 - dArray3[n23 + n10] * d;
                        dArray5[this.aOffset][n24 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                        for (int k = 0; k < n3; ++k) {
                            int n25 = k + this.cOffset;
                            dArray5[n25][n24 + nArray3[n25]] = dArray[k][n21 + nArray[k]] + dArray2[k][n22 + nArray2[k]] * d2;
                        }
                        n21 += n5;
                        n22 += n7;
                        n23 += n9;
                        n24 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n20 += n14;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    int n26 = n16;
                    int n27 = n17;
                    int n28 = n18;
                    int n29 = n19;
                    int n30 = n20;
                    for (int j = 0; j < n; ++j) {
                        double d3 = dArray3[n28 + n10];
                        double d4 = 1.0 - d3 * d;
                        dArray5[this.aOffset][n30 + nArray3[this.aOffset]] = d3 + dArray4[n29 + n13] * d4;
                        for (int k = 0; k < n3; ++k) {
                            int n31 = k + this.cOffset;
                            dArray5[n31][n30 + nArray3[n31]] = dArray[k][n26 + nArray[k]] + dArray2[k][n27 + nArray2[k]] * d4;
                        }
                        n26 += n5;
                        n27 += n7;
                        n28 += n9;
                        n29 += n12;
                        n30 += n15;
                    }
                    n16 += n4;
                    n17 += n6;
                    n18 += n8;
                    n19 += n11;
                    n20 += n14;
                }
            }
        } else if (rasterAccessor4 == null) {
            for (int i = 0; i < n2; ++i) {
                int n32 = n16;
                int n33 = n17;
                int n34 = n18;
                int n35 = n20;
                for (int j = 0; j < n; ++j) {
                    double d5 = dArray3[n34 + n10] * d;
                    double d6 = 1.0 - d5;
                    dArray5[this.aOffset][n35 + nArray3[this.aOffset]] = Double.MAX_VALUE;
                    for (int k = 0; k < n3; ++k) {
                        int n36 = k + this.cOffset;
                        dArray5[n36][n35 + nArray3[n36]] = dArray[k][n32 + nArray[k]] * d5 + dArray2[k][n33 + nArray2[k]] * d6;
                    }
                    n32 += n5;
                    n33 += n7;
                    n34 += n9;
                    n35 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n20 += n14;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n37 = n16;
                int n38 = n17;
                int n39 = n18;
                int n40 = n19;
                int n41 = n20;
                for (int j = 0; j < n; ++j) {
                    double d7;
                    double d8;
                    double d9 = dArray3[n39 + n10];
                    double d10 = (1.0 - d9 * d) * dArray4[n40 + n13];
                    double d11 = d9 + d10;
                    if (d11 == 0.0) {
                        d8 = 0.0;
                        d7 = 0.0;
                    } else {
                        d8 = d9 / d11;
                        d7 = d10 / d11;
                    }
                    dArray5[this.aOffset][n41 + nArray3[this.aOffset]] = d11;
                    for (int k = 0; k < n3; ++k) {
                        int n42 = k + this.cOffset;
                        dArray5[n42][n41 + nArray3[n42]] = dArray[k][n37 + nArray[k]] * d8 + dArray2[k][n38 + nArray2[k]] * d7;
                    }
                    n37 += n5;
                    n38 += n7;
                    n39 += n9;
                    n40 += n12;
                    n41 += n15;
                }
                n16 += n4;
                n17 += n6;
                n18 += n8;
                n19 += n11;
                n20 += n14;
            }
        }
    }
}

