/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.service.C;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.DirectoryImportJob;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.Directory;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="/directory")
public final class DirectoryService
extends C
implements Serializable {
    private static final long serialVersionUID = -8061277343399746611L;

    @GET
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/json", "application/xml"})
    public Response listDirectory(@PathParam(value="directorypath") String string) {
        Response.ResponseBuilder responseBuilder;
        block12: {
            if (!(string = URL.cleanUpSourceParameter(string)).endsWith("/")) {
                string = string + "/";
            }
            try {
                HttpSession httpSession = this.\u00f800000(false);
                SourceManagerSettings sourceManagerSettings = this.\u00d6O0000();
                SourceConnectorReader sourceConnectorReader = sourceManagerSettings.getSourceConnectorFromAssetURLPath(string, httpSession);
                PermissionSet permissionSet = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                if (permissionSet == null || !permissionSet.list.files.booleanValue() && !permissionSet.list.directories.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                java.nio.file.Path path = this.\u00f8o0000(string, sourceConnectorReader);
                if (path != null) {
                    Directory directory = new Directory();
                    try {
                        List<PathCached> list = FileOperations.listAllFiles(path);
                        if (list != null) {
                            for (PathCached pathCached : list) {
                                Object object;
                                if (pathCached.isRegularFile() && permissionSet.list.files.booleanValue()) {
                                    object = new Directory.ImageEntry();
                                    ((Directory.ImageEntry)object).lastModified = pathCached.lastModified();
                                    ((Directory.ImageEntry)object).name = pathCached.getFileName();
                                    ((Directory.ImageEntry)object).size = pathCached.size();
                                    directory.images.add((Directory.ImageEntry)object);
                                    continue;
                                }
                                if (!pathCached.isDirectory() || !permissionSet.list.directories.booleanValue()) continue;
                                object = new Directory.DirEntry();
                                ((Directory.DirEntry)object).name = pathCached.getFileName();
                                directory.subdirectory.add((Directory.DirEntry)object);
                            }
                        } else {
                            throw new WebApplicationException(Response.Status.NOT_FOUND);
                        }
                        responseBuilder = Response.ok((Object)directory);
                        break block12;
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    catch (IOException iOException) {
                        throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                    }
                }
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (NotConfiguredException notConfiguredException) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/json", "application/xml"})
    public Response createDirectory(@PathParam(value="directorypath") String string) {
        ActionResponse actionResponse;
        block32: {
            if (!(string = URL.cleanUpSourceParameter(string)).endsWith("/")) {
                string = string + "/";
            }
            actionResponse = new ActionResponse();
            try {
                Object object;
                if (string.contains("/..")) {
                    actionResponse.setStatuscode(403);
                    actionResponse.setCause("Invalid path value.");
                    this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 126, string, actionResponse.getCause());
                    break block32;
                }
                String string2 = string.substring(0, string.length() - 1);
                int n = string2.lastIndexOf("/");
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                HttpSession httpSession = this.\u00f800000(false);
                SourceConnectorReader sourceConnectorReader = this.\u00d6O0000().getSourceConnectorFromAssetURLPath(string, httpSession);
                PermissionSet permissionSet = this.\u00d6O0000().getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                if (permissionSet == null || !permissionSet.write.createDirectory.booleanValue()) {
                    this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 126, string, "Not authorized");
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                String string3 = null;
                if (!sourceConnectorReader.isVirtualViewerConnector()) {
                    object = new ScannerPauseReason(string2, ScannerPauseReason.ModificationType.\u00d300000);
                    string3 = "PK3" + string2.hashCode();
                    this.\u00d6O0000().getScannerDaemon().pauseScanner(string3, new ScannerPauseReason[]{object});
                }
                try {
                    block33: {
                        object = this.\u00f8o0000(string, sourceConnectorReader);
                        if (object != null) {
                            if (Files.exists((java.nio.file.Path)object, new LinkOption[0])) {
                                if (Files.isRegularFile((java.nio.file.Path)object, new LinkOption[0])) {
                                    actionResponse.setStatuscode(409);
                                    actionResponse.setCause("Failed to create directory.");
                                } else if (Files.isWritable((java.nio.file.Path)object)) {
                                    actionResponse.setStatuscode(409);
                                    actionResponse.setCause("Directory already exists.");
                                } else {
                                    actionResponse.setStatuscode(409);
                                    actionResponse.setCause("Directory already exists but is not readable.");
                                }
                            } else {
                                try {
                                    Files.createDirectories((java.nio.file.Path)object, new FileAttribute[0]);
                                    if (Files.exists((java.nio.file.Path)object, new LinkOption[0])) {
                                        if (!sourceConnectorReader.isVirtualViewerConnector()) {
                                            try {
                                                String string4;
                                                String string5;
                                                java.nio.file.Path path = this.\u00d8o0000().getDirectoryFile(string);
                                                String string6 = string.substring(0, string.lastIndexOf("/", string.length() - 2));
                                                java.nio.file.Path path2 = this.\u00d8o0000().getDirectoryFile(string6);
                                                if (Files.notExists(path2, new LinkOption[0])) {
                                                    this.createDirectory(string6);
                                                }
                                                this.oO0000().updateEntries(path, string, path2, string6, new ArrayList<PoolEntry>(), FileOperations.getSafeLastModified((java.nio.file.Path)object));
                                                int n2 = string6.lastIndexOf("/", string6.length() - 2);
                                                if (n2 > -1) {
                                                    string5 = string6.substring(0, n2);
                                                    string4 = string6.substring(n2 + 1);
                                                } else {
                                                    string5 = "/";
                                                    string4 = string6;
                                                }
                                                java.nio.file.Path path3 = this.\u00d8o0000().getDirectoryFile(string5);
                                                try {
                                                    PoolList poolList = this.\u00d300000().getListFileContents(path3, string5);
                                                    PoolDirectoryEntry poolDirectoryEntry = poolList.getDirectory(string4);
                                                    ++poolDirectoryEntry.null;
                                                    ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
                                                    arrayList.add(poolDirectoryEntry);
                                                    this.oO0000().updateEntries(path3, string5, null, null, arrayList, -1L);
                                                }
                                                catch (Exception exception) {
                                                    exception.printStackTrace();
                                                }
                                                this.\u00d6O0000().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(string, false);
                                                actionResponse.setStatuscode(200);
                                            }
                                            catch (NotConfiguredException notConfiguredException) {
                                                actionResponse.setStatuscode(503);
                                                actionResponse.setCause("Server not configured.");
                                            }
                                            break block33;
                                        }
                                        this.\u00d200000(string2);
                                        actionResponse.setStatuscode(200);
                                        break block33;
                                    }
                                    actionResponse.setStatuscode(500);
                                    actionResponse.setCause("Failed to create directory");
                                }
                                catch (IOException iOException) {
                                    actionResponse.setStatuscode(500);
                                    actionResponse.setCause("Failed to create directory: " + iOException.getLocalizedMessage());
                                }
                            }
                        } else {
                            actionResponse.setStatuscode(409);
                            actionResponse.setCause("Failed to create directory");
                        }
                    }
                    if (actionResponse.getStatuscode() == 200 || actionResponse.getStatuscode() == 201) {
                        this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 125, object);
                    } else {
                        this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 126, object, actionResponse.getCause());
                    }
                    if (string3 != null) {
                        this.\u00d6O0000().getScannerDaemon().resumeScanner(string3);
                    }
                }
                catch (Throwable throwable) {
                    if (string3 != null) {
                        this.\u00d6O0000().getScannerDaemon().resumeScanner(string3);
                    }
                    throw throwable;
                }
            }
            catch (NotConfiguredException notConfiguredException) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        return this.returnsuper(actionResponse);
    }

    @DELETE
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/json", "application/xml"})
    public Response deleteDirectory(@PathParam(value="directorypath") String string) {
        return this.returnsuper(this.deleteDirectory(string, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse deleteDirectory(String string, boolean bl) {
        ActionResponse actionResponse = new ActionResponse();
        if (this.null()) {
            try {
                string = URL.cleanUpSourceParameter(string);
                if (!string.substring(1).contains("/")) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                if (string.startsWith("_trash") || string.startsWith("_downloads")) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                HttpSession httpSession = this.\u00f800000(false);
                SourceConnectorReader sourceConnectorReader = this.\u00d6O0000().getSourceConnectorFromAssetURLPath(string, httpSession);
                PermissionSet permissionSet = this.\u00d6O0000().getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                if (permissionSet == null || bl && !permissionSet.write.delete.booleanValue() || !bl && !permissionSet.write.moveToTrash.booleanValue()) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                java.nio.file.Path path = this.\u00f8o0000(string, sourceConnectorReader);
                if (path != null) {
                    if (Files.isWritable(path) && string.contains("/")) {
                        if (!sourceConnectorReader.isVirtualViewerConnector()) {
                            ScannerPauseReason scannerPauseReason = new ScannerPauseReason(string, ScannerPauseReason.ModificationType.new);
                            String string2 = "PK4-" + string.hashCode();
                            this.\u00d6O0000().getScannerDaemon().pauseScanner(string2, scannerPauseReason);
                            try {
                                this.private().cancelJobsByPrefix(string);
                                if (bl) {
                                    this.for().delete(path, string, sourceConnectorReader);
                                } else {
                                    this.for().moveToTrash(path, string, sourceConnectorReader);
                                }
                                if (this.\u00f5o0000() != null) {
                                    this.\u00f5o0000().deleteAssetWithPrefixAsync(string + "/");
                                    this.\u00f5o0000().deleteAssetAsync(string);
                                }
                                actionResponse.setStatuscode(200);
                            }
                            catch (IOException iOException) {
                                actionResponse.setStatuscode(409);
                                actionResponse.setCause("Could not delete item");
                                actionResponse.setDetails("Could not delete file " + path);
                            }
                            catch (NotConfiguredException notConfiguredException) {
                                actionResponse.setStatuscode(503);
                            }
                            finally {
                                this.\u00d6O0000().getScannerDaemon().resumeScanner(string2);
                            }
                        } else {
                            try {
                                FileOperations.deleteDir(path);
                                this.\u00d200000(string);
                                this.\u00d200000(string.substring(0, string.lastIndexOf("/")));
                                actionResponse.setStatuscode(200);
                            }
                            catch (IOException iOException) {
                                this.\u00d6O0000().getScannerDaemon().reportStorageCorruption(iOException);
                                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                            }
                        }
                    } else {
                        actionResponse.setStatuscode(403);
                        actionResponse.setCause("Forbidden");
                    }
                } else {
                    actionResponse.setStatuscode(409);
                    actionResponse.setCause("Could not delete item");
                    actionResponse.setDetails("full path for " + string + " is null");
                }
                this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 127, string);
            }
            catch (NotConfiguredException notConfiguredException) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        } else {
            this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 128, string, "Not authorized");
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return actionResponse;
    }

    @POST
    @Path(value="/{directorypath:.+?}")
    @Produces(value={"application/json", "application/xml"})
    public Response post(@PathParam(value="directorypath") String string, MultivaluedMap<String, String> multivaluedMap) {
        ActionResponse actionResponse;
        String string2 = (String)multivaluedMap.getFirst((Object)"cmd");
        String string3 = (String)multivaluedMap.getFirst((Object)"to");
        String string4 = (String)multivaluedMap.getFirst((Object)"reimport");
        multivaluedMap.remove((Object)"reimport");
        multivaluedMap.remove((Object)"cmd");
        multivaluedMap.remove((Object)"to");
        string = URL.cleanUpSourceParameter(string);
        try {
            if (string2 != null && string2.equalsIgnoreCase("reimport") || string4 != null && (string4.equalsIgnoreCase("true") || string4.equals("1"))) {
                actionResponse = this.reimportDirectory(string, multivaluedMap);
            } else if (string2 != null && string2.equalsIgnoreCase("copy")) {
                actionResponse = this.nullnew(string, string3);
            } else if (string2 != null && string2.equalsIgnoreCase("saveMetaData")) {
                actionResponse = this.Stringnew(string, multivaluedMap);
            } else if (string2 != null && string2.equalsIgnoreCase("deleteMetaData")) {
                actionResponse = this.privatenew(string, multivaluedMap);
            } else if (string2 != null && string2.equalsIgnoreCase("restoreMetaData")) {
                actionResponse = this.\u00d8\u00d20000(string, multivaluedMap);
            } else if (string2 != null && string2.equalsIgnoreCase("trash")) {
                actionResponse = this.deleteDirectory(string, false);
            } else if (string3 != null) {
                actionResponse = this.moveDirectory(string, string3);
            } else {
                actionResponse = new ActionResponse();
                actionResponse.setStatuscode(400);
                actionResponse.setCause("Unknown command.");
            }
        }
        catch (NotConfiguredException notConfiguredException) {
            actionResponse = new ActionResponse();
            actionResponse.setStatuscode(503);
            actionResponse.setCause("Server not configured.");
        }
        return this.returnsuper(actionResponse);
    }

    private ActionResponse reimportDirectory(String string, MultivaluedMap<String, String> multivaluedMap) {
        ActionResponse actionResponse;
        try {
            String string2;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2 = multivaluedMap.containsKey((Object)"options") ? ((String)multivaluedMap.getFirst((Object)"options")).toLowerCase() : null;
            if (string2 == null || string2.contains("image")) {
                bl = true;
            }
            if (string2 != null && string2.contains("metaData")) {
                bl2 = true;
            }
            HttpSession httpSession = this.\u00f800000(false);
            SourceManagerSettings sourceManagerSettings = this.\u00d6O0000();
            SourceConnectorReader sourceConnectorReader = sourceManagerSettings.getSourceConnectorFromAssetURLPath(string, httpSession);
            PermissionSet permissionSet = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
            if (permissionSet == null || !permissionSet.tasks.reimportFiles.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            int n = this.recursiveReimport(sourceConnectorReader, string, bl, bl2);
            actionResponse = new ActionResponse();
            actionResponse.setStatuscode(200);
            actionResponse.setDetails(String.valueOf(n));
            this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 113, n, string);
        }
        catch (NotConfiguredException | IOException exception) {
            actionResponse = new ActionResponse();
            actionResponse.setStatuscode(503);
            actionResponse.setCause("Server not configured.");
        }
        return actionResponse;
    }

    private int recursiveReimport(SourceConnectorReader sourceConnectorReader, String string, boolean bl, boolean bl2) throws CorruptStorageException, NotConfiguredException, IOException {
        int n = 0;
        if (bl2) {
            this.\u00d3\u00d20000(string);
        }
        java.nio.file.Path path = this.\u00f8o0000(string, sourceConnectorReader);
        List<PathCached> list = FileOperations.listAllFiles(path);
        for (PathCached pathCached : list) {
            if (pathCached.isDirectory()) {
                n += this.recursiveReimport(sourceConnectorReader, string + "/" + pathCached.getFileName(), bl, bl2);
                continue;
            }
            int n2 = 0;
            if (bl) {
                n2 += this.\u00d8\u00d30000(sourceConnectorReader, string + "/" + pathCached.getFileName());
            }
            if (bl2) {
                n2 += this.\u00d3\u00d20000(string);
            }
            if (n2 <= 0) continue;
            ++n;
        }
        return n;
    }

    private List<String> buildFileListForMove(String string) throws NotConfiguredException {
        SourceConnectorReader sourceConnectorReader = this.\u00d6O0000().getSourceConnectorFromAssetURLPath(string, this.\u00f800000(false));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object) {
            this.buildFileListFromStorage(string, arrayList);
        } else {
            java.nio.file.Path path = this.\u00f8o0000(string, sourceConnectorReader);
            try {
                this.buildFileListFromSources(string, path, arrayList);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private void buildFileListFromStorage(String string, List<String> list) throws NotConfiguredException {
        java.nio.file.Path path = this.\u00d8o0000().getDirectoryFile(string);
        try {
            this.\u00d5O0000(string);
            PoolList poolList = this.\u00d300000().getListFileContents(path, string);
            for (PoolEntry object : poolList.getFilesAsCollection()) {
                list.add(string + object.o00000);
            }
            for (String string2 : poolList.getDirectoryNameSet()) {
                String string3 = string + string2 + "/";
                list.add(string3);
                this.buildFileListFromStorage(string3, list);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void buildFileListFromSources(String string, java.nio.file.Path path, List<String> list) throws IOException {
        for (PathCached pathCached : FileOperations.listAllFiles(path)) {
            String string2 = pathCached.getFileName();
            list.add(string + string2);
            if (!pathCached.isDirectory()) continue;
            this.buildFileListFromSources(string + string2 + "/", pathCached.getPath(), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionResponse moveDirectory(String string, String string2) {
        ActionResponse actionResponse;
        block37: {
            if (!string.substring(1).contains("/") || !string2.substring(1).contains("/")) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            actionResponse = new ActionResponse();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            try {
                HttpSession httpSession = this.\u00f800000(false);
                SourceManagerSettings sourceManagerSettings = this.\u00d6O0000();
                SourceConnectorReader sourceConnectorReader = sourceManagerSettings.getSourceConnectorFromAssetURLPath(string, httpSession);
                SourceConnectorReader sourceConnectorReader2 = sourceManagerSettings.getSourceConnectorFromAssetURLPath(string2, httpSession);
                PermissionSet permissionSet = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                PermissionSet permissionSet2 = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader2, httpSession, true);
                if (sourceConnectorReader == sourceConnectorReader2) {
                    if (permissionSet == null || !permissionSet.write.moveWithinConnector.booleanValue()) {
                        this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, "Not authorized");
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                } else {
                    if (!(permissionSet != null && permissionSet.read.copy.booleanValue() && permissionSet.list.files.booleanValue() && permissionSet.list.directories.booleanValue() && permissionSet.write.delete.booleanValue())) {
                        this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, "Not authorized");
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                    if (permissionSet2 == null || !permissionSet2.write.paste.booleanValue()) {
                        this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, "Not authorized");
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }
                if (string2.startsWith(string)) {
                    actionResponse.setStatuscode(409);
                    actionResponse.setCause("Failed to rename directory");
                    this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, actionResponse.getCause());
                    return actionResponse;
                }
                java.nio.file.Path path = this.\u00f8o0000(string, sourceConnectorReader);
                if (path == null || Files.notExists(path, new LinkOption[0])) {
                    actionResponse.setStatuscode(404);
                    actionResponse.setCause("Source directory not found.");
                    this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, actionResponse.getCause());
                    return actionResponse;
                }
                java.nio.file.Path path2 = this.\u00f8o0000(string2, sourceConnectorReader2);
                if (path2 != null) {
                    if (!path.equals(path2) && Files.notExists(path2, new LinkOption[0])) {
                        String string322;
                        String string4 = string.substring(0, string.length() - 1);
                        ScannerPauseReason scannerPauseReason = new ScannerPauseReason(string4, ScannerPauseReason.ModificationType.new);
                        String string5 = string.substring(0, string4.lastIndexOf("/"));
                        ScannerPauseReason scannerPauseReason2 = new ScannerPauseReason(string5, ScannerPauseReason.ModificationType.\u00d300000);
                        String string6 = string2.substring(0, string2.length() - 1);
                        String string7 = string2.substring(0, string6.lastIndexOf("/"));
                        if (!permissionSet.write.rename.booleanValue() && string5.equals(string7)) {
                            throw new WebApplicationException(Response.Status.FORBIDDEN);
                        }
                        List<String> list = this.buildFileListForMove(string);
                        boolean bl = false;
                        if (sourceConnectorReader2.isVirtualViewerConnector()) {
                            for (String string322 : list) {
                                if (string322.endsWith("/") || string322.endsWith(".xml") || string322.endsWith(".html")) continue;
                                actionResponse.setStatuscode(403);
                                actionResponse.setCause("Invalid File Type.");
                                return actionResponse;
                            }
                        }
                        ScannerPauseReason scannerPauseReason3 = new ScannerPauseReason(string7, ScannerPauseReason.ModificationType.\u00d300000);
                        string322 = "PK5-" + string4.hashCode();
                        try {
                            this.\u00d6O0000().getScannerDaemon().pauseScanner(string322, scannerPauseReason, scannerPauseReason2, scannerPauseReason3);
                            if (Files.notExists(path2.getParent(), new LinkOption[0])) {
                                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                            }
                            Files.move(path, path2, new CopyOption[0]);
                            this.\u00d6O0000().getLogger().log(3172, string, string2);
                            bl = true;
                            if (bl) {
                                Object object;
                                Object object2;
                                ArrayList<PoolEntry> arrayList;
                                Object object3;
                                Object object4;
                                String string3;
                                for (String object52 : list) {
                                    string3 = object52.substring(string.length());
                                    object4 = string2 + string3;
                                    object3 = this.\u00f8o0000((String)object4, sourceConnectorReader2);
                                    if (Files.isRegularFile((java.nio.file.Path)object3, new LinkOption[0])) {
                                        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object && sourceConnectorReader2.getMountType() == SourceConnectorReader.SourceConnectorType.Object) {
                                            this.\u00f6\u00d20000(object52, (String)object4, sourceConnectorReader, sourceConnectorReader2, false);
                                        } else if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object && sourceConnectorReader2.getMountType() != SourceConnectorReader.SourceConnectorType.Object) {
                                            this.o\u00d30000(object52, sourceConnectorReader);
                                        }
                                    } else if (Files.isDirectory((java.nio.file.Path)object3, new LinkOption[0])) {
                                        if (sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.Object && sourceConnectorReader2.getMountType() == SourceConnectorReader.SourceConnectorType.Object) {
                                            arrayList = new DirectoryImportJob(sourceConnectorReader2, (java.nio.file.Path)object3, (String)object4, FileOperations.getSafeLastModified((java.nio.file.Path)object3), false, false);
                                            this.\u00d6O0000().getScannerDaemon().manuallySubmitDirectory((DirectoryImportJob)((Object)arrayList));
                                        }
                                        arrayList = this.\u00d8o0000().getDirectoryFile(object52);
                                        object2 = this.\u00d8o0000().getDirectoryFile((String)object4);
                                        this.\u00d6O0000().getStorageManager().moveStorageFile((java.nio.file.Path)((Object)arrayList), object52, (java.nio.file.Path)object2, (String)object4);
                                    }
                                    this.\u00d6\u00d30000(object52, (String)object4);
                                    this.\u00d5\u00d30000(sourceConnectorReader, object52, sourceConnectorReader2, (String)object4);
                                }
                                if (!sourceConnectorReader.isVirtualViewerConnector()) {
                                    object = string.substring(0, string.lastIndexOf("/", string.length() - 2));
                                    java.nio.file.Path path3 = this.\u00d8o0000().getDirectoryFile((String)object);
                                    string3 = URL.getParentAssetURLPath((String)object);
                                    object4 = this.\u00d8o0000().getDirectoryFile(string3);
                                    this.oO0000().removeEntry(path3, (String)object, (java.nio.file.Path)object4, string3, path.getFileName().toString(), FileOperations.getSafeLastModified(path.getParent()));
                                    this.\u00d5O0000(string);
                                    this.\u00d5O0000((String)object);
                                }
                                if (!sourceConnectorReader2.isVirtualViewerConnector()) {
                                    object = FileOperations.countDirFiles(path2);
                                    PoolDirectoryEntry poolDirectoryEntry = new PoolDirectoryEntry(path2.getFileName().toString(), FileOperations.getSafeLastModified(path2), (Long)((Pair)object).getItem2(), (Long)((Pair)object).getItem1());
                                    string3 = string2.substring(0, string2.lastIndexOf("/", string2.length() - 2));
                                    object4 = this.\u00d8o0000().getDirectoryFile(string3);
                                    object3 = new PoolDirectoryEntry(path2.getFileName().toString(), FileOperations.getSafeLastModified(path2), poolDirectoryEntry.\u00f500000, poolDirectoryEntry.null);
                                    arrayList = new ArrayList<PoolEntry>();
                                    arrayList.add((PoolEntry)object3);
                                    object2 = URL.getParentAssetURLPath(string3);
                                    java.nio.file.Path path4 = this.\u00d8o0000().getDirectoryFile((String)object2);
                                    this.oO0000().updateEntries((java.nio.file.Path)object4, string3, path4, (String)object2, arrayList, FileOperations.getSafeLastModified(path2.getParent()));
                                    this.\u00d5O0000(string2);
                                    this.\u00d5O0000(string3);
                                    this.\u00d6O0000().getScannerDaemon().getMetaDataAndUpdateSearchDatabase(string3, false);
                                }
                                actionResponse.setStatuscode(200);
                            }
                            break block37;
                        }
                        catch (IOException iOException) {
                            this.\u00d6O0000().getScannerDaemon().reportStorageCorruption(iOException);
                            this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, iOException.getMessage());
                            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
                        }
                        catch (NotConfiguredException notConfiguredException) {
                            actionResponse.setStatuscode(503);
                            actionResponse.setCause("Storage not configured correctly");
                            break block37;
                        }
                        finally {
                            this.\u00d6O0000().getScannerDaemon().resumeScanner(string322);
                        }
                    }
                    this.\u00d6O0000().getLogger().log(3173, string, string2);
                    actionResponse.setStatuscode(409);
                    actionResponse.setCause("Failed to rename directory");
                    break block37;
                }
                actionResponse.setStatuscode(409);
                actionResponse.setCause("Failed to rename directory");
            }
            catch (NotConfiguredException notConfiguredException) {
                throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
            }
        }
        if (actionResponse.getStatuscode() == 200 || actionResponse.getStatuscode() == 201) {
            this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 133, string, string2);
        } else {
            this.\u00d800000().logAccess(this.thisnew(), this.\u00d500000(), 134, string, string2, actionResponse.getCause());
        }
        return actionResponse;
    }
}

