/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.service;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.service.oOOO;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.service.ActionResponse;
import com.neptunelabs.fsiserver.utils.service.JobCreateResponse;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="/{prefix:jobqueue}")
public final class JobQueueService
extends oOOO
implements Serializable {
    private static final long serialVersionUID = -7027361946341987970L;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response createJob(MultivaluedMap<String, String> multivaluedMap) {
        String string = (String)multivaluedMap.getFirst((Object)"cmd");
        multivaluedMap.remove((Object)"cmd");
        if (string != null) {
            if (string.equalsIgnoreCase("createAndStart")) {
                this.checkPermissionsForNewJob(multivaluedMap);
                JobCreateResponse jobCreateResponse = this.createAndStartJob(multivaluedMap);
                Response.ResponseBuilder responseBuilder = Response.status((int)jobCreateResponse.getStatuscode());
                responseBuilder.entity((Object)jobCreateResponse);
                responseBuilder.cacheControl(new);
                return responseBuilder.build();
            }
            if (string.equalsIgnoreCase("cancel")) {
                ActionResponse actionResponse = this.cancelJob((String)multivaluedMap.getFirst((Object)"id"));
                return this.returnsuper(actionResponse);
            }
            if (string.equalsIgnoreCase("restart")) {
                ActionResponse actionResponse = this.restartJob((String)multivaluedMap.getFirst((Object)"id"));
                return this.returnsuper(actionResponse);
            }
        }
        return null;
    }

    private void checkPermissionsForNewJob(MultivaluedMap<String, String> multivaluedMap) {
        HttpSession httpSession = this.\u00f800000(false);
        SourceManagerSettings sourceManagerSettings = this.\u00d6O0000();
        try {
            SourceConnectorReader sourceConnectorReader = sourceManagerSettings.getSourceConnectorFromAssetURLPath("_downloads", httpSession);
            PermissionSet permissionSet = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
            if (permissionSet == null || !permissionSet.write.paste.booleanValue()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            boolean bl = multivaluedMap.containsKey((Object)"renderingquery");
            HashMap<SourceConnectorReader, PermissionSet> hashMap = new HashMap<SourceConnectorReader, PermissionSet>();
            List list = (List)multivaluedMap.get((Object)"file");
            for (String string : list) {
                SourceConnectorReader sourceConnectorReader2 = sourceManagerSettings.getSourceConnectorFromAssetURLPath(string, httpSession);
                PermissionSet permissionSet2 = (PermissionSet)hashMap.get(sourceConnectorReader2);
                if (permissionSet2 == null) {
                    permissionSet2 = sourceManagerSettings.getUserAuthenticationInterface().getPermissions(sourceConnectorReader2, httpSession, true);
                    hashMap.put(sourceConnectorReader2, permissionSet2);
                }
                if (permissionSet2 != null && (!bl || permissionSet2.tasks.batchRendering.booleanValue() && permissionSet2.read.renderedImages.booleanValue()) && (bl || permissionSet2.tasks.createArchive.booleanValue() && permissionSet2.read.files.booleanValue())) continue;
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
        }
        catch (NotConfiguredException notConfiguredException) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    private DownloadJob.ArchiveType determineArchiveType(MultivaluedMap<String, String> multivaluedMap) {
        DownloadJob.ArchiveType archiveType = DownloadJob.ArchiveType.ZIP;
        if (multivaluedMap.containsKey((Object)"archivetype")) {
            String string = (String)multivaluedMap.getFirst((Object)"archivetype");
            if (string.equalsIgnoreCase("tar.gz")) {
                archiveType = DownloadJob.ArchiveType.TAR_GZ;
            } else if (string.equalsIgnoreCase("tar.bz2")) {
                archiveType = DownloadJob.ArchiveType.TAR_BZ2;
            }
        }
        return archiveType;
    }

    private JobCreateResponse createAndStartJob(MultivaluedMap<String, String> multivaluedMap) {
        JobCreateResponse jobCreateResponse = new JobCreateResponse();
        DownloadJobProcessor downloadJobProcessor = this.\u00d3O0000();
        DownloadJob downloadJob = DownloadJob.createJob();
        downloadJob.setArchiveType(this.determineArchiveType(multivaluedMap));
        String string = (String)multivaluedMap.getFirst((Object)"name");
        switch (downloadJob.getArchiveType()) {
            case TAR_GZ: {
                downloadJob.setName(string + ".tar.gz");
                break;
            }
            case TAR_BZ2: {
                downloadJob.setName(string + ".tar.bz2");
                break;
            }
            default: {
                downloadJob.setName(string + ".zip");
            }
        }
        String string2 = this.\u00d500000();
        downloadJob.setCreator(string2);
        downloadJob.setGroups(this.\u00d2O0000());
        TreeSet<String> treeSet = new TreeSet<String>((Collection)multivaluedMap.get((Object)"file"));
        downloadJob.setFiles(treeSet);
        downloadJob.setRenderingQuery((String)multivaluedMap.getFirst((Object)"renderingquery"));
        if (multivaluedMap.containsKey((Object)"scheduleDate")) {
            try {
                downloadJob.setScheduledStart(Long.parseLong((String)multivaluedMap.getFirst((Object)"scheduleDate")));
            }
            catch (NumberFormatException numberFormatException) {
                jobCreateResponse.setStatuscode(500);
                jobCreateResponse.setCause("Invalid value for scheduleDate.");
                return jobCreateResponse;
            }
        }
        if (multivaluedMap.containsKey((Object)"appendfileextension") && ((String)multivaluedMap.getFirst((Object)"appendfileextension")).equals("true")) {
            downloadJob.setReplaceFilenameExtension(false);
        } else {
            downloadJob.setReplaceFilenameExtension(true);
        }
        boolean bl = downloadJobProcessor.enqueueJob(downloadJob);
        if (bl) {
            jobCreateResponse.setId(downloadJob.getId());
            jobCreateResponse.setStatuscode(200);
        } else {
            jobCreateResponse.setStatuscode(500);
            jobCreateResponse.setCause("Error enqueuing job.");
        }
        return jobCreateResponse;
    }

    private ActionResponse cancelJob(String string) {
        DownloadJobProcessor downloadJobProcessor = this.\u00d3O0000();
        boolean bl = downloadJobProcessor.cancelJob(string);
        ActionResponse actionResponse = new ActionResponse();
        if (bl) {
            actionResponse.setStatuscode(200);
        } else {
            actionResponse.setStatuscode(500);
            actionResponse.setCause("Error cancelling job.");
        }
        return actionResponse;
    }

    private ActionResponse restartJob(String string) {
        ActionResponse actionResponse = new ActionResponse();
        if (string == null) {
            actionResponse.setStatuscode(404);
            actionResponse.setCause("No job id specified");
        } else {
            DownloadJobProcessor downloadJobProcessor = this.\u00d3O0000();
            try {
                downloadJobProcessor.restartJob(string);
                actionResponse.setStatuscode(200);
            }
            catch (NoSuchFileException noSuchFileException) {
                actionResponse.setStatuscode(404);
                actionResponse.setCause("Unknown job id");
            }
            catch (IOException iOException) {
                actionResponse.setStatuscode(500);
                actionResponse.setCause("Error reading job details from filesystem.");
            }
        }
        return actionResponse;
    }
}

