/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.comparator.FSIStringComparator;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.helpers.FloatingParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.helper.Decode8BIM;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.RequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashList;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class RendererAbstract
extends RequestHandler {
    static final int \u00f400000 = 0;
    static final int if = 1;
    static final int \u00d3O0000 = 2;
    static final int OO0000 = 3;
    static final double[] oO0000 = new double[]{0.0, 0.0, 1.0, 1.0};
    static final int[] \u00d8O0000 = new int[]{-1, -1, -1, -1};
    final String \u00d800000;
    final RendererEnvironment \u00f800000;
    private final Map<String, PoolFileEntryComparator> thissuper = new HashMap<String, PoolFileEntryComparator>();
    int \u00f4O0000 = 400;
    int \u00d500000 = 300;
    int \u00d5O0000 = 5120;
    int \u00d4O0000 = 2880;
    double[] return = null;
    String \u00f500000 = null;
    private Set<String> while = null;

    RendererAbstract(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings);
        this.\u00d800000 = string;
        this.\u00f800000 = requestProcessorSettings.getRenderEnvironment();
    }

    static void disposeImages(FSIImage ... fSIImageArray) {
        for (FSIImage fSIImage : fSIImageArray) {
            if (fSIImage == null) continue;
            fSIImage.dispose();
        }
    }

    static void getRelativeRangeFromParameters(Parameters parameters, double[] dArray) {
        if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000)) {
            double[] dArray2 = RendererAbstract.parseRangeParameterValue(parameters.get(Parameters.GeneralImage.\u00d3\u00d20000));
            System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
        } else {
            if (parameters.contains(Parameters.GeneralImage.\u00d6\u00d20000)) {
                dArray[0] = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.\u00d6\u00d20000));
            }
            if (parameters.contains(Parameters.GeneralImage.\u00d6\u00d30000)) {
                dArray[1] = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.\u00d6\u00d30000));
            }
            double d = 1.0;
            if (parameters.contains(Parameters.GeneralImage.intnew)) {
                d = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.intnew));
            }
            double d2 = 1.0;
            if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d40000)) {
                d2 = FloatingParser.parseDouble(parameters.get(Parameters.GeneralImage.\u00d3\u00d40000));
            }
            dArray[2] = d2 - dArray[0];
            dArray[3] = d - dArray[1];
        }
        if (!(dArray[2] > 0.0 && dArray[2] <= 1.0 && dArray[3] > 0.0 && dArray[3] <= 1.0)) {
            throw new IllegalArgumentException("Invalid Range in request");
        }
    }

    static double[] parseRangeParameterValue(String string) {
        double[] dArray = new double[4];
        if (string != null) {
            String[] stringArray = string.split(",", 5);
            dArray[0] = FloatingParser.parseDouble(stringArray[0]);
            dArray[1] = FloatingParser.parseDouble(stringArray[1]);
            dArray[2] = FloatingParser.parseDouble(stringArray[2]);
            dArray[3] = FloatingParser.parseDouble(stringArray[3]);
        } else {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 1.0;
            dArray[3] = 1.0;
        }
        return dArray;
    }

    static int[] getReferenceDimensions(Parameters parameters) {
        String string;
        int n = -1;
        int n2 = -1;
        String string2 = parameters.get(Parameters.GeneralImage.\u00f6\u00d20000);
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if ((string = parameters.get(Parameters.GeneralImage.\u00d4\u00d40000)) != null) {
            n2 = Integer.parseInt(string);
        }
        return new int[]{n, n2};
    }

    static String escapeString(String string, Escaper.EscaperType escaperType) {
        if (string == null) {
            return "";
        }
        switch (escaperType) {
            case o00000: {
                return Escaper.escapeForXML(string);
            }
            case \u00d400000: {
                return Escaper.escapeForXMLURI(string);
            }
            case new: {
                return Escaper.escapeForURIXML(string);
            }
            case \u00d500000: {
                return Escaper.escapeForJSON(string);
            }
        }
        return string;
    }

    static RendererTextResponse generateInvalidParameterValueResponse(String string, String string2) {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setStatus(400);
        rendererTextResponse.setContentType("text/plain");
        rendererTextResponse.setStatusMessage("Bad Request: Invalid Parameter value " + string2 + " for parameter " + string);
        return rendererTextResponse;
    }

    static RendererTextResponse generateMissingParameterResponse(String string) {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setStatus(400);
        rendererTextResponse.setContentType("text/plain");
        rendererTextResponse.setStatusMessage("Bad Request.");
        rendererTextResponse.setBody("Bad Request: Missing Parameter " + string);
        return rendererTextResponse;
    }

    static RendererTextResponse generateNotAuthorizedResponse() {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setStatus(403);
        rendererTextResponse.setContentType("text/plain");
        rendererTextResponse.setStatusMessage("Forbidden");
        rendererTextResponse.setBody("Access to one or more of the requested resources denied");
        rendererTextResponse.setCacheable(false);
        return rendererTextResponse;
    }

    static RendererTextResponse generateNotFoundResponse() {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setStatus(404);
        rendererTextResponse.setContentType("text/plain");
        rendererTextResponse.setStatusMessage("Not Found.");
        rendererTextResponse.setBody("One or more of the requested resources could not be found.");
        return rendererTextResponse;
    }

    static RendererTextResponse generateErrorResponse() {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setStatus(500);
        rendererTextResponse.setContentType("text/plain");
        rendererTextResponse.setStatusMessage("Internal Server Error.");
        rendererTextResponse.setBody("The server encountered an error processing your request.");
        return rendererTextResponse;
    }

    static RendererTextResponse generateUnavailableResponse() {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setStatus(503);
        rendererTextResponse.setContentType("text/plain");
        rendererTextResponse.setStatusMessage("Service unavailable.");
        rendererTextResponse.setBody("This service is currently unavailable.");
        return rendererTextResponse;
    }

    static boolean multiSources(String string) {
        return string.contains(",");
    }

    public void addAllowedGroup(String string) {
        if (this.while == null) {
            this.while = new HashSet<String>();
        }
        this.while.add(string);
    }

    public Set<String> getAllowedGroups() {
        return this.while;
    }

    void calculateRendererChecksum() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.getSupportedOptions());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuilder.append(this.getOption(string));
        }
        this.\u00f500000 = stringBuilder.toString();
    }

    public abstract Set<String> getRequiredMetaData();

    public abstract RendererResponse processRequest(HttpServletRequest var1, Map<String, Object> var2) throws ProcessingException, InterruptedException;

    public abstract void setOption(String var1, String var2);

    public abstract String getOption(String var1);

    public abstract Set<String> getSupportedOptions();

    void getPixelRangeFromParameters(Parameters parameters, int[] nArray) {
        if (parameters.contains(Parameters.GeneralImage.supernew)) {
            String[] stringArray = parameters.get(Parameters.GeneralImage.supernew).split(",", 5);
            nArray[0] = Integer.parseInt(stringArray[0]);
            nArray[1] = Integer.parseInt(stringArray[1]);
            nArray[2] = Integer.parseInt(stringArray[2]);
            nArray[3] = Integer.parseInt(stringArray[3]);
        } else {
            this.getPixelRangeFromSeparatedParameters(parameters, nArray);
        }
    }

    private void getPixelRangeFromSeparatedParameters(Parameters parameters, int[] nArray) {
        if (parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000)) {
            nArray[0] = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f4\u00d20000));
        }
        if (parameters.contains(Parameters.GeneralImage.floatObject)) {
            nArray[1] = Integer.parseInt(parameters.get(Parameters.GeneralImage.floatObject));
        }
        int n = -1;
        if (parameters.contains(Parameters.GeneralImage.\u00d2\u00d30000)) {
            n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d2\u00d30000));
        }
        int n2 = -1;
        if (parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000)) {
            n2 = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f8\u00d20000));
        }
        if (nArray[0] != -1 && n2 != -1) {
            nArray[2] = n2 - nArray[0];
        }
        if (nArray[1] != -1 && n != -1) {
            nArray[3] = n - nArray[1];
        }
    }

    boolean checkTemplateAccessRestrictions(TemplateAttributes templateAttributes, HttpSession httpSession) throws NotConfiguredException {
        Set<String> set = templateAttributes.getAllowedGroups();
        if (set != null) {
            if (set.contains("public")) {
                return true;
            }
            if (httpSession != null) {
                String string = (String)httpSession.getAttribute("id");
                String string2 = this.\u00d300000.getUserAuthenticationInterface().getUser(string);
                Set<String> set2 = this.\u00d300000.getUserAuthenticationInterface().getGroupNamesForUser(string2);
                for (String string3 : set2) {
                    if (!set.contains(string3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    Pair<Integer, Boolean> getWidth(String string) {
        int n = -1;
        boolean bl = false;
        if (string == null) {
            n = this.\u00f4O0000;
            bl = true;
        } else {
            try {
                int n2 = Integer.valueOf(string);
                n = n2 < 1 ? 1 : (n2 > this.\u00d5O0000 ? this.\u00d5O0000 : n2);
            }
            catch (NumberFormatException numberFormatException) {
                n = this.\u00f4O0000;
                if (n > this.\u00d5O0000) {
                    n = this.\u00d5O0000;
                }
                bl = true;
            }
        }
        return new Pair<Integer, Boolean>(n, bl);
    }

    Pair<Integer, Boolean> getHeight(String string) {
        int n = -1;
        boolean bl = false;
        if (string == null) {
            n = this.\u00d500000;
            bl = true;
        } else {
            try {
                int n2 = Integer.valueOf(string);
                n = n2 < 1 ? 1 : (n2 > this.\u00d4O0000 ? this.\u00d4O0000 : n2);
            }
            catch (NumberFormatException numberFormatException) {
                n = this.\u00d500000;
                if (n > this.\u00d4O0000) {
                    n = this.\u00d4O0000;
                }
                bl = true;
            }
        }
        return new Pair<Integer, Boolean>(n, bl);
    }

    void sortingPoolList(List<PoolFileEntry> list, PoolEntrySortingField poolEntrySortingField, FSIStringComparator fSIStringComparator, SortDirection sortDirection) {
        PoolFileEntryComparator poolFileEntryComparator = this.getPoolEntryComparator(poolEntrySortingField, fSIStringComparator, sortDirection);
        list.sort(poolFileEntryComparator);
    }

    private PoolFileEntryComparator getPoolEntryComparator(PoolEntrySortingField poolEntrySortingField, FSIStringComparator fSIStringComparator, SortDirection sortDirection) {
        String string = poolEntrySortingField.name() + fSIStringComparator.hashCode() + sortDirection.name();
        PoolFileEntryComparator poolFileEntryComparator = this.thissuper.get(string);
        if (poolFileEntryComparator == null) {
            poolFileEntryComparator = new PoolFileEntryComparator(poolEntrySortingField, fSIStringComparator, sortDirection);
            this.thissuper.put(string, poolFileEntryComparator);
        }
        return poolFileEntryComparator;
    }

    List<DownloadJob> getDownloadsList(HttpSession httpSession) throws NotConfiguredException {
        Set<String> set = this.getGroups(httpSession);
        String string = this.getUsername(httpSession);
        ArrayList<DownloadJob> arrayList = new ArrayList<DownloadJob>(this.getFinishedDownloadJobs(string, set));
        DownloadJobProcessor downloadJobProcessor = this.\u00d300000.getJobProcessor();
        if (downloadJobProcessor != null) {
            List<DownloadJob> list = downloadJobProcessor.getJobs(string, set);
            for (DownloadJob downloadJob : list) {
                if (arrayList.contains(downloadJob)) continue;
                arrayList.add(downloadJob);
            }
        }
        return arrayList;
    }

    private List<DownloadJob> getFinishedDownloadJobs(String string, Set<String> set) {
        ArrayList<DownloadJob> arrayList = new ArrayList<DownloadJob>();
        Path path = this.\u00d400000.getDownloadsFolder();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                DownloadJob downloadJob;
                if (!Files.isRegularFile(path2, new LinkOption[0]) || !path2.getFileName().toString().endsWith(".job") || (downloadJob = DownloadJob.createFromFile(path2)) == null || downloadJob.getUser() == null || downloadJob.getGroups() == null || !downloadJob.getUser().equals(string) && Collections.disjoint(set, downloadJob.getGroups())) continue;
                arrayList.add(downloadJob);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private Set<String> getTrashConnectorsForSession(HttpSession httpSession) throws NotConfiguredException {
        PermissionSet permissionSet = this.\u00d300000.getUserAuthenticationInterface().getPermissions("_trash", httpSession, true);
        if (!permissionSet.list.files.booleanValue()) {
            return new HashSet<String>();
        }
        Set<String> set = this.\u00d300000.getSourceConnectorNames();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (string.equals("_downloads") || string.equals("_trash") || string.equals("_config")) continue;
            PermissionSet permissionSet2 = this.\u00d300000.getUserAuthenticationInterface().getPermissions(this.\u00d300000.getSourceConnector(string), httpSession, true);
            if (!permissionSet2.list.connector.booleanValue() || !permissionSet2.list.files.booleanValue()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    long getTrashLastModified(HttpSession httpSession, ImageBuilder imageBuilder) throws NotConfiguredException {
        Set<String> set = this.getTrashConnectorsForSession(httpSession);
        if (set.size() > 0) {
            long l = 0L;
            for (String string : set) {
                SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnector(string);
                Path path = this.\u00d400000.getTrashFolder(sourceConnectorReader);
                long l2 = FileOperations.getSafeLastModified(path);
                if (l2 <= l) continue;
                l = l2;
            }
            return l;
        }
        return 0L;
    }

    List<TrashListEntry> getTrashList(HttpSession httpSession) throws NotConfiguredException {
        Object object;
        Set<String> set = this.getTrashConnectorsForSession(httpSession);
        ArrayList<TrashListEntry> arrayList = new ArrayList<TrashListEntry>();
        for (String object2 : set) {
            object = this.\u00d300000.getSourceConnector(object2);
            Path path = this.\u00d400000.getTrashFolder((SourceConnectorReader)object);
            TrashList trashList = TrashList.getInstance(path.resolve(".trashlist"));
            for (TrashListEntry trashListEntry : trashList.getList()) {
                trashListEntry.profilePrefix = object2;
                arrayList.add(trashListEntry);
            }
        }
        SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath("_configs", this.getUsername(httpSession));
        if (sourceConnectorReader != null) {
            Path path = this.\u00d400000.getTrashFolder(sourceConnectorReader);
            object = TrashList.getInstance(path.resolve(".trashlist"));
            for (TrashListEntry trashListEntry : ((TrashList)object).getList()) {
                trashListEntry.profilePrefix = sourceConnectorReader.getPrefix();
                arrayList.add(trashListEntry);
            }
        }
        return arrayList;
    }

    void createFallbackResponse(String string, Parameters parameters, short s, RendererResponse rendererResponse) {
        String string2;
        String string3 = null;
        String string4 = null;
        if (s == 2) {
            string2 = this.getOption("importingFallback");
            if (string2 != null) {
                string3 = string2;
            } else {
                string3 = "_service/loading.png";
                string3 = "_service/loading.png";
            }
        } else {
            string3 = s == 5 ? "_service/mime-types/mime_flat.png" : ((string2 = this.getOption("errorFallback")) != null ? string2 : "_service/broken.png");
        }
        boolean bl = parameters.contains(Parameters.GeneralImage.supernew);
        StringBuilder stringBuilder = new StringBuilder("server?");
        for (Map.Entry<Parameters.Parameter, String> entry : parameters.entrySet()) {
            if (entry.getKey() == Parameters.General.\u00f8\u00d40000 || string4 != null && entry.getKey() == Parameters.General.\u00f6\u00d40000 || bl && (entry.getKey() == Parameters.GeneralImage.\u00f6\u00d30000 || entry.getKey() == Parameters.GeneralImage.\u00d8\u00d30000) || entry.getKey() == Parameters.GeneralImage.\u00f6\u00d30000 && entry.getValue().equals("0") || entry.getKey() == Parameters.GeneralImage.\u00d8\u00d30000 && entry.getValue().equals("0")) continue;
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("&");
        }
        stringBuilder.append("source=");
        stringBuilder.append(string3);
        if (string4 != null) {
            stringBuilder.append("&renderer=");
            stringBuilder.append(string4);
        }
        if (string3.equals(string)) {
            rendererResponse.setStatus(500);
        } else {
            rendererResponse.setStatus(307);
            rendererResponse.setHeader("Location", stringBuilder.toString());
        }
    }

    Map getSimpleHashFromMetaData(MetaData metaData, Escaper.EscaperType escaperType, PermissionSet.Read read) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List<Pair<String, String>> list;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("src", RendererAbstract.escapeString(metaData.getAssetURLPath(), escaperType));
        if (metaData instanceof ImageMetaData) {
            list = (ImageMetaData)metaData;
            if (read.basicMetadata.booleanValue()) {
                if (((ImageMetaData)((Object)list)).getWidth() > 0) {
                    hashMap.put("width", ((ImageMetaData)((Object)list)).getWidth());
                }
                if (((ImageMetaData)((Object)list)).getHeight() > 0) {
                    hashMap.put("height", ((ImageMetaData)((Object)list)).getHeight());
                }
                hashMap.put("alpha", Boolean.toString(((ImageMetaData)((Object)list)).hasAlpha()));
            }
            if (read.storageStatus.booleanValue() && ((ImageMetaData)((Object)list)).getImportStatus() != 0) {
                hashMap.put("importstatus", ((ImageMetaData)((Object)list)).getImportStatus());
                if (((ImageMetaData)((Object)list)).getImportTime() > 0L) {
                    hashMap.put("importtimestamp", ((ImageMetaData)((Object)list)).getImportTime());
                }
            }
            if (read.extendedMetadata.booleanValue()) {
                object4 = ((ImageMetaData)((Object)list)).getICC();
                if (object4 != null) {
                    hashMap.put("icc", ((ICCProfileWrap)object4).getName());
                }
                if (((ImageMetaData)((Object)list)).getZoomLevels() != null && ((ImageMetaData)((Object)list)).getZoomLevels().length > 0) {
                    hashMap.put("levels", this.getZoomLevelSequence(((ImageMetaData)((Object)list)).getZoomLevels()));
                }
                if ((object3 = ((ImageMetaData)((Object)list)).getSelections()) != null && (object2 = Decode8BIM.getSelectionNames((byte[])object3)) != null) {
                    hashMap.put("selections", this.getSelectionsSimpleSequence((String[])object2, escaperType));
                }
                if ((object2 = ((ImageMetaData)((Object)list)).getAlphaNames()) != null && ((String[])object2).length == ((ImageMetaData)((Object)list)).getExtraAlphaCount()) {
                    hashMap.put("alphanames", this.getSelectionsSimpleSequence((String[])object2, escaperType));
                } else if (((ImageMetaData)((Object)list)).getExtraAlphaCount() > 0) {
                    object = new ArrayList<String>();
                    for (int i = 0; i < ((ImageMetaData)((Object)list)).getExtraAlphaCount(); ++i) {
                        object.add("Unnamed");
                    }
                    hashMap.put("alphanames", object);
                }
            }
        }
        if (metaData instanceof FileMetaData) {
            hashMap.put("type", "file");
            if (read.basicMetadata.booleanValue()) {
                list = (FileMetaData)metaData;
                hashMap.put("size", ((FileMetaData)((Object)list)).getSourceFileSize());
            }
        } else if (metaData instanceof DirectoryMetaData) {
            hashMap.put("type", "directory");
            if (read.basicMetadata.booleanValue()) {
                list = (DirectoryMetaData)metaData;
                hashMap.put("files", ((DirectoryMetaData)((Object)list)).getFiles());
                hashMap.put("directories", ((DirectoryMetaData)((Object)list)).getSubdirectories());
            }
        }
        if (read.basicMetadata.booleanValue() && metaData.getLastModified() > 0L) {
            hashMap.put("lastmodified", metaData.getLastModified());
        }
        if (read.extendedMetadata.booleanValue()) {
            list = metaData.getSortedIPTCList();
            if (!list.isEmpty()) {
                object4 = this.getFieldnamesFromList(list, escaperType);
                if (object4.size() > 0) {
                    hashMap.put("iptclist", object4);
                }
                if ((object3 = (Object)this.getSimpleHashFromList(list, escaperType)).size() > 0) {
                    hashMap.put("iptc", object3);
                }
            }
            if (!(object4 = metaData.getExifSortedMap(this.\u00d300000.getLogger(), metaData.getAssetURLPath(), true)).isEmpty()) {
                object3 = this.getExifSimpleSequence((Map<Integer, Pair<String, String>>)object4, escaperType);
                if (object3.size() > 0) {
                    hashMap.put("exiflist", object3);
                }
                if ((object2 = this.getExifSimpleHash((Map<Integer, Pair<String, String>>)object4, escaperType)).size() > 0) {
                    hashMap.put("exif", object2);
                }
            }
            if (!(object3 = metaData.getSortedFSIList()).isEmpty()) {
                object2 = this.getFieldnamesFromList((List<Pair<String, String>>)object3, escaperType);
                if (object2.size() > 0) {
                    hashMap.put("fsilist", object2);
                }
                if ((object = this.getSimpleHashFromList((List<Pair<String, String>>)object3, escaperType)).size() > 0) {
                    hashMap.put("fsi", object);
                }
            }
        }
        return hashMap;
    }

    List<PoolFileEntry> limitList(List<PoolFileEntry> list, int n, int n2) {
        LinkedList<PoolFileEntry> linkedList = new LinkedList<PoolFileEntry>();
        if (n2 == -1) {
            n2 = list.size();
        }
        int n3 = Math.min(n + n2, list.size());
        for (int i = n; i < n3; ++i) {
            linkedList.add(list.get(i));
        }
        return linkedList;
    }

    private List getFieldnamesFromList(List<Pair<String, String>> list, Escaper.EscaperType escaperType) {
        ArrayList arrayList = new ArrayList();
        for (Pair<String, String> pair : list) {
            if (pair.getItem1() == null || pair.getItem2() == null || pair.getItem1().equalsIgnoreCase("directory version")) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("key", RendererAbstract.escapeString(pair.getItem1(), escaperType));
            hashMap.put("name", RendererAbstract.escapeString(pair.getItem2(), escaperType));
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private Map getSimpleHashFromList(List<Pair<String, String>> list, Escaper.EscaperType escaperType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Pair<String, String> pair : list) {
            if (pair.getItem1() == null || pair.getItem2() == null || pair.getItem1().equalsIgnoreCase("directory version")) continue;
            hashMap.put(RendererAbstract.escapeString(pair.getItem1(), escaperType), RendererAbstract.escapeString(pair.getItem2(), escaperType));
        }
        return hashMap;
    }

    private List getExifSimpleSequence(Map<Integer, Pair<String, String>> map, Escaper.EscaperType escaperType) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<Integer, Pair<String, String>> entry : map.entrySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("key", RendererAbstract.escapeString(entry.getValue().getItem1(), escaperType));
            hashMap.put("name", RendererAbstract.escapeString(entry.getValue().getItem2(), escaperType));
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private Map getExifSimpleHash(Map<Integer, Pair<String, String>> map, Escaper.EscaperType escaperType) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<Integer, Pair<String, String>> entry : map.entrySet()) {
            hashMap.put(RendererAbstract.escapeString(entry.getValue().getItem1(), escaperType), RendererAbstract.escapeString(entry.getValue().getItem2(), escaperType));
        }
        return hashMap;
    }

    private List getSelectionsSimpleSequence(String[] stringArray, Escaper.EscaperType escaperType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(RendererAbstract.escapeString(string, escaperType));
        }
        return arrayList;
    }

    private List getZoomLevelSequence(Level[] levelArray) {
        ArrayList arrayList = new ArrayList();
        for (Level level : levelArray) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("width", level.\u00d400000);
            hashMap.put("height", level.o00000);
            hashMap.put("tilewidth", level.Object);
            hashMap.put("tileheight", level.\u00d200000);
            arrayList.add(hashMap);
        }
        return arrayList;
    }
}

