/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StitchInfoRenderer
extends RendererAbstract {
    public StitchInfoRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
    }

    @Override
    public String getOption(String string) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        if (!parameters.contains(Parameters.General.\u00f8\u00d40000)) {
            return StitchInfoRenderer.generateMissingParameterResponse("source");
        }
        String[] stringArray = parameters.get(Parameters.General.\u00f8\u00d40000).split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = URL.cleanUpSourceParameter(stringArray[i]);
        }
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        ArrayList<ImageMetaData> arrayList = new ArrayList<ImageMetaData>();
        try {
            Object object;
            Object object2;
            String string = parameters.contains(Parameters.General.\u00f4\u00d40000) ? parameters.get(Parameters.General.\u00f4\u00d40000) : "info";
            Template template = this.\u00d300000.getTemplateCache().getTemplate(TemplateType.new, string + ".ftl");
            TemplateAttributes templateAttributes = new TemplateAttributes(this.new, template);
            if (!this.checkTemplateAccessRestrictions(templateAttributes, httpSession)) {
                return StitchInfoRenderer.generateNotAuthorizedResponse();
            }
            for (String object32 : stringArray) {
                object2 = this.\u00d300000.getUserAuthenticationInterface().getPermissions(object32, httpSession, true);
                if (object2 != null && ((PermissionSet)object2).read.basicMetadata.booleanValue() && ((PermissionSet)object2).read.extendedMetadata.booleanValue()) continue;
                return StitchInfoRenderer.generateNotAuthorizedResponse();
            }
            for (String string2 : stringArray) {
                object2 = this.\u00d300000.getSourceConnectorFromAssetURLPath(string2);
                object = this.\u00d300000.getImageBuilder().getImageMetaData((SourceConnectorReader)object2, string2, 0, true, httpServletRequest.getSession(false));
                ((MetaData)object).setAssetURLPath(string2);
                if (!(object instanceof ImageMetaData)) continue;
                arrayList.add((ImageMetaData)object);
            }
            templateAttributes.setRendererResponseContentType(rendererTextResponse);
            boolean bl = false;
            for (ImageMetaData imageMetaData : arrayList) {
                if (imageMetaData.getImportStatus() == 1 || bl) continue;
                bl = true;
                rendererTextResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            }
            rendererTextResponse.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(arrayList));
            HashMap hashMap = new HashMap();
            hashMap.put("type", "file");
            Pair<Integer, Integer> pair = StitchRendererUtils.getTotalDimensions(arrayList, parameters);
            hashMap.put("width", pair.getItem1());
            hashMap.put("height", pair.getItem2());
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("info", hashMap);
            hashMap2.put("query", parameters);
            object2 = new StringWriterFast();
            object = null;
            try {
                Environment environment = template.createProcessingEnvironment(hashMap2, (Writer)object2);
                environment.process();
                rendererTextResponse.setBody(((StringWriterFast)object2).toString());
                rendererTextResponse.setStatus(200);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((StringWriterFast)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((StringWriterFast)object2).close();
                    }
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return StitchInfoRenderer.generateNotFoundResponse();
        }
        catch (TemplateException | IOException throwable) {
            rendererTextResponse.setStatus(500);
            this.new.logException((Exception)throwable, 3191, throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererTextResponse.setStatus(503);
            this.new.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
        }
        return rendererTextResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String string, String string2) {
    }
}

