/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TrashList {
    private static final Map<Path, TrashList> String = new HashMap<Path, TrashList>();
    private final Path \u00d200000;
    private long o00000 = -1L;
    private Set<TrashListEntry> \u00d300000;

    private TrashList(Path path) {
        this.\u00d200000 = path;
    }

    public static synchronized TrashList getInstance(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Can't create TrashList without file.");
        }
        if (String.containsKey(path)) {
            return String.get(path);
        }
        TrashList trashList = new TrashList(path);
        String.put(path, trashList);
        return trashList;
    }

    public Set<TrashListEntry> getList() {
        this.readFromFile();
        return new HashSet<TrashListEntry>(this.\u00d300000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(TrashListEntry trashListEntry) {
        Path path = this.\u00d200000;
        synchronized (path) {
            this.readFromFile();
            this.\u00d300000.add(trashListEntry);
            return this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEntry(String string) {
        Path path = this.\u00d200000;
        synchronized (path) {
            this.readFromFile();
            TrashListEntry trashListEntry = null;
            for (TrashListEntry trashListEntry2 : this.\u00d300000) {
                if (!trashListEntry2.trashID.equals(string)) continue;
                trashListEntry = trashListEntry2;
                break;
            }
            if (trashListEntry != null) {
                this.\u00d300000.remove(trashListEntry);
            }
            return this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrashListEntry getEntryByHash(String string) {
        Path path = this.\u00d200000;
        synchronized (path) {
            this.readFromFile();
            TrashListEntry trashListEntry = null;
            for (TrashListEntry trashListEntry2 : this.\u00d300000) {
                if (!trashListEntry2.trashID.equals(string)) continue;
                trashListEntry = trashListEntry2;
                break;
            }
            return trashListEntry;
        }
    }

    private void readFromFile() {
        try {
            long l = Files.getLastModifiedTime(this.\u00d200000, new LinkOption[0]).toMillis();
            if (this.\u00d300000 == null || l != this.o00000) {
                this.\u00d300000 = (Set)FileOperations.readObjectFromFile(this.\u00d200000);
                this.o00000 = l;
            }
        }
        catch (Exception exception) {
            this.\u00d300000 = new HashSet<TrashListEntry>();
        }
    }

    private boolean writeToFile() {
        try {
            FileOperations.writeObjectToFile(this.\u00d200000, this.\u00d300000);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

