/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.encoder.jpegturbo;

import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoder;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.jpegturbo.JPEGTurboPreparation;
import com.neptunelabs.fsiserver.imagereader.JPEGInjector;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJException;

public final class JPEGTurboEncoder
extends ImageEncoderUtils
implements ImageEncoder {
    private final TJCompressor newObject = new TJCompressor();
    private final JPEGTurboPreparation \u00f5\u00d30000;
    private final int \u00f8\u00d30000;
    private byte[] \u00f6\u00d30000;

    public JPEGTurboEncoder(FSILogger fSILogger, JPEGTurboPreparation jPEGTurboPreparation) throws TJException {
        super(fSILogger);
        this.\u00f5\u00d30000 = jPEGTurboPreparation;
        this.\u00f8\u00d30000 = jPEGTurboPreparation.isProgressive() ? 16384 : 0;
    }

    @Override
    public void encode() throws IOException {
        this.newObject.setJPEGQuality(this.\u00f5\u00d30000.getQuality());
        this.newObject.setSubsamp(this.\u00f5\u00d30000.getChromaSubsampling());
        int n = this.\u00d300000.getWidth();
        int n2 = this.\u00d300000.getHeight();
        int n3 = TJ.bufSize(n, n2, this.\u00f5\u00d30000.getChromaSubsampling());
        byte[] byArray = new byte[n3];
        int n4 = 5;
        byte[] byArray2 = new byte[n * n2 * 4];
        this.\u00d300000.getSampleRangeBytes(0, 0, n - 1, n2 - 1, byArray2);
        this.newObject.setSourceImage(byArray2, 0, 0, n, 0, n2, n4);
        this.newObject.compress(byArray, this.\u00f8\u00d30000);
        int n5 = this.newObject.getCompressedSize();
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray, 0, byArray3, 0, n5);
        JPEGInjector jPEGInjector = new JPEGInjector(byArray3, this.\u00f5\u00d30000.getDPI());
        if (this.\u00f5\u00d30000.getComment() != null) {
            jPEGInjector.insertCommentSegment((byte)-2, this.\u00f5\u00d30000.getComment().getBytes(StandardCharsets.US_ASCII));
        }
        if (this.\u00f5\u00d30000.getICC() != null) {
            jPEGInjector.insertSegment((byte)-30, this.\u00f5\u00d30000.getICC());
        }
        if (this.\u00f600000 != null && this.\u00f600000.length() > 0) {
            jPEGInjector.insertSegment((byte)-18, this.\u00f600000.getBytes(StandardCharsets.US_ASCII));
        }
        this.\u00f6\u00d30000 = jPEGInjector.rebuild();
    }

    public byte[] getData() {
        return this.\u00f6\u00d30000;
    }

    @Override
    public void setImage(FSIImage fSIImage) {
        this.\u00d300000 = fSIImage;
    }

    @Override
    public String getName() {
        return "JPEGTurboEncoder";
    }

    @Override
    public void dispose() {
        try {
            this.newObject.close();
        }
        catch (TJException tJException) {
            // empty catch block
        }
    }
}

