/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader;

import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.ImageFormatScanner;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderAbstract;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderBMP;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderFPX;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderGIF;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderJPEG;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderPNG;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderTIFF;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderTM;
import java.io.IOException;
import java.nio.file.NoSuchFileException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MetaScanner {
    private final FSILogger new;
    private boolean o00000;
    private int \u00d300000 = 0;

    public MetaScanner(FSILogger fSILogger) {
        this.new = fSILogger;
    }

    public FSIMetaData scanImage(PathCached pathCached, boolean bl) throws NoSuchFileException, IOException {
        ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
        ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
        MetaReaderAbstract metaReaderAbstract = null;
        if (imageFormat.\u00d400000) {
            switch (imageFormat.o00000) {
                case \u00d400000: {
                    metaReaderAbstract = new MetaReaderJPEG(this.new, imageFormat);
                    break;
                }
                case \u00f400000: {
                    metaReaderAbstract = new MetaReaderTIFF(this.new, imageFormat);
                    break;
                }
                case Object: {
                    metaReaderAbstract = new MetaReaderPNG(this.new, imageFormat);
                    break;
                }
                case \u00f600000: {
                    metaReaderAbstract = new MetaReaderGIF(this.new, imageFormat);
                    break;
                }
                case \u00d200000: {
                    metaReaderAbstract = new MetaReaderBMP(this.new, imageFormat);
                    break;
                }
                case void: {
                    metaReaderAbstract = new MetaReaderFPX(this.new, imageFormat);
                    break;
                }
                case \u00d600000: {
                    metaReaderAbstract = new MetaReaderTM(this.new, imageFormat);
                    break;
                }
                default: {
                    this.o00000 = true;
                    break;
                }
            }
        } else {
            this.o00000 = true;
        }
        if (this.o00000) {
            this.new.log(3810, "MetaScanner: " + pathCached);
        }
        FSIMetaData fSIMetaData = new FSIMetaData(pathCached);
        fSIMetaData.\u00d200000 = imageFormat;
        if (metaReaderAbstract != null) {
            metaReaderAbstract.scanImage(pathCached, bl);
            if (metaReaderAbstract.hasError()) {
                this.o00000 = true;
                this.\u00d300000 = metaReaderAbstract.getErrorCode();
            } else {
                fSIMetaData = metaReaderAbstract.getMetaData();
            }
        }
        if (fSIMetaData == null) {
            fSIMetaData = new FSIMetaData(pathCached);
        }
        if (bl) {
            fSIMetaData.\u00d500000 = pathCached.lastModified();
            fSIMetaData.\u00d2O0000 = pathCached.size();
        }
        return fSIMetaData;
    }

    public boolean hasError() {
        return this.o00000;
    }

    public int getErrorCode() {
        return this.\u00d300000;
    }
}

