/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.reader;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.MemoryManager;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imageio.SeekableByteChannelImageInputStream;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.fsiserver.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.imagereader.reader.ConverterImageReaderAbstract;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.NoSuchFileException;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ConverterImageReaderTIFF
extends ConverterImageReaderAbstract {
    public static final int O\u00d20000 = 259;
    private static final long \u00f8o0000 = 0x1000000L;

    public ConverterImageReaderTIFF(FSILogger fSILogger, SwapPool swapPool, BufferedImageConverter bufferedImageConverter, ByteOrder byteOrder, boolean bl) {
        super(fSILogger, swapPool, bufferedImageConverter, byteOrder, bl, 259);
    }

    @Override
    public void setFile(FSIMetaData fSIMetaData) {
        long l;
        this.voidsuper = fSIMetaData;
        if (fSIMetaData.\u00d2O0000 > 0xFFFFFFFEL) {
            if (this.\u00d200000 != null) {
                this.\u00d200000.log(3806, fSIMetaData.o00000);
            }
            this.Oo0000 = true;
        }
        if (!(this.Oo0000 || (l = 4L * (long)fSIMetaData.getWidth() * (long)fSIMetaData.getHeight()) <= MemoryManager.getFreeHeapSpace() && l <= Integer.MAX_VALUE)) {
            this.Objectsuper = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage() throws IOException {
        this.\u00d400000 = true;
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl = false;
        if (this.\u00d8O0000 && this.voidsuper.\u00d2O0000 < this.interface) {
            bl = true;
            byteArrayInputStream = new ByteArrayInputStream(FileOperations.readFile(this.\u00d200000, this.voidsuper.null.getPath()));
        }
        ImageInputStream imageInputStream = null;
        try {
            imageInputStream = byteArrayInputStream == null ? new SeekableByteChannelImageInputStream(this.voidsuper.null.getPath()) : ImageIO.createImageInputStream(byteArrayInputStream);
        }
        catch (NoSuchFileException noSuchFileException) {
            this.\u00d200000.logException(noSuchFileException, 3801, this.voidsuper.o00000);
            this.Oo0000 = true;
        }
        catch (IOException iOException) {
            this.\u00d200000.logException(iOException, 3802, this.voidsuper.o00000);
            this.Oo0000 = true;
        }
        TIFFImageReader tIFFImageReader = new TIFFImageReader(new TIFFImageReaderSpi());
        if (!this.Oo0000 && imageInputStream != null) {
            boolean bl2 = this.isOldFSITool(this.voidsuper.getImage().\u00f500000);
            tIFFImageReader.setIsOldFSITool(bl2);
            tIFFImageReader.setInput(imageInputStream);
            try {
                Object object;
                int n;
                int n2;
                int n3;
                int n4;
                FSIImageMode fSIImageMode = this.voidsuper.\u00f500000 ? FSIImageMode.new : FSIImageMode.o00000;
                this.\u00f4O0000 = this.Objectsuper || this.\u00d2O0000 ? new FSIImageUnlimited(this.\u00d200000, this.super, this.\u00d2o0000, this.voidsuper.getWidth(), this.voidsuper.getHeight(), this.voidsuper.o00000, fSIImageMode, null, false) : new FSIImageLimited(this.\u00d200000, this.super, this.\u00d2o0000, this.voidsuper.getWidth(), this.voidsuper.getHeight(), this.voidsuper.o00000, fSIImageMode, this.Objectsuper | this.\u00d2O0000);
                if (this.voidsuper.private > 0 && (n4 = this.voidsuper.private) > 0) {
                    this.\u00f4O0000.createExtraAlpha(n4);
                }
                this.voidsuper.getSamplesPerPixel();
                if (this.\u00d4o0000) {
                    this.voidsuper.oO0000 = new Histogram();
                }
                n4 = this.voidsuper.getWidth();
                int n5 = this.voidsuper.getHeight();
                int n6 = this.voidsuper.getTileWidth();
                int n7 = this.voidsuper.getTileHeight();
                if (n6 == -1) {
                    n6 = n4;
                }
                if (n7 == -1) {
                    n7 = n5;
                }
                int n8 = (int)Math.ceil((float)n4 / (float)n6);
                int n9 = (int)Math.ceil((float)n5 / (float)n7);
                int n10 = n8 * n9;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                boolean bl3 = false;
                long l = 4L * (long)n6 * (long)n7;
                if (l > MemoryManager.getFreeHeapSpace() || l > 0x1000000L) {
                    bl3 = true;
                }
                if ((n3 = (n2 = n6 * n7 * 4) * (n = 1000)) > 0x7800000 && (n = (int)Math.floor(0x7800000 / n2)) < 1) {
                    n = 1;
                }
                boolean bl4 = true;
                ExecutorService executorService = ExecutorPool.createExecutorService("Reader TIFF", ExecutorPool.getMaxCPUThreads(), 1);
                LinkedList<CompletableFuture<Boolean>> linkedList = new LinkedList<CompletableFuture<Boolean>>();
                while (n11 < n10 && !this.\u00f6O0000 && !this.Oo0000) {
                    n14 = n12;
                    n15 = n13;
                    object = tIFFImageReader.readTile(0, n12, n13);
                    BufferedImageWrap bufferedImageWrap = new BufferedImageWrap((BufferedImage)object, this.\u00d3o0000.getClutCache());
                    bufferedImageWrap.setDefaultICCProfiles(this.\u00d4O0000, this.floatsuper, this.\u00d600000);
                    bufferedImageWrap.setICCProfile(this.voidsuper.getICC());
                    bufferedImageWrap.setSawAdobeMarker(this.voidsuper.String);
                    bufferedImageWrap.setUseFallbackConverter(this.\u00d6O0000);
                    bufferedImageWrap.initColorConverter(this.voidsuper.\u00f600000);
                    bufferedImageWrap.\u00f5O0000 = this.voidsuper.oO0000;
                    bufferedImageWrap.\u00f600000 = this.voidsuper.o00000;
                    if (this.voidsuper.\u00d3O0000 != -1) {
                        bufferedImageWrap.setAlphaBand(this.voidsuper.\u00d3O0000);
                        bufferedImageWrap.setHasAlpha(true);
                        bufferedImageWrap.setIsAlphaPremultiplied(this.voidsuper.\u00d800000);
                        bufferedImageWrap.setAlphaStart(this.voidsuper.\u00d3O0000);
                    }
                    int n16 = n14 * n6;
                    int n17 = n15 * n7;
                    ReaderHelperAbstact._o _o2 = new ReaderHelperAbstact._o(bufferedImageWrap, this.\u00d3o0000, this.\u00f4O0000, n16, n17);
                    linkedList.add(CompletableFuture.supplyAsync(_o2, executorService));
                    if (++n14 == n8) {
                        CompletableFuture completableFuture;
                        n14 = 0;
                        ++n15;
                        while ((completableFuture = (CompletableFuture)linkedList.poll()) != null) {
                            bl4 &= ((Boolean)completableFuture.get()).booleanValue();
                        }
                    }
                    if (++n12 == n8) {
                        n12 = 0;
                        ++n13;
                    }
                    ++n11;
                }
                while ((object = (CompletableFuture)linkedList.poll()) != null) {
                    bl4 &= ((Boolean)((CompletableFuture)object).get()).booleanValue();
                }
                if (!(bl4 &= ExecutorPool.shutdownAndWait(executorService, linkedList, 60))) {
                    this.Oo0000 = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                this.\u00d200000.logException(nullPointerException, 3804, this.voidsuper.o00000, "1 " + nullPointerException.getLocalizedMessage());
                this.Oo0000 = true;
            }
            catch (FSIImageException fSIImageException) {
                this.\u00d200000.logException(fSIImageException, 3804, this.voidsuper.o00000, "2 " + fSIImageException.getLocalizedMessage());
                this.Oo0000 = true;
            }
            catch (ExecutionException executionException) {
                if (!this.\u00f6O0000) {
                    this.\u00d200000.logException(executionException, 3804, this.voidsuper.o00000, "3 " + executionException.getLocalizedMessage());
                }
                this.Oo0000 = true;
            }
            catch (InterruptedException | ClosedByInterruptException exception) {
                exception.printStackTrace();
                this.\u00f800000 = true;
            }
            catch (Exception exception) {
                this.\u00d200000.logException(exception, 3804, this.voidsuper.o00000, "4 " + exception.getLocalizedMessage());
                this.Oo0000 = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.\u00d200000.logError(outOfMemoryError, 3804, this.voidsuper.o00000, "5 " + outOfMemoryError.getLocalizedMessage());
                this.Oo0000 = true;
            }
            catch (Error error) {
                this.\u00d200000.logError(error, 3804, this.voidsuper.o00000, "6 " + error.getLocalizedMessage());
                this.Oo0000 = true;
            }
            finally {
                tIFFImageReader.reset();
                tIFFImageReader.dispose();
                this.closeReaderInput(tIFFImageReader);
                this.OO0000 = true;
            }
        }
        if (imageInputStream != null) {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.voidsuper.oO0000 != null) {
            this.voidsuper.oO0000.digest();
        }
        return !this.Oo0000;
    }

    @Override
    public void destroy() {
        this.shutdown();
        if (this.\u00d400000) {
            while (!this.OO0000 && !this.Oo0000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        super.destroy();
    }

    private void closeReaderInput(ImageReader imageReader) {
        if (imageReader == null) {
            return;
        }
        Object object = imageReader.getInput();
        if (object != null && object instanceof ImageInputStream) {
            try {
                ((ImageInputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

