/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DirectoryImageRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.FreemarkerEntityFixer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class FirstAssetInfoRenderer
extends RendererAbstract {
    private final SortingParameters \u00d5\u00d60000 = new SortingParameters();
    private final ImageBuilder \u00d4\u00d60000;
    private int thisclass = 32;

    public FirstAssetInfoRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.\u00d4\u00d60000 = requestProcessorSettings.getImageBuilder();
        this.\u00d5\u00d60000.\u00d300000 = RendererEnvironment.\u00d400000;
        this.\u00d5\u00d60000.for = RendererEnvironment.\u00f500000;
        this.\u00d5\u00d60000.o00000 = RendererEnvironment.o00000;
        this.\u00d5\u00d60000.\u00f500000 = this.\u00f800000.getDefaultSortLanguage();
        this.\u00d5\u00d60000.\u00f800000 = this.\u00f800000.getDefaultSortCountry();
        this.\u00d5\u00d60000.\u00d800000 = false;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxImages")) {
            string2 = String.valueOf(this.thisclass);
        } else if (string.equalsIgnoreCase("defaultsortfield")) {
            string2 = this.\u00d5\u00d60000.\u00d300000.name();
        } else if (string.equalsIgnoreCase("forcesortfield") && this.\u00d5\u00d60000.\u00d200000 != null) {
            string2 = this.\u00d5\u00d60000.\u00d200000.name();
        } else if (string.equalsIgnoreCase("defaultsortorder")) {
            string2 = this.\u00d5\u00d60000.for.name();
        } else if (string.equalsIgnoreCase("forcesortorder") && this.\u00d5\u00d60000.\u00f600000 != null) {
            string2 = this.\u00d5\u00d60000.\u00f600000.name();
        } else if (string.equalsIgnoreCase("defaultsortmethod")) {
            string2 = this.\u00d5\u00d60000.o00000.name();
        } else if (string.equalsIgnoreCase("forcesortmethod") && this.\u00d5\u00d60000.oO0000 != null) {
            string2 = this.\u00d5\u00d60000.oO0000.name();
        } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
            string2 = this.\u00d5\u00d60000.\u00f500000;
        } else if (string.equalsIgnoreCase("forcesortlanguage")) {
            string2 = this.\u00d5\u00d60000.null;
        } else if (string.equalsIgnoreCase("defaultsortcountry")) {
            string2 = this.\u00d5\u00d60000.\u00f800000;
        } else if (string.equalsIgnoreCase("forcesortcountry")) {
            string2 = this.\u00d5\u00d60000.\u00d600000;
        } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
            string2 = Boolean.toString(this.\u00d5\u00d60000.\u00d800000);
        } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
            string2 = Boolean.toString(this.\u00d5\u00d60000.\u00d500000);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        try {
            this.processRequest1(httpServletRequest, rendererTextResponse);
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererTextResponse.setStatus(503);
        }
        catch (TemplateException | IOException throwable) {
            rendererTextResponse.setStatus(500);
        }
        return rendererTextResponse;
    }

    private RendererResponse processRequest1(HttpServletRequest httpServletRequest, RendererTextResponse rendererTextResponse) throws NotConfiguredException, IOException, TemplateException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string = parameters.getAssetURLPath();
        HttpSession httpSession = httpServletRequest.getSession(false);
        SourceConnectorReader sourceConnectorReader = this.\u00d300000.getSourceConnectorFromAssetURLPath(string, httpSession);
        String string2 = parameters.contains(Parameters.General.\u00f4\u00d40000) ? parameters.get(Parameters.General.\u00f4\u00d40000) : "info";
        Template template = this.\u00d300000.getTemplateCache().getTemplate(TemplateType.new, string2 + ".ftl");
        TemplateAttributes templateAttributes = new TemplateAttributes(this.new, template);
        if (!this.checkTemplateAccessRestrictions(templateAttributes, httpSession)) {
            return FirstAssetInfoRenderer.generateNotAuthorizedResponse();
        }
        PermissionSet permissionSet = this.\u00d300000.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
        if (permissionSet == null || !permissionSet.read.basicMetadata.booleanValue()) {
            return FirstAssetInfoRenderer.generateNotAuthorizedResponse();
        }
        String string3 = this.getFirstAsset(parameters, sourceConnectorReader, string, httpSession);
        if (string3 != null) {
            Escaper.EscaperType escaperType = templateAttributes.getStaticEscape();
            int n = templateAttributes.getReadFlag();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("query", parameters);
            MetaData metaData = this.\u00d4\u00d60000.getImageMetaData(sourceConnectorReader, string3, n, true, httpSession);
            Map map = this.getSimpleHashFromMetaData(metaData, escaperType, permissionSet.read);
            templateAttributes.setRendererResponseContentType(rendererTextResponse);
            rendererTextResponse.setDateHeader("Last-Modified", metaData.getLastModified());
            if (metaData instanceof ImageMetaData && ((ImageMetaData)metaData).getImportStatus() != 1) {
                rendererTextResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            }
            hashMap.put("info", map);
            hashMap.put("entityFixer", new FreemarkerEntityFixer());
            try (StringWriterFast stringWriterFast = new StringWriterFast();){
                Environment environment = template.createProcessingEnvironment(hashMap, (Writer)stringWriterFast);
                environment.process();
                rendererTextResponse.setBody(stringWriterFast.toString());
                String string4 = String.valueOf(metaData.hashCode()) + template.getCustomAttribute("checksum");
                rendererTextResponse.setETagModifier(string4);
                rendererTextResponse.setStatus(200);
            }
        } else {
            rendererTextResponse.setStatus(404);
        }
        return rendererTextResponse;
    }

    private String getFirstAsset(Parameters parameters, SourceConnectorReader sourceConnectorReader, String string, HttpSession httpSession) throws IOException, NotConfiguredException {
        Object object;
        Object object2;
        PoolFileEntryComparator poolFileEntryComparator = DirectoryImageRendererUtils.getComparator(parameters, this.\u00d5\u00d60000);
        int n = 0;
        int n2 = this.thisclass;
        if (parameters.contains(Parameters.DirectoryImage.\u00d2\u00d60000)) {
            try {
                object2 = parameters.get(Parameters.DirectoryImage.\u00d2\u00d60000);
                object = ((String)object2).split(",", 2);
                if (((String[])object).length == 1) {
                    n2 = Integer.parseInt((String)object[0]);
                } else if (((Object)object).length == 2) {
                    n2 = Integer.parseInt((String)object[1]);
                    n = Integer.parseInt((String)object[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((object = ((PoolList)(object2 = this.\u00d4\u00d60000.getPoolList(sourceConnectorReader, string, httpSession))).getFilesAsList()).size() > 0) {
            object.sort(poolFileEntryComparator);
            return string + "/" + ((PoolFileEntry)object.get((int)0)).o00000;
        }
        return null;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("defaultSortField");
        treeSet.add("forceSortField");
        treeSet.add("defaultSortOrder");
        treeSet.add("forceSortOrder");
        treeSet.add("defaultSortMethod");
        treeSet.add("forceSortMethod");
        treeSet.add("defaultSortLanguage");
        treeSet.add("forceSortLanguage");
        treeSet.add("defaultSortCountry");
        treeSet.add("forceSortCountry");
        treeSet.add("defaultSortCaseSensitive");
        treeSet.add("forceSortCaseSensitive");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("maxImages")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 1) {
                    this.thisclass = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.new.log(3043, string2, string, this.\u00d800000);
            }
        } else if (string.equalsIgnoreCase("defaultsortfield")) {
            this.\u00d5\u00d60000.\u00d300000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("forcesortfield")) {
            this.\u00d5\u00d60000.\u00d200000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("defaultsortorder")) {
            this.\u00d5\u00d60000.for = SortDirection.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("forcesortorder")) {
            this.\u00d5\u00d60000.\u00f600000 = SortDirection.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("defaultsortmethod")) {
            this.\u00d5\u00d60000.o00000 = SortMethod.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("forcesortmethod")) {
            this.\u00d5\u00d60000.oO0000 = SortMethod.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
            this.\u00d5\u00d60000.\u00f500000 = string2.toLowerCase();
        } else if (string.equalsIgnoreCase("forcesortlanguage")) {
            this.\u00d5\u00d60000.null = string2.toLowerCase();
        } else if (string.equalsIgnoreCase("defaultsortcountry")) {
            this.\u00d5\u00d60000.\u00f800000 = string2.toUpperCase();
        } else if (string.equalsIgnoreCase("forcesortcountry")) {
            this.\u00d5\u00d60000.\u00d600000 = string2.toUpperCase();
        } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
            this.\u00d5\u00d60000.\u00d800000 = Boolean.valueOf(string2.toLowerCase());
        } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
            this.\u00d5\u00d60000.\u00d500000 = Boolean.valueOf(string2.toLowerCase());
            this.\u00d5\u00d60000.String = true;
        }
    }
}

