/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.solr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.neptunelabs.fsiserver.framework.helpers.StringUtils;
import com.neptunelabs.fsiserver.framework.helpers.URLEncoderFast;
import com.neptunelabs.fsiserver.search.SearchException;
import com.neptunelabs.fsiserver.search.SearchToken;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SolrSearcher {
    private final SearchDatabaseSolr super;
    private final DateFormat \u00d200000 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public SolrSearcher(SearchDatabaseSolr searchDatabaseSolr) {
        this.super = searchDatabaseSolr;
    }

    public SearchProcessor.SearchResult search(String string, String string2, List<String> list, String string3, int n, int n2, String string4, String string5) throws SearchException {
        return this.search(string, string2, list, null, string3, n, n2, string4, string5);
    }

    public SearchProcessor.SearchResult search(String string, String string2, List<String> list, Set<String> set, String string3, int n, int n2, String string4, String string5) throws SearchException {
        Object object;
        StringBuilder stringBuilder;
        boolean bl = false;
        if (string != null && ((string = string.toLowerCase()).contains("<") || string.contains(">"))) {
            string = this.solrizeSearchString(string);
        }
        if (list != null || string2 != null) {
            stringBuilder = this.buildRequest(string, 0, 1, null, null, null);
            object = this.executeSearchRequest(stringBuilder.toString());
            if (((SearchProcessor.SearchResult)object).super == 0) {
                return new SearchProcessor.SearchResult();
            }
        }
        stringBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                stringBuilder.append("file.connector").append(':').append("\"").append(list.get(0)).append("\"");
            } else {
                stringBuilder.append('(');
                for (int i = 0; i < list.size(); ++i) {
                    stringBuilder.append("file.connector").append(':').append("\"").append(list.get(i)).append("\"");
                    if (i + 1 >= list.size()) continue;
                    stringBuilder.append(" OR ");
                }
                stringBuilder.append(')');
            }
            bl = true;
        }
        if (string3 != null && string3.trim().length() > 0) {
            stringBuilder.append(" AND file.type:\"").append(string3).append("\"");
        }
        if (string2 != null) {
            if (bl) {
                stringBuilder.append(" AND ");
            } else {
                bl = true;
            }
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuilder.append("file.path");
            stringBuilder.append(':');
            stringBuilder.append("\"").append(string2).append("\"");
        }
        if (string != null) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("(").append(string).append(")");
        }
        object = stringBuilder.toString();
        StringBuilder stringBuilder2 = this.buildRequest((String)object, n, n2, set, string4, string5);
        SearchProcessor.SearchResult searchResult = this.executeSearchRequest(stringBuilder2.toString());
        return searchResult;
    }

    private SearchProcessor.SearchResult executeSearchRequest(String string) throws SearchException {
        SearchProcessor.SearchResult searchResult;
        SolrResponse solrResponse = this.super.searchJSON(string);
        try {
            switch (solrResponse.Object) {
                case 200: {
                    searchResult = this.solrResponseToSearchResult(solrResponse);
                    break;
                }
                case 0: {
                    throw new SearchException(503, solrResponse.\u00d200000);
                }
                default: {
                    if (solrResponse.\u00d200000 == null) {
                        solrResponse.\u00d200000 = "Invalid search string or error in database.";
                    }
                    throw new SearchException(solrResponse.Object, solrResponse.\u00d200000);
                }
            }
        }
        catch (IOException iOException) {
            throw new SearchException(500, "Invalid response " + iOException.getLocalizedMessage());
        }
        return searchResult;
    }

    private StringBuilder buildRequest(String string, int n, int n2, Set<String> set, String string2, String string3) {
        String string4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("q=");
        URLEncoderFast uRLEncoderFast = new URLEncoderFast("", false);
        stringBuilder.append(uRLEncoderFast.escape(string));
        if (set != null) {
            stringBuilder.append("&qf=").append(StringUtils.join(set, '+'));
        }
        if (n > 0) {
            stringBuilder.append("&start=").append(n);
        }
        if (n2 > 0) {
            stringBuilder.append("&rows=").append(n2);
        }
        if (string2 != null && (string4 = this.getSortFieldFromQuery(string2)) != null) {
            String string5 = this.getSortOrderFromQuery(string3);
            stringBuilder.append("&sort=").append(string4).append("+").append(string5);
        }
        return stringBuilder;
    }

    private String getSortOrderFromQuery(String string) {
        String string2 = string.toLowerCase().trim();
        if (string2.equals("desc")) {
            return "desc";
        }
        return "asc";
    }

    private String getSortFieldFromQuery(String string) {
        String string2 = string.toLowerCase().trim();
        if (string2.equals("filename")) {
            return "file.fullpath";
        }
        if (string2.equals("width")) {
            return "file.width";
        }
        if (string2.equals("height")) {
            return "file.height";
        }
        if (string2.equals("filesize")) {
            return "file.size";
        }
        if (string2.equals("lastmodified")) {
            return "file.lastmodified";
        }
        if (string2.equals("importstatus")) {
            return "file.status";
        }
        return null;
    }

    private SearchProcessor.SearchResult solrResponseToSearchResult(SolrResponse solrResponse) throws IOException {
        SearchProcessor.SearchResult searchResult = new SearchProcessor.SearchResult();
        if (solrResponse.o00000 != null) {
            String string = new String(solrResponse.o00000, solrResponse.\u00d400000);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(string);
            JsonNode jsonNode2 = jsonNode.get("response");
            searchResult.super = jsonNode2.get("numFound").asInt();
            JsonNode jsonNode3 = jsonNode2.get("docs");
            searchResult.\u00d200000 = new ArrayList<MetaData>();
            for (int i = 0; i < jsonNode3.size(); ++i) {
                MetaData metaData;
                Object object;
                JsonNode jsonNode4 = jsonNode3.get(i);
                if (jsonNode4.has("file.height")) {
                    object = new ImageMetaData();
                    ((ImageMetaData)object).setHeight(jsonNode4.get("file.height").asInt());
                    ((ImageMetaData)object).setWidth(jsonNode4.get("file.width").asInt());
                    ((FileMetaData)object).setSourceFileSize(jsonNode4.get("file.size").asLong());
                    if (jsonNode4.has("file.status")) {
                        ((ImageMetaData)object).setImportStatus((byte)jsonNode4.get("file.status").asInt());
                    }
                    metaData = object;
                } else if (jsonNode4.has("file.size")) {
                    object = new FileMetaData();
                    ((FileMetaData)object).setSourceFileSize(jsonNode4.get("file.size").asLong());
                    metaData = object;
                } else {
                    metaData = jsonNode4.get("file.type").asText().equals("directory") ? new DirectoryMetaData() : new MetaData();
                }
                metaData.setAssetURLPath(jsonNode4.get("asset.fullpath").asText());
                if (jsonNode4.has("file.lastmodified") && (object = jsonNode4.get("file.lastmodified").asText()) != null) {
                    try {
                        metaData.setLastModified(this.\u00d200000.parse((String)object).getTime());
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
                searchResult.\u00d200000.add(metaData);
            }
        }
        return searchResult;
    }

    private String solrizeSearchString(String string) {
        List<SearchToken> list = this.parseSearchString(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (SearchToken searchToken : list) {
            stringBuilder.append(searchToken.getTokenForSolr()).append(" ");
        }
        return stringBuilder.toString();
    }

    private List<SearchToken> parseSearchString(String string) {
        boolean bl = false;
        ArrayList<SearchToken> arrayList = new ArrayList<SearchToken>();
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    boolean bl2 = bl = !bl;
                }
                if (c == ' ' && !bl) {
                    if (stringBuilder.toString().trim().length() <= 0) continue;
                    arrayList.add(new SearchToken(stringBuilder.toString()));
                    stringBuilder = new StringBuilder();
                    continue;
                }
                stringBuilder.append(c);
            }
            if (stringBuilder.toString().trim().length() > 0) {
                arrayList.add(new SearchToken(stringBuilder.toString()));
            }
        }
        return arrayList;
    }
}

