/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.search.SDBChecker;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.ConverterState;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ThreadLocalsCleaner;
import com.yworks.util.annotation.Obfuscation;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;

@Obfuscation
public final class SourceManager {
    private final ServletContext servletContext;
    private SourceManagerSettings settings;
    private ScannerDaemon scannerDaemon = null;
    private SDBChecker sdbChecker = null;
    private Converter_V1002 converterManagerV1002 = null;
    private ImageListFileReader imagelistfilereader = null;
    private StorageManager storageManager = null;
    private long startTime = 0L;

    public SourceManager(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void init() {
        this.startTime = System.currentTimeMillis();
        this.settings = (SourceManagerSettings)this.servletContext.getAttribute("settings.sourceManager");
        this.startTime = System.currentTimeMillis();
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis();
        this.storageManager = (StorageManager)this.servletContext.getAttribute("com.neptunelabs.fsiserver.StorageManager");
        this.settings.initSourceConnectorWatcher();
        l2 = System.currentTimeMillis();
        this.imagelistfilereader = (ImageListFileReader)this.servletContext.getAttribute("com.neptunelabs.fsiserver.ImageListFileReader");
        this.settings.getLogger().log(3204, "ImageList", System.currentTimeMillis() - l2);
        this.initSystemMonitor();
        this.settings.configureJMXSupport();
        l2 = System.currentTimeMillis();
        boolean bl = this.settings.getPrefsBoolean("application", "import");
        this.converterManagerV1002 = (Converter_V1002)this.servletContext.getAttribute("com.neptunelabs.fsiserver.ConverterManager");
        if (!bl) {
            this.settings.getLogger().log(3204, "Converter disabled", System.currentTimeMillis() - l2);
        } else if (this.settings.getPrefsBoolean("application", "prefetch")) {
            int n = this.settings.getConversionThreads();
            this.settings.getLogger().log(3204, "Converter (" + n + ") with prefetching", System.currentTimeMillis() - l2);
        } else {
            int n = this.settings.getConversionThreads();
            this.settings.getLogger().log(3204, "Converter (" + n + ")", System.currentTimeMillis() - l2);
        }
        this.settings.initCacheDirectory();
        l2 = System.currentTimeMillis();
        this.scannerDaemon = (ScannerDaemon)this.servletContext.getAttribute("com.neptunelabs.fsiserver.ScannerDaemon");
        this.settings.getLogger().log(3204, "SourceManager", System.currentTimeMillis() - l);
        this.settings.getLogger().log(2019, new Object[0]);
    }

    private void sendStopSignalToScanner() {
        if (this.scannerDaemon != null) {
            this.settings.getLogger().log(2016, this.scannerDaemon.getName());
            long l = System.currentTimeMillis();
            this.scannerDaemon.halt();
            try {
                this.scannerDaemon.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.settings.getLogger().log(3205, "ScannerDaemon", System.currentTimeMillis() - l);
        }
    }

    private void waitForConverterStop() {
        if (this.converterManagerV1002 != null) {
            long l = System.currentTimeMillis();
            while (this.converterManagerV1002.isAlive()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.settings.getLogger().log(3205, "Converter", System.currentTimeMillis() - l);
        }
        this.settings.getLogger().log(2016, "Converter");
    }

    private void stopListBuffer() {
        if (this.imagelistfilereader != null) {
            long l = System.currentTimeMillis();
            this.imagelistfilereader.shutdownListBuffer();
            this.settings.getLogger().log(3205, "ImageListFileReader", System.currentTimeMillis() - l);
        }
    }

    private void sendHaltNowSignalToConverter() {
        if (this.converterManagerV1002 != null) {
            this.converterManagerV1002.haltNow();
        }
    }

    private void sendHaltSignalToConverter() {
        if (this.converterManagerV1002 != null) {
            this.converterManagerV1002.halt();
        }
    }

    public void destroy() {
        this.sendHaltSignalToConverter();
        if (this.settings.getLogger() != null) {
            this.settings.getLogger().log(2002, SoftwareVersion.getSoftware(true));
        }
        long l = System.currentTimeMillis();
        if (this.sdbChecker != null) {
            this.sdbChecker.halt();
        }
        if (this.storageManager != null) {
            this.storageManager.dispose();
        }
        this.sendStopSignalToScanner();
        this.stopListBuffer();
        this.sendHaltNowSignalToConverter();
        this.waitForConverterStop();
        this.settings.getLogger().log(3205, "Source Manager", System.currentTimeMillis() - l);
        this.settings.getLogger().log(2018, new Object[0]);
        this.settings.dispose();
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Driver driver = enumeration.nextElement();
                try {
                    DriverManager.deregisterDriver(driver);
                }
                catch (SQLException sQLException) {}
            }
        }
        ThreadLocalsCleaner.removeThreadLocals();
    }

    public List<FileImportJob> getRecentConverterJobs() {
        List<FileImportJob> list = new ArrayList<FileImportJob>();
        if (this.converterManagerV1002 != null) {
            list = this.converterManagerV1002.getRecentJobs();
        }
        return list;
    }

    public List<ConverterState> getCurrentConverterJobs() {
        List<ConverterState> list = new ArrayList<ConverterState>();
        if (this.converterManagerV1002 != null) {
            list = this.converterManagerV1002.getCurrentJobStates();
        }
        return list;
    }

    private void initSystemMonitor() {
        SystemMonitor systemMonitor = (SystemMonitor)this.servletContext.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
        systemMonitor.setConnectorCount(this.settings.getSourceConnectorCount());
    }
}

