/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.download;

import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.MimeHelper;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessorNG;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.ProcessorEnv;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DownloadJobProcessor
extends Thread {
    private final ProcessorEnv \u00d600000;
    private final BlockingQueue<DownloadJob> o00000 = new LinkedBlockingQueue<DownloadJob>();
    private final Map<String, _o> void = new ConcurrentHashMap<String, _o>();
    private final FSILogger \u00f600000;
    private final SourceManagerSettings \u00d500000;
    private Path \u00f400000;
    private Path \u00f500000;
    private volatile DownloadJob \u00d200000 = null;
    private volatile _Oo Object;
    private final Timer \u00d400000 = new Timer("Download Job Processor Timer", true);

    public DownloadJobProcessor(SourceManagerSettings sourceManagerSettings, ProcessorEnv processorEnv) {
        this.\u00d500000 = sourceManagerSettings;
        this.\u00d600000 = processorEnv;
        this.\u00f600000 = sourceManagerSettings.getLogger();
        try {
            this.\u00f400000 = sourceManagerSettings.getStorageHelper().getDownloadsFolder();
            this.\u00f500000 = this.\u00f400000.resolve("pending");
            if (Files.notExists(this.\u00f500000, new LinkOption[0])) {
                Files.createDirectories(this.\u00f500000, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.\u00f400000 = null;
            this.\u00f500000 = null;
        }
        this.setName("Download Job Processor");
    }

    public void restartJob(String string) throws IOException {
        Path path = this.\u00f400000.resolve(string + ".job");
        if (Files.notExists(path, new LinkOption[0])) {
            path = this.\u00f500000.resolve(string + ".job");
        }
        DownloadJob downloadJob = DownloadJob.createFromFile(path);
        Files.deleteIfExists(path);
        if (downloadJob.getStatus() == DownloadJob.JobState.QUEUED && downloadJob.getScheduledStart() != 0L) {
            downloadJob.setScheduledStart(0L);
        }
        this.enqueueJob(downloadJob);
    }

    public boolean enqueueJob(DownloadJob downloadJob) {
        Path path = this.\u00f500000.resolve(downloadJob.getId() + ".job");
        downloadJob.setStatus(DownloadJob.JobState.QUEUED);
        try {
            downloadJob.saveToFile(path);
        }
        catch (IOException iOException) {
            this.\u00f600000.log(3255, path, downloadJob.getId());
            return false;
        }
        if (downloadJob.getScheduledStart() == 0L || downloadJob.getScheduledStart() < System.currentTimeMillis()) {
            this.o00000.add(downloadJob);
        } else {
            this.scheduleJob(downloadJob);
        }
        return true;
    }

    public List<DownloadJob> getJobs(String string, Set<String> set) {
        HashSet<DownloadJob> hashSet = new HashSet<DownloadJob>();
        int n = 1;
        for (DownloadJob iterator : this.o00000) {
            iterator.setQueuePos(n);
            ++n;
            hashSet.add(iterator);
        }
        if (this.\u00d200000 != null) {
            hashSet.add(this.\u00d200000);
        }
        for (_o _o2 : this.void.values()) {
            hashSet.add(_o2.\u00d200000);
        }
        ArrayList arrayList = new ArrayList();
        for (DownloadJob downloadJob : hashSet) {
            if (!downloadJob.getUser().equals(string) && Collections.disjoint(downloadJob.getGroups(), set)) continue;
            arrayList.add(downloadJob);
        }
        return arrayList;
    }

    @Override
    public void run() {
        if (this.\u00f400000 != null) {
            try {
                this.initJobQueueFromFileSystem();
                this.Object = _Oo.class;
                while (this.Object != _Oo.\u00d300000) {
                    this.\u00d200000 = null;
                    try {
                        DownloadJob downloadJob;
                        this.Object = _Oo.class;
                        this.\u00d200000 = downloadJob = this.o00000.take();
                        this.Object = _Oo.\u00d400000;
                        boolean bl = this.processJob(downloadJob);
                    }
                    catch (InterruptedException interruptedException) {
                        this.Object = _Oo.\u00d300000;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.Object = _Oo.super;
    }

    private void initJobQueueFromFileSystem() throws IOException {
        List<DownloadJob> list = this.readJobsFromDirectory(this.\u00f500000);
        Collections.sort(list);
        long l = System.currentTimeMillis();
        for (DownloadJob downloadJob : list) {
            if (downloadJob.getScheduledStart() == 0L) {
                this.o00000.add(downloadJob);
                continue;
            }
            if (downloadJob.getScheduledStart() < l) {
                this.cancelJob(downloadJob.getId());
                continue;
            }
            this.scheduleJob(downloadJob);
        }
    }

    private void scheduleJob(DownloadJob downloadJob) {
        _o _o2 = new _o(downloadJob);
        long l = downloadJob.getScheduledStart() - System.currentTimeMillis();
        this.\u00d400000.schedule((TimerTask)_o2, l);
        this.void.put(downloadJob.getId(), _o2);
    }

    private List<DownloadJob> readJobsFromDirectory(Path path) throws IOException {
        ArrayList<DownloadJob> arrayList = new ArrayList<DownloadJob>();
        List<PathCached> list = FileOperations.listAllFiles(path, "*");
        for (PathCached pathCached : list) {
            if (!pathCached.isRegularFile() || !pathCached.getFileName().endsWith(".job")) continue;
            try {
                DownloadJob downloadJob = DownloadJob.createFromFile(pathCached.getPath());
                if (downloadJob == null) continue;
                arrayList.add(downloadJob);
            }
            catch (IOException iOException) {
                this.\u00f600000.log(3241, pathCached, iOException.getLocalizedMessage());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processJob(DownloadJob downloadJob) {
        Path path;
        String string = downloadJob.getId();
        this.\u00f600000.log(3250, downloadJob.getId(), downloadJob.getUser());
        if (downloadJob.getRenderingQuery() != null && !this.\u00d500000.getLicence().isBatchProcessingEnabled()) {
            downloadJob.setStatus(DownloadJob.JobState.CANCELLED);
            this.\u00f600000.log(2059, downloadJob.getName());
        } else {
            downloadJob.setStatus(DownloadJob.JobState.PROCESSING);
            path = this.\u00f400000.resolve(string + ".tmp");
            try {
                int n = 0;
                for (String string2 : downloadJob.getFiles()) {
                    SourceConnectorReader sourceConnectorReader = this.\u00d500000.getSourceConnectorFromAssetURLPath(string2, downloadJob.getUser());
                    String[] stringArray = StorageHelperV1002.splitAssetURLPath(string2);
                    Path path2 = sourceConnectorReader.getInboxDirectory().resolve(stringArray[1]);
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        n = (int)((long)n + FileOperations.countFilesRecursively(path2));
                        continue;
                    }
                    ++n;
                }
                downloadJob.setFileCount(n);
                this.\u00f600000.log(3251, downloadJob.getId(), downloadJob.getFileCount());
                if (downloadJob.getStatus() == DownloadJob.JobState.PROCESSING) {
                    downloadJob.setStartTime(System.currentTimeMillis());
                    this.createArchive(downloadJob, path);
                }
                if (Files.exists(path, new LinkOption[0])) {
                    Path path3 = this.\u00f400000.resolve(string + ".download");
                    FileOperations.move(path, path3);
                    downloadJob.setArchiveSize(Files.size(path3));
                }
                downloadJob.setFinishedTime(System.currentTimeMillis());
                if (downloadJob.getStatus() == DownloadJob.JobState.PROCESSING) {
                    downloadJob.setStatus(DownloadJob.JobState.COMPLETE);
                }
            }
            catch (NotConfiguredException | IOException exception) {
                this.\u00f600000.log(3239, exception.getLocalizedMessage());
                downloadJob.setStatus(DownloadJob.JobState.ERROR);
            }
            finally {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        path = this.\u00f400000.resolve(string + ".job");
        try {
            downloadJob.saveToFile(path);
        }
        catch (IOException iOException) {
            this.\u00f600000.log(3255, path, downloadJob.getId());
            return false;
        }
        Path path4 = this.\u00f500000.resolve(string + ".job");
        try {
            Files.deleteIfExists(path4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.\u00f600000.log(3252, downloadJob.getId(), downloadJob.getStatus().name());
        return true;
    }

    private void addEntryToArchive(Path path, String string, ArchiveOutputStream archiveOutputStream, DownloadJob.ArchiveType archiveType) throws IOException {
        Object object = archiveType == DownloadJob.ArchiveType.ZIP ? new ZipArchiveEntry(path.toFile(), string) : new TarArchiveEntry(path.toFile(), string);
        archiveOutputStream.putArchiveEntry((ArchiveEntry)object);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            archiveOutputStream.write(FileOperations.readFile(path));
        }
        archiveOutputStream.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursivelyAddToArchive(DownloadJob downloadJob, Path path, String string, String string2, ArchiveOutputStream archiveOutputStream, DownloadJob.ArchiveType archiveType) throws IOException {
        block25: {
            block24: {
                SourceConnectorReader sourceConnectorReader;
                if (!Files.isRegularFile(path, new LinkOption[0])) break block24;
                boolean bl = false;
                if (downloadJob.getRenderingQuery() != null && (sourceConnectorReader = this.\u00d500000.getSourceConnectorFromAssetURLPath(string2)).getMountType() != SourceConnectorReader.SourceConnectorType.o00000) {
                    Path path2;
                    bl = true;
                    MainProcessorNG mainProcessorNG = new MainProcessorNG(null, this.\u00d600000);
                    Parameters parameters = new Parameters(downloadJob.getRenderingQuery());
                    parameters.put(Parameters.General.\u00f8\u00d40000, string2);
                    int n = 0;
                    String string3 = String.valueOf(System.currentTimeMillis());
                    while (Files.exists(path2 = this.\u00d500000.getWorkDirectory().resolve(string3 + "_" + n), new LinkOption[0])) {
                    }
                    try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path2, new OpenOption[0]));){
                        String string4 = mainProcessorNG.handleBatchRequest(parameters, bufferedOutputStream);
                        String string5 = MimeHelper.getFileExtensionFromMimeType(string4);
                        if (downloadJob.isReplaceFilenameExtension()) {
                            int n2 = string.lastIndexOf(".");
                            string = string.substring(0, n2) + string5;
                        } else {
                            string = string + string5;
                        }
                        this.addEntryToArchive(path2, string, archiveOutputStream, archiveType);
                        downloadJob.getProgressCount().incrementAndGet();
                    }
                    catch (Exception exception) {
                        downloadJob.setStatus(DownloadJob.JobState.ERROR);
                        this.\u00f600000.logException(exception, 3263, string2, exception.getLocalizedMessage());
                    }
                    finally {
                        Files.deleteIfExists(path2);
                    }
                }
                if (bl) break block25;
                this.addEntryToArchive(path, string, archiveOutputStream, archiveType);
                downloadJob.getProgressCount().incrementAndGet();
                break block25;
            }
            this.addEntryToArchive(path, string, archiveOutputStream, archiveType);
            List<PathCached> list = FileOperations.listAllFiles(path);
            if (list != null) {
                for (PathCached pathCached : list) {
                    this.recursivelyAddToArchive(downloadJob, pathCached.getPath(), string + "/" + pathCached.getFileName(), string2 + "/" + pathCached.getFileName(), archiveOutputStream, archiveType);
                    if (downloadJob.getStatus() == DownloadJob.JobState.PROCESSING) continue;
                    break;
                }
            }
        }
    }

    private void createArchive(DownloadJob downloadJob, Path path) throws NotConfiguredException, IOException {
        switch (downloadJob.getArchiveType()) {
            case ZIP: {
                this.createZip(downloadJob, path);
                break;
            }
            case TAR_GZ: 
            case TAR_BZ2: {
                this.createTar(downloadJob, path);
            }
        }
        if (downloadJob.getStatus() != DownloadJob.JobState.PROCESSING) {
            Files.deleteIfExists(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTar(DownloadJob downloadJob, Path path) throws NotConfiguredException, IOException {
        TarArchiveOutputStream tarArchiveOutputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = downloadJob.getArchiveType() == DownloadJob.ArchiveType.TAR_GZ ? new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]))) : new BZip2CompressorOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));
            tarArchiveOutputStream = new TarArchiveOutputStream(outputStream);
            tarArchiveOutputStream.setLongFileMode(2);
            this.packArchive(downloadJob, (ArchiveOutputStream)tarArchiveOutputStream);
        }
        finally {
            if (tarArchiveOutputStream != null) {
                tarArchiveOutputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void packArchive(DownloadJob downloadJob, ArchiveOutputStream archiveOutputStream) throws IOException, NotConfiguredException {
        for (String string : downloadJob.getFiles()) {
            SourceConnectorReader sourceConnectorReader = this.\u00d500000.getSourceConnectorFromAssetURLPath(string, downloadJob.getUser());
            String[] stringArray = StorageHelperV1002.splitAssetURLPath(string);
            Path path = sourceConnectorReader.getInboxDirectory().resolve(stringArray[1]);
            this.recursivelyAddToArchive(downloadJob, path, path.getFileName().toString(), string, archiveOutputStream, downloadJob.getArchiveType());
            if (downloadJob.getStatus() == DownloadJob.JobState.PROCESSING) continue;
            break;
        }
    }

    private void createZip(DownloadJob downloadJob, Path path) throws NotConfiguredException, IOException {
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])));){
            this.packArchive(downloadJob, (ArchiveOutputStream)zipArchiveOutputStream);
        }
    }

    public boolean cancelJob(String string) {
        DownloadJob downloadJob = this.removeJobIfScheduled(string);
        if (downloadJob == null) {
            downloadJob = this.removeJobIfQueued(string);
        }
        if (downloadJob == null) {
            downloadJob = this.cancelJobIfRunning(string);
        }
        if (downloadJob != null) {
            Path path = this.\u00f400000.resolve(string + ".job");
            try {
                this.removePendingJobFromFileSystem(string);
                downloadJob.getProgressCount().set(0);
                downloadJob.setStatus(DownloadJob.JobState.CANCELLED);
                downloadJob.saveToFile(path);
            }
            catch (IOException iOException) {
                this.\u00f600000.log(3255, path, downloadJob.getId());
                return false;
            }
        }
        return true;
    }

    private DownloadJob removeJobIfScheduled(String string) {
        _o _o2 = this.void.get(string);
        if (_o2 != null) {
            _o2.cancel();
            this.void.remove(string);
            return _o2.\u00d200000;
        }
        return null;
    }

    private DownloadJob removeJobIfQueued(String string) {
        DownloadJob downloadJob = null;
        for (DownloadJob downloadJob2 : this.o00000) {
            if (!downloadJob2.getId().equals(string)) continue;
            downloadJob = downloadJob2;
            break;
        }
        if (downloadJob != null) {
            this.o00000.remove(downloadJob);
        }
        return downloadJob;
    }

    private DownloadJob cancelJobIfRunning(String string) {
        if (this.\u00d200000 != null && this.\u00d200000.getId().equals(string)) {
            this.\u00d200000.setStatus(DownloadJob.JobState.CANCELLED);
            return this.\u00d200000;
        }
        return null;
    }

    private void removePendingJobFromFileSystem(String string) throws IOException {
        Path path = this.\u00f500000.resolve(string + ".job");
        Files.deleteIfExists(path);
    }

    public void halt() {
        this.Object = _Oo.\u00d300000;
        this.\u00d400000.cancel();
        this.\u00d400000.purge();
        this.interrupt();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class _o
    extends TimerTask {
        final DownloadJob \u00d200000;

        _o(DownloadJob downloadJob) {
            this.\u00d200000 = downloadJob;
        }

        @Override
        public void run() {
            DownloadJobProcessor.this.void.remove(this.\u00d200000.getId());
            DownloadJobProcessor.this.enqueueJob(this.\u00d200000);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static enum _Oo {
        class,
        \u00d400000,
        \u00d300000,
        super;

    }
}

