/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.helpers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;

public class Inet6AddressUtils {
    public static Inet6Address parseInet6AddressString(String string) {
        Inet6Address inet6Address = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress instanceof Inet6Address) {
                inet6Address = (Inet6Address)inetAddress;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inet6Address;
    }

    public static Pair<Inet6Address, Inet6Address> parseCIDR(String string) {
        Pair<Inet6Address, Integer> pair = Inet6AddressUtils.getValidCIDRComponents(string);
        BitSet bitSet = Inet6AddressUtils.createPrefixAddress(pair.getItem2());
        BitSet bitSet2 = Inet6AddressUtils.getBitSetfromByteArray(pair.getItem1().getAddress());
        BitSet bitSet3 = (BitSet)bitSet2.clone();
        bitSet3.and(bitSet);
        BitSet bitSet4 = new BitSet(128);
        bitSet4.set(0, 128 - pair.getItem2());
        BitSet bitSet5 = (BitSet)bitSet3.clone();
        bitSet5.or(bitSet4);
        try {
            Inet6Address inet6Address = (Inet6Address)InetAddress.getByAddress(Inet6AddressUtils.getByteArrayFromBitSet(bitSet3));
            Inet6Address inet6Address2 = (Inet6Address)InetAddress.getByAddress(Inet6AddressUtils.getByteArrayFromBitSet(bitSet5));
            return new Pair<Inet6Address, Inet6Address>(inet6Address, inet6Address2);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static boolean isInRange(Inet6Address inet6Address, Pair<Inet6Address, Inet6Address> pair) {
        return Inet6AddressUtils.isLargerOrEqual(inet6Address, pair.getItem1()) && Inet6AddressUtils.isSmallerOrEqual(inet6Address, pair.getItem2());
    }

    private static boolean isSmallerOrEqual(Inet6Address inet6Address, Inet6Address inet6Address2) {
        BitSet bitSet = Inet6AddressUtils.getBitSetfromByteArray(inet6Address.getAddress());
        BitSet bitSet2 = Inet6AddressUtils.getBitSetfromByteArray(inet6Address2.getAddress());
        return Inet6AddressUtils.isSmallerOrEqual(bitSet, bitSet2);
    }

    private static boolean isSmallerOrEqual(BitSet bitSet, BitSet bitSet2) {
        for (int i = bitSet.size(); i >= 0; --i) {
            if (!bitSet.get(i) && bitSet2.get(i)) {
                return true;
            }
            if (!bitSet.get(i) || bitSet2.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLargerOrEqual(Inet6Address inet6Address, Inet6Address inet6Address2) {
        BitSet bitSet = Inet6AddressUtils.getBitSetfromByteArray(inet6Address.getAddress());
        BitSet bitSet2 = Inet6AddressUtils.getBitSetfromByteArray(inet6Address2.getAddress());
        return Inet6AddressUtils.isLargerOrEqual(bitSet, bitSet2);
    }

    private static boolean isLargerOrEqual(BitSet bitSet, BitSet bitSet2) {
        for (int i = bitSet.size(); i >= 0; --i) {
            if (bitSet.get(i) && !bitSet2.get(i)) {
                return true;
            }
            if (bitSet.get(i) || !bitSet2.get(i)) continue;
            return false;
        }
        return true;
    }

    private static BitSet createPrefixAddress(int n) {
        BitSet bitSet = new BitSet(128);
        bitSet.flip(128 - n, 128);
        return bitSet;
    }

    private static Pair<Inet6Address, Integer> getValidCIDRComponents(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Given string not a CIDR notation");
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Given string not a CIDR notation");
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
            if (inetAddress instanceof Inet6Address) {
                return new Pair<Inet6Address, Integer>((Inet6Address)inetAddress, n);
            }
            throw new IllegalArgumentException("Given string does not contain a valid IPv6 address");
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("Unable to parse IPv6 address");
        }
    }

    private static BitSet getBitSetfromByteArray(byte[] byArray) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < byArray.length * 8; ++i) {
            if ((byArray[byArray.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private static byte[] getByteArrayFromBitSet(BitSet bitSet) {
        byte[] byArray = new byte[bitSet.size() / 8];
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i)) continue;
            int n = byArray.length - i / 8 - 1;
            byArray[n] = (byte)(byArray[n] | 1 << i % 8);
        }
        return byArray;
    }
}

