/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.helpers.swap;

import com.neptunelabs.fsiserver.framework.helpers.swap.SwapIntFileAbstract;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.FileStore;
import java.nio.file.Files;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class UnlimitedIntBuffer {
    private final SwapPool \u00d800000;
    private final ByteOrder \u00d600000;
    private final long null;
    private final SwapIntFileAbstract[] \u00f500000;
    private long String;
    private static final int \u00d200000 = Integer.MAX_VALUE;
    private static final int o00000 = UnlimitedIntBuffer.multiFourLength(Integer.MAX_VALUE);
    private static final long \u00d300000 = (long)o00000 / 4L;
    private boolean \u00d500000 = false;

    public UnlimitedIntBuffer(SwapPool swapPool, ByteOrder byteOrder, long l) throws IOException {
        this(swapPool, byteOrder, l, null, false);
    }

    private UnlimitedIntBuffer(SwapPool swapPool, ByteOrder byteOrder, long l, SwapIntFileAbstract[] swapIntFileAbstractArray, boolean bl) throws IOException {
        this.\u00d800000 = swapPool;
        this.null = l;
        this.\u00d600000 = byteOrder;
        if (this.null > 0x3FFFFFFF8L) {
            this.\u00d500000 = true;
            throw new IOException("Maximum swap size exceeded 17179869176");
        }
        FileStore fileStore = Files.getFileStore(swapPool.getSwapDir());
        if (this.null * 2L > fileStore.getUsableSpace()) {
            this.\u00d500000 = true;
            throw new IOException("No space left on device for swap: " + this.null);
        }
        int n = (int)(l / (long)o00000 + 1L);
        this.\u00f500000 = new SwapIntFileAbstract[n];
        if (!bl && swapIntFileAbstractArray == null) {
            String string = Long.toHexString(System.nanoTime());
            for (int i = 0; i < n; ++i) {
                int n2 = i + 1 == n ? (int)(this.null - (long)(i * o00000)) : o00000;
                SwapIntFileAbstract swapIntFileAbstract = swapPool.createSwapIntFile(string + "_" + i + "_" + Long.toHexString(l), n2, true, true, byteOrder);
                if (swapIntFileAbstract == null) {
                    this.\u00d500000 = true;
                    break;
                }
                this.\u00f500000[i] = swapIntFileAbstract;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.\u00f500000[i] = swapIntFileAbstractArray[i].makeSlice();
            }
        }
        this.String = 0L;
    }

    public boolean hasError() {
        return this.\u00d500000;
    }

    public void dispose() {
        for (SwapIntFileAbstract swapIntFileAbstract : this.\u00f500000) {
            if (swapIntFileAbstract == null) continue;
            this.\u00d800000.disposeSwapFile(swapIntFileAbstract);
        }
    }

    public long capacity() {
        return this.null / 4L;
    }

    public long capacity(int n) {
        return this.\u00f500000[n].capacity();
    }

    public long position() {
        return this.String;
    }

    public void position(long l) {
        this.String = l;
        long l2 = UnlimitedIntBuffer.getSwapPosition(l);
        int n = (int)(l2 >> 32);
        int n2 = (int)l2;
        this.\u00f500000[n].position(n2);
    }

    public void position(int[] nArray) {
        this.String = nArray[0] * Integer.MAX_VALUE + nArray[1];
        this.\u00f500000[nArray[0]].position(nArray[1]);
    }

    public int get() throws IndexOutOfBoundsException, BufferUnderflowException {
        long l = UnlimitedIntBuffer.getSwapPosition(this.String++);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        return this.\u00f500000[n].get(n2);
    }

    public int get(long l) throws IndexOutOfBoundsException, BufferUnderflowException {
        long l2 = UnlimitedIntBuffer.getSwapPosition(l);
        int n = (int)(l2 >> 32);
        int n2 = (int)l2;
        return this.\u00f500000[n].get(n2);
    }

    public void get(int[] nArray, int n, int n2) throws BufferUnderflowException, IndexOutOfBoundsException {
        long l = UnlimitedIntBuffer.getSwapPosition(this.String);
        int n3 = (int)(l >> 32);
        int n4 = (int)l;
        long l2 = UnlimitedIntBuffer.getSwapPosition(this.String + (long)(n2 * 4));
        int n5 = (int)(l2 >> 32);
        int n6 = (int)l2;
        int n7 = n2;
        long l3 = this.String;
        int n8 = n3;
        int n9 = 0;
        while (n8 <= n5) {
            int n10;
            int n11;
            int n12;
            if (n9 == 0) {
                n12 = n;
                n11 = Math.min(n2, (int)(\u00d300000 - (long)n2));
                n7 -= n11;
                n10 = n4;
            } else {
                n12 = 0;
                if ((long)n7 > \u00d300000) {
                    n11 = (int)\u00d300000;
                    n7 -= n11;
                } else {
                    n11 = n7;
                }
                n10 = 0;
            }
            n11 = Math.min(n11, this.\u00f500000[n8].remaining());
            this.\u00f500000[n8].position(n10);
            this.\u00f500000[n8].get(nArray, n12, n11);
            l3 += (long)n11;
            ++n8;
            ++n9;
        }
        this.String = l3;
    }

    public ByteOrder order() {
        return this.\u00f500000[0].return.order();
    }

    public void put(int n) throws IndexOutOfBoundsException {
        long l = UnlimitedIntBuffer.getSwapPosition(this.String++);
        int n2 = (int)(l >> 32);
        int n3 = (int)l;
        this.\u00f500000[n2].put(n3, n);
    }

    public void put(int[] nArray) throws IndexOutOfBoundsException {
        this.put(nArray, 0, nArray.length);
    }

    private void put(int[] nArray, int n, int n2) throws IndexOutOfBoundsException {
        long l = UnlimitedIntBuffer.getSwapPosition(this.String);
        int n3 = (int)(l >> 32);
        int n4 = (int)l;
        long l2 = UnlimitedIntBuffer.getSwapPosition(this.String + (long)(n2 * 4));
        int n5 = (int)(l2 >> 32);
        int n6 = n2;
        long l3 = this.String;
        int n7 = n3;
        int n8 = 0;
        while (n7 <= n5) {
            int n9;
            int n10;
            int n11;
            if (n8 == 0) {
                n11 = n;
                n10 = Math.min(n2, (int)(\u00d300000 - (long)n2));
                n6 -= n10;
                n9 = n4;
            } else {
                n11 = 0;
                if ((long)n6 > \u00d300000) {
                    n10 = (int)\u00d300000;
                    n6 -= n10;
                } else {
                    n10 = n6;
                }
                n9 = 0;
            }
            this.\u00f500000[n7].position(n9);
            this.\u00f500000[n7].put(nArray, n11, n10);
            l3 += (long)n10;
            ++n7;
            ++n8;
        }
        this.String = l3;
    }

    public void put(long l, int n) throws IndexOutOfBoundsException {
        long l2 = UnlimitedIntBuffer.getSwapPosition(l);
        int n2 = (int)(l2 >> 32);
        int n3 = (int)l2;
        this.\u00f500000[n2].put(n3, n);
    }

    public void copyIntBuffer(IntBuffer intBuffer) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        intBuffer.position(0);
        long l = UnlimitedIntBuffer.getSwapPosition(this.String);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        long l2 = UnlimitedIntBuffer.getSwapPosition(this.String + (long)(intBuffer.capacity() * 4));
        int n3 = (int)(l2 >> 32);
        if (n == n3 && this.\u00f500000[n].remaining() >= intBuffer.capacity()) {
            this.\u00f500000[n].position(n2);
            this.\u00f500000[n].put(intBuffer);
            this.String += (long)intBuffer.capacity();
        } else {
            int n4 = intBuffer.capacity();
            int n5 = Math.min(n3, this.\u00f500000.length - 1);
            for (int i = n; i <= n5; ++i) {
                int n6 = Math.min(n4, (int)\u00d300000);
                n6 = Math.min(n6, this.\u00f500000[i].remaining());
                for (int j = 0; j < n6; ++j) {
                    this.\u00f500000[i].put(intBuffer.get());
                }
                this.String += (long)n6;
                n4 -= n6;
            }
        }
    }

    public UnlimitedIntBuffer slice() throws IOException {
        return new UnlimitedIntBuffer(this.\u00d800000, this.\u00d600000, this.null, this.\u00f500000, true);
    }

    public int getSwapCount() {
        return this.\u00f500000.length;
    }

    public IntBuffer getSwapIntBuffer(int n) {
        return this.\u00f500000[n].getIntBuffer();
    }

    public void clear() {
        for (SwapIntFileAbstract swapIntFileAbstract : this.\u00f500000) {
            swapIntFileAbstract.return.clear();
            swapIntFileAbstract.clear();
        }
    }

    public static long getSwapPosition(long l) {
        long l2 = (int)(l / \u00d300000);
        return l2 << 32 | (long)((int)(l - l2 * \u00d300000));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SwapFiles: ");
        stringBuilder.append(this.\u00f500000.length);
        stringBuilder.append("\n");
        long l = 0L;
        for (SwapIntFileAbstract swapIntFileAbstract : this.\u00f500000) {
            stringBuilder.append("File: ");
            stringBuilder.append(swapIntFileAbstract.\u00d300000.toString());
            stringBuilder.append(" : IntBuffer Length: ");
            int n = swapIntFileAbstract.capacity();
            l += (long)n;
            stringBuilder.append(n);
            stringBuilder.append("\n");
        }
        stringBuilder.append("Total Integer Size: ");
        stringBuilder.append(l);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static int multiFourLength(int n) {
        int n2 = n / 4;
        return n2 * 4;
    }
}

