/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imageloader;

import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheLoad;
import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imageloader.A;
import com.neptunelabs.fsiserver.imageloader.B;
import com.neptunelabs.fsiserver.imageloader.E;
import com.neptunelabs.fsiserver.imageloader.Object;
import com.neptunelabs.fsiserver.imagemanipulator.area.PaddingPositions;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.pyramidreader.FlatImageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.custommetadata.CustomMetaDataFileReader;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class ImageBuilder {
    private final B \u00d400000;
    private final A \u00d600000;
    private final E Object;
    private final Object o00000;
    private final FSIServerSettings \u00d500000;
    private final FSILogger \u00d200000;

    public ImageBuilder(FSIServerSettings fSIServerSettings, SwapPool swapPool, ImageListFileReader imageListFileReader) {
        this.\u00d500000 = fSIServerSettings;
        this.\u00d200000 = fSIServerSettings.getLogger();
        this.\u00d400000 = new B(fSIServerSettings, swapPool, imageListFileReader);
        this.\u00d600000 = new A(fSIServerSettings, swapPool, imageListFileReader);
        this.Object = new E(fSIServerSettings, swapPool);
        this.o00000 = new Object(fSIServerSettings, swapPool);
    }

    public MetaData getImageMetaData(SourceConnectorReader sourceConnectorReader, String string, int n, boolean bl, HttpSession httpSession) throws IOException {
        java.lang.Object object;
        MetaData metaData = null;
        boolean bl2 = !string.startsWith("_configs") && !string.startsWith("_viewers");
        CacheKey cacheKey = null;
        if (bl2) {
            cacheKey = CacheKey.getInstance(string, 'A', "ImageMetaData-" + n);
            object = this.\u00d500000.getCacheManager().get(cacheKey, CacheType.\u00d400000);
            if (object != null) {
                metaData = ((CacheLoad)object).Object != null ? (MetaData)((CacheLoad)object).Object : MetaData.unpack(((CacheLoad)object).\u00d200000);
            }
            if (metaData != null) {
                metaData.setAssetURLPath(string);
            }
        }
        if (metaData == null) {
            if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
                object = this.\u00d400000.OO0000(string, n, bl);
                if (metaData == null) {
                    metaData = object;
                }
            } else if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000) {
                boolean bl3 = true;
                metaData = this.\u00d600000.\u00f6o0000(sourceConnectorReader.getSourceFileFromAssetURLPath(string), true);
                metaData.setAssetURLPath(string);
            } else if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.o00000) {
                metaData = string.startsWith("_configs") || string.startsWith("_viewers") ? this.o00000.\u00f6O0000(string, httpSession) : this.Object.intsuper(sourceConnectorReader.getSourceFileFromAssetURLPath(string));
                metaData.setAssetURLPath(string);
            }
            if (bl2) {
                this.\u00d500000.getCacheManager().put(cacheKey, metaData, true);
            }
        }
        if (bl2 && metaData != null && n != 0 && Files.exists((Path)(object = this.\u00d500000.getMetaDataLocation().resolve(string + ".meta")), new LinkOption[0])) {
            try {
                CustomMetaDataFileReader customMetaDataFileReader = new CustomMetaDataFileReader(this.\u00d500000, (Path)object);
                Map<String, String> map = customMetaDataFileReader.getDataSet();
                metaData.setCustomMetaData(map);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException) {
                this.\u00d200000.logException(iOException, 3253, object);
            }
        }
        return metaData;
    }

    public DirectoryMetaData getDirectoryMetaData(String string) {
        return this.\u00d400000.float(string);
    }

    public DirectoryMetaData getDirectoryMetaData(SourceConnectorReader sourceConnectorReader, String string, PathCached pathCached, int n) throws IOException, NotConfiguredException {
        Path path;
        java.lang.Object object;
        DirectoryMetaData directoryMetaData = null;
        if (sourceConnectorReader == null || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
            directoryMetaData = this.\u00d400000.\u00d2O0000(string);
        } else {
            directoryMetaData = new DirectoryMetaData();
            directoryMetaData.setAssetURLPath(string);
            directoryMetaData.setLastModified(pathCached.lastModified());
            int n2 = 0;
            int n3 = 0;
            try {
                object = Files.newDirectoryStream(pathCached.getPath());
                Throwable throwable = null;
                try {
                    Iterator<Path> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Path path2 = iterator.next();
                        if (Files.isDirectory(path2, new LinkOption[0])) {
                            ++n3;
                            continue;
                        }
                        ++n2;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            object.close();
                        }
                    }
                }
            }
            catch (DirectoryIteratorException directoryIteratorException) {
                // empty catch block
            }
            directoryMetaData.setFiles(n2);
            directoryMetaData.setSubdirectories(n3);
        }
        if (directoryMetaData != null && n != 0 && Files.exists(path = this.\u00d500000.getMetaDataLocation().resolve(string + ".meta"), new LinkOption[0])) {
            try {
                CustomMetaDataFileReader customMetaDataFileReader = new CustomMetaDataFileReader(this.\u00d500000, path);
                object = customMetaDataFileReader.getDataSet();
                directoryMetaData.setCustomMetaData((Map<String, String>)object);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException iOException) {
                this.\u00d200000.logException(iOException, 3253, path);
            }
        }
        return directoryMetaData;
    }

    public PoolListSummary getPoolListSummary(SourceConnectorReader sourceConnectorReader, String string, HttpSession httpSession) throws IOException {
        PoolListSummary poolListSummary = null;
        if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000) {
            poolListSummary = this.\u00d600000.\u00d2\u00d20000(sourceConnectorReader.getSourceFileFromAssetURLPath(string));
        } else if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.o00000) {
            if (string.startsWith("_configs") || string.startsWith("_viewers")) {
                PoolList poolList = this.o00000.\u00d4O0000(string, httpSession);
                poolListSummary = new PoolListSummary(poolList.privateString, poolList.getFileCount(), poolList.getDirectoryCount());
            } else {
                poolListSummary = this.Object.oo0000(sourceConnectorReader.getSourceFileFromAssetURLPath(string));
            }
        } else if (sourceConnectorReader == null || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
            PoolList poolList = null;
            try {
                poolList = this.\u00d400000.\u00f500000(string);
            }
            catch (NoSuchFileException noSuchFileException) {
                poolList = this.\u00d400000.\u00f500000(string);
            }
            if (poolList != null) {
                poolListSummary = poolList.getSummary();
            }
        }
        return poolListSummary;
    }

    public PoolList getPoolList(SourceConnectorReader sourceConnectorReader, String string, HttpSession httpSession) throws IOException, NotConfiguredException {
        if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000) {
            return this.\u00d600000.o\u00d20000(string, sourceConnectorReader.getSourceFileFromAssetURLPath(string).getPath());
        }
        if (sourceConnectorReader != null && sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.o00000) {
            if (string.startsWith("_configs") || string.startsWith("_viewers")) {
                return this.o00000.\u00d4O0000(string, httpSession);
            }
            return this.Object.\u00d4o0000(sourceConnectorReader.getSourceFileFromAssetURLPath(string).getPath(), string);
        }
        if (sourceConnectorReader == null || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
            return this.\u00d400000.\u00f500000(string);
        }
        return null;
    }

    public FSIImageLimited getImagePixelBased(EISReader eISReader, SourceConnectorReader sourceConnectorReader, String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, FSIInterpolation fSIInterpolation) throws IOException, IllegalArgumentException, NotConfiguredException, FlatImageException, ProcessingException, InterruptedException {
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
            return this.\u00d400000.oO0000(eISReader, string, n, n2, n3, n4, n5, n6, fSIInterpolation);
        }
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000) {
            return this.\u00d600000.interfacesuper(sourceConnectorReader.getSourceFileFromAssetURLPath(string), string, n, n2, n3, n4, n5, n6, fSIInterpolation);
        }
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.o00000) {
            throw new IllegalArgumentException("Image retrieval not supported for static source connectors.");
        }
        return null;
    }

    public FSIImageLimited getImage(EISReader eISReader, SourceConnectorReader sourceConnectorReader, String string, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, double d, double d2, double d3, double d4, boolean bl, FSIInterpolation fSIInterpolation, PaddingPositions paddingPositions) throws IOException, IllegalArgumentException, NotConfiguredException, FlatImageException, ProcessingException, InterruptedException {
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.Object || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
            return this.\u00d400000.\u00f600000(eISReader, string, pair, pair2, d, d2, d3, d4, bl, fSIInterpolation, paddingPositions);
        }
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d500000) {
            return this.\u00d600000.\u00d6\u00d20000(sourceConnectorReader.getSourceFileFromAssetURLPath(string), string, pair, pair2, d, d2, d3, d4, bl, fSIInterpolation);
        }
        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.o00000) {
            throw new IllegalArgumentException("Image retrieval not supported for static source connectors.");
        }
        return null;
    }
}

