/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.color;

import com.neptunelabs.fsiserver.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.fsiserver.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;

public final class RGBLumSafeMatrix
extends ColorOperatorImpl {
    private final float \u00d4\u00d30000;
    private final float o\u00d30000;
    private final float \u00d8\u00d30000;
    private final float \u00d3\u00d30000;
    private final float \u00f5\u00d30000;
    private final float thisObject;
    private final float whilenew;
    private final float \u00f4\u00d30000;
    private final float \u00d5\u00d30000;

    public RGBLumSafeMatrix(float[] fArray) throws ImageManipulatorException {
        if (fArray.length != 9) {
            throw new ImageManipulatorException("Invalid matrix length");
        }
        this.\u00d4\u00d30000 = fArray[0];
        this.o\u00d30000 = fArray[1];
        this.\u00d8\u00d30000 = fArray[2];
        this.\u00d3\u00d30000 = fArray[3];
        this.\u00f5\u00d30000 = fArray[4];
        this.thisObject = fArray[5];
        this.whilenew = fArray[6];
        this.\u00f4\u00d30000 = fArray[7];
        this.\u00d5\u00d30000 = fArray[8];
    }

    @Override
    public final int transform(int n, int n2) {
        int n3 = n >>> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        float[] fArray = BaseImageUtils.rgbToFloat1(n);
        float[] fArray2 = BaseImageUtils.rgbToHsl(fArray[0], fArray[1], fArray[2]);
        int n7 = BaseImageUtils.clampFT255((float)n4 * this.\u00d4\u00d30000 + (float)n5 * this.o\u00d30000 + (float)n6 * this.\u00d8\u00d30000);
        int n8 = BaseImageUtils.clampFT255((float)n4 * this.\u00d3\u00d30000 + (float)n5 * this.\u00f5\u00d30000 + (float)n6 * this.thisObject);
        int n9 = BaseImageUtils.clampFT255((float)n4 * this.whilenew + (float)n5 * this.\u00f4\u00d30000 + (float)n6 * this.\u00d5\u00d30000);
        float[] fArray3 = BaseImageUtils.rgbToHsl((float)n7 / 255.0f, (float)n8 / 255.0f, (float)n9 / 255.0f);
        fArray = BaseImageUtils.hslToRgb(fArray3[0], fArray3[1], fArray2[2]);
        int n10 = BaseImageUtils.floatRgbToIntRgb(fArray);
        return n3 << 24 | n10;
    }
}

