/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.combine;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Mandelbrot {
    private final FSILogger public;
    private final SwapPool oO0000;
    private final ByteOrder OO0000;
    private static final double \u00f500000 = -2.25;
    private static final double float = 0.75;
    private static final double \u00d500000 = 1.5;
    private static final double void = -1.5;
    private final int \u00f600000 = 100;
    private double \u00d200000;
    private double \u00f400000;
    private double \u00d2O0000;
    private double \u00d400000;
    private static final int \u00d600000 = 5;
    private static final int Object = 512;
    private final int[][] o00000 = new int[512][];

    public Mandelbrot(FSILogger fSILogger, SwapPool swapPool, ByteOrder byteOrder) {
        this.public = fSILogger;
        this.oO0000 = swapPool;
        this.OO0000 = byteOrder;
        int[][] nArrayArray = new int[][]{{238, 112, 74}, {255, 255, 255}, {88, 168, 255}, {73, 73, 73}, {24, 104, 189}};
        this.computeColors(nArrayArray);
    }

    public void setColors(int n, int n2, int n3, int n4, int n5) {
        int[][] nArrayArray = new int[][]{{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF}, {n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF}, {n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF}, {n4 >> 16 & 0xFF, n4 >> 8 & 0xFF, n4 & 0xFF}, {n5 >> 16 & 0xFF, n5 >> 8 & 0xFF, n5 & 0xFF}};
        this.computeColors(nArrayArray);
    }

    public void setRange(double d, double d2, double d3, double d4) {
        this.\u00d200000 = 3.0 * d + -2.25;
        this.\u00f400000 = 3.0 * (d + d3) + -2.25;
        this.\u00d400000 = 3.0 * (1.0 - d2) - 1.5;
        this.\u00d2O0000 = 3.0 * (1.0 - (d2 + d4)) - 1.5;
    }

    public FSIImage render(Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2) throws ProcessingException {
        FSIImageLimited fSIImageLimited = new FSIImageLimited(this.public, this.oO0000, this.OO0000, (int)pair.getItem1(), pair2.getItem1(), null, FSIImageMode.new);
        int n = ExecutorPool.getMaxCPUThreads();
        ForkJoinPool forkJoinPool = ExecutorPool.createForkJoinPool("Mandelbrot", n);
        ArrayList<ForkJoinTask<Void>> arrayList = new ArrayList<ForkJoinTask<Void>>();
        int n2 = fSIImageLimited.getHeight() < n ? fSIImageLimited.getHeight() : n;
        int n3 = (int)Math.floor(fSIImageLimited.getHeight() / n2);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            n5 = i + 1 < n2 ? (n5 += n3) : fSIImageLimited.getHeight();
            _o _o2 = new _o(n4, n5, ((FSIImage)fSIImageLimited).createSlice());
            arrayList.add(forkJoinPool.submit(_o2));
            n4 += n3;
        }
        try {
            ExecutorPool.shutdownAndWait(forkJoinPool, arrayList, 600);
            ExecutorPool.getAllRecursiveAction(arrayList);
        }
        catch (ExecutionException executionException) {
            ((FSIImage)fSIImageLimited).dispose();
            throw new ProcessingException(executionException);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return fSIImageLimited;
    }

    private void computeColors(int[][] nArray) {
        int n;
        this.o00000[0] = new int[]{0, 0, 0};
        for (n = 0; n < 4; ++n) {
            int n2 = (nArray[n + 1][0] - nArray[n][0]) / 63;
            int n3 = (nArray[n + 1][1] - nArray[n][1]) / 63;
            int n4 = (nArray[n + 1][2] - nArray[n][2]) / 63;
            for (int i = 0; i < 64; ++i) {
                int n5 = nArray[n][0] + n2 * i;
                int n6 = nArray[n][1] + n3 * i;
                int n7 = nArray[n][2] + n4 * i;
                this.o00000[i + n * 64 + 1] = new int[]{n5, n6, n7};
            }
        }
        for (n = 257; n < 512; ++n) {
            this.o00000[n] = this.o00000[n - 256];
        }
    }

    final class _o
    extends RecursiveAction {
        private static final long serialVersionUID = 3091690728074743349L;
        private final int \u00d400000;
        private final int \u00d200000;
        private final FSIImage \u00d500000;
        private final int Object;

        _o(int n, int n2, FSIImage fSIImage) {
            this.\u00d400000 = n;
            this.\u00d200000 = n2;
            this.\u00d500000 = fSIImage;
            this.Object = fSIImage.getWidth();
        }

        @Override
        public void compute() {
            int n = 256;
            double d = (Mandelbrot.this.\u00f400000 - Mandelbrot.this.\u00d200000) / (double)this.\u00d500000.getWidth();
            double d2 = (Mandelbrot.this.\u00d400000 - Mandelbrot.this.\u00d2O0000) / (double)this.\u00d500000.getHeight();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 1.0;
            for (int i = this.\u00d400000; i < this.\u00d200000; ++i) {
                double d6 = Mandelbrot.this.\u00d400000 - d2 * (double)i;
                for (int j = 0; j < this.Object; ++j) {
                    double d7 = Mandelbrot.this.\u00d200000 + d * (double)j;
                    int n2 = 0;
                    double d8 = 0.0;
                    double d9 = 0.0;
                    do {
                        d3 = d9 * d9 - d8 * d8 + d7;
                        d4 = 2.0 * d9 * d8 + d6;
                        d9 = d3;
                        d8 = d4;
                    } while ((d5 = d3 * d3 + d4 * d4) <= 100.0 && ++n2 < 256);
                    if (n2 >= 256) {
                        n2 = 0;
                    }
                    int n3 = 0xFF000000 | Mandelbrot.this.o00000[n2][0] << 16 | Mandelbrot.this.o00000[n2][1] << 8 | Mandelbrot.this.o00000[n2][2];
                    this.\u00d500000.setSample(j, i, n3);
                }
            }
        }
    }
}

